/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.model.VirtualPartition;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;

public class PHPValue
extends PHPDebugElement
implements IValue {
    private static final String[] VARIABLE_TYPES = new String[]{"NULL", "INT", "STRING", "BOOLEAN", "DOUBLE", "ARRAY", "OBJECT", "RESOURCE", "CLASS"};
    private static final int ARRAY_PARTITION_BOUNDARY = 100;
    private Expression fVariable;
    private ExpressionValue fValue;
    private boolean fGlobal;
    private IVariable[] fChildren;

    public PHPValue(PHPDebugTarget target, Expression variable, boolean global) {
        super(target);
        this.fValue = variable.getValue();
        this.fVariable = variable;
        this.fGlobal = global;
    }

    public PHPValue(PHPDebugTarget target, Expression variable) {
        this(target, variable, false);
    }

    public String getReferenceTypeName() throws DebugException {
        return VARIABLE_TYPES[this.fValue.getType()];
    }

    public String getValueString() throws DebugException {
        return this.fValue.getValueAsString();
    }

    public String getValue() throws DebugException {
        return (String)this.fValue.getValue();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.fChildren == null) {
            this.requestVariables();
            if (this.fChildren == null) {
                this.fChildren = new IVariable[0];
            }
            if (this.fValue.getType() == 5 && this.fChildren.length >= 100) {
                this.createPartitions();
            }
        }
        return this.fChildren;
    }

    private void createPartitions() {
        int numChild = this.fChildren.length;
        int partitions = (int)Math.ceil((double)numChild / 100.0);
        IVariable[] children = new IVariable[partitions];
        int i = 0;
        while (i < partitions) {
            int startIndex = i * 100;
            int endIndex = (i + 1) * 100 - 1;
            if (endIndex > numChild) {
                endIndex = numChild - 1;
            }
            final IVariable[] vars = Arrays.copyOfRange(this.fChildren, startIndex, endIndex + 1);
            VirtualPartition var = new VirtualPartition((IDebugElement)this, new VirtualPartition.IVariableProvider(){

                @Override
                public IVariable[] getVariables() throws DebugException {
                    return vars;
                }
            }, startIndex, endIndex);
            children[i] = var;
            ++i;
        }
        this.fChildren = children;
    }

    private void requestVariables() {
        PHPDebugTarget debugTarget = (PHPDebugTarget)this.getDebugTarget();
        DefaultExpressionsManager expressionManager = debugTarget.getExpressionManager();
        Expression variable = this.fVariable;
        if (this.fGlobal) {
            String exp = "$GLOBALS[\"" + this.fVariable.getFullName().substring(1) + "\"]";
            variable = new DefaultExpression(exp);
        }
        expressionManager.update(variable, 1);
        this.fValue = variable.getValue();
        this.initChildren(this.fValue);
    }

    private void initChildren(ExpressionValue value) {
        this.fChildren = null;
        Expression[] children = value.getChildren();
        if (children != null) {
            this.fChildren = new PHPVariable[children.length];
            int i = 0;
            while (i < children.length) {
                this.fChildren[i] = new PHPVariable((PHPDebugTarget)this.getDebugTarget(), children[i], this.fGlobal);
                ++i;
            }
        }
    }

    public boolean hasVariables() throws DebugException {
        boolean isArrayOrObject;
        boolean bl = isArrayOrObject = this.fValue.getType() == 5 || this.fValue.getType() == 6 || this.fValue.getType() == 8;
        if (!isArrayOrObject) {
            return false;
        }
        return this.fValue.getChildrenCount() > 0;
    }

    public void updateValue(ExpressionValue value) {
        this.fValue = value;
        this.initChildren(this.fValue);
    }

    public boolean isPrimitive() {
        return this.fValue.isPrimitive();
    }

    public Expression getVariable() {
        return this.fVariable;
    }
}

