/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.changes.ProgramFileChange;
import org.eclipse.php.refactoring.core.rename.INameUpdating;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class AbstractRenameProcessor<R extends IResource>
extends RenameProcessor
implements INameUpdating {
    private static final String REFACTORING_ACTION_INTERNAL_ERROR = PhpRefactoringCoreMessages.getString("RenameProcessorBase.internalerror");
    private static final String IS_NOT_A_VALID_PHP_IDENTIFIER = PhpRefactoringCoreMessages.getString("RenameProcessorBase.0");
    private static final RefactoringParticipant[] EMPTY_REFACTORING_PARTICIPANTS = new RefactoringParticipant[0];
    protected String fNewElementName;
    protected Map<IFile, Program> participantFiles;
    protected final R resource;

    public AbstractRenameProcessor(R file) {
        assert (file != null);
        this.resource = file;
    }

    protected TextFileChange acquireChange(IFile file, Program program) {
        ProgramFileChange change = new ProgramFileChange(file.getName(), file, program);
        change.setEdit((TextEdit)new MultiTextEdit());
        change.setTextType("php");
        return change;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        boolean hasExternalDependencies = false;
        try {
            this.participantFiles = new HashMap<IFile, Program>();
            if (this.resource instanceof IFile && PHPToolkitUtil.isPhpFile((IFile)((IFile)this.resource))) {
                IFile file = (IFile)this.resource;
                ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
                IProject project = file.getProject();
                PHPVersion version = ProjectOptions.getPhpVersion((IProject)project);
                ASTParser newParser = ASTParser.newParser((PHPVersion)version, (ISourceModule)sourceModule);
                Program program = newParser.createAST(null);
                this.participantFiles.put(file, program);
                this.collectReferences(program, pm);
            }
        }
        catch (Exception e) {
            String exceptionMessage = e.getMessage();
            String formattedString = REFACTORING_ACTION_INTERNAL_ERROR.concat(exceptionMessage == null ? "" : exceptionMessage);
            return RefactoringStatus.createFatalErrorStatus((String)formattedString);
        }
        if (hasExternalDependencies) {
            String message = PhpRefactoringCoreMessages.getString("AbstractRenameProcessor.1");
            return RefactoringStatus.createWarningStatus((String)message);
        }
        return new RefactoringStatus();
    }

    protected void collectReferences(Program program, IProgressMonitor pm) {
        IFile file;
        Collection<ReferenceTree.Node> references = this.getReferencingFiles(program);
        if (references != null) {
            for (ReferenceTree.Node node : references) {
                file = (IFile)node.getFile().getResource();
                try {
                    this.participantFiles.put(file, RefactoringUtility.getProgramForFile(file));
                }
                catch (Exception exception) {}
            }
        }
        if ((references = this.getReferencedFiles(program)) != null) {
            for (ReferenceTree.Node node : references) {
                file = (IFile)node.getFile().getResource();
                try {
                    this.participantFiles.put(file, RefactoringUtility.getProgramForFile(file));
                }
                catch (Exception exception) {}
            }
        }
    }

    protected static int getSearchFlags(boolean includeInterp) {
        int flags = 3;
        if (includeInterp) {
            flags |= 4;
        }
        return flags;
    }

    protected Collection<ReferenceTree.Node> getReferencedFiles(Program program) {
        ReferenceTree tree;
        ISourceModule sourceModule = program.getSourceModule();
        if (sourceModule != null && (tree = FileNetworkUtility.buildReferencedFilesTree((ISourceModule)sourceModule, null)) != null && tree.getRoot() != null) {
            return tree.getRoot().getChildren();
        }
        return Collections.emptyList();
    }

    protected Collection<ReferenceTree.Node> getReferencingFiles(Program program) {
        ReferenceTree tree;
        ISourceModule sourceModule = program.getSourceModule();
        if (sourceModule != null && (tree = FileNetworkUtility.buildReferencingFilesTree((ISourceModule)sourceModule, null)) != null && tree.getRoot() != null) {
            return tree.getRoot().getChildren();
        }
        return Collections.emptyList();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result = RefactoringStatus.create((IStatus)Status.OK_STATUS);
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(pm, 100);
        subProgressMonitor.beginTask(PhpRefactoringCoreMessages.getString("RenameProcessorBase.1"), this.participantFiles.size());
        for (Map.Entry<IFile, Program> entry : this.participantFiles.entrySet()) {
            IFile key = entry.getKey();
            Program program = entry.getValue();
            RefactoringStatus status = this.getRefactoringStatus(key, program);
            result.merge(status);
            subProgressMonitor.worked(1);
        }
        subProgressMonitor.done();
        return result;
    }

    public abstract RefactoringStatus getRefactoringStatus(IFile var1, Program var2);

    @Override
    public abstract String getCurrentElementName();

    @Override
    public abstract Object getNewElement() throws CoreException;

    @Override
    public void setNewElementName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewElementName = newName;
    }

    @Override
    public String getNewElementName() {
        return this.fNewElementName;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return EMPTY_REFACTORING_PARTICIPANTS;
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        if (!AbstractRenameProcessor.isValidIdentifier(newName)) {
            return AbstractRenameProcessor.getFatalError(newName);
        }
        return new RefactoringStatus();
    }

    public static final boolean isValidIdentifier(String newName) {
        if (newName == null || newName.length() == 0 || !Character.isLetter(newName.charAt(0)) && newName.charAt(0) != '_') {
            return false;
        }
        int length = newName.length();
        int i = 1;
        while (i < length) {
            if (!Character.isJavaIdentifierPart(newName.charAt(i))) {
                return false;
            }
            if (newName.charAt(i) == '$') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static final RefactoringStatus getFatalError(String newName) {
        return RefactoringStatus.createFatalErrorStatus((String)(String.valueOf(newName) + IS_NOT_A_VALID_PHP_IDENTIFIER));
    }

    public Program getProgram(IFile file) {
        return this.participantFiles.get(file);
    }

    public boolean isApplicable() throws CoreException {
        if (this.resource == null) {
            return false;
        }
        if (!this.resource.isAccessible()) {
            return false;
        }
        ResourceAttributes attributes = this.resource.getResourceAttributes();
        if (attributes == null) {
            return false;
        }
        return !this.resource.getResourceAttributes().isReadOnly();
    }
}

