/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.code.flow;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.Selection;
import org.eclipse.php.refactoring.core.code.flow.DoWhileFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.FlowAnalyzer;
import org.eclipse.php.refactoring.core.code.flow.FlowContext;
import org.eclipse.php.refactoring.core.code.flow.FlowInfo;
import org.eclipse.php.refactoring.core.code.flow.ForFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.GenericConditionalFlowInfo;
import org.eclipse.php.refactoring.core.code.flow.GenericSequentialFlowInfo;

public class InputFlowAnalyzer
extends FlowAnalyzer {
    private Selection fSelection;
    private boolean fDoLoopReentrance;
    private LoopReentranceVisitor fLoopReentranceVisitor;

    public InputFlowAnalyzer(FlowContext context, Selection selection, boolean doLoopReentrance) {
        super(context);
        this.fSelection = selection;
        Assert.isNotNull((Object)this.fSelection);
        this.fDoLoopReentrance = doLoopReentrance;
    }

    public FlowInfo perform(ASTNode node) {
        node.accept((Visitor)this);
        return this.getFlowInfo(node);
    }

    @Override
    protected boolean traverseNode(ASTNode node) {
        return node.getEnd() > this.fSelection.getInclusiveEnd();
    }

    @Override
    protected boolean createReturnFlowInfo(ReturnStatement node) {
        return node.getStart() >= this.fSelection.getInclusiveEnd();
    }

    public boolean visit(DoStatement node) {
        this.createLoopReentranceVisitor((ASTNode)node);
        return super.visit(node);
    }

    public boolean visit(ForStatement node) {
        this.createLoopReentranceVisitor((ASTNode)node);
        return super.visit(node);
    }

    public boolean visit(WhileStatement node) {
        this.createLoopReentranceVisitor((ASTNode)node);
        return super.visit(node);
    }

    private void createLoopReentranceVisitor(ASTNode node) {
        if (this.fLoopReentranceVisitor == null && this.fDoLoopReentrance) {
            this.fLoopReentranceVisitor = new LoopReentranceVisitor(this.fFlowContext, this.fSelection, node);
        }
    }

    @Override
    public void endVisit(ConditionalExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        Expression thenPart = node.getIfTrue();
        Expression elsePart = node.getIfFalse();
        if (thenPart != null && this.fSelection.coveredBy((ASTNode)thenPart) || elsePart != null && this.fSelection.coveredBy((ASTNode)elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo((ASTNode)node, info);
            this.endVisitConditional(info, (ASTNode)node.getCondition(), new ASTNode[]{thenPart, elsePart});
        } else {
            super.endVisit(node);
        }
    }

    @Override
    public void endVisit(DoStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance((ASTNode)node);
    }

    @Override
    public void endVisit(IfStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        Statement thenPart = node.getTrueStatement();
        Statement elsePart = node.getFalseStatement();
        if (thenPart != null && this.fSelection.coveredBy((ASTNode)thenPart) || elsePart != null && this.fSelection.coveredBy((ASTNode)elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo((ASTNode)node, info);
            this.endVisitConditional(info, (ASTNode)node.getCondition(), new ASTNode[]{thenPart, elsePart});
        } else {
            super.endVisit(node);
        }
    }

    @Override
    public void endVisit(ForStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance((ASTNode)node);
    }

    @Override
    public void endVisit(SwitchStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        FlowAnalyzer.SwitchData data = this.createSwitchData(node);
        IRegion[] ranges = data.getRanges();
        int i = 0;
        while (i < ranges.length) {
            IRegion range = ranges[i];
            if (this.fSelection.coveredBy(range)) {
                GenericSequentialFlowInfo info = this.createSequential();
                this.setFlowInfo((ASTNode)node, info);
                info.merge(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
                info.merge(data.getInfo(i), this.fFlowContext);
                info.removeLabel(null);
                return;
            }
            ++i;
        }
        super.endVisit(node, data);
    }

    @Override
    public void endVisit(WhileStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance((ASTNode)node);
    }

    private void endVisitConditional(GenericSequentialFlowInfo info, ASTNode condition, ASTNode[] branches) {
        info.merge(this.getFlowInfo(condition), this.fFlowContext);
        int i = 0;
        while (i < branches.length) {
            ASTNode branch = branches[i];
            if (branch != null && this.fSelection.coveredBy(branch)) {
                info.merge(this.getFlowInfo(branch), this.fFlowContext);
                break;
            }
            ++i;
        }
    }

    private void handleLoopReentrance(ASTNode node) {
        if (!this.fSelection.coveredBy(node) || this.fLoopReentranceVisitor == null || this.fLoopReentranceVisitor.getLoopNode() != node) {
            return;
        }
        this.fLoopReentranceVisitor.process(node);
        GenericSequentialFlowInfo info = this.createSequential();
        info.merge(this.getFlowInfo(node), this.fFlowContext);
        info.merge(this.fLoopReentranceVisitor.getFlowInfo(node), this.fFlowContext);
        this.setFlowInfo(node, info);
    }

    private static class LoopReentranceVisitor
    extends FlowAnalyzer {
        private Selection fSelection;
        private ASTNode fLoopNode;

        public LoopReentranceVisitor(FlowContext context, Selection selection, ASTNode loopNode) {
            super(context);
            this.fSelection = selection;
            this.fLoopNode = loopNode;
        }

        @Override
        protected boolean traverseNode(ASTNode node) {
            return true;
        }

        @Override
        protected boolean createReturnFlowInfo(ReturnStatement node) {
            return node.getEnd() <= this.fSelection.getExclusiveEnd();
        }

        protected ASTNode getLoopNode() {
            return this.fLoopNode;
        }

        public void process(ASTNode node) {
            try {
                this.fFlowContext.setLoopReentranceMode(true);
                node.accept((Visitor)this);
            }
            finally {
                this.fFlowContext.setLoopReentranceMode(false);
            }
        }

        @Override
        public void endVisit(DoStatement node) {
            if (this.skipNode((ASTNode)node)) {
                return;
            }
            DoWhileFlowInfo info = this.createDoWhile();
            this.setFlowInfo((ASTNode)node, info);
            info.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
            info.removeLabel(null);
        }

        @Override
        public void endVisit(ForStatement node) {
            if (this.skipNode((ASTNode)node)) {
                return;
            }
            GenericSequentialFlowInfo initInfo = this.createSequential(node.initializers());
            GenericSequentialFlowInfo conditionInfo = this.createSequential(node.conditions());
            GenericSequentialFlowInfo incrementInfo = this.createSequential(node.updaters());
            FlowInfo actionInfo = this.getFlowInfo((ASTNode)node.getBody());
            ForFlowInfo forInfo = this.createFor();
            this.setFlowInfo((ASTNode)node, forInfo);
            if (node == this.fLoopNode) {
                forInfo.mergeIncrement(incrementInfo, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                GenericConditionalFlowInfo initIncr = new GenericConditionalFlowInfo();
                initIncr.merge(initInfo, this.fFlowContext);
                initIncr.merge(incrementInfo, this.fFlowContext);
                forInfo.mergeAccessModeSequential(initIncr, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
        }
    }
}

