/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.php.internal.debug.core.PHPExeException;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.phpIni.PHPINIUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;

public final class PHPExeUtil {
    private static final Pattern PATTERN_PHP_VERSION = Pattern.compile("PHP (\\d\\.\\d\\.\\d+).*? \\((.*?)\\)");
    private static final Pattern PATTERN_PHP_CLI_CONFIG = Pattern.compile("Configuration File \\(php.ini\\) Path => (.*)");
    private static final Pattern PATTERN_PHP_CGI_CONFIG = Pattern.compile("Configuration File \\(php.ini\\) Path </td><td class=\"v\">(.*?)</td>");
    private static final Map<File, PHPExeInfo> phpInfos = new HashMap<File, PHPExeInfo>();

    private PHPExeUtil() {
    }

    public static String exec(String ... cmd) throws IOException {
        String l;
        String[] envParams = null;
        String env = PHPLaunchUtilities.getLibrarySearchPathEnv(new File(cmd[0]).getParentFile());
        if (env != null) {
            envParams = new String[]{env};
        }
        cmd = PHPExeUtil.filterNulls(cmd);
        Process p = Runtime.getRuntime().exec(cmd, envParams);
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        StringBuilder buf = new StringBuilder();
        while ((l = r.readLine()) != null) {
            buf.append(l).append('\n');
        }
        return buf.toString();
    }

    private static String[] filterNulls(String[] cmd) {
        ArrayList<String> result = new ArrayList<String>(cmd.length);
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String el = stringArray[n2];
            if (el != null) {
                result.add(el);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public static synchronized PHPExeInfo getPHPInfo(File executableFile, boolean reload) throws PHPExeException {
        String exePath;
        PHPExeInfo phpInfo = phpInfos.get(executableFile);
        if (phpInfo != null && !reload) {
            return phpInfo;
        }
        String version = null;
        String sapiType = null;
        String name = null;
        File configFile = null;
        String string = exePath = executableFile == null ? "<null>" : executableFile.getAbsolutePath();
        if (executableFile == null || !executableFile.exists() || !executableFile.getName().toLowerCase().contains("php") || executableFile.isDirectory()) {
            return null;
        }
        File tempPHPIni = PHPINIUtil.createTemporaryPHPINIFile();
        try {
            PHPexes.changePermissions(executableFile);
            String output = PHPExeUtil.fetchVersion(executableFile, tempPHPIni, true);
            Matcher m = PATTERN_PHP_VERSION.matcher(output);
            if (!m.find() && !(m = PATTERN_PHP_VERSION.matcher(output = PHPExeUtil.fetchVersion(executableFile, tempPHPIni, false))).find()) {
                throw new PHPExeException(MessageFormat.format("Cannot determine version of the PHP executable ({0}).", exePath));
            }
            version = m.group(1);
            String sType = m.group(2);
            sapiType = null;
            if (sType.startsWith("cgi")) {
                sapiType = "CGI";
            } else if (sType.startsWith("cli")) {
                sapiType = "CLI";
            } else {
                throw new PHPExeException(MessageFormat.format("Cannot determine type of the PHP executable ({0}).", exePath));
            }
            name = "PHP " + version + " (" + sapiType + ")";
            output = PHPExeUtil.fetchInfo(executableFile, tempPHPIni, true);
            m = PHPExeUtil.getConfigMatcher(sapiType, m, output);
            if (!m.find() && !(m = PHPExeUtil.getConfigMatcher(sapiType, m, output = PHPExeUtil.fetchInfo(executableFile, tempPHPIni, false))).find()) {
                throw new PHPExeException(MessageFormat.format("Cannot determine php.ini location of the PHP executable ({0}).", exePath));
            }
            String configDir = m.group(1);
            configFile = new File(configDir.trim(), "php.ini");
            if (!configFile.exists()) {
                configFile = null;
            }
        }
        catch (IOException iOException) {
            throw new PHPExeException(MessageFormat.format("Invalid PHP executable: {0}.", exePath));
        }
        phpInfo = new PHPExeInfo(name, version, sapiType, executableFile, configFile);
        phpInfos.put(executableFile, phpInfo);
        return phpInfo;
    }

    public static List<PHPModuleInfo> getModules(PHPexeItem phpExeItem) {
        String result;
        ArrayList<PHPModuleInfo> modules = new ArrayList<PHPModuleInfo>();
        File iniFile = phpExeItem.getINILocation();
        if (iniFile == null) {
            iniFile = PHPINIUtil.findPHPIni(phpExeItem.getExecutable().getAbsolutePath());
        }
        PHPVersion phpVersion = new PHPVersion(phpExeItem);
        try {
            result = iniFile != null ? (phpVersion.getMajor() >= 5 ? PHPExeUtil.exec(phpExeItem.getExecutable().getAbsolutePath(), phpExeItem.isLoadDefaultINI() ? null : "-n", "-c", iniFile.getAbsolutePath(), "-m") : PHPExeUtil.exec(phpExeItem.getExecutable().getAbsolutePath(), "-c", iniFile.getAbsolutePath(), "-m")) : PHPExeUtil.exec(phpExeItem.getExecutable().getAbsolutePath(), "-m");
        }
        catch (IOException iOException) {
            return modules;
        }
        Scanner scanner = new Scanner(result);
        String currentGroup = null;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine().trim();
            if (line.startsWith("[")) {
                currentGroup = line;
                continue;
            }
            if (line.isEmpty()) continue;
            modules.add(new PHPModuleInfo(line, currentGroup));
        }
        scanner.close();
        return modules;
    }

    public static boolean hasModule(PHPexeItem phpExeItem, String moduleName) {
        List<PHPModuleInfo> modules = PHPExeUtil.getModules(phpExeItem);
        for (PHPModuleInfo module : modules) {
            if (!module.getName().equalsIgnoreCase(moduleName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasModule(PHPexeItem phpExeItem, String moduleName, String groupName) {
        List<PHPModuleInfo> modules = PHPExeUtil.getModules(phpExeItem);
        for (PHPModuleInfo module : modules) {
            if (!module.getName().equalsIgnoreCase(moduleName) || !module.getGroupName().equalsIgnoreCase(groupName)) continue;
            return true;
        }
        return false;
    }

    private static Matcher getConfigMatcher(String sapiType, Matcher m, String output) {
        if (sapiType == "CLI") {
            m = PATTERN_PHP_CLI_CONFIG.matcher(output);
        } else if (sapiType == "CGI") {
            m = PATTERN_PHP_CGI_CONFIG.matcher(output);
        }
        return m;
    }

    private static String fetchVersion(File exec, File tmpIni, boolean skipSystemIni) throws IOException {
        return PHPExeUtil.exec(exec.getAbsolutePath(), skipSystemIni ? null : "-n", "-c", tmpIni.getParentFile().getAbsolutePath(), "-v");
    }

    private static String fetchInfo(File exec, File tmpIni, boolean skipSystemIni) throws IOException {
        return PHPExeUtil.exec(exec.getAbsolutePath(), skipSystemIni ? null : "-n", "-c", tmpIni.getParentFile().getAbsolutePath(), "-i");
    }

    public static final class PHPExeInfo {
        private String version;
        private String sapiType;
        private File systemIniFile;
        private File execFile;
        private String name;

        private PHPExeInfo(String name, String version, String sapiType, File execFile, File systemIniFile) {
            this.name = name;
            this.version = version;
            this.sapiType = sapiType;
            this.systemIniFile = systemIniFile;
            this.execFile = execFile;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSapiType() {
            return this.sapiType;
        }

        public File getSystemINIFile() {
            return this.systemIniFile;
        }

        public File getExecFile() {
            return this.execFile;
        }
    }

    public static final class PHPModuleInfo {
        private String name;
        private String groupName;

        public PHPModuleInfo(String name, String groupName) {
            this.name = name;
            this.groupName = groupName;
        }

        public String getName() {
            return this.name;
        }

        public String getGroupName() {
            return this.groupName;
        }
    }

    public static final class PHPVersion {
        private int major = 0;
        private int minor = 0;
        private int service = 0;

        private PHPVersion(PHPexeItem phpExeItem) {
            this.build(phpExeItem.getVersion());
        }

        private void build(String version) {
            if (version == null) {
                return;
            }
            String[] parts = version.split("\\.");
            try {
                this.major = Integer.valueOf(parts[0]);
                this.minor = Integer.valueOf(parts[1]);
                this.service = Integer.valueOf(parts[2]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getService() {
            return this.service;
        }
    }
}

