/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.debug.core.debugger.launching.ILaunchDelegateListener;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.phpIni.PHPINIUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NoneDebuggerConfiguration
extends AbstractDebuggerConfiguration {
    public static final String ID = "org.eclipse.php.debug.core.noneDebugger";
    private static final String NAME = "<none>";

    @Override
    public void openConfigurationDialog(Shell parentShell) {
    }

    @Override
    public String getAttribute(String id) {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getScriptLaunchDelegateClass() {
        return ScriptLaunchDelegate.class.getName();
    }

    @Override
    public String getWebLaunchDelegateClass() {
        return WebLaunchDelegate.class.getName();
    }

    @Override
    public String getDebuggerId() {
        return ID;
    }

    @Override
    public void save() {
    }

    @Override
    public void setPort(int port) {
    }

    @Override
    public String getModuleId() {
        return NAME;
    }

    @Override
    public void applyDefaults() {
    }

    @Override
    public IStatus validate(PHPexeItem item) {
        return Status.OK_STATUS;
    }

    private static void displayError(final String message) {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.Debugger_LaunchError_title, (String)message);
            }
        });
    }

    public static final class ScriptLaunchDelegate
    extends LaunchConfigurationDelegate {
        public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
            PHPexeItem phpExeItem = PHPLaunchUtilities.getPHPExe(configuration);
            if (phpExeItem == null) {
                NoneDebuggerConfiguration.displayError(MessageFormat.format(PHPDebugCoreMessages.NoneDebuggerConfiguration_There_is_no_PHP_runtime_environment, configuration.getName()));
                return false;
            }
            String phpExeString = configuration.getAttribute("ATTR_LOCATION", null);
            if (phpExeString == null || !new File(phpExeString).exists()) {
                NoneDebuggerConfiguration.displayError(MessageFormat.format(PHPDebugCoreMessages.NoneDebuggerConfiguration_PHP_executable_file_is_invalid, configuration.getName()));
                return false;
            }
            String fileName = configuration.getAttribute("ATTR_FILE_FULL_PATH", null);
            if (fileName == null || !new File(fileName).exists()) {
                NoneDebuggerConfiguration.displayError(MessageFormat.format(PHPDebugCoreMessages.NoneDebuggerConfiguration_PHP_script_file_is_invalid, configuration.getName()));
                return false;
            }
            if (mode.equals("debug")) {
                NoneDebuggerConfiguration.displayError(MessageFormat.format(PHPDebugCoreMessages.NoneDebuggerConfiguration_There_is_no_debugger_attached_for_PHP_executable, configuration.getName(), phpExeItem.getName()));
                return false;
            }
            return true;
        }

        public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
            PHPexeItem[] items;
            if (!PHPLaunchUtilities.notifyPreviousLaunches(launch)) {
                monitor.setCanceled(true);
                monitor.done();
                return;
            }
            String phpExeString = configuration.getAttribute("ATTR_LOCATION", null);
            String phpIniPath = configuration.getAttribute("ATTR_INI_LOCATION", null);
            String fileName = configuration.getAttribute("ATTR_FILE_FULL_PATH", null);
            IProject project = null;
            String file = configuration.getAttribute("ATTR_FILE", null);
            if (file != null) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(file);
                if (resource != null) {
                    project = resource.getProject();
                } else {
                    IProject resolved;
                    String projectName = configuration.getAttribute("ATTR_PROJECT_NAME", null);
                    if (projectName != null && (resolved = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && resolved.isAccessible()) {
                        project = resolved;
                    }
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
            File phpIni = phpIniPath != null && new File(phpIniPath).exists() ? new File(phpIniPath) : PHPINIUtil.findPHPIni(phpExeString);
            File tempIni = PHPINIUtil.prepareBeforeLaunch(phpIni, phpExeString, project);
            launch.setAttribute("PHPIniLocation", tempIni.getAbsolutePath());
            Path phpExe = new Path(phpExeString);
            String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
            File phpExeFile = new File(phpExeString);
            String phpIniLocation = launch.getAttribute("PHPIniLocation");
            String phpConfigDir = phpExeFile.getParent();
            if (phpIniLocation != null && !phpIniLocation.equals("")) {
                phpConfigDir = new File(phpIniLocation).getParent();
            }
            String sapiType = null;
            String phpVersion = null;
            PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getAllItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem item = pHPexeItemArray[n2];
                if (item.getExecutable().equals(phpExeFile)) {
                    sapiType = item.getSapiType();
                    phpVersion = item.getVersion();
                    break;
                }
                ++n2;
            }
            String[] args = PHPLaunchUtilities.getProgramArguments(launch.getLaunchConfiguration());
            String[] cmdLine = PHPLaunchUtilities.getCommandLine(launch.getLaunchConfiguration(), phpExeString, phpConfigDir, fileName, (String[])("CLI".equals(sapiType) ? args : null), phpVersion);
            String libPath = PHPLaunchUtilities.getLibrarySearchPathEnv(phpExeFile.getParentFile());
            if (libPath != null) {
                String[] envpNew = new String[envp == null ? 1 : envp.length + 1];
                if (envp != null) {
                    System.arraycopy(envp, 0, envpNew, 0, envp.length);
                }
                envpNew[envpNew.length - 1] = libPath;
                envp = envpNew;
            }
            if (monitor.isCanceled()) {
                return;
            }
            File workingDir = new File(fileName).getParentFile();
            Process process = workingDir.exists() ? DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp) : DebugPlugin.exec((String[])cmdLine, null, (String[])envp);
            new Thread(new ProcessCrashDetector(launch, process)).start();
            IProcess runtimeProcess = null;
            HashMap<String, String> processAttributes = new HashMap<String, String>();
            String programName = phpExe.lastSegment();
            String extension = phpExe.getFileExtension();
            if (extension != null) {
                programName = programName.substring(0, programName.length() - (extension.length() + 1));
            }
            programName = programName.toLowerCase();
            processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
            if (process != null) {
                subMonitor = new SubProgressMonitor(monitor, 90);
                subMonitor.beginTask(MessageFormat.format(PHPDebugCoreMessages.NoneDebuggerConfiguration_Launching, configuration.getName()), -1);
                runtimeProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)phpExe.toOSString(), processAttributes);
                if (runtimeProcess == null) {
                    process.destroy();
                    throw new CoreException((IStatus)new Status(4, PHPDebugPlugin.getID(), 0, null, null));
                }
                subMonitor.done();
            }
            runtimeProcess.setAttribute(IProcess.ATTR_CMDLINE, fileName);
        }
    }

    public static final class WebLaunchDelegate
    extends LaunchConfigurationDelegate {
        private static final String LAUNCH_LISTENERS_EXTENSION_ID = "org.eclipse.php.debug.core.phpLaunchDelegateListener";
        private List<ILaunchDelegateListener> preLaunchListeners = new ArrayList<ILaunchDelegateListener>();

        public WebLaunchDelegate() {
            this.registerLaunchListeners();
        }

        public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
            Server server = PHPLaunchUtilities.getPHPServer(configuration);
            if (server == null) {
                NoneDebuggerConfiguration.displayError(MessageFormat.format(PHPDebugCoreMessages.NoneDebuggerConfiguration_There_is_no_PHP_server_specified, configuration.getName()));
                return false;
            }
            String fileName = configuration.getAttribute("file_name", null);
            if (fileName == null) {
                NoneDebuggerConfiguration.displayError(MessageFormat.format(PHPDebugCoreMessages.NoneDebuggerConfiguration_PHP_source_file_is_invalid, configuration.getName()));
                return false;
            }
            if (mode.equals("debug")) {
                Server phpServer = PHPLaunchUtilities.getPHPServer(configuration);
                NoneDebuggerConfiguration.displayError(MessageFormat.format(PHPDebugCoreMessages.NoneDebuggerConfiguration_There_is_no_debugger_attached_for_PHP_server, configuration.getName(), phpServer.getName()));
                return false;
            }
            return true;
        }

        public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
            int resultCode = this.notifyPreLaunch(configuration, mode, launch, monitor);
            if (resultCode != 0) {
                monitor.setCanceled(true);
                monitor.done();
                return;
            }
            if (!PHPLaunchUtilities.notifyPreviousLaunches(launch)) {
                monitor.setCanceled(true);
                monitor.done();
                return;
            }
            String fileName = configuration.getAttribute("file_name", null);
            Path filePath = new Path(fileName);
            IProject project = null;
            try {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(filePath.segment(0));
            }
            catch (Throwable throwable) {}
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            String projectLocation = project.getFullPath().toString();
            wc.setAttribute("org.eclipse.php.debug.core.PHP_Project", projectLocation);
            wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(project));
            wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(project));
            wc.setAttribute("php_debug_type", "php_web_page_debug");
            wc.doSave();
            String launchURL = new String(configuration.getAttribute("base_url", "").getBytes());
            launch.setAttribute("webServerDebugger", Boolean.toString(true));
            launch.setAttribute("uriginalURL", launchURL);
            DebugPlugin.newProcess((ILaunch)launch, (Process)new MockProcess(launchURL), (String)launchURL, new HashMap());
        }

        protected int notifyPreLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
            for (ILaunchDelegateListener listener : this.preLaunchListeners) {
                int returnCode = listener.preLaunch(configuration, mode, launch, monitor);
                if (returnCode == 0) continue;
                return returnCode;
            }
            return 0;
        }

        private void registerLaunchListeners() {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(LAUNCH_LISTENERS_EXTENSION_ID);
            try {
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    final Object o = e.createExecutableExtension("class");
                    if (o instanceof ILaunchDelegateListener) {
                        ISafeRunnable runnable = new ISafeRunnable(){

                            public void run() throws Exception {
                                ILaunchDelegateListener listener = (ILaunchDelegateListener)o;
                                Assert.isNotNull((Object)listener);
                                WebLaunchDelegate.this.preLaunchListeners.add(listener);
                            }

                            public void handleException(Throwable exception) {
                                Logger.logException(exception);
                            }
                        };
                        SafeRunner.run((ISafeRunnable)runnable);
                    }
                    ++n2;
                }
            }
            catch (CoreException ex) {
                Logger.logException(ex);
            }
        }

        private final class MockProcess
        extends Process {
            private String launchURL;
            private OutputStream outputStream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            };
            private InputStream inputStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            };
            private InputStream errorStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            };

            private MockProcess(String launchURL) {
                this.launchURL = launchURL;
            }

            @Override
            public int waitFor() throws InterruptedException {
                try {
                    PHPDebugUtil.openLaunchURL(this.launchURL);
                }
                catch (DebugException e) {
                    Logger.logException("Error while opening launch URL.", e);
                }
                return 0;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.outputStream;
            }

            @Override
            public InputStream getInputStream() {
                return this.inputStream;
            }

            @Override
            public InputStream getErrorStream() {
                return this.errorStream;
            }

            @Override
            public int exitValue() {
                throw new IllegalThreadStateException();
            }

            @Override
            public void destroy() {
            }
        }
    }
}

