/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.UserLibrary;
import org.eclipse.dltk.internal.core.UserLibraryManager;
import org.eclipse.dltk.internal.ui.wizards.BuildpathAttributeConfiguration;
import org.eclipse.dltk.internal.ui.wizards.buildpath.AccessRulesDialog;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementSorter;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListLabelProvider;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPUserLibraryElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildpathAttributeConfigurationDescriptors;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.preferences.UserLibraryPreferencePage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.ui.preferences.IPHPLibraryButtonHandler;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class PhpLibraryPreferencePage
extends UserLibraryPreferencePage {
    private static final String BUILTIN_ATTRIBUTE = "builtin";
    private static final String BTN_HANDLERS_EXTENSION_POINT = "libraryButtonHandlers";
    private static final String ID_TEMPLATE = "org.eclipse.dltk.{0}.preferences.UserLibraryPreferencePage";
    private IDialogSettings fDialogSettings;
    private IScriptProject fDummyProject;
    private BuildpathAttributeConfigurationDescriptors fAttributeDescriptors;
    private static List<IPHPLibraryButtonHandler> handlers;

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.php_libraries_preferences");
        super.performHelp();
    }

    public PhpLibraryPreferencePage() {
        this.setPreferenceStore(DLTKUIPlugin.getDefault().getPreferenceStore());
        this.fDummyProject = PhpLibraryPreferencePage.createPlaceholderProject();
        this.fAttributeDescriptors = DLTKUIPlugin.getDefault().getClasspathAttributeConfigurationDescriptors();
        this.setTitle(PreferencesMessages.UserLibraryPreferencePage_title);
        this.setDescription(PreferencesMessages.UserLibraryPreferencePage_description);
        this.noDefaultAndApplyButton();
        this.fDialogSettings = DLTKUIPlugin.getDefault().getDialogSettings();
        UserLibraryAdapter adapter = new UserLibraryAdapter();
        handlers = new ArrayList<IPHPLibraryButtonHandler>();
        handlers.add(new NewButtonHandler());
        handlers.add(new EditButtonHandler());
        handlers.add(new AddZipButtonHandler());
        handlers.add(new AddExternalButtonHandler());
        handlers.add(new RemoveButtonHandler());
        handlers.add(new EmptyButtonHandler());
        handlers.add(new UpButtonHandler());
        handlers.add(new DownButtonHandler());
        handlers.add(new EmptyButtonHandler());
        handlers.add(new LoadButtonHandler());
        handlers.add(new SaveButtonHandler());
        List<IPHPLibraryButtonHandler> additionalHandlers = this.getHandlers();
        for (IPHPLibraryButtonHandler handler : additionalHandlers) {
            int position = handler.getPosition();
            if (position < 0) {
                position = 0;
            }
            if (position > handlers.size()) {
                position = handlers.size();
            }
            handlers.add(handler.getPosition(), handler);
        }
        String[] buttonLabels = new String[handlers.size()];
        int size = handlers.size();
        int i = 0;
        while (i < size) {
            buttonLabels[i] = handlers.get(i).getLabel();
            ++i;
        }
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        this.fLibraryList = new TreeListDialogField((ITreeListAdapter)adapter, buttonLabels, (ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new BPListLabelProvider(), (ILabelDecorator)decoratorManager));
        this.fLibraryList.setLabelText(PreferencesMessages.UserLibraryPreferencePage_libraries_label);
        String[] names = DLTKCore.getUserLibraryNames((IDLTKLanguageToolkit)this.getLanguageToolkit());
        ArrayList<BPUserLibraryElement> elements = new ArrayList<BPUserLibraryElement>();
        int i2 = 0;
        while (i2 < names.length) {
            UserLibrary lib = ModelManager.getUserLibraryManager().getUserLibrary(names[i2], this.getLanguageToolkit());
            if (lib != null) {
                IPath path = new Path("org.eclipse.dltk.USER_LIBRARY").append(UserLibraryManager.makeLibraryName((String)names[i2], (IDLTKLanguageToolkit)this.getLanguageToolkit()));
                try {
                    IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)path, (IScriptProject)this.fDummyProject);
                    elements.add(new BPUserLibraryElement(names[i2], container, this.fDummyProject, lib.getAttributes()));
                }
                catch (ModelException e) {
                    DLTKUIPlugin.log((Throwable)e);
                }
            }
            ++i2;
        }
        this.fLibraryList.setElements(elements);
        this.fLibraryList.setViewerSorter((ViewerSorter)new BPListElementSorter());
        this.doSelectionChanged(this.fLibraryList);
    }

    public static String getPreferencePageId(IDLTKLanguageToolkit toolkit) {
        return NLS.bind((String)ID_TEMPLATE, (Object)toolkit.getLanguageName().toLowerCase());
    }

    protected void doSelectionChanged(TreeListDialogField field) {
        if (handlers != null) {
            int size = handlers.size();
            int i = 0;
            while (i < size) {
                field.enableButton(i, handlers.get(i).selectionChanged(field));
                ++i;
            }
        }
    }

    protected void doCustomButtonPressed(TreeListDialogField field, int index) {
        if (handlers != null) {
            handlers.get(index).handleSelection(field);
        }
    }

    protected IDLTKLanguageToolkit getLanguageToolkit() {
        return PHPLanguageToolkit.getDefault();
    }

    private static IScriptProject createPlaceholderProject() {
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name)).exists()) {
            name = String.valueOf(name) + '1';
        }
        return DLTKCore.create((IProject)project);
    }

    private BPUserLibraryElement getSingleSelectedLibrary(List selected) {
        if (selected.size() == 1 && selected.get(0) instanceof BPUserLibraryElement) {
            return (BPUserLibraryElement)selected.get(0);
        }
        return null;
    }

    private void editAttributeEntry(BPListElementAttribute elem) {
        IBuildpathAttribute result;
        BuildpathAttributeConfiguration config;
        String key = elem.getKey();
        BPListElement selElement = elem.getParent();
        if (key.equals("accessrules")) {
            AccessRulesDialog dialog = new AccessRulesDialog(this.getShell(), selElement, null, false);
            if (dialog.open() == 0) {
                selElement.setAttribute("accessrules", (Object)dialog.getAccessRules());
                this.fLibraryList.refresh((Object)elem);
                this.fLibraryList.expandElement((Object)elem, 2);
            }
        } else if (!elem.isBuiltIn() && (config = this.fAttributeDescriptors.get(key)) != null && (result = config.performEdit(this.getShell(), elem.getBuildpathAttributeAccess())) != null) {
            elem.setValue((Object)result.getValue());
            this.fLibraryList.refresh((Object)elem);
        }
    }

    private void doEdit(List selected) {
        if (selected.size() == 1) {
            Object curr = selected.get(0);
            if (curr instanceof BPListElementAttribute) {
                this.editAttributeEntry((BPListElementAttribute)curr);
            } else if (curr instanceof BPUserLibraryElement) {
                this.editUserLibraryElement((BPUserLibraryElement)curr);
            } else if (curr instanceof BPListElement) {
                BPListElement elem = (BPListElement)curr;
                if (((BPListElement)curr).isExternalFolder()) {
                    this.editExternalElement(elem, (BPUserLibraryElement)elem.getParentContainer());
                } else {
                    this.editArchiveElement(elem, (BPUserLibraryElement)elem.getParentContainer());
                }
            }
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private void editUserLibraryElement(BPUserLibraryElement element) {
        UserLibraryPreferencePage.LibraryNameDialog dialog = new UserLibraryPreferencePage.LibraryNameDialog(this.getShell(), element, this.fLibraryList.getElements());
        if (dialog.open() == 0) {
            BPUserLibraryElement newLibrary = dialog.getNewLibrary();
            if (element != null) {
                this.fLibraryList.replaceElement((Object)element, (Object)newLibrary);
            } else {
                this.fLibraryList.addElement((Object)newLibrary);
            }
            this.fLibraryList.expandElement((Object)newLibrary, -1);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)newLibrary));
        }
    }

    private void editArchiveElement(BPListElement existingElement, BPUserLibraryElement parent) {
        BPListElement[] elements = this.openExtZipFileDialog(existingElement, parent);
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                if (existingElement != null) {
                    parent.replace(existingElement, elements[i]);
                } else {
                    parent.add(elements[i]);
                }
                ++i;
            }
            this.fLibraryList.refresh((Object)parent);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection(Arrays.asList(elements)));
            this.fLibraryList.expandElement((Object)parent, 2);
        }
    }

    private void editExternalElement(BPListElement existingElement, BPUserLibraryElement parent) {
        BPListElement[] elements = this.openExtSourceFolderDialog(existingElement, parent);
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                if (existingElement != null) {
                    parent.replace(existingElement, elements[i]);
                } else {
                    parent.add(elements[i]);
                }
                ++i;
            }
            this.fLibraryList.refresh((Object)parent);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection(Arrays.asList(elements)));
            this.fLibraryList.expandElement((Object)parent, 2);
        }
    }

    private void doRemove(List selected) {
        Object selectionAfter = null;
        int i = 0;
        while (i < selected.size()) {
            Object curr = selected.get(i);
            if (curr instanceof BPUserLibraryElement) {
                this.fLibraryList.removeElement(curr);
            } else if (curr instanceof BPListElement) {
                Object parent = ((BPListElement)curr).getParentContainer();
                if (parent instanceof BPUserLibraryElement) {
                    BPUserLibraryElement elem = (BPUserLibraryElement)parent;
                    elem.remove((BPListElement)curr);
                    this.fLibraryList.refresh((Object)elem);
                    selectionAfter = parent;
                }
            } else if (curr instanceof BPListElementAttribute) {
                BPListElementAttribute attrib = (BPListElementAttribute)curr;
                if (attrib.isBuiltIn()) {
                    IAccessRule[] value = null;
                    String key = attrib.getKey();
                    if (key.equals("accessrules")) {
                        value = new IAccessRule[]{};
                    }
                    attrib.getParent().setAttribute(key, (Object)value);
                    this.fLibraryList.refresh((Object)attrib);
                } else {
                    IBuildpathAttribute result;
                    BuildpathAttributeConfiguration config = this.fAttributeDescriptors.get(attrib.getKey());
                    if (config != null && (result = config.performRemove(attrib.getBuildpathAttributeAccess())) != null) {
                        attrib.setValue((Object)result.getValue());
                        this.fLibraryList.refresh((Object)attrib);
                    }
                }
            }
            ++i;
        }
        if (this.fLibraryList.getSelectedElements().isEmpty()) {
            if (selectionAfter != null) {
                this.fLibraryList.selectElements((ISelection)new StructuredSelection(selectionAfter));
            } else {
                this.fLibraryList.selectFirstElement();
            }
        } else {
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private void doAdd(List list) {
        if (this.canAdd(list)) {
            BPUserLibraryElement element = this.getSingleSelectedLibrary(list);
            this.editArchiveElement(null, element);
        }
    }

    private void doAddExternal(List list) {
        if (this.canAdd(list)) {
            BPUserLibraryElement element = this.getSingleSelectedLibrary(list);
            this.editExternalElement(null, element);
        }
    }

    private void doLoad() {
        List existing = this.fLibraryList.getElements();
        UserLibraryPreferencePage.LoadSaveDialog dialog = new UserLibraryPreferencePage.LoadSaveDialog(this.getShell(), false, existing, this.fDialogSettings);
        if (dialog.open() == 0) {
            HashMap<String, BPUserLibraryElement> map = new HashMap<String, BPUserLibraryElement>(existing.size());
            int k = 0;
            while (k < existing.size()) {
                BPUserLibraryElement elem = (BPUserLibraryElement)existing.get(k);
                map.put(elem.getName(), elem);
                ++k;
            }
            List list = dialog.getLoadedLibraries();
            int i = 0;
            while (i < list.size()) {
                BPUserLibraryElement elem = (BPUserLibraryElement)list.get(i);
                BPUserLibraryElement found = (BPUserLibraryElement)map.get(elem.getName());
                if (found == null) {
                    existing.add(elem);
                    map.put(elem.getName(), elem);
                } else {
                    existing.set(existing.indexOf(found), elem);
                }
                ++i;
            }
            this.fLibraryList.setElements(existing);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection(list));
        }
    }

    private void doSave() {
        UserLibraryPreferencePage.LoadSaveDialog dialog = new UserLibraryPreferencePage.LoadSaveDialog(this.getShell(), true, this.fLibraryList.getElements(), this.fDialogSettings);
        dialog.open();
    }

    protected void doDoubleClicked(TreeListDialogField field) {
        List selected = field.getSelectedElements();
        if (this.canEdit(selected)) {
            this.doEdit(field.getSelectedElements());
        }
    }

    protected boolean canAdd(List list) {
        BPUserLibraryElement lib;
        if (this.getSingleSelectedLibrary(list) == null) {
            return false;
        }
        Object firstElement = list.get(0);
        return !(firstElement instanceof BPUserLibraryElement) || !this.isBuiltIn(lib = (BPUserLibraryElement)firstElement);
    }

    private boolean canEdit(List list) {
        BPUserLibraryElement lib;
        BPListElement listElem;
        Object parent;
        BPUserLibraryElement lib2;
        if (list.size() != 1) {
            return false;
        }
        Object firstElement = list.get(0);
        if (firstElement instanceof BPUserLibraryElement && this.isBuiltIn(lib2 = (BPUserLibraryElement)firstElement)) {
            return false;
        }
        if (firstElement instanceof BPListElement && (parent = (listElem = (BPListElement)firstElement).getParentContainer()) instanceof BPUserLibraryElement && this.isBuiltIn(lib = (BPUserLibraryElement)parent)) {
            return false;
        }
        if (firstElement instanceof IAccessRule) {
            return false;
        }
        if (firstElement instanceof BPListElementAttribute) {
            BPListElementAttribute attrib = (BPListElementAttribute)firstElement;
            if (attrib.getParent().getParentContainer() instanceof BPUserLibraryElement) {
                if (this.isBuiltIn((BPUserLibraryElement)attrib.getParent().getParentContainer())) {
                    return false;
                }
            } else if (!attrib.isBuiltIn()) {
                BuildpathAttributeConfiguration config = this.fAttributeDescriptors.get(attrib.getKey());
                return config != null && config.canEdit(attrib.getBuildpathAttributeAccess());
            }
        }
        return true;
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            Object elem = list.get(i);
            if (elem instanceof BPListElementAttribute) {
                BPListElementAttribute attrib = (BPListElementAttribute)elem;
                if (attrib.isBuiltIn()) {
                    if (attrib.getKey().equals("accessrules")) {
                        return ((IAccessRule[])attrib.getValue()).length > 0;
                    }
                    if (attrib.getValue() == null) {
                        return false;
                    }
                } else {
                    BuildpathAttributeConfiguration config = this.fAttributeDescriptors.get(attrib.getKey());
                    if (config == null || !config.canRemove(attrib.getBuildpathAttributeAccess())) {
                        return false;
                    }
                }
            } else if (elem instanceof BPListElement) {
                BPUserLibraryElement lib;
                BPListElement listElem = (BPListElement)elem;
                Object parent = listElem.getParentContainer();
                if (parent instanceof BPUserLibraryElement && this.isBuiltIn(lib = (BPUserLibraryElement)parent)) {
                    return false;
                }
            } else if (elem instanceof BPUserLibraryElement) {
                BPUserLibraryElement lib = (BPUserLibraryElement)elem;
                if (this.isBuiltIn(lib)) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isBuiltIn(BPUserLibraryElement element) {
        String value = element.getAttribute(BUILTIN_ATTRIBUTE);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BPUserLibraryElement getCommonParent(List list) {
        BPUserLibraryElement parent = null;
        int i = 0;
        int len = list.size();
        while (i < len) {
            Object curr = list.get(i);
            if (!(curr instanceof BPListElement)) return null;
            Object elemParent = ((BPListElement)curr).getParentContainer();
            if (parent == null) {
                if (!(elemParent instanceof BPUserLibraryElement)) return null;
                parent = (BPUserLibraryElement)elemParent;
            } else if (parent != elemParent) {
                return null;
            }
            ++i;
        }
        return parent;
    }

    private void doMoveUp(List list) {
        BPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            parent.moveUp(list);
            this.fLibraryList.refresh((Object)parent);
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private void doMoveDown(List list) {
        BPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            parent.moveDown(list);
            this.fLibraryList.refresh((Object)parent);
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private boolean canMoveUp(List list) {
        BPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            BPListElement[] children = parent.getChildren();
            int i = 0;
            int len = Math.min(list.size(), children.length);
            while (i < len) {
                if (!list.contains(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean canMoveDown(List list) {
        BPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            BPListElement[] children = parent.getChildren();
            int i = children.length - 1;
            int end = Math.max(0, children.length - list.size());
            while (i >= end) {
                if (!list.contains(children[i])) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    private BPListElement[] openExtZipFileDialog(BPListElement existing, Object parent) {
        String res;
        String lastUsedPath;
        if (existing != null) {
            lastUsedPath = existing.getPath().removeLastSegments(1).toOSString();
        } else {
            lastUsedPath = this.fDialogSettings.get("org.eclipse.dltk.ui.lastextzip");
            if (lastUsedPath == null) {
                lastUsedPath = "";
            }
        }
        String title = existing == null ? PreferencesMessages.UserLibraryPreferencePage_browsejar_new_title : PreferencesMessages.UserLibraryPreferencePage_browsejar_edit_title;
        FileDialog dialog = new FileDialog(this.getShell(), existing == null ? 2 : 4);
        dialog.setText(title);
        dialog.setFilterExtensions(new String[]{"*.zip"});
        dialog.setFilterPath(lastUsedPath);
        if (existing != null) {
            dialog.setFileName(existing.getPath().lastSegment());
        }
        if ((res = dialog.open()) == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath filterPath = Path.fromOSString((String)dialog.getFilterPath());
        BPListElement[] elems = new BPListElement[nChosen];
        int i = 0;
        while (i < nChosen) {
            BPListElement curr;
            IPath path = filterPath.append(fileNames[i]).makeAbsolute();
            IFile file = root.getFileForLocation(path);
            if (file != null) {
                path = file.getFullPath();
            }
            path = EnvironmentPathUtils.getFullPath((IEnvironment)EnvironmentManager.getLocalEnvironment(), (IPath)path);
            elems[i] = curr = new BPListElement(parent, null, 1, path, (IResource)file, true);
            ++i;
        }
        this.fDialogSettings.put("org.eclipse.dltk.ui.lastextzip", dialog.getFilterPath());
        return elems;
    }

    private BPListElement[] openExtSourceFolderDialog(BPListElement existing, Object parent) {
        BPListElement curr;
        String lastUsedPath;
        if (existing != null) {
            lastUsedPath = EnvironmentPathUtils.getLocalPath((IPath)existing.getPath().removeLastSegments(1)).toOSString();
        } else {
            lastUsedPath = this.fDialogSettings.get("org.eclipse.dltk.ui.lastextsource");
            if (lastUsedPath == null) {
                lastUsedPath = "";
            }
        }
        String title = existing == null ? PreferencesMessages.UserLibraryPreferencePage_browseext_new_title : PreferencesMessages.UserLibraryPreferencePage_browseext_edit_title;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), existing == null ? 2 : 4);
        dialog.setText(title);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        BPListElement[] elems = new BPListElement[1];
        IPath path = Path.fromOSString((String)res).makeAbsolute();
        elems[0] = curr = new BPListElement(parent, null, 1, EnvironmentPathUtils.getFullPath((IEnvironment)EnvironmentManager.getLocalEnvironment(), (IPath)path), null, true);
        this.fDialogSettings.put("org.eclipse.dltk.ui.lastextsource", dialog.getFilterPath());
        return elems;
    }

    private List<IPHPLibraryButtonHandler> getHandlers() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.ui", BTN_HANDLERS_EXTENSION_POINT);
        ArrayList<IPHPLibraryButtonHandler> result = new ArrayList<IPHPLibraryButtonHandler>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("handler".equals(element.getName())) {
                try {
                    Object handler = element.createExecutableExtension("class");
                    if (handler instanceof IPHPLibraryButtonHandler) {
                        result.add((IPHPLibraryButtonHandler)handler);
                    }
                }
                catch (CoreException e) {
                    PHPUiPlugin.log(e);
                }
            }
            ++n2;
        }
        return result;
    }

    private class AddExternalButtonHandler
    implements IPHPLibraryButtonHandler {
        private AddExternalButtonHandler() {
        }

        @Override
        public boolean selectionChanged(TreeListDialogField field) {
            return PhpLibraryPreferencePage.this.canAdd(field.getSelectedElements());
        }

        @Override
        public void handleSelection(TreeListDialogField field) {
            PhpLibraryPreferencePage.this.doAddExternal(field.getSelectedElements());
        }

        @Override
        public String getLabel() {
            return PreferencesMessages.UserLibraryPreferencePage_libraries_addext_button;
        }

        @Override
        public int getPosition() {
            return 3;
        }
    }

    private class AddZipButtonHandler
    implements IPHPLibraryButtonHandler {
        private AddZipButtonHandler() {
        }

        @Override
        public boolean selectionChanged(TreeListDialogField field) {
            return PhpLibraryPreferencePage.this.canAdd(field.getSelectedElements()) && PhpLibraryPreferencePage.this.getLanguageToolkit().languageSupportZIPBuildpath();
        }

        @Override
        public void handleSelection(TreeListDialogField field) {
            PhpLibraryPreferencePage.this.doAdd(field.getSelectedElements());
        }

        @Override
        public String getLabel() {
            return PreferencesMessages.UserLibraryPreferencePage_libraries_addzip_button;
        }

        @Override
        public int getPosition() {
            return 2;
        }
    }

    private class DownButtonHandler
    implements IPHPLibraryButtonHandler {
        private DownButtonHandler() {
        }

        @Override
        public boolean selectionChanged(TreeListDialogField field) {
            return PhpLibraryPreferencePage.this.canMoveDown(field.getSelectedElements());
        }

        @Override
        public void handleSelection(TreeListDialogField field) {
            PhpLibraryPreferencePage.this.doMoveDown(field.getSelectedElements());
        }

        @Override
        public String getLabel() {
            return PreferencesMessages.UserLibraryPreferencePage_UserLibraryPreferencePage_libraries_down_button;
        }

        @Override
        public int getPosition() {
            return 6;
        }
    }

    private class EditButtonHandler
    implements IPHPLibraryButtonHandler {
        private EditButtonHandler() {
        }

        @Override
        public boolean selectionChanged(TreeListDialogField field) {
            return PhpLibraryPreferencePage.this.canEdit(field.getSelectedElements());
        }

        @Override
        public void handleSelection(TreeListDialogField field) {
            PhpLibraryPreferencePage.this.doEdit(field.getSelectedElements());
        }

        @Override
        public String getLabel() {
            return PreferencesMessages.UserLibraryPreferencePage_libraries_edit_button;
        }

        @Override
        public int getPosition() {
            return 1;
        }
    }

    private class EmptyButtonHandler
    implements IPHPLibraryButtonHandler {
        private EmptyButtonHandler() {
        }

        @Override
        public boolean selectionChanged(TreeListDialogField field) {
            return false;
        }

        @Override
        public void handleSelection(TreeListDialogField field) {
        }

        @Override
        public String getLabel() {
            return null;
        }

        @Override
        public int getPosition() {
            return 9;
        }
    }

    private class LoadButtonHandler
    implements IPHPLibraryButtonHandler {
        private LoadButtonHandler() {
        }

        @Override
        public boolean selectionChanged(TreeListDialogField field) {
            return true;
        }

        @Override
        public void handleSelection(TreeListDialogField field) {
            PhpLibraryPreferencePage.this.doLoad();
        }

        @Override
        public String getLabel() {
            return PreferencesMessages.UserLibraryPreferencePage_libraries_load_button;
        }

        @Override
        public int getPosition() {
            return 7;
        }
    }

    private class NewButtonHandler
    implements IPHPLibraryButtonHandler {
        private NewButtonHandler() {
        }

        @Override
        public boolean selectionChanged(TreeListDialogField field) {
            return true;
        }

        @Override
        public void handleSelection(TreeListDialogField field) {
            PhpLibraryPreferencePage.this.editUserLibraryElement(null);
        }

        @Override
        public String getLabel() {
            return PreferencesMessages.UserLibraryPreferencePage_libraries_new_button;
        }

        @Override
        public int getPosition() {
            return 0;
        }
    }

    private class RemoveButtonHandler
    implements IPHPLibraryButtonHandler {
        private RemoveButtonHandler() {
        }

        @Override
        public boolean selectionChanged(TreeListDialogField field) {
            return PhpLibraryPreferencePage.this.canRemove(field.getSelectedElements());
        }

        @Override
        public void handleSelection(TreeListDialogField field) {
            PhpLibraryPreferencePage.this.doRemove(field.getSelectedElements());
        }

        @Override
        public String getLabel() {
            return PreferencesMessages.UserLibraryPreferencePage_libraries_remove_button;
        }

        @Override
        public int getPosition() {
            return 4;
        }
    }

    private class SaveButtonHandler
    implements IPHPLibraryButtonHandler {
        private SaveButtonHandler() {
        }

        @Override
        public boolean selectionChanged(TreeListDialogField field) {
            return field.getSize() > 0;
        }

        @Override
        public void handleSelection(TreeListDialogField field) {
            PhpLibraryPreferencePage.this.doSave();
        }

        @Override
        public String getLabel() {
            return PreferencesMessages.UserLibraryPreferencePage_libraries_save_button;
        }

        @Override
        public int getPosition() {
            return 8;
        }
    }

    private class UpButtonHandler
    implements IPHPLibraryButtonHandler {
        private UpButtonHandler() {
        }

        @Override
        public boolean selectionChanged(TreeListDialogField field) {
            return PhpLibraryPreferencePage.this.canMoveUp(field.getSelectedElements());
        }

        @Override
        public void handleSelection(TreeListDialogField field) {
            PhpLibraryPreferencePage.this.doMoveUp(field.getSelectedElements());
        }

        @Override
        public String getLabel() {
            return PreferencesMessages.UserLibraryPreferencePage_UserLibraryPreferencePage_libraries_up_button;
        }

        @Override
        public int getPosition() {
            return 5;
        }
    }

    private class UserLibraryAdapter
    implements ITreeListAdapter {
        private final Object[] EMPTY = new Object[0];

        private UserLibraryAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            PhpLibraryPreferencePage.this.doCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            PhpLibraryPreferencePage.this.doSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            PhpLibraryPreferencePage.this.doDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            PhpLibraryPreferencePage.this.doKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            BPListElementAttribute attribute;
            if (element instanceof BPUserLibraryElement) {
                BPUserLibraryElement elem = (BPUserLibraryElement)element;
                return elem.getChildren();
            }
            if (element instanceof BPListElement) {
                return ((BPListElement)element).getChildren();
            }
            if (element instanceof BPListElementAttribute && "accessrules".equals((attribute = (BPListElementAttribute)element).getKey())) {
                return (IAccessRule[])attribute.getValue();
            }
            return this.EMPTY;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof BPListElementAttribute) {
                return ((BPListElementAttribute)element).getParent();
            }
            if (element instanceof BPListElement) {
                return ((BPListElement)element).getParentContainer();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }
    }
}

