/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.quickfix;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.compiler.ast.parser.PhpProblemIdentifier;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.quickfix.Messages;
import org.eclipse.php.internal.ui.text.correction.IInvocationContext;
import org.eclipse.php.internal.ui.text.correction.IProblemLocation;
import org.eclipse.php.internal.ui.text.correction.IQuickFixProcessor;
import org.eclipse.php.internal.ui.text.correction.IQuickFixProcessorExtension;
import org.eclipse.php.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.php.internal.ui.text.correction.proposals.AbstractCorrectionProposal;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class UnusedUseStatementProcessor
implements IQuickFixProcessor,
IQuickFixProcessorExtension {
    private static final String ORGANIZE_USE_STATEMENTS_ID = "org.eclipse.php.ui.editor.organize.use.statements";

    @Override
    public boolean hasCorrections(ISourceModule unit, IProblemIdentifier identifier) {
        return identifier == PhpProblemIdentifier.USE_STATEMENTS;
    }

    @Override
    public boolean hasCorrections(ISourceModule unit, int problemId) {
        return false;
    }

    @Override
    public IScriptCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations.length == 0) {
            return null;
        }
        boolean detect = false;
        int i = 0;
        while (i < locations.length) {
            if (this.hasCorrections(context.getCompilationUnit(), locations[i].getProblemIdentifier())) {
                detect = true;
                break;
            }
            ++i;
        }
        if (!detect) {
            return null;
        }
        return new IScriptCompletionProposal[]{new RunCommandProposal(), new RemoveImportProposal(context)};
    }

    private class RemoveImportProposal
    extends ASTRewriteCorrectionProposal {
        private final IInvocationContext context;

        public RemoveImportProposal(IInvocationContext context) {
            super(Messages.UnusedUseStatementProcessor_RemoveImport, context.getCompilationUnit(), (ASTRewrite)null, 9, DLTKPluginImages.get((String)"org.eclipse.dltk.ui.correction_delete_import.png"));
            this.context = context;
        }

        @Override
        protected ASTRewrite getRewrite() throws CoreException {
            ASTNode coveringNode = this.context.getCoveringNode();
            ASTRewrite rewrite = ASTRewrite.create((AST)coveringNode.getAST());
            TextEditGroup editGroup = new TextEditGroup(Messages.UnusedUseStatementProcessor_RemoveImport);
            if (coveringNode != null) {
                if (coveringNode instanceof Identifier) {
                    coveringNode = coveringNode.getParent();
                }
                if (coveringNode instanceof NamespaceName) {
                    coveringNode = coveringNode.getParent();
                }
                if (coveringNode instanceof UseStatement) {
                    rewrite.remove(coveringNode, editGroup);
                } else if (coveringNode instanceof UseStatementPart) {
                    UseStatement part = (UseStatement)coveringNode.getParent();
                    if (part.parts().size() == 1) {
                        rewrite.remove((ASTNode)part, editGroup);
                    } else {
                        rewrite.remove(coveringNode, editGroup);
                    }
                }
            }
            return rewrite;
        }
    }

    private class RunCommandProposal
    extends AbstractCorrectionProposal {
        public RunCommandProposal() {
            super(Messages.UnusedUseStatementProcessor_CommandName, 10, DLTKPluginImages.get((String)"org.eclipse.dltk.ui.correction_change.png"), UnusedUseStatementProcessor.ORGANIZE_USE_STATEMENTS_ID);
        }

        public void apply(IDocument document) {
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            try {
                service.getCommand(this.getCommandId()).executeWithChecks(new ExecutionEvent());
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }

        public String getAdditionalProposalInfo() {
            return null;
        }
    }
}

