/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.builder;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.AbstractBuildParticipantType;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.libfolders.LibraryFolderManager;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.parser.PhpProblemIdentifier;
import org.eclipse.php.internal.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.corext.util.DocumentUtils;
import org.eclipse.php.internal.core.search.Messages;

public class OrganizeBuildParticipantFactory
extends AbstractBuildParticipantType
implements IExecutableExtension {
    private static final String UNUSED_MESSAGE = CoreMessages.getString("use_unused");
    private String natureId = null;

    public IBuildParticipant createBuildParticipant(IScriptProject project) throws CoreException {
        if (this.natureId != null) {
            return new OrganizeBuildParticipantParticipant();
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.natureId = config.getAttribute("nature");
    }

    private static class ImportValidationVisitor
    extends PHPASTVisitor {
        private IBuildContext context;
        private IDocument doc;
        private UseStatement[] statements;
        private NamespaceDeclaration currentNamespace;

        public ImportValidationVisitor(IBuildContext context, UseStatement[] statements) {
            this.context = context;
            this.statements = statements;
            this.doc = new Document(new String(context.getContents()));
        }

        @Override
        public boolean visit(NamespaceDeclaration n) throws Exception {
            this.currentNamespace = n;
            return super.visit(n);
        }

        @Override
        public boolean visit(UseStatement s) throws Exception {
            if (this.statements.length == 0) {
                return super.visit(s);
            }
            String total = this.currentNamespace != null && this.currentNamespace.isBracketed() ? DocumentUtils.stripUseStatements(this.statements, this.doc, this.currentNamespace.sourceStart(), this.currentNamespace.sourceEnd()) : DocumentUtils.stripUseStatements(this.statements, this.doc);
            boolean multiPart = s.getParts().size() > 1;
            for (UsePart part : s.getParts()) {
                if (DocumentUtils.containsUseStatement(part, total)) continue;
                int sourceStart = multiPart ? part.getNamespace().sourceStart() : s.sourceStart();
                int sourceEnd = multiPart ? part.getNamespace().sourceEnd() : s.sourceEnd();
                int lineNumber = this.context.getLineTracker().getLineNumberOfOffset(sourceStart);
                DefaultProblem problem = new DefaultProblem(this.context.getFile().getName(), Messages.format(UNUSED_MESSAGE, part.getNamespace().getFullyQualifiedName()), (IProblemIdentifier)PhpProblemIdentifier.USE_STATEMENTS, new String[0], ProblemSeverities.Warning, sourceStart, sourceEnd, lineNumber, -1);
                this.context.getProblemReporter().reportProblem((IProblem)problem);
            }
            return super.visit(s);
        }
    }

    private static class OrganizeBuildParticipantParticipant
    implements IBuildParticipant {
        private OrganizeBuildParticipantParticipant() {
        }

        public void build(IBuildContext context) throws CoreException {
            IModelElement element = context.getModelElement();
            if (LibraryFolderManager.getInstance().isInLibraryFolder(element.getResource())) {
                return;
            }
            ModuleDeclaration moduleDeclaration = (ModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
            if (moduleDeclaration != null) {
                try {
                    UseStatement[] statements = ASTUtils.getUseStatements(moduleDeclaration, context.getContents().length);
                    moduleDeclaration.traverse((ASTVisitor)new ImportValidationVisitor(context, statements));
                }
                catch (Exception exception) {}
            }
        }
    }
}

