/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.contexts.ClassMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionParameterDefaultValueContext;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class ClassStaticMemberContext
extends ClassMemberContext {
    private boolean isParent;
    private boolean isDirectParent;
    private boolean isSelf;
    private boolean isDirectSelf;
    private boolean isFunctionParameterContext = false;

    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        IEvaluatedType instanceType;
        IContext context;
        ModuleDeclaration moduleDeclaration;
        IType[] types;
        TextSequence statementText;
        String parentText;
        int elementStart;
        int lhsIndex;
        PHPVersion phpVersion = ProjectOptions.getPhpVersion((IModelElement)sourceModule);
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        if (this.getTriggerType() != ClassMemberContext.Trigger.CLASS) {
            return false;
        }
        FunctionParameterDefaultValueContext parameterDefaultValueContext = new FunctionParameterDefaultValueContext();
        if (parameterDefaultValueContext.isValid(sourceModule, offset, requestor)) {
            this.isFunctionParameterContext = true;
        }
        if ((lhsIndex = (elementStart = this.getElementStart()) - "parent".length() - this.getTriggerType().getName().length()) >= 0 && ((parentText = (statementText = this.getStatementText()).subSequence(lhsIndex, elementStart - this.getTriggerType().getName().length()).toString()).equals("parent") || PHPVersion.PHP5_4.isLessThan(phpVersion) && parentText.toLowerCase().equals("parent"))) {
            this.isDirectParent = true;
            this.isParent = true;
        }
        if ((lhsIndex = elementStart - "self".length() - this.getTriggerType().getName().length()) >= 0 && ((parentText = (statementText = this.getStatementText()).subSequence(lhsIndex, elementStart - this.getTriggerType().getName().length()).toString()).equals("self") || PHPVersion.PHP5_4.isLessThan(phpVersion) && parentText.toLowerCase().equals("self"))) {
            this.isDirectSelf = true;
            this.isSelf = true;
        }
        if ((!this.isParent || !this.isSelf) && (types = this.getLhsTypes()) != null && types.length > 0 && (moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule)) != null && (context = ASTUtils.findContext(sourceModule, moduleDeclaration, offset)) instanceof MethodContext && (instanceType = ((MethodContext)context).getInstanceType()) instanceof PHPClassType) {
            PHPClassType classType = (PHPClassType)instanceType;
            String typeName = classType.getTypeName();
            String namespace = classType.getNamespace();
            if (namespace != null && namespace.length() > 0) {
                int i = typeName.lastIndexOf(92);
                if (i != -1) {
                    typeName = typeName.substring(i + 1);
                }
                if (namespace.charAt(0) == '\\') {
                    namespace = namespace.substring(1);
                }
                IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)types[0]);
                if (!this.isParent && currentNamespace != null && types.length >= 2) {
                    IType parentType = types[1];
                    boolean bl = this.isParent = namespace.equals(currentNamespace.getElementName()) && typeName.equals(parentType.getElementName());
                }
                if (!this.isSelf && currentNamespace != null) {
                    this.isSelf = namespace.equals(currentNamespace.getElementName()) && typeName.equals(types[0].getElementName());
                }
            } else {
                if (!this.isParent && types.length >= 2) {
                    IType parentType = types[1];
                    this.isParent = typeName.equals(parentType.getElementName());
                }
                if (!this.isSelf) {
                    this.isSelf = typeName.equals(types[0].getElementName());
                }
            }
        }
        return true;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public boolean isDirectParent() {
        return this.isDirectParent;
    }

    public boolean isDirectSelf() {
        return this.isDirectSelf;
    }

    public boolean isFunctionParameterContext() {
        return this.isFunctionParameterContext;
    }
}

