/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.ArrayKeyContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.typeinference.FakeField;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class LocalMethodVariablesStrategyForArray
extends AbstractCompletionStrategy {
    public LocalMethodVariablesStrategyForArray(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public LocalMethodVariablesStrategyForArray(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws Exception {
        ICompletionContext context = this.getContext();
        if (!(context instanceof ArrayKeyContext)) {
            return;
        }
        ArrayKeyContext arrayContext = (ArrayKeyContext)context;
        String prefix = arrayContext.getPrefix();
        CompletionRequestor requestor = arrayContext.getCompletionRequestor();
        try {
            IType declaringType;
            IModelElement enclosingElement = arrayContext.getSourceModule().getElementAt(arrayContext.getOffset());
            while (enclosingElement instanceof IField) {
                enclosingElement = enclosingElement.getParent();
            }
            if (!(enclosingElement instanceof IMethod)) {
                return;
            }
            SourceRange replaceRange = this.getReplacementRange(arrayContext);
            IMethod enclosingMethod = (IMethod)enclosingElement;
            if (!PHPFlags.isStatic((int)enclosingMethod.getFlags()) && (declaringType = enclosingMethod.getDeclaringType()) != null && "$this".startsWith(prefix)) {
                reporter.reportField((IField)new FakeField((ModelElement)declaringType, "$this", 0, 0), "", (ISourceRange)replaceRange, false);
            }
            IModelElement[] iModelElementArray = PHPModelUtils.getMethodFields(enclosingMethod, prefix, requestor.isContextInformationMode(), null);
            int n = iModelElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement element = iModelElementArray[n2];
                reporter.reportField((IField)element, "", (ISourceRange)replaceRange, false);
                ++n2;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
    }
}

