/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalTypesStrategy;

public class PHPDocReturnTypeStrategy
extends GlobalTypesStrategy {
    private static final String[] ALL_TYPE = new String[]{"array", "mixed", "void", "integer", "int", "string", "float", "double", "bool", "boolean", "resource", "null", "NULL", "$this", "self", "static"};
    private static final String EMPTY = "";

    public PHPDocReturnTypeStrategy(ICompletionContext context) {
        super(context, 0, 2048);
    }

    public PHPDocReturnTypeStrategy(ICompletionContext context, int trueFlag, int falseFlag) {
        super(context, trueFlag, falseFlag);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof PHPDocTagContext)) {
            return;
        }
        super.apply(reporter);
        String prefix = ((PHPDocTagContext)context).getPrefix();
        SourceRange replaceRange = this.getReplacementRange(context);
        int i = 0;
        while (i < ALL_TYPE.length) {
            this.reportKeyword(reporter, (ISourceRange)replaceRange, ALL_TYPE[i], prefix);
            ++i;
        }
    }

    private void reportKeyword(ICompletionReporter reporter, ISourceRange replaceRange, String keyword, String prefix) {
        if (keyword.startsWith(prefix)) {
            reporter.reportKeyword(keyword, EMPTY, replaceRange);
        }
    }

    @Override
    protected int getExtraInfo() {
        return 2;
    }
}

