/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTagKinds;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.util.MagicMemberUtil;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;

public class PHPDocTag
extends ASTNode
implements PHPDocTagKinds {
    public static final String ERROR = "ERROR!!!";
    public static final String ABSTRACT_NAME = "abstract";
    public static final String AUTHOR_NAME = "author";
    public static final String DEPRECATED_NAME = "deprecated";
    public static final String FINAL_NAME = "final";
    public static final String GLOBAL_NAME = "global";
    public static final String NAME_NAME = "name";
    public static final String RETURN_NAME = "return";
    public static final String PARAM_NAME = "param";
    public static final String SEE_NAME = "see";
    public static final String STATIC_NAME = "static";
    public static final String STATICVAR_NAME = "staticvar";
    public static final String TODO_NAME = "todo";
    public static final String VAR_NAME = "var";
    public static final String PACKAGE_NAME = "package";
    public static final String ACCESS_NAME = "access";
    public static final String CATEGORY_NAME = "category";
    public static final String COPYRIGHT_NAME = "copyright";
    public static final String DESC_NAME = "desc";
    public static final String EXAMPLE_NAME = "example";
    public static final String FILESOURCE_NAME = "filesource";
    public static final String IGNORE_NAME = "ignore";
    public static final String INTERNAL_NAME = "internal";
    public static final String LICENSE_NAME = "license";
    public static final String LINK_NAME = "link";
    public static final String SINCE_NAME = "since";
    public static final String SUBPACKAGE_NAME = "subpackage";
    public static final String TUTORIAL_NAME = "tutorial";
    public static final String USES_NAME = "uses";
    public static final String VERSION_NAME = "version";
    public static final String THROWS_NAME = "throws";
    public static final String PROPERTY_NAME = "property";
    public static final String PROPERTY_READ_NAME = "property-read";
    public static final String PROPERTY_WRITE_NAME = "property-write";
    public static final String METHOD_NAME = "method";
    public static final String NAMESPACE_NAME = "namespace";
    public static final String INHERITDOC_NAME = "inheritdoc";
    private final int tagKind;
    private final String matchedTag;
    private String value;
    private List<Scalar> texts;
    private VariableReference variableReference;
    private TypeReference singleTypeReference;
    private List<TypeReference> typeReferences;
    private List<SimpleReference> allReferencesWithOrigOrder;
    private List<String> descTexts;
    private String trimmedDescText;

    public PHPDocTag(int start, int end, int tagKind, String matchedTag, String value, List<Scalar> texts) {
        super(start, end);
        this.tagKind = tagKind;
        this.matchedTag = matchedTag;
        this.value = value;
        this.texts = texts;
        this.updateReferences(start, end);
    }

    public List<Scalar> getTexts() {
        return this.texts;
    }

    public List<String> getDescTexts() {
        return this.descTexts;
    }

    public String getTrimmedDescText() {
        return this.trimmedDescText;
    }

    private String getTrimmedDescText(int wordsToSkip) {
        String text = this.value.trim();
        if (wordsToSkip == 0) {
            return text;
        }
        String[] split = MagicMemberUtil.WHITESPACE_SEPERATOR.split(text);
        int i = 0;
        while (i < wordsToSkip) {
            int index = text.indexOf(split[i]);
            text = text.substring(split[i].length() + index);
            ++i;
        }
        return text.trim();
    }

    private List<String> getDescTexts(int wordsToSkip) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < this.texts.size()) {
            String text = this.texts.get(i).getValue();
            if (wordsToSkip <= 0) {
                result.add(text);
            } else if (text.trim().length() != 0) {
                List<String> commentWords = Arrays.asList(MagicMemberUtil.WHITESPACE_SEPERATOR.split(text.trim()));
                if ((commentWords = PHPDocTag.removeEmptyString(commentWords)).size() <= wordsToSkip) {
                    wordsToSkip -= commentWords.size();
                } else {
                    text = this.removeFirstWords(text, commentWords, wordsToSkip);
                    result.add(text);
                    wordsToSkip = 0;
                }
            }
            ++i;
        }
        return result;
    }

    public static List<String> removeEmptyString(List<String> commentWords) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < commentWords.size()) {
            String word = commentWords.get(i);
            if (word.trim().length() != 0) {
                result.add(word);
            }
            ++i;
        }
        return result;
    }

    private String removeFirstWords(String text, List<String> commentWords, int wordSize) {
        int i = 0;
        while (i < wordSize) {
            int index = text.indexOf(commentWords.get(i));
            text = text.substring(commentWords.get(i).length() + index);
            ++i;
        }
        return text.trim();
    }

    private static int getClassStartIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (line.charAt(i) != '|') {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static int getClassEndIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (line.charAt(i) == '|') {
                return i;
            }
            ++i;
        }
        return i;
    }

    private void splitSingleTypeReference(TypeReference reference, List<TypeReference> types) {
        String word = reference.getName();
        int valueStart = reference.sourceStart();
        int classStart = PHPDocTag.getClassStartIndex(word, 0);
        int classEnd = PHPDocTag.getClassEndIndex(word, classStart);
        while (classStart < classEnd) {
            String className = word.substring(classStart, classEnd);
            types.add(new TypeReference(valueStart + classStart, valueStart + classEnd, className));
            classStart = PHPDocTag.getClassStartIndex(word, classEnd);
            classEnd = PHPDocTag.getClassEndIndex(word, classStart);
        }
    }

    private void updateReferences(int start, int end) {
        int secondWordEnd;
        int secondWordStart;
        int firstWordEnd;
        int firstWordStart;
        this.variableReference = null;
        this.singleTypeReference = null;
        this.typeReferences = new ArrayList<TypeReference>();
        this.allReferencesWithOrigOrder = new ArrayList<SimpleReference>();
        this.descTexts = new ArrayList<String>();
        int valueStart = start + this.matchedTag.length();
        int wordsToSkip = 0;
        if (this.tagKind == 6 || this.tagKind == 12 || this.tagKind == 29 || this.tagKind == 8) {
            String word;
            int wordStart = PHPTextSequenceUtilities.readForwardSpaces(this.value, 0);
            int wordEnd = PHPTextSequenceUtilities.readForwardUntilSpaces(this.value, wordStart);
            if (this.tagKind == 12 && wordStart < wordEnd && (word = this.value.substring(wordStart, wordEnd)).charAt(0) == '$') {
                this.variableReference = new VariableReference(valueStart + wordStart, valueStart + wordEnd, word);
                this.allReferencesWithOrigOrder.add((SimpleReference)this.variableReference);
                ++wordsToSkip;
                wordStart = PHPTextSequenceUtilities.readForwardSpaces(this.value, wordEnd);
                wordEnd = PHPTextSequenceUtilities.readForwardUntilSpaces(this.value, wordStart);
            }
            if (wordStart < wordEnd) {
                word = this.value.substring(wordStart, wordEnd);
                this.singleTypeReference = new TypeReference(valueStart + wordStart, valueStart + wordEnd, word);
                this.splitSingleTypeReference(this.singleTypeReference, this.typeReferences);
                this.allReferencesWithOrigOrder.addAll(this.typeReferences);
                ++wordsToSkip;
                wordStart = PHPTextSequenceUtilities.readForwardSpaces(this.value, wordEnd);
                wordEnd = PHPTextSequenceUtilities.readForwardUntilSpaces(this.value, wordStart);
            }
            if (this.tagKind == 12 && this.variableReference == null && wordStart < wordEnd && (word = this.value.substring(wordStart, wordEnd)).charAt(0) == '$') {
                this.variableReference = new VariableReference(valueStart + wordStart, valueStart + wordEnd, word);
                this.allReferencesWithOrigOrder.add((SimpleReference)this.variableReference);
                ++wordsToSkip;
            }
        } else if ((this.tagKind == 7 || this.tagKind == 30 || this.tagKind == 31 || this.tagKind == 32) && (firstWordStart = PHPTextSequenceUtilities.readForwardSpaces(this.value, 0)) < (firstWordEnd = PHPTextSequenceUtilities.readForwardUntilSpaces(this.value, firstWordStart)) && (secondWordStart = PHPTextSequenceUtilities.readForwardSpaces(this.value, firstWordEnd)) < (secondWordEnd = PHPTextSequenceUtilities.readForwardUntilSpaces(this.value, secondWordStart))) {
            String firstWord = this.value.substring(firstWordStart, firstWordEnd);
            String secondWord = this.value.substring(secondWordStart, secondWordEnd);
            if (firstWord.charAt(0) == '$' || firstWord.startsWith("...$")) {
                this.variableReference = new VariableReference(valueStart + firstWordStart, valueStart + firstWordEnd, firstWord);
                this.singleTypeReference = new TypeReference(valueStart + secondWordStart, valueStart + secondWordEnd, secondWord);
                this.splitSingleTypeReference(this.singleTypeReference, this.typeReferences);
                this.allReferencesWithOrigOrder.add((SimpleReference)this.variableReference);
                this.allReferencesWithOrigOrder.addAll(this.typeReferences);
                wordsToSkip = 2;
            } else if (secondWord.charAt(0) == '$' || secondWord.startsWith("...$")) {
                this.variableReference = new VariableReference(valueStart + secondWordStart, valueStart + secondWordEnd, secondWord);
                this.singleTypeReference = new TypeReference(valueStart + firstWordStart, valueStart + firstWordEnd, firstWord);
                this.splitSingleTypeReference(this.singleTypeReference, this.typeReferences);
                this.allReferencesWithOrigOrder.addAll(this.typeReferences);
                this.allReferencesWithOrigOrder.add((SimpleReference)this.variableReference);
                wordsToSkip = 2;
            }
        }
        this.descTexts = this.getDescTexts(wordsToSkip);
        this.trimmedDescText = this.getTrimmedDescText(wordsToSkip);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((ASTNode)this);
        if (visit) {
            for (SimpleReference ref : this.allReferencesWithOrigOrder) {
                ref.traverse(visitor);
            }
        }
        visitor.endvisit((ASTNode)this);
    }

    public int getKind() {
        return 68;
    }

    public int getTagKind() {
        return this.tagKind;
    }

    public String getMatchedTag() {
        return this.matchedTag;
    }

    public String getValue() {
        return this.value;
    }

    public VariableReference getVariableReference() {
        return this.variableReference;
    }

    public TypeReference getSingleTypeReference() {
        return this.singleTypeReference;
    }

    public List<TypeReference> getTypeReferences() {
        return this.typeReferences;
    }

    public List<SimpleReference> getAllReferencesWithOrigOrder() {
        return this.allReferencesWithOrigOrder;
    }

    public boolean isValidMethodDescriptorTag() {
        return this.isValidParamTag() || this.isValidPropertiesTag();
    }

    public boolean isValidPropertiesTag() {
        return (this.tagKind == 30 || this.tagKind == 31 || this.tagKind == 32) && this.singleTypeReference != null && this.variableReference != null;
    }

    public boolean isValidParamTag() {
        return this.tagKind == 7 && this.singleTypeReference != null && this.variableReference != null;
    }

    public boolean isValidVarTag() {
        return this.tagKind == 12 && this.singleTypeReference != null;
    }

    public void adjustStart(int start) {
        this.setStart(this.sourceStart() + start);
        this.setEnd(this.sourceEnd() + start);
    }

    public static String getTagKind(int kind) {
        switch (kind) {
            case 0: {
                return ABSTRACT_NAME;
            }
            case 1: {
                return AUTHOR_NAME;
            }
            case 2: {
                return DEPRECATED_NAME;
            }
            case 3: {
                return FINAL_NAME;
            }
            case 4: {
                return GLOBAL_NAME;
            }
            case 5: {
                return NAME_NAME;
            }
            case 6: {
                return RETURN_NAME;
            }
            case 7: {
                return PARAM_NAME;
            }
            case 8: {
                return SEE_NAME;
            }
            case 9: {
                return STATIC_NAME;
            }
            case 10: {
                return STATICVAR_NAME;
            }
            case 11: {
                return TODO_NAME;
            }
            case 12: {
                return VAR_NAME;
            }
            case 13: {
                return PACKAGE_NAME;
            }
            case 14: {
                return ACCESS_NAME;
            }
            case 15: {
                return CATEGORY_NAME;
            }
            case 16: {
                return COPYRIGHT_NAME;
            }
            case 17: {
                return DESC_NAME;
            }
            case 18: {
                return EXAMPLE_NAME;
            }
            case 19: {
                return FILESOURCE_NAME;
            }
            case 20: {
                return IGNORE_NAME;
            }
            case 21: {
                return INTERNAL_NAME;
            }
            case 22: {
                return LICENSE_NAME;
            }
            case 23: {
                return LINK_NAME;
            }
            case 24: {
                return SINCE_NAME;
            }
            case 25: {
                return SUBPACKAGE_NAME;
            }
            case 26: {
                return TUTORIAL_NAME;
            }
            case 27: {
                return USES_NAME;
            }
            case 28: {
                return VERSION_NAME;
            }
            case 29: {
                return THROWS_NAME;
            }
            case 30: {
                return PROPERTY_NAME;
            }
            case 31: {
                return PROPERTY_READ_NAME;
            }
            case 32: {
                return PROPERTY_WRITE_NAME;
            }
            case 33: {
                return METHOD_NAME;
            }
            case 34: {
                return NAMESPACE_NAME;
            }
            case 35: {
                return INHERITDOC_NAME;
            }
        }
        return ERROR;
    }
}

