/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.parser.ISourceParserFactory;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractPHPSourceParser;
import org.eclipse.php.internal.core.compiler.ast.parser.Messages;
import org.eclipse.php.internal.core.compiler.ast.parser.php5.PhpSourceParser;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class PHPSourceParserFactory
extends AbstractSourceParser
implements ISourceParserFactory,
ISourceParser {
    public ISourceParser createSourceParser() {
        return this;
    }

    public IModuleDeclaration parse(IModuleSource module, IProblemReporter reporter) {
        String fileName = module.getFileName();
        AbstractPHPSourceParser parser = this.createParser(fileName);
        return parser.parse(module, reporter);
    }

    protected AbstractPHPSourceParser createParser(String fileName) {
        PHPVersion phpVersion = ProjectOptions.getPhpVersion(fileName);
        AbstractPHPSourceParser parser = PHPSourceParserFactory.createParser(fileName, phpVersion);
        if (parser == null) {
            throw new IllegalStateException(Messages.PHPSourceParserFactory_0);
        }
        return parser;
    }

    public static AbstractPHPSourceParser createParser(String fileName, PHPVersion phpVersion) {
        if (PHPVersion.PHP4 == phpVersion) {
            return new PhpSourceParser(fileName);
        }
        if (PHPVersion.PHP5 == phpVersion) {
            return new PhpSourceParser(fileName);
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php53.PhpSourceParser(fileName);
        }
        if (PHPVersion.PHP5_4 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php54.PhpSourceParser(fileName);
        }
        if (PHPVersion.PHP5_5 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php55.PhpSourceParser(fileName);
        }
        if (PHPVersion.PHP5_6 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php56.PhpSourceParser(fileName);
        }
        if (PHPVersion.PHP7_0 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php7.PhpSourceParser(fileName);
        }
        return null;
    }

    public static AbstractPHPSourceParser createParser(PHPVersion phpVersion) {
        if (PHPVersion.PHP4 == phpVersion) {
            return new PhpSourceParser();
        }
        if (PHPVersion.PHP5 == phpVersion) {
            return new PhpSourceParser();
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php53.PhpSourceParser();
        }
        if (PHPVersion.PHP5_4 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php54.PhpSourceParser();
        }
        if (PHPVersion.PHP5_5 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php55.PhpSourceParser();
        }
        if (PHPVersion.PHP5_6 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php56.PhpSourceParser();
        }
        if (PHPVersion.PHP7_0 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php7.PhpSourceParser();
        }
        return null;
    }
}

