/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.formatter.autoedit;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.autoEdit.MainAutoEditStrategy;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.php.ui.tests.formatter.autoedit.DocumentAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class FormatterAutoEditTests {
    protected static final String DEFAULT_CURSOR = "|";
    protected IProject project;
    protected int count;
    protected PHPVersion phpVersion;
    protected String[] fileNames;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/formatter-autoedit", "/workspace/phpdoc-generation/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/formatter-autoedit", "/workspace/phpdoc-generation/php5", "/workspace/phpdoc-generation/php53"});
    }

    public FormatterAutoEditTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
        this.fileNames = fileNames;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("FormatterTests" + this.phpVersion.name());
        if (this.project.exists()) {
            return;
        }
        this.project.create(null);
        this.project.open(null);
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        this.project.setDescription(desc, null);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(ISourceModule workingCopy) {
                ISourceModule original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource != null && resource instanceof IFile) {
                    return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                }
                return DocumentAdapter.NULL;
            }
        });
        this.project.refreshLocal(2, null);
        PHPCoreTests.setProjectPhpVersion((IProject)this.project, (PHPVersion)this.phpVersion);
        this.project.build(6, null);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        this.project.close(null);
        this.project.delete(true, true, null);
        this.project = null;
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }

    private static String getCursor(PdttFile pdttFile) {
        Map config = pdttFile.getConfig();
        return (String)config.get("cursor");
    }

    @Test
    public void formatter(String fileName) throws Exception {
        final PdttFile pdttFile = new PdttFile(fileName);
        String cursor = FormatterAutoEditTests.getCursor(pdttFile) != null ? FormatterAutoEditTests.getCursor(pdttFile) : DEFAULT_CURSOR;
        final IFile file = this.createFile(pdttFile.getFile().trim());
        ISourceModule modelElement = (ISourceModule)DLTKCore.create((IFile)file);
        if (ScriptModelUtil.isPrimary((ISourceModule)modelElement)) {
            modelElement.becomeWorkingCopy(new IProblemRequestor(){

                public void acceptProblem(IProblem problem) {
                }

                public void beginReporting() {
                }

                public void endReporting() {
                }

                public boolean isActive() {
                    return false;
                }
            }, null);
        }
        Exception[] err = new Exception[1];
        final IEditorPart[] part = new IEditorPart[1];
        IStructuredModel modelForEdit = StructuredModelManager.getModelManager().getModelForEdit(file);
        try {
            IStructuredDocument document = modelForEdit.getStructuredDocument();
            String beforeFormat = document.get();
            String data = document.get();
            int firstOffset = data.indexOf(cursor);
            int lastOffset = data.lastIndexOf(cursor);
            if (lastOffset == -1) {
                throw new IllegalArgumentException("Offset character is not set");
            }
            final DocumentCommand cmd = new DocumentCommand(){};
            if (firstOffset == lastOffset) {
                data = String.valueOf(data.substring(0, lastOffset)) + data.substring(lastOffset + cursor.length());
                cmd.offset = lastOffset;
                cmd.length = 0;
            } else {
                data = String.valueOf(data.substring(0, firstOffset)) + data.substring(firstOffset + cursor.length(), lastOffset) + data.substring(lastOffset + cursor.length());
                cmd.offset = firstOffset;
                cmd.length = lastOffset - (firstOffset + cursor.length());
            }
            String newContent = data;
            Display.getDefault().syncExec(new Runnable((IDocument)document, newContent, modelElement, err){
                private final /* synthetic */ IDocument val$document;
                private final /* synthetic */ String val$newContent;
                private final /* synthetic */ ISourceModule val$modelElement;
                private final /* synthetic */ Exception[] val$err;
                {
                    this.val$document = iDocument;
                    this.val$newContent = string;
                    this.val$modelElement = iSourceModule;
                    this.val$err = exceptionArray;
                }

                @Override
                public void run() {
                    try {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IWorkbenchPage page = window.getActivePage();
                        part[0] = page.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.php.editor");
                        part[0].setFocus();
                        this.val$document.set(this.val$newContent);
                        this.val$modelElement.reconcile(true, null, null);
                    }
                    catch (Exception e) {
                        this.val$err[0] = e;
                    }
                }
            });
            if (err[0] != null) {
                throw err[0];
            }
            SharedASTProvider.getAST((ISourceModule)modelElement, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
            Display.getDefault().syncExec(new Runnable((IDocument)document, err){
                private final /* synthetic */ IDocument val$document;
                private final /* synthetic */ Exception[] val$err;
                {
                    this.val$document = iDocument;
                    this.val$err = exceptionArray;
                }

                @Override
                public void run() {
                    try {
                        MainAutoEditStrategy indentLineAutoEditStrategy = new MainAutoEditStrategy();
                        if (pdttFile.getOther() != null) {
                            cmd.text = pdttFile.getOther();
                            if (cmd.text != null && cmd.text.trim().length() == 1) {
                                cmd.text = cmd.text.trim();
                            }
                        } else {
                            cmd.text = "\n";
                        }
                        cmd.doit = true;
                        cmd.shiftsCaret = true;
                        cmd.caretOffset = -1;
                        indentLineAutoEditStrategy.customizeDocumentCommand(this.val$document, cmd);
                        this.val$document.replace(cmd.offset, cmd.length, cmd.text);
                    }
                    catch (Exception e) {
                        this.val$err[0] = e;
                    }
                }
            });
            if (err[0] != null) {
                throw err[0];
            }
            PDTTUtils.assertContents((String)pdttFile.getExpected(), (String)document.get());
            document.set(beforeFormat);
            modelForEdit.save();
        }
        catch (Throwable throwable) {
            if (modelForEdit != null) {
                modelForEdit.releaseFromEdit();
            }
            if (part[0] != null) {
                Display.getDefault().syncExec(new Runnable(part, err){
                    private final /* synthetic */ IEditorPart[] val$part;
                    private final /* synthetic */ Exception[] val$err;
                    {
                        this.val$part = iEditorPartArray;
                        this.val$err = exceptionArray;
                    }

                    @Override
                    public void run() {
                        try {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage page = window.getActivePage();
                            page.closeEditor(this.val$part[0], false);
                        }
                        catch (Exception e) {
                            this.val$err[0] = e;
                        }
                    }
                });
                if (err[0] != null) {
                    throw err[0];
                }
            }
            throw throwable;
        }
        if (modelForEdit != null) {
            modelForEdit.releaseFromEdit();
        }
        if (part[0] != null) {
            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
            if (err[0] != null) {
                throw err[0];
            }
        }
    }

    protected IFile createFile(String data) throws Exception {
        IFile testFile = this.project.getFile("test" + ++this.count + ".php");
        testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        return testFile;
    }
}

