/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.documentModel.parser.php7;

import org.eclipse.php.internal.core.util.collections.IntHashtable;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>highlighting_scanner.jflex</tt>
 */
public class PhpLexer extends org.eclipse.php.internal.core.documentModel.parser.AbstractPhpLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_PHP_IN_SCRIPTING = 2;
  public static final int ST_PHP_DOUBLE_QUOTES = 4;
  public static final int ST_PHP_SINGLE_QUOTE = 6;
  public static final int ST_PHP_BACKQUOTE = 8;
  public static final int ST_PHP_QUOTES_AFTER_VARIABLE = 10;
  public static final int ST_PHP_HEREDOC = 12;
  public static final int ST_PHP_NOWDOC = 14;
  public static final int ST_PHP_START_HEREDOC = 16;
  public static final int ST_PHP_START_NOWDOC = 18;
  public static final int ST_PHP_END_HEREDOC = 20;
  public static final int ST_PHP_LOOKING_FOR_PROPERTY = 22;
  public static final int ST_PHP_VAR_OFFSET = 24;
  public static final int ST_PHP_COMMENT = 26;
  public static final int ST_PHP_DOC_COMMENT = 28;
  public static final int ST_PHP_LINE_COMMENT = 30;
  public static final int ST_PHP_HIGHLIGHTING_ERROR = 32;
  public static final int ST_PHP_END_NOWDOC = 34;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16, 17, 17
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\14\1\13\2\0\1\17\22\0\1\14\1\30\1\21\1\76"+
    "\1\20\1\34\1\35\1\75\1\65\1\66\1\32\1\27\1\15\1\4"+
    "\1\2\1\33\1\5\1\11\10\1\1\63\1\16\1\31\1\25\1\26"+
    "\1\45\1\77\1\42\1\10\1\7\1\44\1\3\1\50\1\61\1\56"+
    "\1\46\1\67\1\60\1\54\1\55\1\43\1\40\1\62\1\71\1\41"+
    "\1\52\1\47\1\51\1\64\1\57\1\6\1\53\1\12\1\73\1\22"+
    "\1\74\1\37\1\70\1\23\1\42\1\10\1\7\1\44\1\3\1\50"+
    "\1\61\1\56\1\46\1\67\1\60\1\54\1\55\1\43\1\40\1\62"+
    "\1\71\1\41\1\52\1\47\1\51\1\64\1\57\1\6\1\53\1\12"+
    "\1\24\1\36\1\72\1\15\261\12\2\46\115\12\1\52\u1faa\12\1\60"+
    "\uded5\12\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\20\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\1\2\12\0\1\3\1\4\1\5\1\6"+
    "\1\5\1\4\4\6\1\7\1\5\1\10\1\5\1\11"+
    "\1\12\1\13\1\14\13\5\5\6\1\5\12\6\1\5"+
    "\1\6\1\5\1\6\1\15\1\16\1\17\1\2\1\20"+
    "\1\21\4\20\1\2\3\20\3\22\2\1\3\3\1\2"+
    "\2\23\2\24\2\3\1\0\1\3\1\25\1\26\1\25"+
    "\1\27\1\30\1\27\1\31\1\30\1\6\1\32\2\33"+
    "\3\34\3\35\3\36\1\37\1\40\1\0\1\3\2\4"+
    "\1\41\6\6\1\42\2\0\3\6\1\0\1\6\2\43"+
    "\2\0\1\20\2\0\3\41\1\44\1\45\1\41\4\6"+
    "\1\46\4\6\1\47\1\6\1\50\1\6\1\51\26\6"+
    "\1\52\1\6\12\0\1\6\5\0\1\53\2\54\1\55"+
    "\1\56\1\54\4\0\3\57\1\60\3\0\1\1\2\54"+
    "\1\2\1\0\1\61\2\0\1\62\6\0\1\63\4\0"+
    "\1\64\1\4\1\53\1\65\1\66\20\0\1\67\1\70"+
    "\1\0\7\6\2\4\6\6\1\0\1\6\1\43\1\0"+
    "\1\71\4\6\1\72\4\6\1\73\7\6\1\74\1\6"+
    "\1\75\5\6\1\76\14\6\1\77\12\0\7\6\1\100"+
    "\1\101\1\1\1\102\1\2\3\0\1\103\4\0\1\63"+
    "\40\0\1\104\1\0\1\105\1\6\1\106\5\6\1\107"+
    "\1\6\1\110\3\6\1\111\4\6\1\43\3\0\1\112"+
    "\5\6\1\113\10\6\1\114\2\6\1\115\4\6\1\116"+
    "\3\6\1\117\1\6\1\120\6\6\12\0\10\6\3\0"+
    "\1\103\25\0\1\121\14\0\1\122\2\6\1\123\4\6"+
    "\1\124\1\6\1\125\1\126\1\6\1\127\1\130\1\131"+
    "\1\132\2\133\2\0\3\6\1\134\7\6\1\135\1\6"+
    "\1\136\1\137\1\6\1\140\1\141\1\6\1\142\2\6"+
    "\1\143\1\144\2\6\1\145\3\6\7\0\1\146\2\0"+
    "\10\6\11\0\1\147\1\150\3\0\1\151\4\0\1\152"+
    "\4\0\1\153\7\0\2\6\1\154\2\6\1\155\2\6"+
    "\1\0\1\156\15\6\1\157\1\160\1\0\1\161\2\6"+
    "\1\162\1\163\4\0\10\6\20\0\1\164\1\0\1\165"+
    "\4\0\1\166\3\0\1\167\1\0\1\170\6\6\1\171"+
    "\2\6\1\172\1\173\1\174\4\6\1\175\1\176\1\6"+
    "\1\0\1\6\1\177\2\0\2\6\1\200\5\6\5\0"+
    "\1\201\1\202\1\0\1\203\3\0\1\204\1\0\1\205"+
    "\1\0\1\206\2\0\1\207\1\210\3\0\3\6\1\211"+
    "\1\212\1\213\1\6\1\214\6\6\1\215\1\0\3\6"+
    "\1\216\1\6\1\217\2\6\1\0\1\220\12\0\1\221"+
    "\1\0\1\222\1\223\2\6\1\224\1\6\1\225\1\6"+
    "\1\226\1\227\2\6\1\0\1\230\1\231\4\6\2\0"+
    "\1\232\1\233\2\0\1\234\1\235\3\0\1\236\1\237"+
    "\1\240\2\6\1\241\1\242\1\143\2\6\1\243\1\6"+
    "\1\244\1\245\1\246\2\0\1\247\1\0\5\6\1\250"+
    "\1\251\1\252\1\253\1\254\1\6\1\255\1\6\1\256"+
    "\2\6\1\257";

  private static int [] zzUnpackAction() {
    int [] result = new int[841];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\100\0\200\0\300\0\u0100\0\u0140\0\u0180\0\u01c0"+
    "\0\u0200\0\u0240\0\u0280\0\u02c0\0\u0300\0\u0340\0\u0380\0\u03c0"+
    "\0\u0400\0\u0440\0\0\0\u0480\0\u04c0\0\u0500\0\u0540\0\u0580"+
    "\0\u05c0\0\u0600\0\u0640\0\u0680\0\u06c0\0\0\0\0\0\u0700"+
    "\0\u0740\0\0\0\0\0\0\0\u0780\0\u07c0\0\u0800\0\u0840"+
    "\0\u0880\0\u08c0\0\u0900\0\u0940\0\u0980\0\u09c0\0\u0a00\0\u0a40"+
    "\0\u0a80\0\u0ac0\0\u0b00\0\u0b40\0\u0b80\0\u0bc0\0\u0c00\0\u0c40"+
    "\0\u0c80\0\u0cc0\0\u0d00\0\u0d40\0\u0d80\0\u0dc0\0\u0e00\0\u0e40"+
    "\0\u0e80\0\u0ec0\0\u0f00\0\0\0\u0f40\0\0\0\u0f80\0\u0fc0"+
    "\0\0\0\u1000\0\u1040\0\u1080\0\u10c0\0\u1100\0\u1140\0\u1180"+
    "\0\u11c0\0\0\0\u1200\0\u1240\0\u1280\0\u12c0\0\u1300\0\u1340"+
    "\0\u1380\0\u13c0\0\0\0\u1400\0\0\0\u1440\0\u1480\0\u14c0"+
    "\0\u1500\0\u1500\0\0\0\u1540\0\u1580\0\u15c0\0\0\0\u1600"+
    "\0\0\0\u1640\0\u1680\0\0\0\u16c0\0\u1700\0\0\0\u1740"+
    "\0\u1780\0\u17c0\0\0\0\u1800\0\0\0\u1840\0\u1880\0\0"+
    "\0\u18c0\0\u1900\0\u1940\0\u1980\0\u19c0\0\0\0\u1a00\0\u1a40"+
    "\0\u1a80\0\u1ac0\0\u1b00\0\u1b40\0\0\0\u1b80\0\u1bc0\0\u1c00"+
    "\0\u1c40\0\u1c80\0\u1cc0\0\u1d00\0\u1d40\0\u1d80\0\u0740\0\u1dc0"+
    "\0\0\0\u1e00\0\u1e40\0\u0a00\0\u1e80\0\u1ec0\0\u1f00\0\u1f40"+
    "\0\u0680\0\u1f80\0\u1fc0\0\u2000\0\u2040\0\u0680\0\u2080\0\u20c0"+
    "\0\u2100\0\u2140\0\u0680\0\u2180\0\u21c0\0\u2200\0\u0680\0\u2240"+
    "\0\u2280\0\u22c0\0\u2300\0\u2340\0\u2380\0\u23c0\0\u2400\0\u2440"+
    "\0\u2480\0\u24c0\0\u2500\0\u2540\0\u2580\0\u25c0\0\u2600\0\u2640"+
    "\0\u2680\0\u26c0\0\u2700\0\u2740\0\u2780\0\0\0\u27c0\0\u2800"+
    "\0\u0ec0\0\u2840\0\u2880\0\u28c0\0\u2900\0\u2940\0\u2980\0\u29c0"+
    "\0\u2a00\0\u2a40\0\u0f40\0\u2a80\0\u2ac0\0\u1000\0\u2b00\0\u2b40"+
    "\0\u2ac0\0\0\0\0\0\0\0\u2b00\0\u2b80\0\u2bc0\0\u1180"+
    "\0\u2c00\0\u2bc0\0\0\0\u2c00\0\0\0\u2c40\0\u1340\0\u2c80"+
    "\0\u2cc0\0\u2c40\0\u2c80\0\u2d00\0\u1400\0\0\0\u2d40\0\u1440"+
    "\0\0\0\u2d80\0\u2dc0\0\u2e00\0\u2e40\0\u2e80\0\u2ec0\0\0"+
    "\0\u2f00\0\u2f40\0\u2f80\0\u1480\0\0\0\u2fc0\0\u3000\0\0"+
    "\0\0\0\u3040\0\u3080\0\u30c0\0\u3100\0\u3140\0\u3180\0\u31c0"+
    "\0\u3200\0\u3240\0\u3280\0\u32c0\0\u3300\0\u3340\0\u3380\0\u33c0"+
    "\0\u3400\0\0\0\u3440\0\u3480\0\u34c0\0\u3500\0\u3540\0\u3580"+
    "\0\u35c0\0\u3600\0\u3640\0\u1b80\0\u1bc0\0\u3680\0\u36c0\0\u3700"+
    "\0\u3740\0\u3780\0\u37c0\0\u3800\0\u3840\0\u3880\0\u38c0\0\u3900"+
    "\0\u3940\0\u3980\0\u39c0\0\u3a00\0\u0680\0\u3a40\0\u3a80\0\u3ac0"+
    "\0\u3b00\0\u0680\0\u3b40\0\u3b80\0\u3bc0\0\u3c00\0\u3c40\0\u3c80"+
    "\0\u3cc0\0\u0680\0\u3d00\0\u3d40\0\u3d80\0\u3dc0\0\u3e00\0\u3e40"+
    "\0\u3e80\0\u0680\0\u3ec0\0\u3f00\0\u3f40\0\u3f80\0\u3fc0\0\u4000"+
    "\0\u4040\0\u4080\0\u40c0\0\u4100\0\u4140\0\u4180\0\u0680\0\u41c0"+
    "\0\u4200\0\u4240\0\u4280\0\u42c0\0\u4300\0\u4340\0\u4380\0\u43c0"+
    "\0\u4400\0\u4440\0\u4480\0\u44c0\0\u4500\0\u4540\0\u4580\0\u45c0"+
    "\0\0\0\0\0\u4600\0\0\0\u4640\0\u4680\0\u46c0\0\u4700"+
    "\0\u46c0\0\u4740\0\u4780\0\u47c0\0\u14c0\0\u46c0\0\u4800\0\u4840"+
    "\0\u4880\0\u48c0\0\u4900\0\u4940\0\u4980\0\u49c0\0\u4a00\0\u4a40"+
    "\0\u4a80\0\u4ac0\0\u4b00\0\u4b40\0\u4b80\0\u4bc0\0\u4c00\0\u4c40"+
    "\0\u4c80\0\u4cc0\0\u4d00\0\u4d40\0\u4d80\0\u4dc0\0\u4e00\0\u4e40"+
    "\0\u4e80\0\u4ec0\0\u4f00\0\u4f40\0\u4f80\0\u4fc0\0\0\0\u5000"+
    "\0\u0680\0\u5040\0\u0680\0\u5080\0\u50c0\0\u5100\0\u5140\0\u5180"+
    "\0\u51c0\0\u5200\0\u0680\0\u5240\0\u5280\0\u52c0\0\u0680\0\u5300"+
    "\0\u5340\0\u5380\0\u53c0\0\u5400\0\u5440\0\u5480\0\u54c0\0\0"+
    "\0\u5500\0\u5540\0\u5580\0\u55c0\0\u5600\0\u0680\0\u5640\0\u5680"+
    "\0\u56c0\0\u5700\0\u5740\0\u5780\0\u57c0\0\u5800\0\u0680\0\u5840"+
    "\0\u5880\0\u0680\0\u58c0\0\u5900\0\u5940\0\u5980\0\u0680\0\u59c0"+
    "\0\u5a00\0\u5a40\0\u0680\0\u5a80\0\u0680\0\u5ac0\0\u5b00\0\u5b40"+
    "\0\u5b80\0\u5bc0\0\u5c00\0\u5c40\0\u5c80\0\u5cc0\0\u5d00\0\u5d40"+
    "\0\u5d80\0\u5dc0\0\u5e00\0\u5e40\0\u5e80\0\u5ec0\0\u5f00\0\u5f40"+
    "\0\u5f80\0\u5fc0\0\u6000\0\u6040\0\u6080\0\u60c0\0\u6100\0\u6140"+
    "\0\0\0\u6180\0\u61c0\0\u6200\0\u6240\0\u6280\0\u62c0\0\u6300"+
    "\0\u6340\0\u6380\0\u63c0\0\u6400\0\u6440\0\u6480\0\u64c0\0\u6500"+
    "\0\u6540\0\u6580\0\u65c0\0\u6600\0\u6640\0\u6680\0\0\0\u66c0"+
    "\0\u6700\0\u6740\0\u6780\0\u67c0\0\u6800\0\u6840\0\u6880\0\u68c0"+
    "\0\u6900\0\u6940\0\u6980\0\0\0\u69c0\0\u6a00\0\u0680\0\u6a40"+
    "\0\u6a80\0\u6ac0\0\u6b00\0\u0680\0\u6b40\0\u0680\0\u0680\0\u6b80"+
    "\0\u0680\0\u0680\0\u0680\0\u1d40\0\0\0\u6bc0\0\u6c00\0\u6c40"+
    "\0\u6c80\0\u6cc0\0\u6d00\0\u0680\0\u6d40\0\u6d80\0\u6dc0\0\u6e00"+
    "\0\u6e40\0\u6e80\0\u6ec0\0\u0680\0\u6f00\0\u0680\0\u0680\0\u6f40"+
    "\0\u0680\0\u6f80\0\u6fc0\0\u0680\0\u7000\0\u7040\0\u7080\0\u0680"+
    "\0\u70c0\0\u7100\0\u0680\0\u7140\0\u7180\0\u71c0\0\u7200\0\u7240"+
    "\0\u7280\0\u72c0\0\u7300\0\u7340\0\u7380\0\0\0\u73c0\0\u7400"+
    "\0\u7440\0\u7480\0\u74c0\0\u7500\0\u7540\0\u7580\0\u75c0\0\u7600"+
    "\0\u7640\0\u7680\0\u76c0\0\u7700\0\u7740\0\u7780\0\u77c0\0\u7800"+
    "\0\u7840\0\u7880\0\0\0\u78c0\0\u7900\0\u7940\0\0\0\u7980"+
    "\0\u79c0\0\u7a00\0\u7a40\0\0\0\u7a80\0\u7ac0\0\u7b00\0\u7b40"+
    "\0\0\0\u7b80\0\u7bc0\0\u7c00\0\u7c40\0\u7c80\0\u7cc0\0\u7d00"+
    "\0\u7d40\0\u7d80\0\u7dc0\0\u7e00\0\u7e40\0\u0680\0\u7e80\0\u7ec0"+
    "\0\u7f00\0\u0680\0\u7f40\0\u7f80\0\u7fc0\0\u8000\0\u8040\0\u8080"+
    "\0\u80c0\0\u8100\0\u8140\0\u8180\0\u81c0\0\u8200\0\u8240\0\u0680"+
    "\0\u0680\0\u8280\0\u0680\0\u82c0\0\u8300\0\u0680\0\u0680\0\u8340"+
    "\0\u8380\0\u83c0\0\u8400\0\u8440\0\u8480\0\u84c0\0\u8500\0\u8540"+
    "\0\u8580\0\u85c0\0\u8600\0\u8640\0\u8680\0\u86c0\0\u8700\0\u8740"+
    "\0\u8780\0\u87c0\0\u8800\0\u8840\0\u8880\0\u88c0\0\u8900\0\u8940"+
    "\0\u8980\0\u89c0\0\u8a00\0\0\0\u8a40\0\0\0\u8a80\0\u8ac0"+
    "\0\u8b00\0\u8b40\0\0\0\u8b80\0\u8bc0\0\u8c00\0\0\0\u8c40"+
    "\0\u0680\0\u8c80\0\u8cc0\0\u8d00\0\u8d40\0\u8d80\0\u8dc0\0\u8e00"+
    "\0\u8e40\0\u8e80\0\u0680\0\u0680\0\u8ec0\0\u8f00\0\u8f40\0\u8f80"+
    "\0\u8fc0\0\u0680\0\u0680\0\u9000\0\u9040\0\u9080\0\u0680\0\u90c0"+
    "\0\u9100\0\u9140\0\u9180\0\u0680\0\u91c0\0\u9200\0\u9240\0\u9280"+
    "\0\u92c0\0\u9300\0\u9340\0\u9380\0\u93c0\0\u9400\0\0\0\0"+
    "\0\u9440\0\0\0\u9480\0\u94c0\0\u9500\0\0\0\u9540\0\0"+
    "\0\u9580\0\u95c0\0\u9600\0\u9640\0\0\0\0\0\u9680\0\u96c0"+
    "\0\u9700\0\u9740\0\u9780\0\u97c0\0\u0680\0\u0680\0\u0680\0\u9800"+
    "\0\u0680\0\u9840\0\u9880\0\u98c0\0\u9900\0\u9940\0\u9980\0\u0680"+
    "\0\u99c0\0\u9a00\0\u9a40\0\u9a80\0\u0680\0\u9ac0\0\u0680\0\u9b00"+
    "\0\u9b40\0\u9b80\0\0\0\u9bc0\0\u9c00\0\u9c40\0\u9c80\0\u9cc0"+
    "\0\u9d00\0\u9d40\0\u9d80\0\u9dc0\0\u9e00\0\0\0\u9e40\0\0"+
    "\0\0\0\u9e80\0\u9ec0\0\u0680\0\u9f00\0\u0680\0\u9f40\0\u0680"+
    "\0\u0680\0\u9f80\0\u9fc0\0\ua000\0\u0680\0\u0680\0\ua040\0\ua080"+
    "\0\ua0c0\0\ua100\0\ua140\0\ua180\0\0\0\0\0\ua1c0\0\ua200"+
    "\0\0\0\0\0\ua240\0\ua280\0\ua2c0\0\0\0\u0680\0\u0680"+
    "\0\ua300\0\ua340\0\u0680\0\u0680\0\0\0\ua380\0\ua3c0\0\u0680"+
    "\0\ua400\0\0\0\0\0\0\0\ua440\0\ua480\0\0\0\ua4c0"+
    "\0\ua500\0\ua540\0\ua580\0\ua5c0\0\ua600\0\0\0\0\0\0"+
    "\0\u0680\0\u0680\0\ua640\0\u0680\0\ua680\0\u0680\0\ua6c0\0\ua700"+
    "\0\u0680";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[841];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\100\0\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\24\1\34\2\35\1\36\1\37\1\35"+
    "\1\40\1\41\1\42\1\43\1\44\1\45\1\46\1\47"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\1\56\1\57"+
    "\1\60\1\61\1\62\1\63\1\64\1\65\1\66\1\67"+
    "\1\70\1\71\1\72\1\73\1\74\2\34\1\75\1\34"+
    "\1\76\1\77\1\100\1\101\1\102\1\36\1\34\1\103"+
    "\1\34\1\104\2\36\1\105\1\106\1\36\20\107\1\110"+
    "\1\111\1\112\1\107\1\113\53\107\22\114\1\115\52\114"+
    "\1\111\2\114\20\116\1\117\1\116\1\120\1\111\1\121"+
    "\53\116\4\122\1\123\17\122\1\124\53\122\13\125\1\126"+
    "\3\125\1\126\1\127\1\125\1\130\1\125\1\131\53\125"+
    "\13\10\1\132\3\10\1\132\60\10\3\133\1\134\2\133"+
    "\3\134\1\133\1\134\25\133\5\134\1\133\15\134\1\133"+
    "\1\134\2\133\3\134\6\133\3\135\1\136\2\135\3\136"+
    "\1\135\1\136\25\135\5\136\1\135\15\136\1\135\1\136"+
    "\2\135\3\136\6\135\3\137\1\140\2\137\3\140\1\137"+
    "\1\140\1\141\3\137\1\142\20\137\5\140\1\137\15\140"+
    "\1\137\1\140\2\137\3\140\6\137\3\143\1\144\1\145"+
    "\1\143\3\144\1\143\1\144\2\35\2\143\1\35\20\143"+
    "\5\144\1\143\15\144\1\143\1\144\2\143\3\144\6\143"+
    "\1\23\1\146\1\147\1\34\1\147\1\150\3\34\1\146"+
    "\1\34\2\151\2\147\1\151\1\152\1\147\1\151\15\147"+
    "\3\34\1\153\1\34\1\147\15\34\1\147\1\34\2\147"+
    "\3\34\1\147\1\36\1\154\2\151\1\147\32\155\1\156"+
    "\45\155\32\157\1\160\44\157\1\161\13\162\1\163\3\162"+
    "\1\164\6\162\1\165\5\162\1\166\10\162\1\167\32\162"+
    "\13\170\2\171\2\170\1\171\60\170\13\23\1\172\3\23"+
    "\1\173\60\23\1\0\1\24\1\174\1\175\1\0\1\24"+
    "\3\0\1\24\67\0\1\174\3\0\1\174\3\0\1\174"+
    "\13\0\1\176\53\0\1\34\1\0\1\34\1\0\1\34"+
    "\1\177\1\200\3\34\25\0\3\34\1\201\1\34\1\0"+
    "\6\34\1\202\1\203\5\34\1\0\1\204\2\0\3\34"+
    "\12\0\1\176\20\0\1\176\1\205\52\0\1\24\1\174"+
    "\1\175\1\0\1\24\1\206\1\0\1\207\1\24\67\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\1\60\4\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\1\210\1\34\1\211"+
    "\2\34\1\0\6\34\1\212\6\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\6\0"+
    "\1\41\7\0\1\213\6\0\1\34\1\214\3\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\3\0\1\105\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\21\0\2\35\2\0"+
    "\1\35\63\0\1\215\2\0\3\215\1\0\1\215\25\0"+
    "\5\215\1\0\1\215\1\216\13\215\1\0\1\215\2\0"+
    "\3\215\6\0\20\217\1\220\1\221\1\222\1\217\1\223"+
    "\53\217\25\0\1\224\1\176\76\0\1\176\1\224\76\0"+
    "\1\176\1\0\1\176\75\0\1\224\77\0\1\225\1\176"+
    "\2\0\1\226\73\0\1\176\4\0\1\224\72\0\1\176"+
    "\4\0\1\227\1\106\71\0\1\176\1\230\76\0\1\176"+
    "\7\0\1\176\67\0\1\176\10\0\1\176\66\0\1\176"+
    "\53\0\1\34\1\0\1\34\1\0\6\34\25\0\1\34"+
    "\1\231\3\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\232\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\3\34\1\233\2\34\25\0\1\34"+
    "\1\234\1\34\1\235\1\34\1\0\4\34\1\236\10\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\237"+
    "\1\0\6\34\25\0\2\34\1\240\2\34\1\0\3\34"+
    "\1\241\11\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\242\1\0\6\34\25\0\1\243\4\34\1\0"+
    "\1\244\14\34\1\0\1\34\2\0\3\34\34\0\1\245"+
    "\16\0\1\176\33\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\3\34\1\246\1\34\1\0\2\34\1\247\1\34"+
    "\1\250\2\34\1\251\5\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\1\34"+
    "\1\252\3\34\1\0\10\34\1\253\4\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\1\254\1\255\1\256\2\34\1\0\1\257\2\34"+
    "\1\260\11\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\3\34\1\261\1\34"+
    "\1\0\4\34\1\262\10\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\263\1\0\6\34\25\0\5\34"+
    "\1\0\1\34\1\264\7\34\1\265\3\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\1\266\14\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\1\267\14\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\10\34\1\270\4\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\1\271"+
    "\4\34\1\0\6\34\1\272\6\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\1\34\1\273\1\274\2\34\1\0\3\34\1\275\11\34"+
    "\1\0\1\34\2\0\3\34\71\0\1\276\15\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\2\34\1\277\2\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\16\0\1\300"+
    "\3\0\1\301\23\0\1\302\1\303\1\304\1\0\1\305"+
    "\1\0\1\306\1\0\1\307\1\310\1\311\26\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\15\34"+
    "\1\0\1\34\2\0\1\34\1\312\1\34\6\0\22\313"+
    "\1\314\52\313\1\221\2\313\20\107\1\315\1\0\1\316"+
    "\1\107\1\317\56\107\1\320\2\107\3\320\1\107\1\320"+
    "\5\107\1\321\1\322\1\316\1\107\1\323\13\107\5\320"+
    "\1\107\15\320\1\107\1\320\2\107\3\320\126\107\1\324"+
    "\1\322\1\316\1\107\1\325\53\107\22\114\1\326\52\114"+
    "\1\0\24\114\1\221\52\114\1\221\2\114\20\116\1\327"+
    "\1\116\1\330\1\0\1\331\56\116\1\320\2\116\3\320"+
    "\1\116\1\320\5\116\1\332\1\116\1\330\1\333\1\323"+
    "\13\116\5\320\1\116\15\320\1\116\1\320\2\116\3\320"+
    "\126\116\1\324\1\116\1\330\1\333\1\334\53\116\26\0"+
    "\1\335\71\0\1\324\57\0\13\125\1\126\3\125\1\126"+
    "\1\336\1\125\1\337\1\125\1\340\56\125\1\341\2\125"+
    "\3\341\1\125\1\341\1\126\3\125\1\126\1\336\1\125"+
    "\1\337\1\125\1\340\13\125\5\341\1\125\15\341\1\125"+
    "\1\341\2\125\3\341\11\125\1\320\2\125\3\320\1\125"+
    "\1\320\1\126\3\125\1\126\1\342\1\125\1\337\1\125"+
    "\1\323\13\125\5\320\1\125\15\320\1\125\1\320\2\125"+
    "\3\320\21\125\1\126\3\125\1\126\73\125\1\126\3\125"+
    "\1\126\1\324\1\125\1\337\1\125\1\343\53\125\3\10"+
    "\1\344\2\10\3\344\1\10\1\344\1\132\3\10\1\132"+
    "\20\10\5\344\1\10\15\344\1\10\1\344\2\10\3\344"+
    "\6\10\1\0\1\345\1\0\1\345\1\0\6\345\1\346"+
    "\2\0\1\347\1\346\20\0\5\345\1\0\15\345\1\0"+
    "\1\345\2\0\3\345\7\0\1\350\1\0\1\350\1\0"+
    "\6\350\1\351\2\0\1\352\1\351\20\0\5\350\1\0"+
    "\15\350\1\0\1\350\2\0\3\350\6\0\3\353\1\354"+
    "\2\353\3\354\1\353\1\354\1\0\2\353\1\355\1\0"+
    "\20\353\5\354\1\353\15\354\1\353\1\354\2\353\3\354"+
    "\6\353\1\356\1\357\1\356\1\357\1\356\6\357\1\360"+
    "\2\356\1\361\1\360\20\356\5\357\1\356\15\357\1\356"+
    "\1\357\2\356\3\357\6\356\3\362\1\363\2\362\3\363"+
    "\1\362\1\363\1\141\2\362\1\364\1\141\20\362\5\363"+
    "\1\362\15\363\1\362\1\363\2\362\3\363\6\362\1\0"+
    "\1\144\1\0\1\144\1\0\6\144\25\0\5\144\1\0"+
    "\15\144\1\0\1\144\2\0\3\144\34\0\1\365\52\0"+
    "\1\146\3\0\1\146\3\0\1\146\67\0\1\366\3\0"+
    "\1\366\1\206\1\0\1\207\1\366\71\0\1\367\2\0"+
    "\3\367\1\0\1\367\25\0\5\367\1\0\15\367\1\0"+
    "\1\367\2\0\3\367\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\5\34\1\0\3\34\1\241\11\34\1\0"+
    "\1\34\2\0\3\34\6\0\32\155\1\0\45\155\33\0"+
    "\1\370\77\0\1\371\47\0\1\372\3\0\1\373\31\0"+
    "\1\374\1\375\1\376\1\377\1\0\1\u0100\1\u0101\1\u0102"+
    "\1\u0103\1\u0104\1\0\1\u0105\1\u0106\3\0\1\u0107\1\u0108"+
    "\1\0\1\u0109\13\0\13\162\1\163\3\162\1\163\6\162"+
    "\1\163\5\162\1\163\10\162\1\163\32\162\13\0\1\u010a"+
    "\112\0\1\u010b\77\0\1\245\64\0\2\171\2\0\1\171"+
    "\63\0\1\u010c\2\0\3\u010c\1\0\1\u010c\25\0\5\u010c"+
    "\1\0\15\u010c\1\0\1\u010c\2\0\3\u010c\11\0\1\u010c"+
    "\2\0\3\u010c\1\0\1\u010c\1\172\24\0\5\u010c\1\0"+
    "\15\u010c\1\0\1\u010c\2\0\3\u010c\7\0\1\174\1\0"+
    "\1\175\1\0\1\174\3\0\1\174\67\0\1\366\2\0"+
    "\2\366\3\0\1\366\15\0\1\366\51\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\1\u010d\1\u010e"+
    "\13\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\10\34\1\u010f"+
    "\4\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\4\34\1\u0110\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\4\34\1\u0111\10\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\14\34\1\u0112\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\2\34\1\u0113\2\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\u0114\1\0\1\u0114\1\0"+
    "\1\u0114\1\0\3\u0114\30\0\1\u0114\1\0\1\u0114\3\0"+
    "\1\u0114\34\0\1\u0115\3\0\1\u0115\67\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\3\34\1\u0116\1\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\1\34\1\u0117"+
    "\2\34\1\u0118\1\34\1\u0119\6\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\1\u011a\1\34\1\u011b\2\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\37\0\1\u011c\47\0\1\34\1\0\1\u011d"+
    "\1\0\6\34\25\0\5\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\215\1\0\1\215\1\0\6\215"+
    "\25\0\5\215\1\0\15\215\1\0\1\215\2\0\3\215"+
    "\7\0\1\215\1\0\1\215\1\0\6\215\25\0\5\215"+
    "\1\0\10\215\1\u011e\4\215\1\0\1\215\2\0\3\215"+
    "\6\0\3\217\1\0\2\217\3\0\1\217\1\0\5\217"+
    "\1\220\1\221\1\222\1\217\1\0\13\217\5\0\1\217"+
    "\15\0\1\217\1\0\2\217\3\0\126\217\1\0\1\221"+
    "\1\222\1\217\1\223\53\217\26\0\1\176\76\0\1\176"+
    "\3\0\1\u011f\100\0\1\u0120\60\0\2\230\2\0\1\230"+
    "\61\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\1\34\1\u0121\13\34\1\0\1\34\2\0\2\34"+
    "\1\u0122\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\4\34\1\u0123\10\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\1\34\1\u0124\3\34\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\4\34\1\231\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\11\34\1\u0125\3\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\7\34\1\u0126\5\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\6\34\1\u0127\6\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\2\34\1\u0128\3\34"+
    "\25\0\5\34\1\0\2\34\1\u0129\12\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\u012a\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\21\0\2\245\2\0\1\245\61\0\1\34\1\0\1\34"+
    "\1\0\2\34\1\u012b\3\34\25\0\5\34\1\0\1\34"+
    "\1\u012c\2\34\1\u012d\10\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\4\34\1\u012e\10\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\14\34\1\u012f\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\2\34\1\u0130"+
    "\2\34\1\0\3\34\1\u0131\1\34\1\u0132\7\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\34\1\u0133\3\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\34\1\u0134\3\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\u0135\4\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\6\34\1\u0136\6\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\3\34\1\u0137\1\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\3\34\1\u0138\1\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\4\34\1\u0139\10\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\u013a\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\6\34\1\u013b\6\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\2\34"+
    "\1\u013c\2\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\1\u013d\14\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\u013e\1\0\6\34\25\0\5\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\4\34\1\u013f"+
    "\10\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\1\u0140\14\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\1\34\1\u0141\13\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\1\u0142\4\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\u0143\4\34\1\0\1\u0144\14\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\34\1\u0145\3\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\3\34\1\u0146\2\34\25\0\5\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\34\1\u0147\3\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\46\0\1\u0148\5\0\1\u0149\41\0"+
    "\1\u014a\72\0\1\u014b\135\0\1\u014c\76\0\1\u014d\102\0"+
    "\1\u014e\110\0\1\u014f\66\0\1\u0150\103\0\1\u0151\31\0"+
    "\1\34\1\0\1\34\1\0\2\34\1\u0152\3\34\25\0"+
    "\3\34\1\u0153\1\u0154\1\0\2\34\1\u0155\3\34\1\u0156"+
    "\1\u0157\1\u0158\4\34\1\0\1\34\2\0\3\34\6\0"+
    "\100\313\3\107\1\0\2\107\3\0\1\107\1\0\5\107"+
    "\1\321\1\322\1\316\1\107\1\0\13\107\5\0\1\107"+
    "\15\0\1\107\1\0\2\107\3\0\26\107\1\0\1\322"+
    "\1\316\1\107\1\325\53\107\1\0\1\320\1\0\1\320"+
    "\1\0\6\320\25\0\5\320\1\0\15\320\1\0\1\320"+
    "\2\0\3\320\1\0\1\u0159\4\0\22\114\1\0\52\114"+
    "\1\0\2\114\3\116\1\0\2\116\3\0\1\116\1\0"+
    "\5\116\1\332\1\116\1\330\1\333\1\0\13\116\5\0"+
    "\1\116\15\0\1\116\1\0\2\116\3\0\26\116\1\0"+
    "\1\116\1\330\1\333\1\334\53\116\3\125\1\0\2\125"+
    "\3\0\1\125\1\0\1\126\3\125\1\126\1\342\1\125"+
    "\1\337\1\125\1\0\13\125\5\0\1\125\15\0\1\125"+
    "\1\0\2\125\3\0\21\125\1\126\3\125\1\126\1\0"+
    "\1\125\1\337\1\125\1\343\54\125\1\341\1\125\1\341"+
    "\1\125\6\341\1\u015a\2\125\1\u015b\1\u015a\1\336\1\125"+
    "\1\337\1\125\1\340\13\125\5\341\1\125\15\341\1\125"+
    "\1\341\2\125\3\341\6\125\1\10\1\344\1\10\1\344"+
    "\1\10\6\344\1\u015c\2\10\1\u015d\1\u015c\20\10\5\344"+
    "\1\10\15\344\1\10\1\344\2\10\3\344\6\10\13\0"+
    "\1\346\3\0\1\346\73\0\1\351\3\0\1\351\60\0"+
    "\3\364\1\u015e\2\364\3\u015e\1\364\1\u015e\1\u015f\3\364"+
    "\1\u015f\20\364\5\u015e\1\364\15\u015e\1\364\1\u015e\2\364"+
    "\3\u015e\7\364\1\u0160\1\364\1\u015e\1\364\1\u0160\3\u015e"+
    "\1\u0160\1\u015e\1\u0161\2\364\1\u0162\1\u0161\20\364\5\u015e"+
    "\1\364\15\u015e\1\364\1\u015e\2\364\3\u015e\6\364\3\355"+
    "\1\u0163\2\355\3\u0163\1\355\1\u0163\1\0\3\355\1\0"+
    "\20\355\5\u0163\1\355\15\u0163\1\355\1\u0163\2\355\3\u0163"+
    "\6\355\3\u0164\1\u0165\2\u0164\3\u0165\1\u0164\1\u0165\1\u0161"+
    "\3\u0164\1\u0161\20\u0164\5\u0165\1\u0164\15\u0165\1\u0164\1\u0165"+
    "\2\u0164\3\u0165\7\u0164\1\u0165\1\u0164\1\u0165\1\u0164\6\u0165"+
    "\1\u0166\2\u0164\1\u0167\1\u0166\20\u0164\5\u0165\1\u0164\15\u0165"+
    "\1\u0164\1\u0165\2\u0164\3\u0165\6\u0164\13\u0168\1\360\3\u0168"+
    "\1\360\60\u0168\3\362\1\u0169\2\362\3\u0169\1\362\1\u0169"+
    "\1\u015f\2\362\1\364\1\u015f\20\362\5\u0169\1\362\15\u0169"+
    "\1\362\1\u0169\2\362\3\u0169\6\362\1\u016a\1\363\1\u016a"+
    "\1\363\1\u016a\6\363\1\u0166\2\u016a\1\u0167\1\u0166\20\u016a"+
    "\5\363\1\u016a\15\363\1\u016a\1\363\2\u016a\3\363\6\u016a"+
    "\1\0\1\366\3\0\1\366\3\0\1\366\67\0\1\367"+
    "\1\0\1\367\1\0\6\367\25\0\5\367\1\0\15\367"+
    "\1\0\1\367\2\0\3\367\14\0\1\u016b\131\0\1\u016c"+
    "\1\0\1\u016d\40\0\1\u016e\103\0\1\u016f\1\u0170\40\0"+
    "\1\u0171\70\0\1\u0172\40\0\1\u0173\137\0\1\u0174\15\0"+
    "\1\u0175\56\0\1\u0176\10\0\1\u0177\4\0\1\u0178\67\0"+
    "\1\u0179\103\0\1\u017a\30\0\1\u017b\42\0\1\u017c\1\u017d"+
    "\1\0\1\u017e\74\0\1\u017f\34\0\1\u0180\36\0\1\u0181"+
    "\111\0\1\u0182\64\0\1\u0183\1\u0184\40\0\1\u0185\36\0"+
    "\1\u0186\50\0\2\u010b\2\0\1\u010b\61\0\1\u010c\1\0"+
    "\1\u010c\1\0\6\u010c\1\u0187\2\0\1\u0188\1\u0187\20\0"+
    "\5\u010c\1\0\15\u010c\1\0\1\u010c\2\0\3\u010c\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\0"+
    "\1\34\1\u0189\13\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\u018a\1\0\6\34\25\0\5\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\1\u018b\4\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\4\34\1\u018c\1\0\1\u018d\1\34"+
    "\1\u018e\1\34\1\u018f\4\34\1\u0190\3\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\u0191\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\1\34\1\u0192\13\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\6\34\1\u0193\6\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\1\34\1\u0194\2\34\1\u0195\10\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\2\34"+
    "\1\u0196\3\34\25\0\5\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\u0197\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\6\34\1\u0198\6\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\3\34"+
    "\1\u0199\1\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\4\34\1\u019a\10\34\1\0\1\34\2\0\3\34"+
    "\37\0\1\u011f\47\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\2\34\1\u019b\2\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\215\1\0\1\215\1\0\6\215"+
    "\25\0\5\215\1\0\1\u019c\14\215\1\0\1\215\2\0"+
    "\3\215\11\0\1\u019d\2\0\3\u019d\1\0\1\u019d\1\0"+
    "\1\u011f\4\0\1\u019e\16\0\5\u019d\1\0\15\u019d\1\0"+
    "\1\u019d\2\0\3\u019d\3\0\1\u019f\35\0\1\u01a0\45\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\0"+
    "\3\34\1\u01a1\11\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\0"+
    "\3\34\1\u01a2\11\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\0"+
    "\1\34\1\u01a3\13\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\2\34\1\u01a4"+
    "\2\34\1\0\15\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\u01a5\1\0\6\34\25\0\5\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\6\34\1\u01a6"+
    "\6\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\6\34\1\u01a7"+
    "\6\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\2\34\1\u01a8\2\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\6\34\1\u01a9"+
    "\6\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\u01aa\1\0\6\34\25\0\5\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\5\34\1\0\1\34\1\u01ab\13\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\u01ac\1\0"+
    "\6\34\25\0\5\34\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\6\34\1\u01ad\6\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\1\u01ae\14\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\u01af\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\1\u01b0\4\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\u01b1\1\0\6\34\25\0\5\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\5\34\1\0\7\34\1\u01b2\5\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\5\34\1\0\4\34\1\u01b3\10\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\2\34\1\u01b4\2\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u01b5\3\34\25\0\5\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\u01b6\1\0"+
    "\6\34\25\0\5\34\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\2\34\1\u01b7\12\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\1\34\1\u01b8\13\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\1\34\1\u01b9\13\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\6\34\1\u01ba\6\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\1\34\1\u01bb\13\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\6\34\1\u01bc\6\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\1\u01bd\4\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\3\34\1\u01be\2\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\1\34\1\u01bf\13\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\3\34"+
    "\1\u01c0\1\34\1\0\15\34\1\0\1\u01c1\2\0\3\34"+
    "\7\0\1\34\1\0\1\u01c2\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\6\34"+
    "\1\u01c3\6\34\1\0\1\34\2\0\3\34\46\0\1\u01c4"+
    "\102\0\1\u01c5\123\0\1\u01c6\52\0\1\u01c7\76\0\1\u01c8"+
    "\107\0\1\u01c9\75\0\1\u01ca\70\0\1\u01cb\111\0\1\u01cc"+
    "\66\0\1\u01cd\37\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\6\34\1\u01ce\6\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\2\34\1\u01cf\2\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\1\u01d0\14\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\1\u01d1\2\34\1\u01d2\11\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\1\u01d3\14\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\u01d4\1\0\6\34\25\0"+
    "\5\34\1\0\15\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\2\34\1\u01d5"+
    "\2\34\1\0\15\34\1\0\1\34\2\0\3\34\6\0"+
    "\13\125\1\u015a\3\125\1\u015a\1\336\1\125\1\337\1\125"+
    "\1\340\53\125\13\10\1\u015c\3\10\1\u015c\60\10\1\353"+
    "\1\u01d6\1\353\1\u01d6\1\353\6\u01d6\1\360\2\353\1\u01d7"+
    "\1\360\20\353\5\u01d6\1\353\15\u01d6\1\353\1\u01d6\2\353"+
    "\3\u01d6\6\353\13\u01d8\1\0\2\u01d8\2\0\60\u01d8\1\353"+
    "\1\354\1\353\1\354\1\353\6\354\1\u01d9\2\353\1\u01da"+
    "\1\u01d9\20\353\5\354\1\353\15\354\1\353\1\354\2\353"+
    "\3\354\11\353\1\354\2\353\3\354\1\353\1\354\1\u01d9"+
    "\2\353\1\355\1\u01d9\20\353\5\354\1\353\15\354\1\353"+
    "\1\354\2\353\3\354\6\353\1\355\1\u0163\1\355\1\u0163"+
    "\1\355\6\u0163\1\u01d9\2\355\1\u01da\1\u01d9\20\355\5\u0163"+
    "\1\355\15\u0163\1\355\1\u0163\2\355\3\u0163\6\355\13\356"+
    "\1\u01d9\2\356\1\u0168\1\u01d9\73\356\1\360\2\356\1\u0168"+
    "\1\360\60\356\13\u0168\1\u01d9\3\u0168\1\u01d9\60\u0168\1\362"+
    "\1\u0169\1\362\1\u0169\1\362\6\u0169\1\u0166\2\362\1\u01db"+
    "\1\u0166\20\362\5\u0169\1\362\15\u0169\1\362\1\u0169\2\362"+
    "\3\u0169\6\362\3\u016a\1\363\2\u016a\3\363\1\u016a\1\363"+
    "\1\u0161\2\u016a\1\u0164\1\u0161\20\u016a\5\363\1\u016a\15\363"+
    "\1\u016a\1\363\2\u016a\3\363\6\u016a\7\0\1\u01dc\32\0"+
    "\1\u01dd\117\0\1\u01de\64\0\1\u01df\77\0\1\u01e0\37\0"+
    "\1\u01e1\142\0\1\u01e2\74\0\1\u01e3\105\0\1\u01e4\74\0"+
    "\1\u01e5\7\0\1\u01e6\64\0\1\u01e7\73\0\1\u01e8\100\0"+
    "\1\u01e9\102\0\1\u01ea\71\0\1\u01eb\101\0\1\u01ec\10\0"+
    "\1\u01ed\26\0\1\u01ee\77\0\1\u01ef\137\0\1\u01f0\76\0"+
    "\1\u01f1\45\0\1\u01f2\76\0\1\u01f3\33\0\1\u01f4\103\0"+
    "\1\u01f5\111\0\1\u01f6\56\0\1\u01f7\77\0\1\u01f8\46\0"+
    "\1\u01f9\31\0\1\u01fa\77\0\1\u01fb\77\0\1\u01fc\51\0"+
    "\1\u0187\3\0\1\u0187\61\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\3\34\1\u01fd\1\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\u01fe\1\0"+
    "\6\34\25\0\5\34\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\2\34\1\u01ff\12\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\1\u0200\4\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\11\34\1\u0201\3\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\10\34\1\u0202\4\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\1\u0203\14\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\0"+
    "\5\34\1\u0204\7\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\0"+
    "\1\u0205\14\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\1\34"+
    "\1\u0206\13\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\10\34"+
    "\1\u0207\4\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\2\34\1\u0208\2\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\u0209\1\0\6\34\25\0\5\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\4\34\1\u020a\10\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\12\34\1\u020b\2\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\215\1\0\1\215"+
    "\1\0\6\215\25\0\5\215\1\0\4\215\1\u020c\10\215"+
    "\1\0\1\215\2\0\3\215\7\0\1\u019d\1\0\1\u019d"+
    "\1\0\6\u019d\1\u020d\3\0\1\u020e\20\0\5\u019d\1\0"+
    "\15\u019d\1\0\1\u019d\2\0\3\u019d\11\0\1\u020f\2\0"+
    "\3\u020f\1\0\1\u020f\25\0\5\u020f\1\0\15\u020f\1\0"+
    "\1\u020f\2\0\3\u020f\11\0\1\u0210\2\0\3\u0210\1\0"+
    "\1\u0210\25\0\5\u0210\1\0\15\u0210\1\0\1\u0210\2\0"+
    "\3\u0210\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\1\34\1\u0211\3\34\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\1\u0212\14\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\1\34"+
    "\1\u0213\3\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\5\34\1\u0214\7\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\4\34\1\u0215\10\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\2\34"+
    "\1\u0216\2\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\3\34\1\u0217\11\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\3\34\1\u0218\11\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\1\34"+
    "\1\u0219\3\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\u021a\1\0\6\34\25\0\2\34"+
    "\1\u021b\2\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\1\34\1\u021c\13\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\u021d\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\1\34"+
    "\1\u021e\13\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\11\34"+
    "\1\u021f\3\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\2\34\1\u0220\2\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\u0221\1\0\6\34\25\0\5\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\6\34\1\u0222\6\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\1\34\1\u0223\13\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\1\34\1\u0224\13\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\1\u0225\14\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u0226\3\34\25\0\5\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\4\34\1\u0227\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\u0228\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\2\34"+
    "\1\u0229\2\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\u022a\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\1\34"+
    "\1\u022b\13\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\2\34\1\u022c\2\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\3\34\1\u022d\1\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\1\u022e"+
    "\14\34\1\0\1\34\2\0\3\34\62\0\1\u022f\65\0"+
    "\1\u0230\40\0\1\u0231\150\0\1\u0232\65\0\1\u0233\45\0"+
    "\1\u0234\72\0\1\u0235\10\0\1\u0232\51\0\1\u0236\53\0"+
    "\1\u0237\40\0\1\u0237\142\0\1\u0238\32\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\2\34\1\u0239\2\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\7\34\1\u023a"+
    "\5\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\1\34\1\u023b\3\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\6\34\1\u023c"+
    "\6\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\3\34\1\u023d\1\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\3\34\1\u023e\1\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\1\34\1\u023f"+
    "\13\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\5\34\1\0\6\34\1\u0240"+
    "\6\34\1\0\1\34\2\0\3\34\6\0\1\364\1\u015e"+
    "\1\364\1\u015e\1\364\6\u015e\1\u0166\2\364\1\u01db\1\u0166"+
    "\20\364\5\u015e\1\364\15\u015e\1\364\1\u015e\2\364\3\u015e"+
    "\6\364\3\355\1\u0163\2\355\3\u0163\1\355\1\u0163\1\360"+
    "\3\355\1\360\20\355\5\u0163\1\355\15\u0163\1\355\1\u0163"+
    "\2\355\3\u0163\6\355\3\u015f\1\u0241\2\u015f\3\u0241\1\u015f"+
    "\1\u0241\25\u015f\5\u0241\1\u015f\15\u0241\1\u015f\1\u0241\2\u015f"+
    "\3\u0241\6\u015f\3\355\1\u0163\2\355\3\u0163\1\355\1\u0163"+
    "\1\u01d9\3\355\1\u01d9\20\355\5\u0163\1\355\15\u0163\1\355"+
    "\1\u0163\2\355\3\u0163\6\355\3\353\1\354\2\353\3\354"+
    "\1\353\1\354\1\360\2\353\1\355\1\360\20\353\5\354"+
    "\1\353\15\354\1\353\1\354\2\353\3\354\6\353\3\0"+
    "\1\u0242\151\0\1\u0243\75\0\1\u0244\27\0\1\u0245\145\0"+
    "\1\u0246\31\0\1\u0247\143\0\1\u0248\106\0\1\u0249\24\0"+
    "\1\u024a\103\0\1\u024b\131\0\1\u024c\41\0\1\u024d\134\0"+
    "\1\u024e\77\0\1\u024f\77\0\1\u0250\77\0\1\u0251\101\0"+
    "\1\u0252\40\0\1\u0253\146\0\1\u0254\34\0\1\u0255\137\0"+
    "\1\u0256\112\0\1\u0257\20\0\1\u0258\154\0\1\u0259\75\0"+
    "\1\u025a\67\0\1\u025b\41\0\1\u025c\151\0\1\u025d\75\0"+
    "\1\u025e\61\0\1\u025f\107\0\1\u0260\26\0\1\34\1\0"+
    "\1\34\1\0\6\34\25\0\4\34\1\u0261\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\2\34\1\u0262\3\34\25\0\5\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\1\34\1\u0263\3\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\1\u0264\14\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\5\34\1\0\1\u0265\14\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\2\34\1\u0266\12\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\3\34\1\u0267\1\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\3\34"+
    "\1\u0268\2\34\25\0\5\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\21\0\1\u020d\65\0\1\u020f\1\0\1\u020f"+
    "\1\0\6\u020f\6\0\1\u0269\16\0\5\u020f\1\0\15\u020f"+
    "\1\0\1\u020f\2\0\3\u020f\7\0\1\u0210\1\0\1\u0210"+
    "\1\0\6\u0210\25\0\5\u0210\1\0\15\u0210\1\0\1\u0210"+
    "\2\0\3\u0210\3\0\1\u0269\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\3\34\1\u026a\1\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\1\34\1\u026b\3\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\2\34\1\u026c\2\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\14\34\1\u026d\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\34\1\u026e\3\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\5\34\1\0\6\34\1\u026f\6\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\4\34\1\u0270\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\2\34\1\u0271\12\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\2\34\1\u0272\2\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\3\34\1\u0273\1\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\7\34\1\u0274\5\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\2\34"+
    "\1\u0275\3\34\25\0\5\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\6\34\1\u0276\6\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\1\u0277\14\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\2\34\1\u0278"+
    "\3\34\25\0\5\34\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\10\34\1\u0279\4\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\2\u027a"+
    "\2\0\1\u027a\20\0\5\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\6\34\1\u027b\6\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\2\34"+
    "\1\u027c\3\34\25\0\5\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\1\34\1\u027d\13\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\1\34\1\u027e\13\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\2\34"+
    "\1\u027f\3\34\25\0\5\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\11\0\1\u0280\10\0\1\u0232\51\0\1\u0236"+
    "\52\0\1\u0233\45\0\1\u0237\104\0\1\u0232\51\0\1\u0236"+
    "\64\0\1\u0232\100\0\1\u0281\104\0\1\u0282\65\0\1\u0232"+
    "\73\0\1\u0283\35\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\4\34\1\u0284\10\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\u0285\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\1\34\1\u0286\1\34"+
    "\7\0\1\34\1\0\1\u0287\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\2\34\1\u0288\3\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\u0289\1\0\6\34\25\0\5\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\10\34\1\u028a\4\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\1\34\1\u028b\13\34"+
    "\1\0\1\34\2\0\3\34\6\0\1\u01d8\1\u028c\1\u01d8"+
    "\1\u028c\1\u01d8\6\u028c\1\360\2\u01d8\1\u028d\1\360\20\u01d8"+
    "\5\u028c\1\u01d8\15\u028c\1\u01d8\1\u028c\2\u01d8\3\u028c\6\u01d8"+
    "\62\0\1\u028e\77\0\1\u028f\56\0\1\u0290\117\0\1\u0291"+
    "\57\0\1\u0292\110\0\1\u0293\66\0\1\u0294\76\0\1\u0295"+
    "\111\0\1\u0296\30\0\1\u0297\135\0\1\u0298\77\0\1\u0299"+
    "\77\0\1\u029a\115\0\1\u029b\74\0\1\u029c\75\0\1\u029d"+
    "\30\0\1\u029e\142\0\1\u029f\73\0\1\u02a0\100\0\1\u02a1"+
    "\74\0\1\u02a2\46\0\1\u02a3\132\0\1\u02a4\40\0\1\u02a5"+
    "\136\0\1\u02a6\112\0\1\u02a7\70\0\1\u02a8\32\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\4\34"+
    "\1\u02a9\10\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\6\34"+
    "\1\u02aa\6\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\u02ab\1\0\6\34\25\0\5\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\1\34\1\u02ac\13\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\6\34\1\u02ad\6\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\3\34\1\u02ae\11\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\6\34\1\u02af\6\34"+
    "\1\0\1\34\2\0\3\34\21\0\1\u020d\3\0\1\u020e"+
    "\61\0\1\34\1\0\1\u02b0\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\2\34\1\u02b1\3\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\2\34\1\u02b2\2\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\u02b3\1\0\6\34\25\0\5\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\1\34\1\u02b4\13\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\u02b5"+
    "\1\0\6\34\25\0\5\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\2\34\1\u02b6\2\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\4\34\1\u02b7\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\2\34\1\u02b8"+
    "\3\34\25\0\5\34\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\u02b9\1\0\6\34\25\0"+
    "\5\34\1\0\15\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\0"+
    "\10\34\1\u02ba\4\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\0"+
    "\5\34\1\u02bb\7\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\1\u02bc\4\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\21\0\2\u027a"+
    "\2\0\1\u027a\30\0\1\u02bd\30\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\1\34\1\u02be\13\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\u02bf"+
    "\1\0\6\34\25\0\5\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\50\0\1\u02c0\40\0\1\u0232\77\0\1\u02c1"+
    "\155\0\1\u0232\17\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\4\34\1\u02c2\10\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\4\34\1\u02c3\10\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\1\34"+
    "\1\u02c4\1\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\1\34"+
    "\1\u02c5\1\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\1\34\1\u02c6\13\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\1\34"+
    "\1\u02c7\1\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\1\u02c8\4\34\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\15\34\1\0\1\34\2\0\1\34\1\u02c9"+
    "\1\34\6\0\1\u015f\1\u0241\1\u015f\1\u0241\1\u015f\6\u0241"+
    "\1\u0166\2\u015f\1\u02ca\1\u0166\20\u015f\5\u0241\1\u015f\15\u0241"+
    "\1\u015f\1\u0241\2\u015f\3\u0241\6\u015f\13\0\1\360\3\0"+
    "\1\360\127\0\1\u02cb\104\0\1\u02cc\71\0\1\u02cd\71\0"+
    "\1\u02ce\102\0\1\u02cf\106\0\1\u02d0\67\0\1\u02d1\76\0"+
    "\1\u02d2\120\0\1\u02d3\24\0\1\u02d4\133\0\1\u02d5\37\0"+
    "\1\u02d6\142\0\1\u02d7\103\0\1\u02d8\65\0\1\u02d9\46\0"+
    "\1\u02da\77\0\1\u02db\142\0\1\u02dc\71\0\1\u02dd\107\0"+
    "\1\u02de\64\0\1\u02df\117\0\1\u02e0\56\0\1\u02e1\40\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\2\34\1\u02e2"+
    "\2\34\1\0\15\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\2\34\1\u02e3"+
    "\2\34\1\0\15\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\2\34\1\u02e4\3\34\25\0"+
    "\5\34\1\0\15\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\u02e5\1\0\6\34\25\0\5\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\u02e6\1\0\6\34\25\0\5\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\u02e7\1\0"+
    "\6\34\25\0\5\34\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\15\34\1\0\1\34\2\0\1\34\1\u02e8"+
    "\1\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\1\34\1\u02e9\13\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\2\34\1\u02ea"+
    "\3\34\25\0\5\34\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\15\34\1\0\1\34\2\0\1\34\1\u02eb"+
    "\1\34\7\0\1\34\1\0\1\34\1\0\2\34\1\u02ec"+
    "\3\34\25\0\5\34\1\0\15\34\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\1\u02ed\4\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\u02ee\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\3\34\1\u02ef\1\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\3\34\1\u02f0\1\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\47\0\1\u02f1"+
    "\37\0\1\34\1\0\1\u02f2\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\51\0\1\u0232"+
    "\75\0\1\u0232\37\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\1\34"+
    "\1\u02f3\1\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\14\34\1\u02f4\1\0\1\34\2\0"+
    "\3\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\15\34\1\0\1\34\2\0\1\34\1\u02f5"+
    "\1\34\7\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\5\34\1\0\1\u02f6\14\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\1\34\1\u02f7\1\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\4\34"+
    "\1\u02f8\1\0\15\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\2\34\1\u02f9\3\34\25\0"+
    "\5\34\1\0\15\34\1\0\1\34\2\0\3\34\6\0"+
    "\13\u01d8\1\360\2\u01d8\1\0\1\360\60\u01d8\46\0\1\u02fa"+
    "\34\0\1\u02fb\155\0\1\u02fc\57\0\1\u02fd\45\0\1\u02fe"+
    "\132\0\1\u02ff\77\0\1\u0300\77\0\1\u0301\77\0\1\u0302"+
    "\106\0\1\u0303\112\0\1\u0304\73\0\1\u0305\22\0\1\u0306"+
    "\143\0\1\u0307\33\0\1\u0308\137\0\1\u0309\35\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\1\34\1\u030a\3\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\2\34\1\u030b\3\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\10\34"+
    "\1\u030c\4\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\1\u030d\4\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\u030e\1\0\6\34\25\0\5\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\1\u030f\4\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\u0310\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\2\34\1\u0311\12\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\1\u0312"+
    "\4\34\1\0\15\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\0"+
    "\1\34\1\u0313\13\34\1\0\1\34\2\0\3\34\46\0"+
    "\1\u0314\40\0\1\34\1\0\1\34\1\0\6\34\25\0"+
    "\4\34\1\u0315\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\1\34\1\u0316\1\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\2\34"+
    "\1\u0317\2\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\1\u0318"+
    "\4\34\1\0\15\34\1\0\1\34\2\0\3\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\5\34\1\0"+
    "\15\34\1\0\1\34\2\0\1\34\1\u0319\1\34\7\0"+
    "\1\34\1\0\1\34\1\0\6\34\25\0\1\u031a\4\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\46\0\1\u031b"+
    "\115\0\1\u031c\74\0\1\u031d\73\0\1\u031e\37\0\1\u031f"+
    "\137\0\1\u0320\104\0\1\u0321\77\0\1\u0322\64\0\1\u0323"+
    "\100\0\1\u0324\77\0\1\u0325\110\0\1\u0326\25\0\1\34"+
    "\1\0\1\u0327\1\0\6\34\25\0\5\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\10\34\1\u0328\4\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\3\34\1\u0329\1\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\3\34\1\u032a\1\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\2\34\1\u032b\12\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\6\34\25\0\5\34\1\0\4\34\1\u032c\10\34"+
    "\1\0\1\34\2\0\3\34\63\0\1\u032d\23\0\1\34"+
    "\1\0\1\34\1\0\2\34\1\u032e\3\34\25\0\5\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\3\34\1\u032f\1\34"+
    "\1\0\15\34\1\0\1\34\2\0\3\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\15\34"+
    "\1\0\1\34\2\0\1\34\1\u0330\1\34\7\0\1\34"+
    "\1\0\1\34\1\0\6\34\25\0\5\34\1\0\7\34"+
    "\1\u0331\5\34\1\0\1\34\2\0\3\34\51\0\1\u0332"+
    "\103\0\1\u0333\33\0\1\u0334\77\0\1\u0335\103\0\1\u0336"+
    "\131\0\1\u0337\117\0\1\u0338\17\0\1\34\1\0\1\34"+
    "\1\0\2\34\1\u0339\3\34\25\0\5\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\34"+
    "\1\0\2\34\1\u033a\3\34\25\0\5\34\1\0\15\34"+
    "\1\0\1\34\2\0\3\34\7\0\1\34\1\0\1\u033b"+
    "\1\0\6\34\25\0\5\34\1\0\15\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\1\34"+
    "\1\u033c\1\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\14\34\1\u033d\1\0\1\34\2\0"+
    "\3\34\52\0\1\u033e\36\0\1\u033f\77\0\1\u0340\75\0"+
    "\1\34\1\0\1\u0341\1\0\6\34\25\0\5\34\1\0"+
    "\15\34\1\0\1\34\2\0\3\34\7\0\1\34\1\0"+
    "\1\u0342\1\0\6\34\25\0\5\34\1\0\15\34\1\0"+
    "\1\34\2\0\3\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\5\34\1\0\15\34\1\0\1\34\2\0"+
    "\1\34\1\u0343\1\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\5\34\1\0\15\34\1\0\1\34\2\0"+
    "\1\34\1\u0344\1\34\7\0\1\34\1\0\1\34\1\0"+
    "\6\34\25\0\5\34\1\0\1\u0345\14\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\1\34"+
    "\1\u0346\1\34\7\0\1\34\1\0\1\34\1\0\6\34"+
    "\25\0\5\34\1\0\6\34\1\u0347\6\34\1\0\1\34"+
    "\2\0\3\34\7\0\1\34\1\0\1\u0348\1\0\6\34"+
    "\25\0\5\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\7\0\1\34\1\0\1\34\1\0\6\34\25\0\1\34"+
    "\1\u0349\3\34\1\0\15\34\1\0\1\34\2\0\3\34"+
    "\6\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[42816];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",		//$NON-NLS-1$
    "Error: could not match input",		//$NON-NLS-1$
    "Error: pushback value was too large"		//$NON-NLS-1$
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\10\5\0\2\1\12\0\1\11\12\1\2\11\2\1"+
    "\3\11\37\1\1\11\1\1\1\11\2\1\1\11\10\1"+
    "\1\11\10\1\1\11\1\1\1\11\3\1\1\0\1\1"+
    "\1\11\3\1\1\11\1\1\1\11\2\1\1\11\2\1"+
    "\1\11\3\1\1\11\1\1\1\11\2\1\1\11\1\1"+
    "\1\0\3\1\1\11\6\1\1\11\2\0\3\1\1\0"+
    "\3\1\2\0\1\11\2\0\52\1\1\11\1\1\12\0"+
    "\1\1\5\0\2\1\3\11\1\1\4\0\1\1\1\11"+
    "\1\1\1\11\3\0\4\1\1\0\1\11\2\0\1\11"+
    "\6\0\1\11\4\0\1\11\2\1\2\11\20\0\1\11"+
    "\1\1\1\0\17\1\1\0\2\1\1\0\50\1\12\0"+
    "\7\1\2\11\1\1\1\11\1\1\3\0\1\1\4\0"+
    "\1\1\40\0\1\11\1\0\24\1\3\0\1\11\43\1"+
    "\12\0\10\1\3\0\1\11\25\0\1\11\14\0\1\11"+
    "\20\1\1\11\1\1\2\0\36\1\7\0\1\11\2\0"+
    "\10\1\11\0\1\1\1\11\3\0\1\11\4\0\1\11"+
    "\4\0\1\11\7\0\10\1\1\0\20\1\1\0\5\1"+
    "\4\0\10\1\20\0\1\11\1\0\1\11\4\0\1\11"+
    "\3\0\1\11\1\0\24\1\1\0\2\1\2\0\10\1"+
    "\5\0\2\11\1\0\1\11\3\0\1\11\1\0\1\11"+
    "\1\0\1\1\2\0\2\11\3\0\17\1\1\0\10\1"+
    "\1\0\1\11\12\0\1\11\1\0\2\11\12\1\1\0"+
    "\6\1\2\0\2\11\2\0\2\11\3\0\1\11\6\1"+
    "\1\11\4\1\3\11\2\0\1\11\1\0\5\1\3\11"+
    "\11\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[841];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
    public PhpLexer(int state){
        initialize(state);
    }

    // NB: this method resets the lexer only partially
    protected void reset(java.io.Reader reader, char[] buffer, int[] parameters){
    	this.zzReader = reader;
    	this.zzBuffer = buffer;
    	this.zzFinalHighSurrogate = 0;
    	this.zzMarkedPos = parameters[0];
    	this._zzPushbackPos = parameters[1];
    	this.zzCurrentPos = parameters[2];
    	this.zzStartRead = parameters[3];
    	this.zzEndRead = parameters[4];
    	this.yyline = parameters[5];
    	initialize(parameters[6]);
    }

    protected boolean isHeredocState(int state){
        return state == ST_PHP_HEREDOC || state == ST_PHP_START_HEREDOC || state == ST_PHP_END_HEREDOC || state == ST_PHP_NOWDOC || state == ST_PHP_START_NOWDOC || state == ST_PHP_END_NOWDOC;
    }

    public int[] getParamenters(){
    	return new int[]{zzMarkedPos, _zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline, zzLexicalState};
    }

    protected int getZZLexicalState() {
        return zzLexicalState;
    }

    protected int getZZMarkedPos() {
        return zzMarkedPos;
    }

    protected int getZZEndRead() {
        return zzEndRead;
    }

    public char[] getZZBuffer() {
        return zzBuffer;
    }

    protected int getZZStartRead() {
    	return this.zzStartRead;
    }

    protected int getZZPushBackPosition() {
    	return this._zzPushbackPos;
    }

	protected void pushBack(int i) {
		yypushback(i);
	}

	public int getScriptingState() {
       return ST_PHP_IN_SCRIPTING;
    }

	// A pool of states. To avoid creation of a new state on each createMemento.
	private static final IntHashtable lexerStates = new IntHashtable(100);

	protected IntHashtable getLexerStates() {
		return lexerStates;
	}

 // End user code


  /** the textposition at the last state to be included in yytext */
  private int _zzPushbackPos;

  /* The following fields are added in order to support the change in zzRefill */
  private String oldString = null;
  private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PhpLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 236) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    oldString = new String(zzBuffer, startPos, zzMarkedPos-startPos);

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      _zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (zzAtEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (zzRefill()) {
        return YYEOF;
    }

    return zzBuffer[zzCurrentPos++];
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
    oldString = null;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		startPos = zzMarkedPos;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { if(heredoc!=null&&yytext().startsWith(heredoc)){
		String text = yytext();
		if(heredoc_len < text.length() && (text.charAt(heredoc_len) == '\r'
			|| text.charAt(heredoc_len) == '\n'|| text.charAt(heredoc_len) == ';')){
			yypushback(yylength()-heredoc_len-1);
	        heredoc=null;
	        heredoc_len=0;
	        yybegin(ST_PHP_IN_SCRIPTING);
	        return PHP_HEREDOC_TAG;
		}
	}
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 176: break;
          case 2: 
            { return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 177: break;
          case 3: 
            { yypushback(1);
    pushState(ST_PHP_HIGHLIGHTING_ERROR);
            }
          case 178: break;
          case 4: 
            { return PHP_NUMBER;
            }
          case 179: break;
          case 5: 
            { return PHP_TOKEN;
            }
          case 180: break;
          case 6: 
            { return  PHP_LABEL;
            }
          case 181: break;
          case 7: 
            { return WHITESPACE;
            }
          case 182: break;
          case 8: 
            { return PHP_SEMICOLON;
            }
          case 183: break;
          case 9: 
            { pushState(ST_PHP_DOUBLE_QUOTES);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 184: break;
          case 10: 
            { return PHP_NS_SEPARATOR;
            }
          case 185: break;
          case 11: 
            { pushState(ST_PHP_BACKQUOTE);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 186: break;
          case 12: 
            { return PHP_CURLY_OPEN;
            }
          case 187: break;
          case 13: 
            { if (!phpStack.isEmpty()) {
        popState();
    }
    return  PHP_CURLY_CLOSE;
            }
          case 188: break;
          case 14: 
            { pushState(ST_PHP_SINGLE_QUOTE);
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 189: break;
          case 15: 
            { pushState(ST_PHP_LINE_COMMENT);
    return PHP_LINE_COMMENT;
            }
          case 190: break;
          case 16: 
            { return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 191: break;
          case 17: 
            { popState();
    return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 192: break;
          case 18: 
            { yypushback(1);
        popState();
            }
          case 193: break;
          case 19: 
            { yypushback(1);
	yybegin(ST_PHP_HEREDOC);
            }
          case 194: break;
          case 20: 
            { yypushback(1);
	yybegin(ST_PHP_NOWDOC);
            }
          case 195: break;
          case 21: 
            { yypushback(1);
    popState();
            }
          case 196: break;
          case 22: 
            { popState();
    return PHP_LABEL;
            }
          case 197: break;
          case 23: 
            { /* Offset could be treated as a long */
	return PHP_NUMBER;
            }
          case 198: break;
          case 24: 
            { //the difference from the original rules comes from the fact that we took ';' out of tokens
	return UNKNOWN_TOKEN;
            }
          case 199: break;
          case 25: 
            { yypushback(1);
	popState();
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 200: break;
          case 26: 
            { popState();
	return PHP_TOKEN;
            }
          case 201: break;
          case 27: 
            { return PHP_COMMENT;
            }
          case 202: break;
          case 28: 
            { return PHPDOC_COMMENT;
            }
          case 203: break;
          case 29: 
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			if (yylength() > 0) {
				return PHP_LINE_COMMENT;
			}
			break;
		default:
			popState();
			return PHP_LINE_COMMENT;
	}
            }
          case 204: break;
          case 30: 
            { return PHP_LINE_COMMENT;
            }
          case 205: break;
          case 31: 
            { return UNKNOWN_TOKEN;
            }
          case 206: break;
          case 32: 
            { popState();return WHITESPACE;
            }
          case 207: break;
          case 33: 
            { return PHP_OPERATOR;
            }
          case 208: break;
          case 34: 
            { pushState(ST_PHP_LOOKING_FOR_PROPERTY);
    return PHP_OBJECT_OPERATOR;
            }
          case 209: break;
          case 35: 
            { return PHP_VARIABLE;
            }
          case 210: break;
          case 36: 
            { pushState(ST_PHP_COMMENT);
    return PHP_COMMENT_START;
            }
          case 211: break;
          case 37: 
            { if (asp_tags) {
	    return PHP_CLOSETAG;
	}
	return UNKNOWN_TOKEN;
            }
          case 212: break;
          case 38: 
            { return PHP_AS;
            }
          case 213: break;
          case 39: 
            { return PHP_DO;
            }
          case 214: break;
          case 40: 
            { return PHP_CLOSETAG;
            }
          case 215: break;
          case 41: 
            { return PHP_IF;
            }
          case 216: break;
          case 42: 
            { return PHP_PAAMAYIM_NEKUDOTAYIM;
            }
          case 217: break;
          case 43: 
            { pushState(ST_PHP_QUOTES_AFTER_VARIABLE);
    return PHP_VARIABLE;
            }
          case 218: break;
          case 44: 
            { yypushback(1);
    return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 219: break;
          case 45: 
            { pushState(ST_PHP_IN_SCRIPTING);
    return PHP_TOKEN;
            }
          case 220: break;
          case 46: 
            { yypushback(1);
    pushState(ST_PHP_IN_SCRIPTING);
    return PHP_CURLY_OPEN;
            }
          case 221: break;
          case 47: 
            { yypushback(1);
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 222: break;
          case 48: 
            { popState();
    pushState(ST_PHP_LOOKING_FOR_PROPERTY);
    return PHP_OBJECT_OPERATOR;
            }
          case 223: break;
          case 49: 
            { int label_len = yylength() - 1;

    if (yytext().charAt(label_len-1)==';') {
	    label_len--;
    }

    if (label_len==heredoc_len && yytext().substring(0,label_len).equals(heredoc)) {
        heredoc=null;
        heredoc_len=0;
        yybegin(ST_PHP_IN_SCRIPTING);
        return PHP_HEREDOC_TAG;
    } else {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 224: break;
          case 50: 
            { int label_len = yylength() - 1;

    if (yytext().charAt(label_len-1)==';') {
	    label_len--;
    }

    if (label_len==nowdoc_len && yytext().substring(0,label_len).equals(nowdoc)) {
        nowdoc=null;
        nowdoc_len=0;
        yybegin(ST_PHP_IN_SCRIPTING);
        return PHP_HEREDOC_TAG;
    } else {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 225: break;
          case 51: 
            { int label_len = yylength() - 1;
	int startIndex = 0;
	String yytext = yytext();
	if (yytext.charAt(label_len - 1) == ';') {
		label_len--;
	}
	while (yytext.charAt(startIndex) == '\r'
			|| yytext.charAt(startIndex) == '\n') {
		startIndex++;
	}

	if (label_len > heredoc_len
			&& yytext.substring(startIndex, label_len).equals(
					heredoc)) {
		heredoc = null;
		heredoc_len = 0;
		yybegin(ST_PHP_IN_SCRIPTING);
		return PHP_HEREDOC_TAG;
	} else {
		yybegin(ST_PHP_HEREDOC);
		return PHP_CONSTANT_ENCAPSED_STRING;
	}
            }
          case 226: break;
          case 52: 
            { return PHP_OBJECT_OPERATOR;
            }
          case 227: break;
          case 53: 
            { popState();
    return PHP_COMMENT_END;
            }
          case 228: break;
          case 54: 
            { popState();
    return PHPDOC_COMMENT_END;
            }
          case 229: break;
          case 55: 
            { popState();
    return PHP_LINE_COMMENT;
            }
          case 230: break;
          case 56: 
            { if (asp_tags) {
	    return PHP_CLOSETAG;
	}
	String text = yytext();
	if(text.indexOf('\r') != -1 || text.indexOf('\n') != -1 ){
		popState();
	}
	return PHP_LINE_COMMENT;
            }
          case 231: break;
          case 57: 
            { pushState(ST_PHP_DOC_COMMENT);
    return PHPDOC_COMMENT_START;
            }
          case 232: break;
          case 58: 
            { return PHP_NEW;
            }
          case 233: break;
          case 59: 
            { return PHP_DIE;
            }
          case 234: break;
          case 60: 
            { return PHP_TRY;
            }
          case 235: break;
          case 61: 
            { return PHP_FOR;
            }
          case 236: break;
          case 62: 
            { return PHP_USE;
            }
          case 237: break;
          case 63: 
            { return PHP_VAR;
            }
          case 238: break;
          case 64: 
            { yypushback(1);
	pushState(ST_PHP_VAR_OFFSET);
	return PHP_VARIABLE;
            }
          case 239: break;
          case 65: 
            { int label_len = yylength() - 1;

    if (yytext().charAt(label_len-1)==';') {
	   label_len--;
    }
    if (label_len > heredoc_len && yytext().substring(label_len - heredoc_len,label_len).equals(heredoc)) {

    	if ((label_len - heredoc_len-2) >= 0 && yytext().charAt(label_len - heredoc_len-2)=='\r') {
        	label_len = label_len-2;
    	} else {
        	label_len--;
    	}
    	yypushback(heredoc_len + (yylength() - label_len));

        yybegin(ST_PHP_END_HEREDOC);
    }
    // In some cases, all text is pushed back (using yypushback()),
    // especially when the parsed document has Windows newlines.
    // In those cases, ignore this rule and try next one...
    if (yylength() > 0) {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 240: break;
          case 66: 
            { int label_len = yylength() - 1;

	if (yytext().charAt(label_len-1)==';') {
	   label_len--;
    }
    if (label_len > nowdoc_len && yytext().substring(label_len - nowdoc_len,label_len).equals(nowdoc)) {
    	//nowdoc = null;
    	//nowdoc_len = 0;
		//yypushback(1);
		//yybegin(ST_PHP_END_NOWDOC);

    	if ((label_len - nowdoc_len-2) >= 0 && yytext().charAt(label_len - nowdoc_len-2)=='\r') {
        	label_len = label_len-2;
    	} else {
        	label_len--;
    	}
    	yypushback(nowdoc_len + (yylength() - label_len));

        yybegin(ST_PHP_END_NOWDOC);
	}
    // In some cases, all text is pushed back (using yypushback()),
    // especially when the parsed document has Windows newlines.
    // In those cases, ignore this rule and try next one...
    if (yylength() > 0) {
        return PHP_CONSTANT_ENCAPSED_STRING;
    }
            }
          case 241: break;
          case 67: 
            { yybegin(ST_PHP_HEREDOC);
	return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 242: break;
          case 68: 
            { nowdoc = null;
	nowdoc_len = 0;
    yybegin(ST_PHP_IN_SCRIPTING);
    return PHP_HEREDOC_TAG;
            }
          case 243: break;
          case 69: 
            { return PHP_EXIT;
            }
          case 244: break;
          case 70: 
            { return PHP_ECHO;
            }
          case 245: break;
          case 71: 
            { return PHP_ELSE;
            }
          case 246: break;
          case 72: 
            { return PHP_EVAL;
            }
          case 247: break;
          case 73: 
            { return PHP_CASE;
            }
          case 248: break;
          case 74: 
            { yypushback(2);
    pushState(ST_PHP_COMMENT);
    return PHP_COMMENT_START;
            }
          case 249: break;
          case 75: 
            { return  PHP_KEYWORD;
            }
          case 250: break;
          case 76: 
            { return PHP_TRUE;
            }
          case 251: break;
          case 77: 
            { return PHP_FROM;
            }
          case 252: break;
          case 78: 
            { return PHP_SELF;
            }
          case 253: break;
          case 79: 
            { return PHP_LIST;
            }
          case 254: break;
          case 80: 
            { return PHP_GOTO;
            }
          case 255: break;
          case 81: 
            { return PHPDOC_SEE;
            }
          case 256: break;
          case 82: 
            { return PHPDOC_VAR;
            }
          case 257: break;
          case 83: 
            { return PHP_ENDIF;
            }
          case 258: break;
          case 84: 
            { return PHP_EMPTY;
            }
          case 259: break;
          case 85: 
            { return PHP_CONST;
            }
          case 260: break;
          case 86: 
            { return PHP_CATCH;
            }
          case 261: break;
          case 87: 
            { return PHP_CLONE;
            }
          case 262: break;
          case 88: 
            { return PHP_CLASS;
            }
          case 263: break;
          case 89: 
            { return PHP_BREAK;
            }
          case 264: break;
          case 90: 
            { return PHP_THIS;
            }
          case 265: break;
          case 91: 
            { int bprefix = (yytext().charAt(0) != '<') ? 1 : 0;
    int startString=3+bprefix;

    int hereOrNowDoc_len = yylength()-bprefix-3-1-(yytext().charAt(yylength()-2)=='\r'?1:0);
    while ((yytext().charAt(startString) == ' ') || (yytext().charAt(startString) == '\t')) {
        startString++;
        hereOrNowDoc_len--;
    }
    String hereOrNowDoc = yytext().substring(startString,hereOrNowDoc_len+startString);
    if (hereOrNowDoc.charAt(0) == '\'') {
    	nowdoc = hereOrNowDoc.substring(1, hereOrNowDoc_len-1);
    	nowdoc_len = hereOrNowDoc_len - 2;
    	yybegin(ST_PHP_START_NOWDOC);
    }
    else if (hereOrNowDoc.charAt(0) == '"') {
    	heredoc = hereOrNowDoc.substring(1, hereOrNowDoc_len-1);
    	heredoc_len = hereOrNowDoc_len - 2;
    	yybegin(ST_PHP_START_HEREDOC);
    } else {
    	heredoc = hereOrNowDoc;
    	heredoc_len = hereOrNowDoc_len;
    	yybegin(ST_PHP_START_HEREDOC);
    }
    return PHP_HEREDOC_TAG;
            }
          case 266: break;
          case 92: 
            { return PHP_ARRAY;
            }
          case 267: break;
          case 93: 
            { return PHP_ISSET;
            }
          case 268: break;
          case 94: 
            { return PHP_TRAIT;
            }
          case 269: break;
          case 95: 
            { return PHP_THROW;
            }
          case 270: break;
          case 96: 
            { return PHP_FALSE;
            }
          case 271: break;
          case 97: 
            { return PHP_FINAL;
            }
          case 272: break;
          case 98: 
            { return PHP_UNSET;
            }
          case 273: break;
          case 99: 
            { return PHP_YIELD;
            }
          case 274: break;
          case 100: 
            { return PHP_WHILE;
            }
          case 275: break;
          case 101: 
            { return PHP_PRINT;
            }
          case 276: break;
          case 102: 
            { return PHP_CASTING;
            }
          case 277: break;
          case 103: 
            { return PHPDOC_NAME;
            }
          case 278: break;
          case 104: 
            { return PHPDOC_DESC;
            }
          case 279: break;
          case 105: 
            { return PHPDOC_TODO;
            }
          case 280: break;
          case 106: 
            { return PHPDOC_USES;
            }
          case 281: break;
          case 107: 
            { return PHPDOC_LINK;
            }
          case 282: break;
          case 108: 
            { return PHP_ENDFOR;
            }
          case 283: break;
          case 109: 
            { return PHP_ELSEIF;
            }
          case 284: break;
          case 110: 
            { return PHP_RETURN;
            }
          case 285: break;
          case 111: 
            { return PHP_STATIC;
            }
          case 286: break;
          case 112: 
            { return PHP_SWITCH;
            }
          case 287: break;
          case 113: 
            { return PHP_GLOBAL;
            }
          case 288: break;
          case 114: 
            { return PHP_PARENT;
            }
          case 289: break;
          case 115: 
            { return PHP_PUBLIC;
            }
          case 290: break;
          case 116: 
            { return PHPDOC_FINAL;
            }
          case 291: break;
          case 117: 
            { return PHPDOC_SINCE;
            }
          case 292: break;
          case 118: 
            { return PHPDOC_MAGIC;
            }
          case 293: break;
          case 119: 
            { return PHPDOC_PARAM;
            }
          case 294: break;
          case 120: 
            { return PHP_EXTENDS;
            }
          case 295: break;
          case 121: 
            { return PHP_REQUIRE;
            }
          case 296: break;
          case 122: 
            { return PHP_DECLARE;
            }
          case 297: break;
          case 123: 
            { return PHP_DEFAULT;
            }
          case 298: break;
          case 124: 
            { return PHP_INCLUDE;
            }
          case 299: break;
          case 125: 
            { return PHP_FOREACH;
            }
          case 300: break;
          case 126: 
            { return PHP_FINALLY;
            }
          case 301: break;
          case 127: 
            { return PHP_PRIVATE;
            }
          case 302: break;
          case 128: 
            { return PHP__DIR__;
            }
          case 303: break;
          case 129: 
            { return PHPDOC_RETURN;
            }
          case 304: break;
          case 130: 
            { return PHPDOC_ACCESS;
            }
          case 305: break;
          case 131: 
            { return PHPDOC_AUTHOR;
            }
          case 306: break;
          case 132: 
            { return PHPDOC_IGNORE;
            }
          case 307: break;
          case 133: 
            { return PHPDOC_THROWS;
            }
          case 308: break;
          case 134: 
            { return PHPDOC_STATIC;
            }
          case 309: break;
          case 135: 
            { return PHPDOC_METHOD;
            }
          case 310: break;
          case 136: 
            { return PHPDOC_GLOBAL;
            }
          case 311: break;
          case 137: 
            { return PHP_ENDWHILE;
            }
          case 312: break;
          case 138: 
            { return PHP_CONTINUE;
            }
          case 313: break;
          case 139: 
            { return PHP_CALLABLE;
            }
          case 314: break;
          case 140: 
            { return PHP_ABSTRACT;
            }
          case 315: break;
          case 141: 
            { return PHP_FUNCTION;
            }
          case 316: break;
          case 142: 
            { return PHP__FILE__;
            }
          case 317: break;
          case 143: 
            { return PHP__LINE__;
            }
          case 318: break;
          case 144: 
            { return PHPDOC_EXAMPLE;
            }
          case 319: break;
          case 145: 
            { return PHPDOC_LICENSE;
            }
          case 320: break;
          case 146: 
            { return PHPDOC_PACKAGE;
            }
          case 321: break;
          case 147: 
            { return PHPDOC_VERSION;
            }
          case 322: break;
          case 148: 
            { return PHP_ENDSWITCH;
            }
          case 323: break;
          case 149: 
            { return PHP_NAMESPACE;
            }
          case 324: break;
          case 150: 
            { return PHP_INTERFACE;
            }
          case 325: break;
          case 151: 
            { return PHP_INSTEADOF;
            }
          case 326: break;
          case 152: 
            { return PHP_PROTECTED;
            }
          case 327: break;
          case 153: 
            { return PHP__CLASS__;
            }
          case 328: break;
          case 154: 
            { return PHPDOC_CATEGORY;
            }
          case 329: break;
          case 155: 
            { return PHPDOC_ABSTRACT;
            }
          case 330: break;
          case 156: 
            { return PHPDOC_INTERNAL;
            }
          case 331: break;
          case 157: 
            { return PHPDOC_TUTORIAL;
            }
          case 332: break;
          case 158: 
            { return PHPDOC_PROPERTY;
            }
          case 333: break;
          case 159: 
            { return PHP_ENDDECLARE;
            }
          case 334: break;
          case 160: 
            { return PHP_ENDFOREACH;
            }
          case 335: break;
          case 161: 
            { return PHP_INSTANCEOF;
            }
          case 336: break;
          case 162: 
            { return PHP_IMPLEMENTS;
            }
          case 337: break;
          case 163: 
            { return PHP__METHOD__;
            }
          case 338: break;
          case 164: 
            { return PHPDOC_EXCEPTION;
            }
          case 339: break;
          case 165: 
            { return PHPDOC_COPYRIGHT;
            }
          case 340: break;
          case 166: 
            { return PHPDOC_NAMESPACE;
            }
          case 341: break;
          case 167: 
            { return PHPDOC_STATICVAR;
            }
          case 342: break;
          case 168: 
            { return PHPDOC_DEPRECATED;
            }
          case 343: break;
          case 169: 
            { return PHPDOC_FILESOURCE;
            }
          case 344: break;
          case 170: 
            { return PHPDOC_SUBPACKAGE;
            }
          case 345: break;
          case 171: 
            { return PHP_REQUIRE_ONCE;
            }
          case 346: break;
          case 172: 
            { return PHP_INCLUDE_ONCE;
            }
          case 347: break;
          case 173: 
            { return PHP__FUNCTION__;
            }
          case 348: break;
          case 174: 
            { return PHP__NAMESPACE__;
            }
          case 349: break;
          case 175: 
            { return PHP_HALT_COMPILER;
            }
          case 350: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
