/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.php.internal.ui.dialogs.saveFiles.SaveFilesHandler;
import org.eclipse.swt.widgets.Shell;

public class RefactoringStarter {
    private RefactoringStatus fStatus;

    public boolean activate(Refactoring refactoring, RefactoringWizard wizard, Shell parent, String dialogTitle, boolean mustSaveEditors) {
        if (!this.canActivate(mustSaveEditors, parent)) {
            return false;
        }
        try {
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(wizard);
            int result = op.run(parent, dialogTitle);
            this.fStatus = op.getInitialConditionCheckingStatus();
            if (result != 1 && result != 1025 && result == 0) {
                return true;
            }
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    public RefactoringStatus getInitialConditionCheckingStatus() {
        return this.fStatus;
    }

    private boolean canActivate(boolean mustSaveEditors, Shell shell) {
        return !mustSaveEditors || this.checkUnsavedFiles();
    }

    private boolean checkUnsavedFiles() {
        boolean autoSave = false;
        SaveFilesHandler.SaveFilesResult result = SaveFilesHandler.handle(null, (boolean)autoSave, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
        return result.isAccepted();
    }
}

