/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.PHPManualConfig;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewPHPManualSiteDialog
extends StatusDialog {
    private static final String[] FILE_EXT = new String[]{"php", "htm", "html"};
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private static final String FILE_PROTO = "file://";
    private static final String CHM_PROTO = "mk:@MSITStore:";
    private static final Pattern LANG_DETECT_PATTERN = Pattern.compile("/([a-z_]*)/function\\.");
    protected Text name;
    protected Text url;
    private Button okButton;
    private boolean enableOK = false;
    private List configs;
    private PHPManualConfig edited;
    private PHPManualConfig result;
    private Button remoteSiteBtn;
    private Button localDirectoryBtn;
    private Button chmFileBtn;
    private Text localDir;
    private Text chmFile;
    private Button dirBrowseButton;
    private Button chmBrowseButton;
    private Label fileExtLabel;
    private Combo fileExtCombo;

    public NewPHPManualSiteDialog(Shell parentShell, PHPManualConfig edited, List configs) {
        super(parentShell);
        this.configs = new ArrayList(configs.size());
        int i = 0;
        while (i < configs.size()) {
            PHPManualConfig config = (PHPManualConfig)configs.get(i);
            if (!config.equals(edited)) {
                this.configs.add(config);
            }
            ++i;
        }
        this.edited = edited;
        if (edited != null) {
            this.setTitle(PHPUIMessages.NewPHPManualSiteDialog_updateTitle);
        } else {
            this.setTitle(PHPUIMessages.NewPHPManualSiteDialog_newTitle);
        }
    }

    public PHPManualConfig getResult() {
        return this.result;
    }

    protected void setResult(PHPManualConfig result) {
        this.result = result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(this.enableOK);
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 15;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 400;
        composite.setLayoutData((Object)data);
        Composite siteNameGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        siteNameGroup.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        siteNameGroup.setLayoutData((Object)data);
        Label label = new Label(siteNameGroup, 0);
        label.setText(PHPUIMessages.NewPHPManualSiteDialog_name);
        this.name = new Text(siteNameGroup, 2048);
        data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPHPManualSiteDialog.this.verifyComplete();
            }
        });
        this.remoteSiteBtn = new Button(composite, 16);
        this.remoteSiteBtn.setText(PHPUIMessages.NewPHPManualSiteDialog_remoteSiteURL);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.remoteSiteBtn.setLayoutData((Object)data);
        this.remoteSiteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = NewPHPManualSiteDialog.this.remoteSiteBtn.getSelection();
                NewPHPManualSiteDialog.this.url.setEnabled(enabled);
                if (enabled) {
                    NewPHPManualSiteDialog.this.fileExtCombo.select(0);
                }
            }
        });
        this.url = new Text(composite, 2048);
        data = new GridData(768);
        data.horizontalIndent = this.convertWidthInCharsToPixels(3);
        data.horizontalSpan = 2;
        this.url.setLayoutData((Object)data);
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPHPManualSiteDialog.this.verifyComplete();
            }
        });
        this.localDirectoryBtn = new Button(composite, 16);
        this.localDirectoryBtn.setText(PHPUIMessages.NewPHPManualSiteDialog_localDirectory);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.localDirectoryBtn.setLayoutData((Object)data);
        this.localDirectoryBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = NewPHPManualSiteDialog.this.localDirectoryBtn.getSelection();
                NewPHPManualSiteDialog.this.localDir.setEnabled(enabled);
                NewPHPManualSiteDialog.this.dirBrowseButton.setEnabled(enabled);
                if (enabled) {
                    NewPHPManualSiteDialog.this.fileExtCombo.select(2);
                }
            }
        });
        this.localDir = new Text(composite, 2048);
        data = new GridData(768);
        data.horizontalIndent = this.convertWidthInCharsToPixels(3);
        this.localDir.setLayoutData((Object)data);
        this.localDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPHPManualSiteDialog.this.verifyComplete();
            }
        });
        this.dirBrowseButton = new Button(composite, 0);
        data = new GridData();
        data.widthHint = 50;
        data.horizontalAlignment = 0x1000008;
        this.dirBrowseButton.setLayoutData((Object)data);
        this.dirBrowseButton.setText("...");
        this.dirBrowseButton.setAlignment(0x1000000);
        this.dirBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog dialog = new DirectoryDialog(PHPUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
                dialog.setText(PHPUIMessages.NewPHPManualSiteDialog_chooseDir);
                String directoryAsString = dialog.open();
                if (directoryAsString == null) {
                    return;
                }
                NewPHPManualSiteDialog.this.localDir.setText(directoryAsString);
            }
        });
        if (isWindows) {
            this.chmFileBtn = new Button(composite, 16);
            this.chmFileBtn.setText(PHPUIMessages.NewPHPManualSiteDialog_windowsCHMFile);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.chmFileBtn.setLayoutData((Object)data);
            this.chmFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = NewPHPManualSiteDialog.this.chmFileBtn.getSelection();
                    NewPHPManualSiteDialog.this.chmFile.setEnabled(enabled);
                    NewPHPManualSiteDialog.this.chmBrowseButton.setEnabled(enabled);
                    if (enabled) {
                        NewPHPManualSiteDialog.this.fileExtCombo.select(2);
                    }
                }
            });
            this.chmFile = new Text(composite, 2048);
            data = new GridData(768);
            data.horizontalIndent = this.convertWidthInCharsToPixels(3);
            this.chmFile.setLayoutData((Object)data);
            this.chmFile.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewPHPManualSiteDialog.this.verifyComplete();
                }
            });
            this.chmBrowseButton = new Button(composite, 0);
            data = new GridData();
            data.widthHint = 50;
            data.horizontalAlignment = 0x1000008;
            this.chmBrowseButton.setLayoutData((Object)data);
            this.chmBrowseButton.setText("...");
            this.chmBrowseButton.setAlignment(0x1000000);
            this.chmBrowseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog dialog = new FileDialog(PHPUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
                    dialog.setText(PHPUIMessages.NewPHPManualSiteDialog_chooseCHMFile);
                    dialog.setFilterExtensions(new String[]{"*.chm"});
                    String fileAsString = dialog.open();
                    if (fileAsString == null) {
                        return;
                    }
                    NewPHPManualSiteDialog.this.chmFile.setText(fileAsString);
                }
            });
        }
        Composite fileExtGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        fileExtGroup.setLayout((Layout)layout);
        data = new GridData();
        data.horizontalSpan = 2;
        fileExtGroup.setLayoutData((Object)data);
        this.fileExtLabel = new Label(fileExtGroup, 0);
        data = new GridData(768);
        this.fileExtLabel.setLayoutData((Object)data);
        this.fileExtLabel.setText(PHPUIMessages.NewPHPManualSiteDialog_fileExtension);
        this.fileExtCombo = new Combo(fileExtGroup, 8);
        this.fileExtCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPHPManualSiteDialog.this.verifyComplete();
            }
        });
        this.fileExtCombo.setItems(FILE_EXT);
        this.fileExtCombo.select(0);
        this.initializeFields();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void initializeFields() {
        if (this.edited != null) {
            this.name.setText(this.edited.getLabel());
            this.fileExtCombo.setText(this.edited.getExtension());
            String urlStr = this.edited.getUrl();
            if (isWindows && urlStr.startsWith(CHM_PROTO)) {
                int sepIdx = (urlStr = urlStr.substring(CHM_PROTO.length())).indexOf("::");
                if (sepIdx != -1) {
                    urlStr = urlStr.substring(0, sepIdx);
                }
                this.chmFile.setText(urlStr);
                this.chmFileBtn.setSelection(true);
            } else if (urlStr.startsWith(FILE_PROTO)) {
                urlStr = urlStr.substring(FILE_PROTO.length());
                this.localDir.setText(urlStr);
                this.localDirectoryBtn.setSelection(true);
            } else {
                this.url.setText(urlStr);
            }
        } else {
            this.url.setText("http://www.php.net/manual/en");
            this.remoteSiteBtn.setSelection(true);
        }
        this.remoteSiteBtn.notifyListeners(13, new Event());
        this.localDirectoryBtn.notifyListeners(13, new Event());
        if (isWindows) {
            this.chmFileBtn.notifyListeners(13, new Event());
        }
    }

    private void verifyComplete() {
        if (this.okButton == null) {
            return;
        }
        if (this.name.getText().trim().length() == 0) {
            this.okButton.setEnabled(false);
            this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.NewPHPManualSiteDialog_siteNotSpecified, null));
            return;
        }
        if (this.isDuplicate()) {
            return;
        }
        this.okButton.setEnabled(true);
        this.updateStatus((IStatus)new Status(0, PHPUiPlugin.getPluginId(), 0, "", null));
        if (this.remoteSiteBtn.getSelection()) {
            try {
                String urlStr = this.url.getText().trim();
                new URL(URLDecoder.decode(urlStr, "UTF-8"));
                this.result = new PHPManualConfig(this.name.getText(), urlStr, this.fileExtCombo.getText(), false);
            }
            catch (Exception exception) {
                this.okButton.setEnabled(false);
                this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.NewPHPManualSiteDialog_incorrectUrl, null));
                return;
            }
        } else if (this.localDirectoryBtn.getSelection()) {
            String localDirStr = this.localDir.getText().trim();
            if (!new File(localDirStr).isDirectory()) {
                this.okButton.setEnabled(false);
                this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.NewPHPManualSiteDialog_dirDoesntExist, null));
                return;
            }
            this.result = new PHPManualConfig(this.name.getText(), FILE_PROTO + localDirStr, this.fileExtCombo.getText(), false);
        } else if (isWindows) {
            String chmFileStr = this.chmFile.getText().trim();
            if (!new File(chmFileStr).isFile()) {
                this.okButton.setEnabled(false);
                this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.NewPHPManualSiteDialog_fileDoesntExist, null));
                return;
            }
            this.result = new PHPManualConfig(this.name.getText(), CHM_PROTO + chmFileStr + this.detectCHMLanguageSuffix(chmFileStr), this.fileExtCombo.getText(), false);
        }
    }

    private boolean isDuplicate() {
        if (this.configs == null) {
            return false;
        }
        int i = 0;
        while (i < this.configs.size()) {
            PHPManualConfig config;
            if (!this.isCurrentlyEditedSiteBookmark(i) && (config = (PHPManualConfig)this.configs.get(i)).getLabel().equals(this.name.getText().trim())) {
                this.okButton.setEnabled(false);
                this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.NewPHPManualSiteDialog_nameAlreadyInUse, null));
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isCurrentlyEditedSiteBookmark(int index) {
        return false;
    }

    protected void updateButtonsEnableState(IStatus status) {
        if (this.okButton != null && !this.okButton.isDisposed() && this.name.getText().trim().length() != 0) {
            this.okButton.setEnabled(!status.matches(4));
        }
    }

    private String detectCHMLanguageSuffix(String chmFile) {
        StringBuffer suffix = new StringBuffer("::/");
        char[] buf = new char[8192];
        try (FileReader r = new FileReader(chmFile);){
            while (r.ready()) {
                r.read(buf);
                Matcher m = LANG_DETECT_PATTERN.matcher(new String(buf));
                if (!m.find()) continue;
                suffix.append(m.group(1));
                break;
            }
        }
        catch (Exception exception) {}
        return suffix.toString();
    }
}

