/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SWTUtil {
    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getShell(Widget widget) {
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        if (widget instanceof Caret) {
            return ((Caret)widget).getParent().getShell();
        }
        if (widget instanceof DragSource) {
            return ((DragSource)widget).getControl().getShell();
        }
        if (widget instanceof DropTarget) {
            return ((DropTarget)widget).getControl().getShell();
        }
        if (widget instanceof Menu) {
            return ((Menu)widget).getParent().getShell();
        }
        if (widget instanceof ScrollBar) {
            return ((ScrollBar)widget).getParent().getShell();
        }
        return null;
    }

    public static int getTableHeightHint(Table table, int rows) {
        if (table.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            table.setFont(JFaceResources.getDialogFont());
        }
        int result = table.getItemHeight() * rows + table.getHeaderHeight();
        if (table.getLinesVisible()) {
            result += table.getGridLineWidth() * (rows - 1);
        }
        return result;
    }

    public static CTabFolder createTabFolder(Composite parent) {
        Display display = SWTUtil.getStandardDisplay();
        Color c1 = display.getSystemColor(31);
        Color c2 = display.getSystemColor(32);
        CTabFolder tabs = new CTabFolder(parent, 0x900008);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        tabs.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
        tabs.setSelectionForeground(SWTUtil.getStandardDisplay().getSystemColor(30));
        tabs.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        tabs.setLayoutData((Object)gd);
        tabs.setBorderVisible(true);
        tabs.setFont(parent.getFont());
        return tabs;
    }

    public static void showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(DebugUIPlugin.getShell(), manager);
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            {
                this.val$targetNode = iPreferenceNode;
            }

            @Override
            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                dialog.open();
            }
        });
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = SWTUtil.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    public static Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    public static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    public static Label createLabel(Composite parent, String text, int hspan) {
        Label l = new Label(parent, 0);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Text createSingleText(Composite parent, int hspan) {
        Text t = new Text(parent, 2052);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        t.setLayoutData((Object)gd);
        return t;
    }

    public static Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public static void setAccessibilityText(Control control, final String text) {
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = text;
            }
        });
    }
}

