/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.hierarchy.FakeType;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.actions.Messages;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class AddPHPExceptionBreakpointDialog
extends SelectionDialog {
    public static final IType[] ERROR_TYPES = new IType[]{new ErrorType("Notice", Messages.AddPHPExceptionBreakpointDialog_Suspend_on_notice), new ErrorType("Warning", Messages.AddPHPExceptionBreakpointDialog_Suspend_on_error), new ErrorType("Deprecated", Messages.AddPHPExceptionBreakpointDialog_Suspend_on_deprecated)};
    private static final String EXCEPTION_BASE_CLASS_NAME = "Exception";
    private static final String DIALOG_SETTINGS = "org.eclipse.php.debug.ui.dialogs.AddPHPExceptionDialog";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private Set<IType> fExceptionTypesCache;
    private Text fExceptionFilter;
    private TableViewer fExceptionViewer;
    private IDialogSettings fSettings;
    private Point fLocation;
    private Point fSize;

    public AddPHPExceptionBreakpointDialog() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.initializeSettings();
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                AddPHPExceptionBreakpointDialog.this.fetchExceptionTypes();
            }
        });
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this.fSize != null) {
            result.x = Math.max(result.x, this.fSize.x);
            result.y = Math.max(result.y, this.fSize.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this.fLocation != null) {
            int ye;
            result.x = this.fLocation.x;
            result.y = this.fLocation.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.readSettings();
        Composite area = (Composite)super.createDialogArea(parent);
        Label filterLabel = new Label(area, 0);
        filterLabel.setText(Messages.AddPHPExceptionBreakpointDialog_Choose_an_exception_filter_message);
        this.fExceptionFilter = new Text(area, 2048);
        GridData gridData = new GridData(768);
        this.fExceptionFilter.setLayoutData((Object)gridData);
        this.fExceptionFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPHPExceptionBreakpointDialog.this.filterExceptionTypes(AddPHPExceptionBreakpointDialog.this.fExceptionFilter.getText());
            }
        });
        this.fExceptionFilter.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    AddPHPExceptionBreakpointDialog.this.fExceptionViewer.getTable().setFocus();
                }
            }
        });
        Label itemsLabel = new Label(area, 0);
        itemsLabel.setText(Messages.AddPHPExceptionBreakpointDialog_Matching_items);
        this.fExceptionViewer = new TableViewer(area, 2050);
        gridData = new GridData(4, 4, true, true);
        PixelConverter converter = new PixelConverter((Control)this.fExceptionViewer.getTable());
        gridData.widthHint = converter.convertWidthInCharsToPixels(60);
        gridData.heightHint = SWTUtil.getTableHeightHint((Table)this.fExceptionViewer.getTable(), (int)10);
        this.fExceptionViewer.getTable().setLayoutData((Object)gridData);
        this.fExceptionViewer.getTable().setFont(parent.getFont());
        this.fExceptionViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AddPHPExceptionBreakpointDialog.this.okPressed();
            }
        });
        this.fExceptionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fExceptionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        Set<IType> input = this.fExceptionTypesCache;
        this.fExceptionViewer.setInput(this.fExceptionTypesCache);
        if (!input.isEmpty()) {
            this.fExceptionViewer.setSelection((ISelection)new StructuredSelection(input.iterator().next()));
        }
        CLabel noteIcon = new CLabel(area, 0);
        noteIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        noteIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
        noteIcon.setText(Messages.AddPHPExceptionBreakpointDialog_Note);
        return area;
    }

    protected void okPressed() {
        this.computeResult();
        super.okPressed();
    }

    private void computeResult() {
        ArrayList<Object> results = new ArrayList<Object>();
        IStructuredSelection selection = this.fExceptionViewer.getStructuredSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            results.add(element);
            ++n2;
        }
        this.setResult(results);
    }

    private void initializeSettings() {
        IDialogSettings settings = PHPDebugUIPlugin.getDefault().getDialogSettings();
        this.fSettings = settings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            settings.addSection(this.fSettings);
            this.fSettings.put(WIDTH, 480);
            this.fSettings.put(HEIGHT, 320);
        }
    }

    private void readSettings() {
        try {
            int x = this.fSettings.getInt("x");
            int y = this.fSettings.getInt("y");
            this.fLocation = new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
        }
        try {
            int width = this.fSettings.getInt(WIDTH);
            int height = this.fSettings.getInt(HEIGHT);
            this.fSize = new Point(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            this.fSize = null;
        }
    }

    private void writeSettings() {
        Point location = this.getShell().getLocation();
        this.fSettings.put("x", location.x);
        this.fSettings.put("y", location.y);
        Point size = this.getShell().getSize();
        this.fSettings.put(WIDTH, size.x);
        this.fSettings.put(HEIGHT, size.y);
    }

    private void filterExceptionTypes(String text) {
        String patternBase = text.replaceAll("\\*", ".*").replaceAll("\\?", ".").concat(".*");
        Pattern pattern = Pattern.compile(patternBase, 2);
        LinkedList<IType> filtered = new LinkedList<IType>();
        for (IType type : this.fExceptionTypesCache) {
            if (!pattern.matcher(type.getElementName()).matches()) continue;
            filtered.add(type);
        }
        this.fExceptionViewer.setInput(filtered);
        if (!filtered.isEmpty()) {
            this.fExceptionViewer.setSelection((ISelection)new StructuredSelection(filtered.iterator().next()));
        }
    }

    private void fetchExceptionTypes() {
        if (this.fExceptionTypesCache == null) {
            IType[] exceptionBaseTypes;
            this.fExceptionTypesCache = new TreeSet<IType>(new Comparator<IType>(){

                @Override
                public int compare(IType o1, IType o2) {
                    if (o1 instanceof ErrorType && !(o2 instanceof ErrorType)) {
                        return -1;
                    }
                    return o1.getElementName().toLowerCase().compareTo(o2.getElementName().toLowerCase());
                }
            });
            PhpModelAccess modelAccess = PhpModelAccess.getDefault();
            IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
            scope.enclosingProjectsAndZips();
            IType[] iTypeArray = exceptionBaseTypes = modelAccess.findTypes(EXCEPTION_BASE_CLASS_NAME, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            int n = exceptionBaseTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType exceptionBaseType = iTypeArray[n2];
                try {
                    IType[] subtypes;
                    this.fExceptionTypesCache.add(exceptionBaseType);
                    ITypeHierarchy hierarchy = exceptionBaseType.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    IType[] iTypeArray2 = subtypes = hierarchy.getAllSubtypes(exceptionBaseType);
                    int n3 = subtypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType subType = iTypeArray2[n4];
                        this.fExceptionTypesCache.add(subType);
                        ++n4;
                    }
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
                ++n2;
            }
            iTypeArray = ERROR_TYPES;
            n = ERROR_TYPES.length;
            n2 = 0;
            while (n2 < n) {
                IType mockType = iTypeArray[n2];
                this.fExceptionTypesCache.add(mockType);
                ++n2;
            }
        }
    }

    static class ErrorType
    extends FakeType {
        private String description;

        public ErrorType(String name, String description) {
            super(null, name);
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private class LabelProvider
    extends StyledCellLabelProvider {
        private LabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            cell.setImage(this.getImage(element));
            String text = this.getText(element);
            cell.setText(text);
            int separatorIndex = text.indexOf(45);
            StyleRange greyRange = new StyleRange(separatorIndex, text.length() - separatorIndex, Display.getDefault().getSystemColor(16), null);
            cell.setStyleRanges(new StyleRange[]{greyRange});
            super.update(cell);
        }

        private String getText(Object element) {
            IType exception = (IType)element;
            if (exception instanceof ErrorType) {
                return MessageFormat.format(Messages.AddPHPExceptionBreakpointDialog_Exception_description, exception.getElementName(), ((ErrorType)exception).getDescription());
            }
            return MessageFormat.format(Messages.AddPHPExceptionBreakpointDialog_Exception_description, exception.getElementName(), exception.getSourceModule().getElementName());
        }

        private Image getImage(Object element) {
            IType exception = (IType)element;
            if (exception instanceof ErrorType) {
                return PHPDebugUIImages.get("IMG_ELCL_ERROR_BREAKPOINT");
            }
            return PHPDebugUIImages.get("IMG_ELCL_EXCEPTION_BREAKPOINT");
        }
    }
}

