/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.preferences.phps.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;

public class PHPInterpreterExecutionConfigurationBlock {
    private TableViewer fProfilesViewer;
    private CheckboxTableViewer fJREsViewer;
    private Map<PHPVersion, PHPexeItem> versionToDefaultItem = new HashMap<PHPVersion, PHPexeItem>();
    private Map<PHPVersion, PHPexeItem[]> versionToCompatibleItems = new HashMap<PHPVersion, PHPexeItem[]>();
    PHPexes phpExes = PHPexes.getInstance();
    PHPexeItem[] allItems = this.phpExes.getAllItems();
    private Composite fControl;

    public PHPInterpreterExecutionConfigurationBlock() {
        this.versionToDefaultItem.putAll(this.phpExes.getDefaultItemsForPHPVersion());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createControl(Composite ancestor) {
        this.fControl = ancestor;
        Composite container = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        container.setFont(ancestor.getFont());
        Composite eeContainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        eeContainer.setLayout((Layout)layout);
        eeContainer.setLayoutData((Object)new GridData(1808));
        Label label = new Label(eeContainer, 0);
        label.setFont(ancestor.getFont());
        label.setText(Messages.PHPInterpreterExecutionConfigurationBlock_0);
        label.setLayoutData((Object)new GridData(4, 0, true, false));
        Table table = new Table(eeContainer, 2052);
        table.setLayout((Layout)layout);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fProfilesViewer = new TableViewer(table);
        this.fProfilesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fProfilesViewer.setLabelProvider((IBaseLabelProvider)new ExecutionEnvironmentsLabelProvider());
        this.fProfilesViewer.setComparator(new ViewerComparator());
        this.fProfilesViewer.setInput((Object)PHPVersion.supportedVersions());
        Composite jreContainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        jreContainer.setLayout((Layout)layout);
        jreContainer.setLayoutData((Object)new GridData(1808));
        label = new Label(jreContainer, 0);
        label.setFont(ancestor.getFont());
        label.setText(Messages.PHPInterpreterExecutionConfigurationBlock_1);
        label.setLayoutData((Object)new GridData(4, 0, true, false));
        table = new Table(jreContainer, 2084);
        table.setLayout((Layout)layout);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fJREsViewer = new CheckboxTableViewer(table);
        this.fJREsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fJREsViewer.setLabelProvider((IBaseLabelProvider)new PHPExeLabelProvider());
        this.fJREsViewer.setInput((Object)new PHPexeItem[0]);
        this.fProfilesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PHPVersion version = (PHPVersion)((IStructuredSelection)event.getSelection()).getFirstElement();
                PHPexeItem jre = (PHPexeItem)PHPInterpreterExecutionConfigurationBlock.this.versionToDefaultItem.get(version);
                PHPInterpreterExecutionConfigurationBlock.this.fJREsViewer.setInput((Object)PHPInterpreterExecutionConfigurationBlock.this.getCompatibleItems(PHPInterpreterExecutionConfigurationBlock.this.allItems, version));
                if (jre != null) {
                    PHPInterpreterExecutionConfigurationBlock.this.fJREsViewer.setCheckedElements(new Object[]{jre});
                } else {
                    PHPInterpreterExecutionConfigurationBlock.this.fJREsViewer.setCheckedElements(new Object[0]);
                }
            }
        });
        this.fJREsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    Object element = event.getElement();
                    PHPInterpreterExecutionConfigurationBlock.this.versionToDefaultItem.put((PHPVersion)((IStructuredSelection)PHPInterpreterExecutionConfigurationBlock.this.fProfilesViewer.getSelection()).getFirstElement(), (PHPexeItem)element);
                    PHPInterpreterExecutionConfigurationBlock.this.fJREsViewer.setCheckedElements(new Object[]{element});
                } else {
                    PHPInterpreterExecutionConfigurationBlock.this.versionToDefaultItem.remove(PHPInterpreterExecutionConfigurationBlock.this.fJREsViewer.getInput());
                }
            }
        });
        Dialog.applyDialogFont((Control)ancestor);
        return ancestor;
    }

    private PHPexeItem[] getCompatibleItems(PHPexeItem[] allItems, PHPVersion version) {
        version.getAlias().substring(3);
        PHPexeItem[] result = this.versionToCompatibleItems.get(version);
        if (result == null) {
            result = this.phpExes.getCompatibleItems(allItems, version);
            this.versionToCompatibleItems.put(version, result);
        }
        return result;
    }

    public boolean performOk() {
        for (PHPVersion version : this.versionToDefaultItem.keySet()) {
            this.phpExes.setItemDefaultForPHPVersion(this.versionToDefaultItem.get(version), version);
        }
        this.phpExes.save();
        return true;
    }

    public Control getControl() {
        return this.fControl;
    }

    public class ExecutionEnvironmentsLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            return DLTKPluginImages.getDescriptor((String)"org.eclipse.dltk.ui.library_obj.png").createImage();
        }

        public String getText(Object element) {
            return ((PHPVersion)element).getAlias();
        }
    }

    class PHPExeLabelProvider
    extends LabelProvider {
        PHPExeLabelProvider() {
        }

        public Image getImage(Object element) {
            return PHPDebugUIImages.get("IMG_OBJ_PHP_EXE");
        }

        public String getText(Object element) {
            if (element instanceof PHPexeItem) {
                PHPexeItem phpExe = (PHPexeItem)element;
                return phpExe.getName();
            }
            return element.toString();
        }
    }
}

