/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.filenetwork;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public abstract class SuiteOfTestCases
extends TestCase {
    Suite parentSuite;
    private static final Map<String, Suite> initializedSuites = new HashMap<String, Suite>();

    public SuiteOfTestCases(String name) {
        super(name);
    }

    public void setUpSuite() throws Exception {
    }

    public void tearDownSuite() throws Exception {
    }

    public void run(TestResult result) {
        String className = ((Object)((Object)this)).getClass().getName();
        this.parentSuite = initializedSuites.get(className);
        if (this.parentSuite == null) {
            this.parentSuite = new Suite(((Object)((Object)this)).getClass().getName());
            initializedSuites.put(((Object)((Object)this)).getClass().getName(), this.parentSuite);
            System.out.println("setUpSuite() in " + ((Object)((Object)this)).getClass().getName());
            final AtomicBoolean errors = new AtomicBoolean();
            TestListener listener = new TestListener(){

                public void startTest(Test test) {
                }

                public void endTest(Test test) {
                }

                public void addFailure(Test test, AssertionFailedError t) {
                    errors.set(true);
                }

                public void addError(Test test, Throwable t) {
                    errors.set(true);
                }
            };
            result.addListener(listener);
            result.runProtected((Test)this, new Protectable(){

                public void protect() throws Throwable {
                    SuiteOfTestCases.this.setUpSuite();
                }
            });
            result.removeListener(listener);
            if (errors.get()) {
                return;
            }
        } else if (this.parentSuite.currentTestCase != null) {
            this.parentSuite.initialize(this);
        }
        this.parentSuite.currentTestCase = this;
        super.run(result);
    }

    public static class Suite
    extends TestSuite {
        SuiteOfTestCases currentTestCase;

        public Suite(Class<? extends SuiteOfTestCases> theClass) {
            super(theClass);
        }

        public Suite(Class<? extends SuiteOfTestCases> theClass, String ... methodNames) {
            super(theClass.getName());
            int i = 0;
            while (i < methodNames.length) {
                String methodName = methodNames[i];
                try {
                    Method method = theClass.getMethod(methodName, new Class[0]);
                    if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
                        this.addTest(Suite.createTest(theClass, (String)methodName));
                    } else {
                        this.warning(methodName, "Wrong modifiers");
                    }
                }
                catch (SecurityException e) {
                    this.warning(methodName, e.toString());
                }
                catch (NoSuchMethodException e) {
                    this.warning(methodName, e.toString());
                }
                ++i;
            }
        }

        private void warning(String name, final String message) {
            this.addTest((Test)new TestCase(name){

                protected void runTest() {
                    1.fail((String)message);
                }
            });
        }

        public Suite(String name) {
            super(name);
        }

        void initialize(SuiteOfTestCases test) {
            Class<?> currentClass = ((Object)((Object)test)).getClass();
            while (currentClass != null && !currentClass.equals(SuiteOfTestCases.class)) {
                Field[] fields = currentClass.getDeclaredFields();
                int i = 0;
                int length = fields.length;
                while (i < length) {
                    Field field = fields[i];
                    int modifiers = field.getModifiers();
                    if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
                        field.setAccessible(true);
                        try {
                            Object value = field.get((Object)this.currentTestCase);
                            field.set((Object)test, value);
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                    ++i;
                }
                currentClass = currentClass.getSuperclass();
            }
        }

        public void run(final TestResult result) {
            Protectable p = new Protectable(){

                public void protect() throws Exception {
                    try {
                        Suite.this.superRun(result);
                    }
                    finally {
                        if (Suite.this.currentTestCase != null) {
                            Suite.this.currentTestCase.tearDownSuite();
                        }
                    }
                }
            };
            result.runProtected((Test)this, p);
        }

        public void superRun(TestResult result) {
            super.run(result);
        }

        public void runTest(Test test, TestResult result) {
            if (test instanceof SuiteOfTestCases) {
                SuiteOfTestCases current = (SuiteOfTestCases)test;
                if (this.currentTestCase == null) {
                    try {
                        current.setUpSuite();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    this.initialize(current);
                }
                current.parentSuite = this;
                try {
                    super.runTest(test, result);
                }
                finally {
                    current.parentSuite = null;
                    this.currentTestCase = current;
                }
            } else {
                super.runTest(test, result);
            }
        }
    }
}

