/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.locator.AbstraceConciliatorTest;
import org.eclipse.php.internal.core.ast.locator.PhpElementConciliator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PhpElementConciliatorV5_3Test
extends AbstraceConciliatorTest {
    private IProject project1;

    @Before
    public void setUp() throws Exception {
        System.setProperty("disableStartupRunner", "true");
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = this.createProject("project53", this.getPHPVersion());
    }

    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP5_3;
    }

    protected IFile setFileContent(String content) throws CoreException {
        IFile file = this.project1.getFile("test1.php");
        ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
        if (!file.exists()) {
            file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        return file;
    }

    @Test
    public void concileClassName() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; class TestRenameClass{} new TestRenameClass(); ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 54;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 26;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileClassName1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; class TestRenameClass{} class TestExtendedClass extends TestRenameClass{}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 82;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileClassName2() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; class A{function foo(){}} $a = new A();$a->foo(); my\\name\\A::foo();?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 59;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 82;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileInterface() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; interface iTemplate{public function setVariable($name, $var);}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 25;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 36;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileInterface1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; interface iTemplate{public function setVariable($name, $var);} class Template implements iTemplate{  public function setVariable($name, $var){}}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 25;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 115;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileProgram() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; class TestRenameClass{}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        Assert.assertEquals((long)7L, (long)PhpElementConciliator.concile((ASTNode)program));
    }

    @Test
    public void concileGlobalVar() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; $a = 1;  function test(){  global $a; echo $a;} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 26;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 60;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 69;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileGlobalVar1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 67;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileFunc() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 35;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 44;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileFunc1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; function a($n){return ($n * $n);}echo a(5);?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 62;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public static function bar(){return 'bar in a class called';}}$strFN2 = foo::bar;echo bar();?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 91;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod2() {
        IFile file = null;
        try {
            file = this.setFileContent("<? namespace my\name;class foo {public function bar(){return 'bar in a class called';}}$strFN2 = new foo(); $strFN2->bar()?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 118;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod3() {
        IFile file = null;
        try {
            file = this.setFileContent("<? namespace my\name;class foo {public function bar(){return 'bar in a class called';} public function f(){$this->bar();}}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 115;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod4() {
        IFile file = null;
        try {
            file = this.setFileContent("<? namespace my\name;class foo {public function bar(){return 'bar in a class called';} public function f(){$this->bar();}}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 50;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileField1() {
        IFile file = null;
        try {
            file = this.setFileContent("<? namespace my\name;class foo {var $f; public function f(){$this->$f;}}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 33;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 64;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileField2() {
        IFile file = null;
        try {
            file = this.setFileContent("<? namespace my\name;class foo {var $f; public function f(){$this->$f;}} $cls= new foo(); $cls->f;?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 95;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileStaticField1() {
        IFile file = null;
        try {
            file = this.setFileContent("<? namespace my\name;class foo {public static $my_static = 'foo';} echo Foo::$my_static; echo $foo->my_static?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 107;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 78;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 101;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void localVar() {
        IFile file = null;
        try {
            file = this.setFileContent("<? namespace my\name; $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 65;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)3L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 52;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)3L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; define('CONSTANT', 'Hello world.'); echo CONSTANT; echo Constant; ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 25;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 34;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 67;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 82;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; define ('TEST', 1234); ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 26;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant2() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace my\name; define ('TEST', 1234); ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 27;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant3() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php namespace NS;define(\"CONSTANT\", \"Hello world.\"); echo \\NS\\CONSTANT;?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 20;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 28;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 51;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 64;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }
}

