/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.formatter.core.Logger;

public class MarkerUtilities {
    public static String getMarkerType(IMarker marker) {
        try {
            return marker.getType();
        }
        catch (CoreException e) {
            Logger.logException(e);
            return null;
        }
    }

    public static void createMarker(final IResource resource, final Map<String, ? extends Object> attributes, final String markerType) throws CoreException {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(markerType);
                marker.setAttributes(attributes);
            }
        };
        resource.getWorkspace().run(r, null, 1, null);
    }
}

