/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.contentassist;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.dltk.core.search.indexing.AbstractJob;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.search.processing.IJob;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.validation.ValidationFramework;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public class ContentAssistTests {
    protected IProject project;
    protected IFile testFile;
    protected IFile[] otherFiles = new IFile[0];
    protected PHPVersion phpVersion;
    protected PHPStructuredEditor fEditor;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static final String DEFAULT_CURSOR = "|";

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/codeassist/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php53/classExclusive"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php56"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php56", "/workspace/codeassist/php7"});
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return PHPUiTests.getDefault().getBundle();
    }

    public ContentAssistTests(PHPVersion version, String[] fileNames) {
        this.phpVersion = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            IWorkspaceDescription workspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
            workspaceDescription.setAutoBuilding(false);
            ResourcesPlugin.getWorkspace().setDescription(workspaceDescription);
        }
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Content Assist_" + this.phpVersion);
        if (this.project.exists()) {
            return;
        }
        this.project.create(null);
        this.project.open(null);
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        this.project.setDescription(desc, null);
        DefaultScope.INSTANCE.getNode("org.eclipse.php.ui").putBoolean("contentAssistAutoinsert", true);
        ValidationFramework.getDefault().suspendValidation(this.project, true);
        PHPCoreTests.setProjectPhpVersion((IProject)this.project, (PHPVersion)this.phpVersion);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        this.project.close(null);
        this.project.delete(true, true, null);
        this.project = null;
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            IWorkspaceDescription workspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
            workspaceDescription.setAutoBuilding(true);
            ResourcesPlugin.getWorkspace().setDescription(workspaceDescription);
        }
    }

    @Test
    public void assist(String fileName) throws Exception {
        final PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
        pdttFile.applyPreferences();
        String data = pdttFile.getFile();
        String cursor = ContentAssistTests.getCursor(pdttFile) != null ? ContentAssistTests.getCursor(pdttFile) : DEFAULT_CURSOR;
        final int offset = data.lastIndexOf(cursor);
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        ByteArrayInputStream stream = new ByteArrayInputStream(data.getBytes());
        final Exception[] err = new Exception[1];
        this.createFile(stream, Long.toString(System.currentTimeMillis()), this.prepareOtherStreams(pdttFile));
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ContentAssistTests.this.openEditor();
                    String result = ContentAssistTests.this.executeAutoInsert(offset);
                    ContentAssistTests.this.closeEditor();
                    if (!pdttFile.getExpected().trim().equals(result.trim())) {
                        StringBuilder errorBuf = new StringBuilder();
                        errorBuf.append("\nEXPECTED COMPLETIONS LIST:\n-----------------------------\n");
                        errorBuf.append(pdttFile.getExpected());
                        errorBuf.append("\nACTUAL COMPLETIONS LIST:\n-----------------------------\n");
                        errorBuf.append(result);
                        Assert.fail((String)errorBuf.toString());
                    }
                }
                catch (Exception e) {
                    err[0] = e;
                }
            }
        });
        if (err[0] != null) {
            throw err[0];
        }
    }

    @After
    public void after() throws Exception {
        if (this.testFile != null) {
            this.testFile.delete(true, null);
            this.testFile = null;
        }
        if (this.otherFiles != null) {
            IFile[] iFileArray = this.otherFiles;
            int n = this.otherFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file != null) {
                    file.delete(true, null);
                }
                ++n2;
            }
            this.otherFiles = null;
        }
    }

    private static String getCursor(PdttFile pdttFile) {
        Map config = pdttFile.getConfig();
        return (String)config.get("cursor");
    }

    protected InputStream[] prepareOtherStreams(PdttFile file) {
        String[] contents = file.getOtherFiles();
        InputStream[] result = new InputStream[contents.length];
        int i = 0;
        while (i < contents.length) {
            result[i] = new ByteArrayInputStream(contents[i].getBytes());
            ++i;
        }
        return result;
    }

    protected void closeEditor() {
        this.fEditor.doSave(null);
        this.fEditor.getSite().getPage().closeEditor((IEditorPart)this.fEditor, false);
        this.fEditor = null;
    }

    protected String executeAutoInsert(int offset) {
        StructuredTextViewer viewer = null;
        Display display = Display.getDefault();
        long timeout = System.currentTimeMillis() + 3000L;
        while (System.currentTimeMillis() < timeout && (viewer = this.fEditor.getTextViewer()) == null) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (viewer == null) {
            Assert.fail((String)("fEditor.getTextViewer() returns null for file " + this.testFile.getFullPath() + "(" + this.testFile.getLocation() + ")"));
        }
        StyledText textWidget = viewer.getTextWidget();
        textWidget.setCaretOffset(offset);
        viewer.doOperation(13);
        return this.fEditor.getDocument().get();
    }

    protected void createFile(InputStream inputStream, String fileName) throws Exception {
        this.createFile(inputStream, fileName, new InputStream[0]);
    }

    protected void createFile(InputStream inputStream, String fileName, InputStream[] other) throws Exception {
        this.testFile = this.project.getFile(new Path(fileName).removeFileExtension().addFileExtension("php").lastSegment());
        this.testFile.create(inputStream, true, null);
        this.otherFiles = new IFile[other.length];
        int i = 0;
        while (i < other.length) {
            this.otherFiles[i] = this.project.getFile(new Path(String.valueOf(i) + fileName).addFileExtension("php").lastSegment());
            this.otherFiles[i].create(other[i], true, null);
            ++i;
        }
        this.waitForIndexerNoDelay();
    }

    protected void openEditor() throws Exception {
        FileEditorInput input;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart part = page.openEditor((IEditorInput)(input = new FileEditorInput(this.testFile)), "org.eclipse.php.editor", true);
        if (part instanceof PHPStructuredEditor) {
            this.fEditor = (PHPStructuredEditor)part;
        } else {
            Assert.assertTrue((String)"Unable to open php editor", (boolean)false);
        }
    }

    protected void waitForIndexerNoDelay() {
        final Semaphore waitForIndexerSemaphore = new Semaphore(0);
        final WaitForIndexerThread waitForIndexerThread = new WaitForIndexerThread();
        AbstractJob noDelayRequest = new AbstractJob(){

            protected void run() throws CoreException, IOException {
                waitForIndexerThread.interrupt();
                waitForIndexerSemaphore.release();
            }

            protected String getName() {
                return "WAIT-UNTIL-READY-NO-DELAY-JOB";
            }
        };
        ModelManager.getModelManager().getIndexManager().request((IJob)noDelayRequest);
        waitForIndexerThread.start();
        try {
            waitForIndexerSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Logger.logException((Throwable)e);
        }
    }

    private class WaitForIndexerThread
    extends Thread {
        public WaitForIndexerThread() {
            super("Wait-For-Indexer-Thread");
        }

        @Override
        public void run() {
            ModelManager.getModelManager().getIndexManager().waitUntilReady();
        }
    }
}

