/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.VariableKind;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class ArrayVariableReference
extends VariableReference {
    public static final int VARIABLE_ARRAY = 1;
    public static final int VARIABLE_HASHTABLE = 2;
    private final Expression index;
    private final int arrayType;

    @Deprecated
    public ArrayVariableReference(DLTKToken token, Expression index, int arrayType) {
        super(token);
        this.index = index;
        this.arrayType = arrayType;
    }

    public ArrayVariableReference(int start, int end, String name, VariableKind kind, Expression index, int arrayType) {
        super(start, end, name, kind);
        this.index = index;
        this.arrayType = arrayType;
    }

    public ArrayVariableReference(int start, int end, String name, Expression index, int arrayType) {
        super(start, end, name);
        this.index = index;
        this.arrayType = arrayType;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit && this.index != null) {
            this.index.traverse(visitor);
        }
        visitor.endvisit((Expression)this);
    }

    public static String getArrayType(int type) {
        switch (type) {
            case 1: {
                return "array";
            }
            case 2: {
                return "hashtable";
            }
        }
        throw new IllegalArgumentException();
    }

    public Expression getIndex() {
        return this.index;
    }

    public int getArrayType() {
        return this.arrayType;
    }

    public int getKind() {
        return 0;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

