/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.internal.core.preferences.AbstractPreferencesPropagator;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.ProjectPreferencesPropagator;
import org.osgi.service.prefs.Preferences;

public class PreferencesPropagator
extends AbstractPreferencesPropagator {
    private Map<IProject, ProjectPreferencesPropagator> projectToPropagator;
    private Map<IProject, ProjectScope> projectToScope;
    private Map<IProject, IEclipsePreferences.INodeChangeListener> projectToNodeListener;
    private Map<IEclipsePreferences.IPreferenceChangeListener, IEclipsePreferences> preferenceChangeListeners;
    private String nodeQualifier;
    private IEclipsePreferences.IPreferenceChangeListener propertyChangeListener;

    protected PreferencesPropagator(String nodeQualifier) {
        this.nodeQualifier = nodeQualifier;
        this.install();
    }

    @Override
    public void addPropagatorListener(IPreferencesPropagatorListener listener, String preferencesKey) {
        this.addNodeListener(listener.getProject(), this.getProjectScope(listener.getProject()));
        if (this.isProjectSpecific(listener.getProject(), preferencesKey)) {
            this.addToProjectPropagator(listener, preferencesKey);
        } else {
            super.addPropagatorListener(listener, preferencesKey);
        }
    }

    @Override
    public void removePropagatorListener(IPreferencesPropagatorListener listener, String preferencesKey) {
        if (this.isProjectSpecific(listener.getProject(), preferencesKey)) {
            this.removeFromProjectPropagator(listener, preferencesKey);
        } else {
            super.removePropagatorListener(listener, preferencesKey);
        }
    }

    @Override
    public void setPropagatorListeners(List<IPreferencesPropagatorListener> listeners, String preferencesKey) {
        super.setPropagatorListeners(listeners, preferencesKey);
    }

    @Override
    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.projectToPropagator = new HashMap<IProject, ProjectPreferencesPropagator>();
        this.projectToScope = new HashMap<IProject, ProjectScope>();
        this.projectToNodeListener = new HashMap<IProject, IEclipsePreferences.INodeChangeListener>();
        this.preferenceChangeListeners = new HashMap<IEclipsePreferences.IPreferenceChangeListener, IEclipsePreferences>();
        this.propertyChangeListener = new WorkspacePropertyChangeListener();
        InstanceScope.INSTANCE.getNode(this.nodeQualifier).addPreferenceChangeListener(this.propertyChangeListener);
        super.install();
    }

    @Override
    protected synchronized void uninstall() {
        if (!this.isInstalled) {
            return;
        }
        InstanceScope.INSTANCE.getNode(this.nodeQualifier).removePreferenceChangeListener(this.propertyChangeListener);
        Iterator<IProject> projects = this.projectToNodeListener.keySet().iterator();
        try {
            while (projects.hasNext()) {
                IProject project = projects.next();
                ProjectScope scope = this.projectToScope.get(project);
                IEclipsePreferences node = scope.getNode(this.nodeQualifier);
                if (node == null) continue;
                node.removeNodeChangeListener(this.projectToNodeListener.get(project));
            }
        }
        catch (Exception exception) {}
        Iterator<ProjectPreferencesPropagator> propagators = this.projectToPropagator.values().iterator();
        while (propagators.hasNext()) {
            propagators.next().uninstall();
        }
        this.preferenceChangeListeners = null;
        this.projectToScope = null;
        this.projectToPropagator = null;
        this.projectToNodeListener = null;
        super.uninstall();
    }

    private void addToProjectPropagator(IPreferencesPropagatorListener listener, String preferencesKey) {
        ProjectPreferencesPropagator propagator = this.projectToPropagator.get(listener.getProject());
        if (propagator == null) {
            propagator = new ProjectPreferencesPropagator(listener.getProject(), this.nodeQualifier);
            this.projectToPropagator.put(listener.getProject(), propagator);
        }
        propagator.addPropagatorListener(listener, preferencesKey);
    }

    private void removeFromProjectPropagator(IPreferencesPropagatorListener listener, String preferencesKey) {
        ProjectPreferencesPropagator propagator = this.projectToPropagator.get(listener.getProject());
        if (propagator != null) {
            propagator.removePropagatorListener(listener, preferencesKey);
        }
    }

    private boolean isProjectSpecific(IProject project, String preferencesKey) {
        ProjectScope projectScope = this.getProjectScope(project);
        IPath location = projectScope.getLocation();
        if (location != null && new File(location.toOSString()).exists()) {
            return projectScope.getNode(this.nodeQualifier).get(preferencesKey, null) != null;
        }
        return false;
    }

    private ProjectScope getProjectScope(IProject project) {
        ProjectScope scope = this.projectToScope.get(project);
        if (scope == null) {
            scope = new ProjectScope(project);
            this.projectToScope.put(project, scope);
        }
        return scope;
    }

    private void addNodeListener(IProject project, ProjectScope projectScope) {
        if (this.projectToNodeListener.get(project) != null) {
            return;
        }
        IEclipsePreferences node = projectScope.getNode(this.nodeQualifier);
        if (node != null) {
            InnerNodeChangeListener nodeListener = new InnerNodeChangeListener(project);
            ((IEclipsePreferences)node.parent()).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)nodeListener);
            this.projectToNodeListener.put(project, nodeListener);
            if (!this.preferenceChangeListeners.containsValue(node)) {
                NodePreferenceChangeListener changeListener = new NodePreferenceChangeListener(project);
                node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)changeListener);
                this.preferenceChangeListeners.put(changeListener, node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(PreferencesPropagatorEvent event, String propertyKey, IProject project) {
        Object object = this.lock;
        synchronized (object) {
            if (project != null) {
                ProjectPreferencesPropagator ppp = this.projectToPropagator.get(project);
                if (ppp == null) {
                    ppp = new ProjectPreferencesPropagator(project, this.nodeQualifier);
                    this.projectToPropagator.put(project, ppp);
                }
                ppp.notifyPropagatorEvent(event);
            } else {
                List<IPreferencesPropagatorListener> list = this.getPropagatorListeners(propertyKey);
                if (list == null) {
                    return;
                }
                Iterator<IPreferencesPropagatorListener> iterator = list.iterator();
                while (iterator.hasNext()) {
                    iterator.next().preferencesEventOccured(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveToProjectPropagator(String key, IProject project) {
        List<IPreferencesPropagatorListener> list = null;
        IPreferencesPropagatorListener[] listeners = null;
        Object object = this.lock;
        synchronized (object) {
            list = this.getPropagatorListeners(key);
            if (list == null) {
                return;
            }
            listeners = new IPreferencesPropagatorListener[list.size()];
            list.toArray(listeners);
        }
        IPreferencesPropagatorListener[] iPreferencesPropagatorListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferencesPropagatorListener listener = iPreferencesPropagatorListenerArray[n2];
            if (project.equals((Object)listener.getProject())) {
                super.removePropagatorListener(listener, key);
                this.addToProjectPropagator(listener, key);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromProjectPropagator(String key, IProject project) {
        Object object = this.lock;
        synchronized (object) {
            List<IPreferencesPropagatorListener> listeners;
            ProjectPreferencesPropagator propagator = this.projectToPropagator.get(project);
            if (propagator != null && (listeners = propagator.removePropagatorListeners(key)) != null && listeners.size() > 0) {
                Iterator<IPreferencesPropagatorListener> iter = listeners.iterator();
                while (iter.hasNext()) {
                    this.addPropagatorListener(iter.next(), key);
                }
            }
        }
    }

    private class InnerNodeChangeListener
    implements IEclipsePreferences.INodeChangeListener {
        private IProject project;

        public InnerNodeChangeListener(IProject project) {
            this.project = project;
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            IEclipsePreferences pNode = null;
            if (!(event.getChild() instanceof IEclipsePreferences)) {
                return;
            }
            pNode = (IEclipsePreferences)event.getChild();
            if (!PreferencesPropagator.this.preferenceChangeListeners.containsValue(pNode)) {
                NodePreferenceChangeListener changeListener = new NodePreferenceChangeListener(this.project);
                pNode.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)changeListener);
                PreferencesPropagator.this.preferenceChangeListeners.put(changeListener, pNode);
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            Preferences childNode = event.getChild();
            if (PreferencesPropagator.this.preferenceChangeListeners.containsValue(childNode)) {
                for (Object key : PreferencesPropagator.this.preferenceChangeListeners.keySet()) {
                    IEclipsePreferences aNode = (IEclipsePreferences)PreferencesPropagator.this.preferenceChangeListeners.get(key);
                    if (aNode != childNode) continue;
                    PreferencesPropagator.this.preferenceChangeListeners.remove(key);
                    return;
                }
            }
        }
    }

    public class NodePreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private IProject project;

        public NodePreferenceChangeListener(IProject project) {
            this.project = project;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String key = event.getKey();
            String newValue = (String)event.getNewValue();
            if (newValue == null) {
                PreferencesPropagator.this.removeFromProjectPropagator(key, this.project);
            } else {
                PreferencesPropagator.this.moveToProjectPropagator(key, this.project);
            }
            PreferencesPropagatorEvent e = new PreferencesPropagatorEvent(event.getSource(), event.getOldValue(), event.getNewValue(), event.getKey());
            PreferencesPropagator.this.notifyEvent(e, key, newValue == null ? null : this.project);
        }
    }

    private class WorkspacePropertyChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private WorkspacePropertyChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            PreferencesPropagatorEvent e = new PreferencesPropagatorEvent(event.getSource(), event.getOldValue(), event.getNewValue(), event.getKey());
            PreferencesPropagator.this.notifyEvent(e, event.getKey(), null);
        }
    }
}

