/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.index.IPHPDocAwareElement;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractMethodReturnTypeEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;
import org.eclipse.php.internal.core.typeinference.goals.AbstractMethodReturnTypeGoal;

public class PHPDocMethodReturnTypeEvaluator
extends AbstractMethodReturnTypeEvaluator {
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocMethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        IMethod[] iMethodArray = this.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocBlock docBlock;
            IMethod method = iMethodArray[n2];
            IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)method);
            String[] typeNames = null;
            if (method instanceof IPHPDocAwareElement) {
                typeNames = ((IPHPDocAwareElement)method).getReturnTypes();
            } else {
                LinkedList<String> returnTypeList = new LinkedList<String>();
                PHPDocBlock docBlock2 = PHPModelUtils.getDocBlock(method);
                if (docBlock2 == null) {
                    return IGoal.NO_GOALS;
                }
                this.evaluateReturnType(returnTypeList, docBlock2, method);
                typeNames = returnTypeList.toArray(new String[returnTypeList.size()]);
            }
            if (typeNames != null && (docBlock = PHPModelUtils.getDocBlock(method)) != null) {
                AbstractMethodReturnTypeGoal goal = (AbstractMethodReturnTypeGoal)this.getGoal();
                IType space = currentNamespace != null ? currentNamespace : method.getSourceModule();
                this.evaluated.addAll(Arrays.asList(PHPEvaluationUtils.evaluatePHPDocType(typeNames, (IModelElement)space, docBlock.sourceStart(), goal.getTypes())));
            }
            ++n2;
        }
        return IGoal.NO_GOALS;
    }

    private void evaluateReturnType(List<String> returnTypeList, PHPDocBlock docBlock, IMethod method) {
        IType type;
        PHPDocTag[] tags = docBlock.getTags(PHPDocTag.TagKind.RETURN);
        PHPDocTag[] inherit = docBlock.getTags(PHPDocTag.TagKind.INHERITDOC);
        if (inherit.length == 1 && (type = method.getDeclaringType()) != null) {
            try {
                IType[] superClasses;
                IContext context = this.goal.getContext();
                IModelAccessCache cache = null;
                if (context instanceof IModelCacheContext) {
                    cache = ((IModelCacheContext)context).getCache();
                }
                IType[] iTypeArray = superClasses = PHPModelUtils.getSuperClasses(type, cache == null ? null : cache.getSuperTypeHierarchy(type, null));
                int n = superClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    PHPDocBlock superDocBlock;
                    IType superClass = iTypeArray[n2];
                    IMethod superClassMethod = superClass.getMethod(method.getElementName());
                    if (superClassMethod != null && (superDocBlock = PHPModelUtils.getDocBlock(superClassMethod)) != null) {
                        this.evaluateReturnType(returnTypeList, superDocBlock, superClassMethod);
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        }
        PHPDocTag[] pHPDocTagArray = tags;
        int n = tags.length;
        int n3 = 0;
        while (n3 < n) {
            PHPDocTag phpDocTag = pHPDocTagArray[n3];
            for (TypeReference ref : phpDocTag.getTypeReferences()) {
                returnTypeList.add(ref.getName());
            }
            ++n3;
        }
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

