/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.elements;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.model.connection.PHPUnitMessageParser;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestEvent;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestGroup;

public class PHPUnitTestException
extends PHPUnitTestEvent {
    private static final String TOP_CLASS = "Exception";
    private String exceptionClass = "Exception";

    public PHPUnitTestException(Map<?, ?> exception, PHPUnitTestCase parent, RemoteDebugger remoteDebugger) {
        super(exception, parent, remoteDebugger);
        this.exceptionClass = (String)exception.get("class");
    }

    public String getExceptionClass() {
        return this.exceptionClass;
    }

    public String toString() {
        return String.valueOf(this.file) + ":" + String.valueOf(this.line) + "$" + this.exceptionClass + "!" + this.message;
    }

    public static void addAbnormalException(PHPUnitTestCase testCase) {
        HashMap<String, String> exception = new HashMap<String, String>();
        exception.put("class", PHPUnitMessages.PHPUnitTestException_0);
        exception.put("message", PHPUnitMessages.PHPUnitTestException_1);
        PHPUnitTestException abnormalException = new PHPUnitTestException(exception, null, null);
        abnormalException.setParent(testCase);
        testCase.setException(abnormalException);
        testCase.setStatus(5);
        PHPUnitTestGroup parent = (PHPUnitTestGroup)testCase.getParent();
        if (parent != null) {
            parent.setStatus(testCase.getStatus());
        }
        PHPUnitMessageParser.getInstance().mapException(testCase, exception);
    }
}

