/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename.logic;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.php.core.ast.nodes.ASTNodes;
import org.eclipse.php.core.ast.nodes.ArrayAccess;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.GlobalStatement;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.logic.AbstractRename;

public class RenameGlobalVariable
extends AbstractRename {
    private static final String RENAME_GLOBAL_VARIABLE = PHPRefactoringCoreMessages.getString("RenameGlobalVariableName.0");
    private boolean isGlobalScope = true;

    public RenameGlobalVariable(IFile file, String oldName, String newName, boolean searchTextual) {
        super(file, oldName, newName, searchTextual);
    }

    @Override
    protected String getTextualSearchPattern() {
        return "(\\$" + this.oldName + "|'" + this.oldName + "'|\"" + this.oldName + "\")";
    }

    public boolean visit(ClassDeclaration classDeclaration) {
        this.setNonGlobalScope();
        return true;
    }

    public void endVisit(ClassDeclaration classDeclaration) {
        this.setGlobalScope();
    }

    public boolean visit(TraitDeclaration traitDeclaration) {
        this.setNonGlobalScope();
        return true;
    }

    public void endVisit(TraitDeclaration traitDeclaration) {
        this.setGlobalScope();
    }

    public boolean visit(FunctionDeclaration functionDeclaration) {
        this.setNonGlobalScope();
        return true;
    }

    public void endVisit(FunctionDeclaration functionDeclaration) {
        this.setGlobalScope();
    }

    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        this.setNonGlobalScope();
        return true;
    }

    public void endVisit(InterfaceDeclaration interfaceDeclaration) {
        this.setGlobalScope();
    }

    public boolean visit(FieldsDeclaration fieldDeclaration) {
        this.setNonGlobalScope();
        return true;
    }

    public void endVisit(FieldsDeclaration fieldsDeclaration) {
        this.setGlobalScope();
    }

    public boolean visit(Variable variable) {
        Identifier identifier;
        if ((variable.isDollared() || ASTNodes.isQuotedDollaredCurlied((Variable)variable)) && variable.getName() instanceof Identifier && this.oldName.equals((identifier = (Identifier)variable.getName()).getName()) && this.isGlobalScope) {
            this.addChange(identifier);
        }
        return true;
    }

    public boolean visit(GlobalStatement globalStatement) {
        List variables = globalStatement.variables();
        for (Variable variable : variables) {
            Identifier identifier;
            if (!variable.isDollared() || !this.oldName.equals((identifier = (Identifier)variable.getName()).getName())) continue;
            this.addChange(identifier);
            this.setGlobalScope();
        }
        return false;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        String stringValue;
        Scalar scalar;
        Expression index;
        Identifier id;
        Variable var;
        VariableBase variableName = arrayAccess.getName();
        if (variableName.getType() == 60 && ((var = (Variable)variableName).isDollared() || ASTNodes.isQuotedDollaredCurlied((Variable)var)) && var.getName() instanceof Identifier && ((id = (Identifier)var.getName()).getName().equals("GLOBALS") || id.getName().equals("_GLOBALS")) && (index = arrayAccess.getIndex()).getType() == 51 && this.isScalarNeedChange(scalar = (Scalar)index, stringValue = scalar.getStringValue())) {
            this.addChange(scalar);
            return false;
        }
        return true;
    }

    private boolean isScalarNeedChange(Scalar scalar, String stringValue) {
        return scalar.getScalarType() == 2 && (stringValue.equals(this.oldName) || stringValue.length() > 2 && stringValue.substring(1, stringValue.length() - 1).equals(this.oldName));
    }

    @Override
    public String getRenameDescription() {
        return RENAME_GLOBAL_VARIABLE;
    }

    private void setNonGlobalScope() {
        this.isGlobalScope = false;
    }

    private void setGlobalScope() {
        this.isGlobalScope = true;
    }
}

