/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUIImages;
import org.eclipse.php.profile.ui.dialogs.ExecutionStatisticsFilterDialog;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFilter;
import org.eclipse.php.profile.ui.filters.ExecutionStatisticsFiltersRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FiltersDialog
extends StatusDialog {
    private Label fMainLabel;
    private TableViewer fViewer;
    private Button fNewButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private List<ExecutionStatisticsFilter> fFilters;

    public FiltersDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(PHPProfileUIMessages.getString("FiltersDialog_0"));
        this.fFilters = new ArrayList<ExecutionStatisticsFilter>();
    }

    private void addButtonsGroup(Composite parent) {
        Composite buttonGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        buttonGroup.setLayout((Layout)layout);
        this.fNewButton = new Button(buttonGroup, 0);
        this.fNewButton.setText(PHPProfileUIMessages.getString("FiltersDialog_1"));
        this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersDialog.this.doEditFilter(null);
            }
        });
        this.fEditButton = new Button(buttonGroup, 0);
        this.fEditButton.setText(PHPProfileUIMessages.getString("FiltersDialog_2"));
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)FiltersDialog.this.fViewer.getSelection();
                FiltersDialog.this.doEditFilter((ExecutionStatisticsFilter)((Object)selection.getFirstElement()));
            }
        });
        this.fRemoveButton = new Button(buttonGroup, 0);
        this.fRemoveButton.setText(PHPProfileUIMessages.getString("FiltersDialog_3"));
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)FiltersDialog.this.fViewer.getSelection();
                FiltersDialog.this.fFilters.remove((Object)((ExecutionStatisticsFilter)((Object)selection.getFirstElement())));
                FiltersDialog.this.fViewer.refresh();
            }
        });
    }

    private void updateNewEditRemoveButtonsStates() {
        ExecutionStatisticsFilter filter = (ExecutionStatisticsFilter)((Object)((IStructuredSelection)this.fViewer.getSelection()).getFirstElement());
        this.fEditButton.setEnabled(filter != null);
        this.fRemoveButton.setEnabled(filter != null && filter.isRemovable());
    }

    private void doEditFilter(ExecutionStatisticsFilter filter) {
        ExecutionStatisticsFilterDialog dialog = new ExecutionStatisticsFilterDialog(this.getShell(), filter, this.fFilters);
        if (dialog.open() == 0 && filter == null) {
            this.fFilters.add(dialog.getFilter());
        }
        this.fViewer.refresh();
    }

    public ExecutionStatisticsFilter[] getFilters() {
        return this.fFilters.toArray(new ExecutionStatisticsFilter[this.fFilters.size()]);
    }

    protected void okPressed() {
        ExecutionStatisticsFiltersRegistry.saveFilters(this.fFilters.toArray(new ExecutionStatisticsFilter[this.fFilters.size()]));
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        this.fMainLabel = new Label(parent, 0);
        this.fMainLabel.setText(PHPProfileUIMessages.getString("FiltersDialog_4"));
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.fMainLabel.setLayoutData((Object)layoutData);
        this.fViewer = new TableViewer(parent);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.heightHint = 300;
        layoutData.widthHint = 250;
        this.fViewer.getControl().setLayoutData((Object)layoutData);
        this.fViewer.setContentProvider((IContentProvider)new FiltersListContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new FiltersListLabelProvider());
        ExecutionStatisticsFiltersRegistry.getFilters(this.fFilters);
        this.fViewer.setInput(this.fFilters);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FiltersDialog.this.updateNewEditRemoveButtonsStates();
            }
        });
        this.addButtonsGroup(parent);
        this.updateNewEditRemoveButtonsStates();
        return parent;
    }

    class FiltersListContentProvider
    implements IStructuredContentProvider {
        FiltersListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray(new Object[list.size()]);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class FiltersListLabelProvider
    extends LabelProvider {
        private Image fFilterImage = ProfilerUIImages.get("IMG_OBJ_STAT_FILTER_OBJ");

        public Image getImage(Object element) {
            return this.fFilterImage;
        }

        public String getText(Object element) {
            if (element instanceof ExecutionStatisticsFilter) {
                return ((ExecutionStatisticsFilter)((Object)element)).getName();
            }
            return null;
        }
    }
}

