/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public abstract class CommentHandler
extends AbstractHandler
implements IHandler {
    static final String SINGLE_LINE_COMMENT = "//";
    static final String OPEN_COMMENT = "/*";
    static final String CLOSE_COMMENT = "*/";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocument document;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            Object o = editor.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
            ITextSelection textSelection = this.getCurrentSelection(textEditor);
            if (textSelection.isEmpty()) {
                return null;
            }
            this.processAction(textEditor, document, textSelection);
        }
        return null;
    }

    protected ITextSelection getCurrentSelection(ITextEditor textEditor) {
        ISelection selection;
        ISelectionProvider provider = textEditor.getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }

    void processAction(ITextEditor textEditor, IDocument document, ITextSelection textSelection) {
    }

    protected void removeOpenCloseComments(IDocument document, int offset, int endOffset) {
        try {
            int adjusted_length = endOffset - offset;
            String string = document.get(offset, adjusted_length);
            int index = string.lastIndexOf(OPEN_COMMENT);
            while (index != -1) {
                document.replace(offset + index, OPEN_COMMENT.length(), "");
                index = string.lastIndexOf(OPEN_COMMENT, index - 1);
                adjusted_length -= OPEN_COMMENT.length();
            }
            string = document.get(offset, adjusted_length);
            index = string.lastIndexOf(CLOSE_COMMENT);
            while (index != -1) {
                document.replace(offset + index, CLOSE_COMMENT.length(), "");
                index = string.lastIndexOf(CLOSE_COMMENT, index - 1);
                adjusted_length -= CLOSE_COMMENT.length();
            }
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
    }

    protected boolean isCommentLine(IDocument document, int line) {
        boolean isComment = false;
        try {
            IRegion region = document.getLineInformation(line);
            String string = document.get(region.getOffset(), region.getLength()).trim();
            isComment = string.length() >= OPEN_COMMENT.length() && string.startsWith(OPEN_COMMENT) || string.length() >= SINGLE_LINE_COMMENT.length() && string.startsWith(SINGLE_LINE_COMMENT);
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
        return isComment;
    }

    protected void commentSingleLine(IDocument document, int openCommentOffset) {
        try {
            document.replace(openCommentOffset, 0, SINGLE_LINE_COMMENT);
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
    }

    protected void uncommentSingleLine(IDocument document, int openCommentOffset) {
        try {
            document.replace(openCommentOffset, SINGLE_LINE_COMMENT.length(), "");
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
    }

    protected void commentMultiLine(IDocument document, int selectionStartLine, int selectionEndLine) {
        StringBuilder sb = new StringBuilder(SINGLE_LINE_COMMENT);
        try {
            int i = selectionStartLine;
            while (i < selectionEndLine) {
                if (document.getLineLength(i) > 0) {
                    int openCommentOffset = document.getLineOffset(i);
                    int nextLineOffset = document.getLineOffset(i + 1);
                    sb.append(document.get(openCommentOffset, nextLineOffset - openCommentOffset)).append(SINGLE_LINE_COMMENT);
                }
                ++i;
            }
            document.replace(document.getLineOffset(selectionStartLine), document.getLineOffset(selectionEndLine) - document.getLineOffset(selectionStartLine), sb.toString());
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
    }

    protected void uncommentMultiLine(IDocument document, int selectionStartLine, int selectionEndLine) {
        StringBuilder sb = new StringBuilder();
        try {
            int i = selectionStartLine;
            while (i < selectionEndLine) {
                if (document.getLineLength(i) > 0) {
                    int openCommentOffset = document.getLineOffset(i);
                    int nextLineOffset = document.getLineOffset(i + 1);
                    sb.append(document.get(openCommentOffset, nextLineOffset - openCommentOffset).substring(2));
                }
                ++i;
            }
            document.replace(document.getLineOffset(selectionStartLine), document.getLineOffset(selectionEndLine) + SINGLE_LINE_COMMENT.length() - document.getLineOffset(selectionStartLine), sb.toString());
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
    }

    protected boolean isMoreThanOneContextBlockSelected(IDocument document, ITextSelection textSelection) {
        if (document == null) {
            assert (false);
            return true;
        }
        IStructuredDocument structuredDocument = null;
        if (!(document instanceof IStructuredDocument)) {
            return true;
        }
        structuredDocument = (IStructuredDocument)document;
        IStructuredDocumentRegion[] structuredDocumentRegions = structuredDocument.getStructuredDocumentRegions(textSelection.getOffset(), textSelection.getLength());
        if (structuredDocumentRegions == null || structuredDocumentRegions.length == 0) {
            assert (false);
            return true;
        }
        if (structuredDocumentRegions.length == 1 && this.isPHPDocumentRegion(structuredDocumentRegions[0])) {
            return false;
        }
        IStructuredDocumentRegion[] iStructuredDocumentRegionArray = structuredDocumentRegions;
        int n = structuredDocumentRegions.length;
        int n2 = 0;
        while (n2 < n) {
            IStructuredDocumentRegion structuredDocumentRegion = iStructuredDocumentRegionArray[n2];
            if (this.isPHPDocumentRegion(structuredDocumentRegion)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isPHPDocumentRegion(IStructuredDocumentRegion structuredDocumentRegion) {
        return structuredDocumentRegion.getFirstRegion().getType() == "PHP_OPEN";
    }

    protected void displayCommentActinosErrorDialog(IEditorPart editor) {
        MessageDialog.openError((Shell)editor.getSite().getShell(), (String)PHPUIMessages.AddBlockComment_error_title, (String)PHPUIMessages.AddBlockComment_error_messageBadSelection);
    }
}

