/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.text.Segment;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.php.internal.core.documentModel.parser.Scanner;
import org.eclipse.php.internal.core.documentModel.parser.regions.PHPRegionTypes;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.util.collections.StateStack;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class AbstractPHPLexer
implements Scanner,
PHPRegionTypes {
    protected boolean asp_tags = true;
    protected StateStack phpStack;
    protected String[] heredocIds;
    public LinkedList<ITextRegion> bufferedTokens = null;
    public int bufferedLength = 0;
    public Scanner.LexerState bufferedState = null;

    protected abstract int getZZEndRead();

    protected abstract int getZZLexicalState();

    protected abstract int getZZMarkedPos();

    protected abstract int getZZPushBackPosition();

    protected abstract int getZZStartRead();

    protected abstract void pushBack(int var1);

    public abstract char[] getZZBuffer();

    public abstract void yybegin(int var1);

    public abstract int yylength();

    public abstract String yytext();

    protected abstract void reset(Reader var1, char[] var2, int[] var3);

    public abstract int yystate();

    public abstract int getInScriptingState();

    public abstract int[] getHeredocStates();

    public abstract int[] getPHPQuotesStates();

    public abstract int[] getParameters();

    public abstract int getScriptingState();

    protected static final boolean isLowerCase(String text) {
        if (text == null) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            if (!Character.isLowerCase(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Scanner.LexerState buildLexerState() {
        Scanner.LexerState state = new BasicLexerState(this);
        if (ArrayUtils.contains((int[])this.getHeredocStates(), (int)this.getZZLexicalState())) {
            state = new HeredocState((BasicLexerState)state, this);
        }
        return state;
    }

    @Override
    @NonNull
    public Scanner.LexerState createLexicalStateMemento() {
        if (this.bufferedTokens != null && !this.bufferedTokens.isEmpty()) {
            assert (this.bufferedState != null);
            return this.bufferedState;
        }
        Scanner.LexerState currentState = this.buildLexerState();
        Scanner.LexerState cachedState = this.getLexerStates().get(currentState);
        if (cachedState != null) {
            return cachedState;
        }
        this.getLexerStates().put(currentState, currentState);
        return currentState;
    }

    protected abstract Map<Scanner.LexerState, Scanner.LexerState> getLexerStates();

    public boolean getAspTags() {
        return this.asp_tags;
    }

    @Override
    @NonNull
    public Scanner.LexerState getEndingState() throws IOException {
        this.lexToEnd();
        return this.createLexicalStateMemento();
    }

    @Override
    public int getMarkedPos() {
        return this.getZZMarkedPos();
    }

    @Override
    public void getText(int start, int length, Segment s) {
        if (start + length > this.getZZEndRead()) {
            throw new RuntimeException("bad segment !!");
        }
        s.array = this.getZZBuffer();
        s.offset = start;
        s.count = length;
    }

    public int getTokenStart() {
        return this.getZZStartRead() - this.getZZPushBackPosition();
    }

    @Override
    public void initialize(int state) {
        this.phpStack = new StateStack();
        this.heredocIds = null;
        this.bufferedTokens = null;
        this.bufferedLength = 0;
        this.bufferedState = null;
        this.yybegin(state);
    }

    @Override
    @Nullable
    public String lexToEnd() throws IOException {
        String curr;
        String last = curr = this.yylex();
        while (curr != null) {
            last = curr;
            curr = this.yylex();
        }
        return last;
    }

    protected void popState() {
        this.yybegin(this.phpStack.popStack());
    }

    protected void pushState(int state) {
        this.phpStack.pushStack(this.getZZLexicalState());
        this.yybegin(state);
    }

    protected void pushHeredocId(String heredocId) {
        if (this.heredocIds == null) {
            this.heredocIds = new String[]{heredocId};
            return;
        }
        assert (this.heredocIds.length != 0);
        String[] newHeredocIds = new String[this.heredocIds.length + 1];
        System.arraycopy(this.heredocIds, 0, newHeredocIds, 0, this.heredocIds.length);
        newHeredocIds[this.heredocIds.length] = heredocId;
        this.heredocIds = newHeredocIds;
    }

    protected String getHeredocId() {
        if (this.heredocIds == null) {
            return null;
        }
        assert (this.heredocIds.length != 0);
        return this.heredocIds[this.heredocIds.length - 1];
    }

    protected void popHeredocId() {
        if (this.heredocIds == null) {
            return;
        }
        assert (this.heredocIds.length != 0);
        if (this.heredocIds.length == 1) {
            this.heredocIds = null;
            return;
        }
        String[] newHeredocIds = new String[this.heredocIds.length - 1];
        System.arraycopy(this.heredocIds, 0, newHeredocIds, 0, this.heredocIds.length - 1);
        this.heredocIds = newHeredocIds;
    }

    public void setAspTags(boolean b) {
        this.asp_tags = b;
    }

    @Override
    public void setState(Object state) {
        ((Scanner.LexerState)state).restoreState(this);
    }

    public int yystart() {
        return this.getZZStartRead();
    }

    @Nullable
    public String getNextToken() throws IOException {
        if (this.bufferedTokens != null) {
            if (this.bufferedTokens.isEmpty()) {
                this.bufferedTokens = null;
                this.bufferedLength = 0;
            } else {
                return this.removeFromBuffer();
            }
        }
        this.bufferedState = this.createLexicalStateMemento();
        String yylex = this.yylex();
        if (PHPPartitionTypes.isPHPDocRegion(yylex)) {
            StringBuilder buffer = new StringBuilder();
            int length = 0;
            while (PHPPartitionTypes.isPHPDocRegion(yylex)) {
                buffer.append(this.yytext());
                length += this.yylength();
                yylex = this.yylex();
            }
            this.bufferedTokens = new LinkedList();
            this.bufferedTokens.add((ITextRegion)new ContextRegion("PHPDOC_COMMENT", 0, length, length));
            if (yylex != null) {
                this.bufferedTokens.add((ITextRegion)new ContextRegion(yylex, 0, this.yylength(), this.yylength()));
            }
            yylex = this.removeFromBuffer();
        } else if (PHPPartitionTypes.isPHPCommentState(yylex)) {
            this.bufferedTokens = new LinkedList();
            this.bufferedTokens.add((ITextRegion)new ContextRegion(yylex, 0, this.yylength(), this.yylength()));
            yylex = this.removeFromBuffer();
        }
        if (yylex == "PHP_CLOSETAG") {
            this.pushBack(this.getLength());
        }
        return yylex;
    }

    private String removeFromBuffer() {
        ITextRegion region = this.bufferedTokens.removeFirst();
        this.bufferedLength = region.getLength();
        return region.getType();
    }

    public int getLength() {
        return this.bufferedTokens == null ? this.yylength() : this.bufferedLength;
    }

    private static class BasicLexerState
    implements Scanner.LexerState {
        private final byte lexicalState;
        private StateStack phpStack;

        public BasicLexerState(AbstractPHPLexer lexer) {
            if (!lexer.phpStack.isEmpty()) {
                this.phpStack = lexer.phpStack.createClone();
            }
            this.lexicalState = (byte)lexer.getZZLexicalState();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.lexicalState;
            result = 31 * result + (this.phpStack == null ? 0 : this.phpStack.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BasicLexerState other = (BasicLexerState)obj;
            if (this.lexicalState != other.lexicalState) {
                return false;
            }
            return !(this.phpStack == null ? other.phpStack != null : !this.phpStack.equals(other.phpStack));
        }

        @Override
        public boolean equalsCurrentStack(Scanner.LexerState obj) {
            StateStack otherActiveStack;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BasicLexerState other = (BasicLexerState)obj;
            if (this.lexicalState != other.lexicalState) {
                return false;
            }
            StateStack activeStack = this.getActiveStack();
            return activeStack == (otherActiveStack = other.getActiveStack()) || activeStack != null && activeStack.equals(otherActiveStack);
        }

        @Override
        public boolean equalsTop(Scanner.LexerState obj) {
            return obj != null && obj.getTopState() == this.lexicalState;
        }

        protected StateStack getActiveStack() {
            return this.phpStack;
        }

        @Override
        public int getTopState() {
            return this.lexicalState;
        }

        @Override
        public boolean isSubstateOf(int state) {
            if (this.lexicalState == state) {
                return true;
            }
            StateStack activeStack = this.getActiveStack();
            if (activeStack == null) {
                return false;
            }
            return activeStack.contains(state);
        }

        @Override
        public void restoreState(Scanner scanner) {
            AbstractPHPLexer lexer = (AbstractPHPLexer)scanner;
            if (this.phpStack == null) {
                lexer.phpStack.clear();
            } else {
                lexer.phpStack.copyFrom(this.phpStack);
            }
            lexer.yybegin(this.lexicalState);
        }

        public String toString() {
            StateStack stack = this.getActiveStack();
            String stackStr = stack == null ? "null" : stack.toString();
            return "Stack: " + stackStr + ", currState: " + this.lexicalState;
        }
    }

    private static class HeredocState
    implements Scanner.LexerState {
        private final String[] heredocIds;
        private final BasicLexerState theState;

        public HeredocState(BasicLexerState state, AbstractPHPLexer lexer) {
            this.theState = state;
            this.heredocIds = lexer.heredocIds;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.heredocIds);
            result = 31 * result + (this.theState == null ? 0 : this.theState.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HeredocState other = (HeredocState)obj;
            if (!Arrays.equals(this.heredocIds, other.heredocIds)) {
                return false;
            }
            return !(this.theState == null ? other.theState != null : !this.theState.equals(other.theState));
        }

        @Override
        public boolean equalsCurrentStack(Scanner.LexerState obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.theState.equals(((HeredocState)obj).theState);
        }

        @Override
        public boolean equalsTop(Scanner.LexerState obj) {
            return this.theState.equalsTop(obj);
        }

        @Override
        public int getTopState() {
            return this.theState.getTopState();
        }

        @Override
        public boolean isSubstateOf(int state) {
            return this.theState.isSubstateOf(state);
        }

        @Override
        public void restoreState(Scanner scanner) {
            AbstractPHPLexer lexer = (AbstractPHPLexer)scanner;
            this.theState.restoreState(lexer);
            lexer.heredocIds = this.heredocIds.length == 0 ? null : this.heredocIds;
        }
    }
}

