/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.test;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.VersionedPackage;
import org.eclipse.php.composer.api.collection.Dependencies;
import org.eclipse.php.composer.api.collection.Persons;
import org.eclipse.php.composer.api.collection.Psr;
import org.eclipse.php.composer.api.objects.Autoload;
import org.eclipse.php.composer.api.objects.JsonObject;
import org.eclipse.php.composer.api.objects.Namespace;
import org.eclipse.php.composer.api.objects.Person;
import org.eclipse.php.composer.api.test.ComposertTestCase;
import org.junit.Test;

public class ListenerTest
extends ComposertTestCase {
    private ComposerPackage pkg;
    private String property;
    private Object oldValue;
    private Object newValue;
    private int changes = 0;
    private HashMap<String, Integer> listenerCounter;

    protected void setUp() throws Exception {
        this.pkg = this.createDummyPackage();
        this.listenerCounter = new HashMap();
        this.changes = 0;
        this.pkg.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ListenerTest.this.property = e.getPropertyName();
                ListenerTest.this.oldValue = e.getOldValue();
                ListenerTest.this.newValue = e.getNewValue();
                ListenerTest listenerTest = ListenerTest.this;
                listenerTest.changes = listenerTest.changes + 1;
                if (!ListenerTest.this.listenerCounter.containsKey(ListenerTest.this.property)) {
                    ListenerTest.this.listenerCounter.put(ListenerTest.this.property, 0);
                }
                ListenerTest.this.listenerCounter.put(ListenerTest.this.property, (Integer)ListenerTest.this.listenerCounter.get(ListenerTest.this.property) + 1);
            }
        });
    }

    @Test
    public void testName() {
        String name = "foo/bar";
        this.pkg.setName(name);
        ListenerTest.assertEquals((int)1, (int)this.changes);
        ListenerTest.assertEquals((String)"name", (String)this.property);
        ListenerTest.assertEquals((Object)name, (Object)this.newValue);
        ListenerTest.assertEquals((Object)NAME, (Object)this.oldValue);
        ListenerTest.assertFalse((boolean)this.oldValue.equals(this.newValue));
        this.changes = 0;
        this.pkg.remove("name");
        ListenerTest.assertEquals((int)1, (int)this.changes);
        ListenerTest.assertEquals((String)"name", (String)this.property);
        ListenerTest.assertEquals(null, (Object)this.newValue);
        ListenerTest.assertEquals((Object)name, (Object)this.oldValue);
        ListenerTest.assertFalse((boolean)this.oldValue.equals(this.newValue));
        this.changes = 0;
        this.pkg.setName(NAME);
        ListenerTest.assertEquals((int)1, (int)this.changes);
        ListenerTest.assertEquals((String)"name", (String)this.property);
        ListenerTest.assertEquals((Object)NAME, (Object)this.newValue);
        ListenerTest.assertEquals(null, (Object)this.oldValue);
        ListenerTest.assertFalse((boolean)this.newValue.equals(this.oldValue));
    }

    @Test
    public void testAuthors() {
        String name = "hans";
        Persons authors = this.pkg.getAuthors();
        Person p1 = (Person)authors.get(1);
        p1.setName("hans");
        ListenerTest.assertEquals((int)1, (int)authors.indexOf((Object)p1));
        ListenerTest.assertEquals((int)1, (int)this.changes);
        ListenerTest.assertEquals((String)"authors.#1.name", (String)this.property);
        ListenerTest.assertEquals((Object)name, (Object)this.newValue);
        ListenerTest.assertEquals((Object)PERSON2, (Object)this.oldValue);
        ListenerTest.assertFalse((boolean)this.oldValue.equals(this.newValue));
        this.changes = 0;
        Person p = new Person();
        p.setName(name);
        authors.add((Object)p);
        ListenerTest.assertEquals((int)1, (int)this.changes);
        ListenerTest.assertEquals((String)"authors.#2", (String)this.property);
        ListenerTest.assertEquals((Object)p, (Object)this.newValue);
        ListenerTest.assertEquals(null, (Object)this.oldValue);
        ListenerTest.assertFalse((boolean)this.newValue.equals(this.oldValue));
        this.changes = 0;
        p.setName(name);
        ListenerTest.assertEquals((int)0, (int)this.changes);
        this.changes = 0;
        p = (Person)authors.get(1);
        authors.remove((Object)p);
        ListenerTest.assertEquals((int)1, (int)this.changes);
        ListenerTest.assertEquals((String)"authors.#1", (String)this.property);
        ListenerTest.assertEquals(null, (Object)this.newValue);
        ListenerTest.assertEquals((Object)p, (Object)this.oldValue);
        ListenerTest.assertFalse((boolean)this.oldValue.equals(this.newValue));
    }

    @Test
    public void testCustom() {
        String p = "prop";
        JsonObject o = new JsonObject();
        this.pkg.set(p, (Object)o);
        ListenerTest.assertEquals((int)1, (int)this.changes);
        ListenerTest.assertEquals((String)p, (String)this.property);
        ListenerTest.assertEquals((Object)o, (Object)this.newValue);
        ListenerTest.assertEquals(null, (Object)this.oldValue);
        ListenerTest.assertFalse((boolean)this.newValue.equals(this.oldValue));
        this.changes = 0;
        String p2 = "prop2";
        String v = "val";
        o.set(p2, (Object)v);
        ListenerTest.assertEquals((int)1, (int)this.changes);
        ListenerTest.assertEquals((String)(String.valueOf(p) + "." + p2), (String)this.property);
        ListenerTest.assertEquals((Object)v, (Object)this.newValue);
        ListenerTest.assertEquals(null, (Object)this.oldValue);
        ListenerTest.assertFalse((boolean)this.newValue.equals(this.oldValue));
    }

    private int getCounter(String key) {
        if (!this.listenerCounter.containsKey(key)) {
            return 0;
        }
        return this.listenerCounter.get(key);
    }

    @Test
    public void testLicense() {
        this.pkg.getLicense().add("GPL");
        ListenerTest.assertEquals((int)1, (int)this.getCounter("license.#2"));
        this.pkg.getLicense().add("LGPL");
        ListenerTest.assertEquals((int)1, (int)this.getCounter("license.#3"));
        this.changes = 0;
        this.pkg.getLicense().add("MIT");
        ListenerTest.assertEquals((int)0, (int)this.changes);
        this.pkg.getLicense().clear();
        ListenerTest.assertEquals((int)4, (int)this.getCounter("license.#0"));
    }

    @Test
    public void testKeywords() {
        this.pkg.getKeywords().add((Object)"fool");
        ListenerTest.assertEquals((int)1, (int)this.getCounter("keywords.#2"));
        this.pkg.getKeywords().add((Object)"bar");
        ListenerTest.assertEquals((int)1, (int)this.getCounter("keywords.#3"));
    }

    @Test
    public void testAutoload() {
        Autoload al = this.pkg.getAutoload();
        Psr psr = al.getPsr0();
        Namespace ns1 = new Namespace();
        ns1.setNamespace("test");
        psr.add(ns1);
        ListenerTest.assertEquals((int)1, (int)this.getCounter("autoload.psr-0.test"));
        ns1.add("new/path");
        ListenerTest.assertEquals((int)1, (int)this.getCounter("autoload.psr-0.test.#0"));
        al.getClassMap().add((Object)"file/to/path.php");
        ListenerTest.assertEquals((int)1, (int)this.getCounter("autoload.classmap.#3"));
        al.getFiles().add((Object)"another/file/to/path.php");
        ListenerTest.assertEquals((int)1, (int)this.getCounter("autoload.files.#1"));
    }

    @Test
    public void testDependencies() {
        Dependencies require = this.pkg.getRequireDev();
        VersionedPackage phpunit = (VersionedPackage)require.get(PHPUNIT);
        phpunit.setVersion("1.2.3");
        ListenerTest.assertEquals((int)1, (int)this.changes);
        ListenerTest.assertEquals((String)"require-dev.phpunit/phpunit.version", (String)this.property);
        ListenerTest.assertEquals((Object)"1.2.3", (Object)this.newValue);
        ListenerTest.assertEquals((Object)PHPUNIT_VERSION, (Object)this.oldValue);
        ListenerTest.assertFalse((boolean)this.oldValue.equals(this.newValue));
    }
}

