/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.DebugSessionIdGenerator;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.builtin.IPHPServerBehaviour;
import org.eclipse.php.internal.server.core.builtin.IPHPServerRunner;
import org.eclipse.php.internal.server.core.builtin.Messages;
import org.eclipse.php.internal.server.core.builtin.PHPRuntime;
import org.eclipse.php.internal.server.core.builtin.PHPServer;
import org.eclipse.php.internal.server.core.builtin.PHPServerConfiguration;
import org.eclipse.php.internal.server.core.builtin.PHPServerHelper;
import org.eclipse.php.internal.server.core.builtin.PingThread;
import org.eclipse.php.internal.server.core.builtin.ProgressUtil;
import org.eclipse.php.internal.server.core.builtin.PublishOperation2;
import org.eclipse.php.internal.server.core.builtin.Trace;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.IModulePublishHelper;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.PublishHelper;
import org.eclipse.wst.server.core.util.SocketUtil;

public class PHPServerBehaviour
extends ServerBehaviourDelegate
implements IPHPServerBehaviour,
IModulePublishHelper {
    private static final String ATTR_STOP = "stop-server";
    protected transient PingThread ping = null;
    protected transient IDebugEventSetListener processListener;
    private ILaunch fLaunch;
    private int fSessionId;
    private IPHPServerRunner fPHPServerRunner;

    public void stop(boolean force) {
        this.terminate();
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        PHPexeItem item = this.getPHPRuntime().getExecutableInstall();
        workingCopy.setAttribute("ATTR_LOCATION", item.getExecutable().getAbsolutePath());
        if (item.getINILocation() != null) {
            workingCopy.setAttribute("ATTR_INI_LOCATION", item.getINILocation().getAbsolutePath());
        } else {
            workingCopy.setAttribute("ATTR_INI_LOCATION", "");
        }
        workingCopy.setAttribute("name", this.getServer().getName());
        workingCopy.setAttribute("base_url", this.getPHPServer().getRootUrl().toString());
        workingCopy.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(null));
        workingCopy.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(null));
        workingCopy.setAttribute("php_debug_type", "php_web_page_debug");
    }

    protected IModuleResource[] getResources(IModule[] module) {
        return super.getResources(module);
    }

    protected IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return super.getPublishedResourceDelta(module);
    }

    public IStatus cleanServerWorkDir(IProgressMonitor monitor) throws CoreException {
        IStatus result;
        IPath basePath = this.getRuntimeBaseDirectory();
        IPath workPath = this.getPHPServerConfiguration().getServerWorkDirectory(basePath);
        if (workPath != null) {
            File[] files;
            File workDir = workPath.toFile();
            result = Status.OK_STATUS;
            if (workDir.exists() && workDir.isDirectory() && (files = workDir.listFiles()) != null && files.length > 0) {
                MultiStatus ms = new MultiStatus("org.eclipse.php.server.core", 0, "Problem occurred deleting work directory for module.", null);
                int size = files.length;
                monitor = ProgressUtil.getMonitorFor(monitor);
                monitor.beginTask(NLS.bind((String)"Cleaning Server Work Directory", (Object[])new String[]{workDir.getAbsolutePath()}), size * 10);
                int i = 0;
                while (i < size) {
                    IStatus[] results;
                    File current = files[i];
                    if (current.isDirectory() && (results = PublishHelper.deleteDirectory((File)current, (IProgressMonitor)ProgressUtil.getSubMonitorFor(monitor, 10))) != null && results.length > 0) {
                        int j = 0;
                        while (j < results.length) {
                            ms.add(results[j]);
                            ++j;
                        }
                    }
                    ++i;
                }
                monitor.done();
                result = ms;
            }
        } else {
            result = new Status(4, "org.eclipse.php.server.core", 0, "Could not determine work directory for module", null);
        }
        return result;
    }

    protected void addProcessListener(final IProcess newProcess) {
        if (this.processListener != null || newProcess == null) {
            return;
        }
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        if (newProcess != null && newProcess.equals(events[i].getSource()) && events[i].getKind() == 8) {
                            PHPServerBehaviour.this.stopImpl();
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    protected void setServerStarted() {
        this.setServerState(2);
    }

    protected void stopImpl() {
        if (this.ping != null) {
            this.ping.stop();
            this.ping = null;
        }
        if (this.processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
            this.processListener = null;
        }
        if (this.fPHPServerRunner != null) {
            this.fPHPServerRunner.stop();
            this.fPHPServerRunner = null;
        }
        this.setServerState(4);
    }

    @Override
    public void setupLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        if ("true".equals(launch.getLaunchConfiguration().getAttribute(ATTR_STOP, "false"))) {
            launch.terminate();
            this.stopImpl();
            return;
        }
        Server server = ServersManager.getServer((String)this.getServer().getName());
        PathMapper pathMapper = PathMapperRegistry.getByServer((Server)server);
        pathMapper.setMapping(this.getPHPServerConfiguration().getPathMappings());
        this.fLaunch = launch;
        IStatus status = this.getPHPRuntime().validate();
        if (status != null && status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        PHPServerConfiguration configuration = this.getPHPServerConfiguration();
        Iterator<Object> iterator = configuration.getServerPorts().iterator();
        ArrayList<ServerPort> usedPorts = new ArrayList<ServerPort>();
        while (iterator.hasNext()) {
            ServerPort sp = iterator.next();
            if (sp.getPort() < 0) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.server.core", 0, Messages.errorPortInvalid, null));
            }
            if (!SocketUtil.isPortInUse((int)sp.getPort(), (int)5)) continue;
            usedPorts.add(sp);
        }
        if (usedPorts.size() == 1) {
            ServerPort port = (ServerPort)usedPorts.get(0);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorPortInUse, (Object[])new String[]{String.valueOf(port.getPort()), this.getServer().getName()}), null));
        }
        if (usedPorts.size() > 1) {
            String portStr = "";
            iterator = usedPorts.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (!first) {
                    portStr = String.valueOf(portStr) + ", ";
                }
                first = false;
                ServerPort sp = (ServerPort)iterator.next();
                portStr = String.valueOf(portStr) + sp.getPort();
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorPortsInUse, (Object[])new String[]{portStr, this.getServer().getName()}), null));
        }
        this.setServerRestartState(false);
        this.setServerState(1);
        this.setMode(launchMode);
        if ("debug".equals(launchMode)) {
            this.fSessionId = DebugSessionIdGenerator.generateSessionID();
            int debugPort = PHPDebugPlugin.getDebugPort((String)"org.eclipse.php.debug.core.zendDebugger");
            PHPSessionLaunchMapper.put((int)this.fSessionId, (ILaunch)launch);
            launch.setAttribute("debugSessionID", String.valueOf(this.fSessionId));
            launch.setAttribute("builtinServerDebugger", "true");
            launch.setAttribute("port", String.valueOf(debugPort));
        }
        try {
            String url = "http://" + this.getServer().getHost();
            int port = configuration.getMainPort().getPort();
            if (port != 80) {
                url = String.valueOf(url) + ":" + port;
            }
            this.ping = new PingThread(this.getServer(), url, -1, this);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Can't ping for PHP Server startup.");
        }
    }

    protected void terminate() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        try {
            this.setServerState(3);
            if (Trace.isTraceEnabled()) {
                Trace.trace((byte)4, "Killing the PHP Server process");
            }
            if (this.fLaunch != null) {
                this.fLaunch.terminate();
                this.stopImpl();
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error killing the process", e);
        }
    }

    public IPath getRuntimeBaseDirectory() {
        return this.getPHPServer().getRuntimeBaseDirectory();
    }

    public PHPServer getPHPServer() {
        return (PHPServer)this.getServer().loadAdapter(PHPServer.class, null);
    }

    public PHPServerConfiguration getPHPServerConfiguration() throws CoreException {
        return this.getPHPServer().getPHPServerConfiguration();
    }

    public IPath getTempDirectory() {
        return super.getTempDirectory(false);
    }

    public IPath getPublishDirectory(IModule[] module) {
        if (module == null || module.length != 1) {
            return null;
        }
        return this.getModuleDeployDirectory(module[0]);
    }

    public IPath getModuleDeployDirectory(IModule module) {
        return this.getServerDeployDirectory().append(module.getName());
    }

    public void setModulePublishState2(IModule[] module, int state) {
        this.setModulePublishState(module, state);
    }

    public Properties loadModulePublishLocations() {
        Properties p = new Properties();
        IPath path = this.getTempDirectory().append("publish.txt");
        FileInputStream fin = null;
        try {
            try {
                fin = new FileInputStream(path.toFile());
                p.load(fin);
            }
            catch (Exception exception) {
                try {
                    fin.close();
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                fin.close();
            }
            catch (Exception exception) {}
        }
        return p;
    }

    public void saveModulePublishLocations(Properties p) {
        IPath path = this.getTempDirectory().append("publish.txt");
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(path.toFile());
                p.store(fout, "PHP Server publish data");
            }
            catch (Exception exception) {
                try {
                    fout.close();
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                fout.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setPHPServerPublishState(int state) {
        this.setServerPublishState(state);
    }

    public void setPHPServerRestartState(boolean state) {
        this.setServerRestartState(state);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getRuntime() == null) {
            return;
        }
        IPath installDir = this.getServer().getRuntime().getLocation();
        IPath confDir = null;
        confDir = installDir;
        IStatus status = PHPServerHelper.createDeploymentDirectory(this.getServerDeployDirectory());
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.beginTask(Messages.publishServerTask, 600);
        status = this.getPHPServerConfiguration().cleanupServer(confDir, installDir, false, ProgressUtil.getSubMonitorFor(monitor, 100));
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        status = this.getPHPServerConfiguration().backupAndPublish(confDir, false, ProgressUtil.getSubMonitorFor(monitor, 400));
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        status = this.getPHPServerConfiguration().localizeConfiguration(confDir, this.getServerDeployDirectory(), this.getPHPServer(), ProgressUtil.getSubMonitorFor(monitor, 100));
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        monitor.done();
        this.setServerPublishState(1);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        Properties p = this.loadModulePublishLocations();
        PublishHelper helper = new PublishHelper(this.getRuntimeBaseDirectory().append("temp").toFile());
        if (moduleTree.length == 1) {
            this.publishDir(deltaKind, p, moduleTree, helper, monitor);
        }
        this.setModulePublishState(moduleTree, 1);
        this.saveModulePublishLocations(p);
    }

    private void publishDir(int deltaKind, Properties p, IModule[] module, PublishHelper helper, IProgressMonitor monitor) throws CoreException {
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        if (deltaKind == 3) {
            String publishPath = (String)p.get(module[0].getId());
            if (publishPath != null) {
                try {
                    File f = new File(publishPath);
                    if (f.exists()) {
                        IStatus[] stat = PublishHelper.deleteDirectory((File)f, (IProgressMonitor)monitor);
                        PublishOperation2.addArrayToList(status, stat);
                    }
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorPublishCouldNotRemoveModule, (Object)module[0].getName()), (Throwable)e));
                }
                p.remove(module[0].getId());
            }
        } else {
            IPath path = this.getModuleDeployDirectory(module[0]);
            IModuleResource[] mr = this.getResources(module);
            IPath[] jarPaths = null;
            IStatus[] stat = helper.publishSmart(mr, path, jarPaths, monitor);
            PublishOperation2.addArrayToList(status, stat);
            p.put(module[0].getId(), path.toOSString());
        }
        try {
            this.processPathMapping(module, deltaKind, monitor);
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.server.core", 0, e.getMessage(), (Throwable)e));
        }
        PublishOperation2.throwException(status);
    }

    public IPath getServerDeployDirectory() {
        return this.getPHPServer().getServerDeployDirectory();
    }

    public PHPRuntime getPHPRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (PHPRuntime)this.getServer().getRuntime().loadAdapter(PHPRuntime.class, null);
    }

    private void processPathMapping(IModule[] module, int deltaKind, IProgressMonitor monitor) throws MalformedURLException, CoreException {
        Server server = ServersManager.getServer((String)this.getServer().getName());
        PathMapper pathMapper = PathMapperRegistry.getByServer((Server)server);
        HashMap<String, PathMapper.Mapping> mappings = new HashMap<String, PathMapper.Mapping>();
        IModule[] iModuleArray = module;
        int n = module.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            String moduleName = m.getName();
            if (deltaKind == 3) {
                this.getPHPServerConfiguration().setPathMapping(moduleName, new PathMapper.Mapping[0]);
                this.getPHPServer().saveConfiguration(monitor);
                pathMapper.setMapping(this.getPHPServerConfiguration().getPathMappings());
            } else {
                IProject project = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(moduleName);
                IScriptProject scriptProject = DLTKCore.create((IProject)project);
                VirtualPath remotePath = new VirtualPath(this.getModuleDeployDirectory(m).toOSString());
                IProjectFragment[] iProjectFragmentArray = scriptProject.getProjectFragments();
                int n3 = iProjectFragmentArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProjectFragment fragment = iProjectFragmentArray[n4];
                    if (!fragment.isExternal()) {
                        VirtualPath localPath = new VirtualPath(fragment.getResource().getFullPath().toString());
                        PathMapper.Mapping mapping = new PathMapper.Mapping(localPath, remotePath, PathEntry.Type.WORKSPACE, PathMapper.Mapping.MappingSource.ENVIRONMENT);
                        mappings.put(localPath.toString(), mapping);
                    }
                    ++n4;
                }
                boolean isChanged = false;
                PathMapper.Mapping[] storedMappings = this.getPHPServerConfiguration().getPathMappings(moduleName);
                if (storedMappings.length != mappings.size()) {
                    isChanged = true;
                } else {
                    int i = 0;
                    while (i < storedMappings.length) {
                        PathMapper.Mapping mapping = storedMappings[i];
                        String local = mapping.localPath.toString();
                        if (mappings.containsKey(local) && !((PathMapper.Mapping)mappings.get(local)).equals((Object)mapping)) {
                            isChanged = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (isChanged) {
                    this.getPHPServerConfiguration().setPathMapping(moduleName, mappings.values().toArray(new PathMapper.Mapping[mappings.size()]));
                    this.getPHPServer().saveConfiguration(monitor);
                    pathMapper.setMapping(this.getPHPServerConfiguration().getPathMappings());
                }
            }
            ++n2;
        }
    }

    public void setPHPServerRunner(IPHPServerRunner runner) {
        this.fPHPServerRunner = runner;
    }
}

