/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.rewrite;

import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP55;
import org.eclipse.php.core.tests.dom_ast.rewrite.NodeDeletionTestsPHP56;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

public class ASTRewriteTestsPHP56
extends ASTRewriteTestsPHP55 {
    @Override
    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP5_6;
    }

    @Test
    public void variadicParameterSet() throws Exception {
        String str = "<?php function test($tmp) {} \n ?>";
        this.initialize(str);
        List<FormalParameter> statements = this.getAllOfType(this.program, FormalParameter.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setIsVariadic(true);
        this.rewrite();
        this.checkResult("<?php function test(...$tmp) {} \n ?>");
    }

    @Test
    public void variadicParameterUnset() throws Exception {
        String str = "<?php function test(...$tmp) {} \n ?>";
        this.initialize(str);
        List<FormalParameter> statements = this.getAllOfType(this.program, FormalParameter.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setIsVariadic(false);
        this.rewrite();
        this.checkResult("<?php function test($tmp) {} \n ?>");
    }

    @Test
    public void referenceVariadicParameterSet() throws Exception {
        String str = "<?php function test(&$tmp) {} \n ?>";
        this.initialize(str);
        List<FormalParameter> statements = this.getAllOfType(this.program, FormalParameter.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setIsVariadic(true);
        this.rewrite();
        this.checkResult("<?php function test(&...$tmp) {} \n ?>");
    }

    @Test
    public void referenceVariadicParameterUnset() throws Exception {
        String str = "<?php function test(&...$tmp) {} \n ?>";
        this.initialize(str);
        List<FormalParameter> statements = this.getAllOfType(this.program, FormalParameter.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setIsVariadic(false);
        this.rewrite();
        this.checkResult("<?php function test(&$tmp) {} \n ?>");
    }

    @Test
    public void useStatementFunctionSet() throws Exception {
        String str = "<?php use Foo\\Bar; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(1);
        this.rewrite();
        this.checkResult("<?php use function Foo\\Bar; \n ?>");
    }

    @Test
    public void useStatementConstSet() throws Exception {
        String str = "<?php use Foo\\Bar; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(2);
        this.rewrite();
        this.checkResult("<?php use const Foo\\Bar; \n ?>");
    }

    @Test
    public void useStatementNoneSet() throws Exception {
        String str = "<?php use function Foo\\Bar; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use Foo\\Bar; \n ?>");
    }

    @Test
    public void useStatementManyPartsConstSet() throws Exception {
        String str = "<?php use function Foo\\Bar, Foo\\Bar2; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(2);
        this.rewrite();
        this.checkResult("<?php use const Foo\\Bar, Foo\\Bar2; \n ?>");
    }

    @Test
    public void useStatementManyPartsNoneSet() throws Exception {
        String str = "<?php use function Foo\\Bar, Foo\\Bar2; \n ?>";
        this.initialize(str);
        List<UseStatement> statements = this.getAllOfType(this.program, UseStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setStatementType(0);
        this.rewrite();
        this.checkResult("<?php use Foo\\Bar, Foo\\Bar2; \n ?>");
    }

    @RunWith(value=org.junit.runners.Suite.class)
    @Suite.SuiteClasses(value={ASTRewriteTestsPHP56.class, NodeDeletionTestsPHP56.class})
    public static class Suite {
    }
}

