/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;

public class UsePart
extends ASTNode {
    private FullyQualifiedReference namespace;
    private FullyQualifiedReference groupNamespace;
    private SimpleReference alias;
    private int statementType;

    public UsePart(FullyQualifiedReference namespace, SimpleReference alias) {
        this(null, namespace, alias, 0);
    }

    public UsePart(FullyQualifiedReference groupNamespace, FullyQualifiedReference namespace, SimpleReference alias) {
        this(groupNamespace, namespace, alias, 0);
    }

    public UsePart(FullyQualifiedReference namespace, SimpleReference alias, int statementType) {
        this(null, namespace, alias, statementType);
    }

    public UsePart(FullyQualifiedReference groupNamespace, FullyQualifiedReference namespace, SimpleReference alias, int statementType) {
        this.setGroupNamespace(groupNamespace);
        this.setNamespace(namespace);
        this.setAlias(alias);
        this.statementType = statementType;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[USE: ").append(this.getNamespace().getFullyQualifiedName());
        if (this.getAlias() != null) {
            buf.append(" AS ").append(this.getAlias().getName());
        }
        buf.append("]");
        return buf.toString();
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            this.getNamespace().traverse(visitor);
            if (this.getAlias() != null) {
                this.getAlias().traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public void setAlias(SimpleReference alias) {
        this.alias = alias;
    }

    public SimpleReference getAlias() {
        return this.alias;
    }

    public void setGroupNamespace(FullyQualifiedReference groupNamespace) {
        this.groupNamespace = groupNamespace;
    }

    public FullyQualifiedReference getGroupNamespace() {
        return this.groupNamespace;
    }

    public void setNamespace(FullyQualifiedReference namespace) {
        this.namespace = namespace;
    }

    public FullyQualifiedReference getNamespace() {
        return this.namespace;
    }

    public void setStatementType(int statementType) {
        this.statementType = statementType;
    }

    public int getStatementType() {
        return this.statementType;
    }
}

