/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractUseStatementASTVisitor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class FindUseStatementByNamespaceASTVisitor
extends AbstractUseStatementASTVisitor {
    private UseStatement currentUseStatement;
    private String namespace;
    private UsePart result;

    @Override
    protected void visit(UseStatement s) throws Exception {
        this.currentUseStatement = s;
        super.visit(s);
    }

    public boolean endvisit(Statement s) throws Exception {
        if (s instanceof UseStatement) {
            this.currentUseStatement = null;
        }
        return super.endvisit(s);
    }

    public FindUseStatementByNamespaceASTVisitor(String namespace, int offset) {
        super(offset);
        this.namespace = namespace;
    }

    public UsePart getResult() {
        return this.result;
    }

    @Override
    protected boolean visit(UsePart usePart) {
        String ns = PHPModelUtils.concatFullyQualifiedNames(this.currentUseStatement, usePart);
        if (this.namespace.equalsIgnoreCase(ns)) {
            boolean isGroupStatement;
            boolean bl = isGroupStatement = this.currentUseStatement != null && this.currentUseStatement.getNamespace() != null && usePart.getGroupNamespace() != null;
            if (isGroupStatement) {
                FullyQualifiedReference fqn = ASTUtils.createFakeGroupUseType(usePart);
                this.result = new UsePart(fqn, usePart.getAlias(), Math.max(this.currentUseStatement.getStatementType(), usePart.getStatementType()));
            } else {
                this.result = usePart;
            }
            return false;
        }
        return true;
    }
}

