/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006, 2017 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.documentModel.parser.php5;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag.TagKind;

@SuppressWarnings({"unused", "nls"})


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>highlighting_scanner.jflex</tt>
 */
public class PHPLexer extends org.eclipse.php.internal.core.documentModel.parser.AbstractPHPLexer {

	/** This character denotes the end of file */
	public static final int YYEOF = -1;

	/** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

	/** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_PHP_IN_SCRIPTING = 2;
  public static final int ST_PHP_DOUBLE_QUOTES = 4;
  public static final int ST_PHP_SINGLE_QUOTE = 6;
  public static final int ST_PHP_BACKQUOTE = 8;
  public static final int ST_PHP_QUOTES_AFTER_VARIABLE = 10;
  public static final int ST_PHP_HEREDOC = 12;
  public static final int ST_PHP_START_HEREDOC = 14;
  public static final int ST_PHP_END_HEREDOC = 16;
  public static final int ST_PHP_LOOKING_FOR_PROPERTY = 18;
  public static final int ST_PHP_VAR_OFFSET = 20;
  public static final int ST_PHP_COMMENT = 22;
  public static final int ST_PHP_DOC_COMMENT = 24;
  public static final int ST_PHP_LINE_COMMENT = 26;
  public static final int ST_PHP_HIGHLIGHTING_ERROR = 28;
  public static final int ST_PHP_DOLLAR_CURLY_OPEN = 30;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\11\2\0\1\15\22\0\1\12\1\26\1\17\1\74"+
    "\1\16\1\32\1\33\1\73\1\62\1\64\1\30\1\25\1\13\1\4"+
    "\1\2\1\31\1\5\11\1\1\60\1\14\1\27\1\23\1\24\1\75"+
    "\1\76\1\40\1\7\1\47\1\42\1\3\1\45\1\63\1\52\1\100"+
    "\1\65\1\102\1\54\1\57\1\41\1\36\1\56\1\67\1\37\1\101"+
    "\1\44\1\46\1\61\1\53\1\6\1\51\1\77\1\71\1\20\1\72"+
    "\1\35\1\66\1\21\1\40\1\7\1\47\1\42\1\3\1\45\1\63"+
    "\1\52\1\100\1\65\1\102\1\54\1\57\1\41\1\36\1\56\1\67"+
    "\1\37\1\101\1\44\1\46\1\61\1\53\1\6\1\51\1\77\1\22"+
    "\1\34\1\70\1\13\261\10\2\43\115\10\1\50\u1faa\10\1\55\uded5\10"+
    "\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\20\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\11\0\1\2\1\3\1\4\1\5\1\4"+
    "\1\3\3\5\1\6\1\4\1\7\1\4\1\10\1\11"+
    "\1\12\12\4\16\5\1\4\1\5\1\4\2\5\1\13"+
    "\1\14\1\15\1\4\1\1\1\16\1\17\4\16\1\1"+
    "\3\16\3\20\2\1\3\2\2\21\2\2\1\0\1\2"+
    "\1\22\1\23\1\22\1\3\1\24\1\3\1\25\1\24"+
    "\1\5\1\26\2\27\4\30\3\31\3\32\1\33\1\34"+
    "\1\35\1\36\2\3\1\37\6\5\1\40\2\0\1\5"+
    "\2\41\2\0\1\16\2\0\2\37\1\42\1\43\1\37"+
    "\4\5\1\44\3\5\1\45\2\5\1\46\26\5\1\47"+
    "\1\5\12\0\2\5\2\0\1\50\3\0\1\51\2\52"+
    "\1\53\1\54\1\52\4\0\2\52\1\55\3\0\1\1"+
    "\2\52\1\0\1\56\3\0\1\57\4\0\1\60\1\51"+
    "\1\61\1\0\1\62\1\63\1\64\1\65\1\66\1\36"+
    "\7\5\1\3\1\0\1\5\1\41\1\0\1\67\4\5"+
    "\1\70\3\5\1\71\6\5\1\72\1\5\1\73\5\5"+
    "\1\74\16\5\1\75\12\0\6\5\1\76\1\77\1\1"+
    "\1\0\1\57\2\0\2\100\1\101\6\5\1\102\1\103"+
    "\1\5\1\104\1\5\1\41\1\0\1\105\4\5\1\106"+
    "\7\5\1\107\2\5\1\110\7\5\1\111\2\5\1\112"+
    "\3\5\1\113\5\5\12\0\7\5\1\114\2\5\1\115"+
    "\4\5\1\116\1\117\1\120\2\121\3\5\1\122\5\5"+
    "\1\123\1\5\1\124\1\5\1\125\1\126\1\5\1\127"+
    "\1\5\1\130\1\131\1\132\1\133\2\5\1\134\1\5"+
    "\1\135\3\5\7\0\1\136\2\0\11\5\1\137\2\5"+
    "\1\140\1\141\13\5\1\142\1\143\2\5\1\144\1\145"+
    "\4\0\1\146\6\5\1\147\4\5\1\150\1\5\1\151"+
    "\1\152\1\5\1\153\2\5\1\154\3\5\1\155\2\0"+
    "\11\5\1\156\1\5\1\157\4\5\1\160\1\161\1\5"+
    "\1\162\3\5\1\163\3\5\1\164\1\5\1\165\3\5"+
    "\1\166\1\5\1\167\2\5\1\170\1\171\2\5\1\172"+
    "\1\173\2\5\1\174\4\5\1\175\1\176\1\177\3\5"+
    "\1\200";

  private static int [] zzUnpackAction() {
    int [] result = new int[552];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\103\0\206\0\311\0\u010c\0\u014f\0\u0192\0\u01d5"+
    "\0\u0218\0\u025b\0\u029e\0\u02e1\0\u0324\0\u0367\0\u03aa\0\u03ed"+
    "\0\0\0\u0430\0\u0473\0\u04b6\0\u04f9\0\u053c\0\u057f\0\u05c2"+
    "\0\u0605\0\u0648\0\0\0\0\0\u068b\0\u06ce\0\0\0\u0711"+
    "\0\u0754\0\u0797\0\u07da\0\u081d\0\u0860\0\u08a3\0\u08e6\0\u0929"+
    "\0\u096c\0\u09af\0\u09f2\0\u0a35\0\u0a78\0\u0abb\0\u0afe\0\u0b41"+
    "\0\u0b84\0\u0bc7\0\u0c0a\0\u0c4d\0\u0c90\0\u0cd3\0\u0d16\0\u0d59"+
    "\0\u0d9c\0\u0ddf\0\u0e22\0\u0e65\0\u0ea8\0\u0eeb\0\u0f2e\0\0"+
    "\0\u0f71\0\u0fb4\0\u0ff7\0\0\0\u103a\0\u107d\0\u10c0\0\u1103"+
    "\0\u1146\0\u1189\0\u11cc\0\u120f\0\0\0\u1252\0\u1295\0\u12d8"+
    "\0\u131b\0\u135e\0\u13a1\0\u13e4\0\0\0\u1427\0\u146a\0\u14ad"+
    "\0\u14f0\0\u14f0\0\0\0\u1533\0\u1576\0\u15b9\0\0\0\u15fc"+
    "\0\0\0\u163f\0\u1682\0\0\0\u16c5\0\u1708\0\0\0\u174b"+
    "\0\u178e\0\u17d1\0\u1814\0\0\0\u1857\0\0\0\u189a\0\u0f71"+
    "\0\0\0\u18dd\0\u1920\0\u1963\0\u19a6\0\u19e9\0\0\0\u1a2c"+
    "\0\u1a6f\0\u1ab2\0\u1af5\0\u1b38\0\u1b7b\0\0\0\u1bbe\0\u1c01"+
    "\0\u1c44\0\u1c87\0\u1cca\0\u06ce\0\u1d0d\0\0\0\u1d50\0\u1d93"+
    "\0\u08a3\0\u1dd6\0\u1e19\0\0\0\u0605\0\u1e5c\0\u1e9f\0\u1ee2"+
    "\0\u1f25\0\u0605\0\u1f68\0\u1fab\0\u1fee\0\u0605\0\u2031\0\u2074"+
    "\0\u0605\0\u20b7\0\u20fa\0\u213d\0\u2180\0\u21c3\0\u2206\0\u2249"+
    "\0\u228c\0\u22cf\0\u2312\0\u2355\0\u2398\0\u23db\0\u241e\0\u2461"+
    "\0\u24a4\0\u24e7\0\u252a\0\u256d\0\u25b0\0\u25f3\0\u2636\0\0"+
    "\0\u2679\0\u26bc\0\u0e22\0\u26ff\0\u2742\0\u2785\0\u27c8\0\u280b"+
    "\0\u284e\0\u2891\0\u28d4\0\u2917\0\u295a\0\u0f2e\0\u299d\0\0"+
    "\0\u29e0\0\u103a\0\u2a23\0\u2a66\0\u29e0\0\0\0\0\0\0"+
    "\0\u2a23\0\u2aa9\0\u2aec\0\u11cc\0\u2b2f\0\u2aec\0\u2b2f\0\0"+
    "\0\u2b72\0\u13a1\0\u2bb5\0\u2bf8\0\u2b72\0\u2bb5\0\u1427\0\0"+
    "\0\u2c3b\0\u2c7e\0\u2cc1\0\0\0\u2d04\0\u2d47\0\u2d8a\0\u146a"+
    "\0\0\0\u2dcd\0\0\0\u2e10\0\0\0\u17d1\0\0\0\u2e53"+
    "\0\u2e96\0\u2ed9\0\u2f1c\0\u2f5f\0\u2fa2\0\u2fe5\0\u3028\0\u306b"+
    "\0\u30ae\0\u1bbe\0\u30f1\0\u3134\0\u3177\0\u31ba\0\u31fd\0\u3240"+
    "\0\u3283\0\u32c6\0\u3309\0\u0605\0\u334c\0\u338f\0\u33d2\0\u0605"+
    "\0\u3415\0\u3458\0\u349b\0\u34de\0\u3521\0\u3564\0\u0605\0\u35a7"+
    "\0\u35ea\0\u362d\0\u3670\0\u36b3\0\u36f6\0\u3739\0\u0605\0\u377c"+
    "\0\u37bf\0\u3802\0\u3845\0\u3888\0\u38cb\0\u390e\0\u3951\0\u3994"+
    "\0\u39d7\0\u3a1a\0\u3a5d\0\u3aa0\0\u3ae3\0\u0605\0\u3b26\0\u3b69"+
    "\0\u3bac\0\u3bef\0\u3c32\0\u3c75\0\u3cb8\0\u3cfb\0\u3d3e\0\u3d81"+
    "\0\u3dc4\0\u3e07\0\u3e4a\0\u3e8d\0\u3ed0\0\u3f13\0\0\0\0"+
    "\0\u3f56\0\u14ad\0\u146a\0\u3f99\0\u3fdc\0\0\0\u401f\0\u0605"+
    "\0\u4062\0\u40a5\0\u40e8\0\u412b\0\u416e\0\u41b1\0\u0605\0\u41f4"+
    "\0\u4237\0\u0605\0\u427a\0\u42bd\0\u4300\0\0\0\u4343\0\u4386"+
    "\0\u43c9\0\u440c\0\u0605\0\u444f\0\u4492\0\u44d5\0\u4518\0\u455b"+
    "\0\u459e\0\u45e1\0\u0605\0\u4624\0\u4667\0\u0605\0\u46aa\0\u46ed"+
    "\0\u4730\0\u4773\0\u47b6\0\u47f9\0\u483c\0\u0605\0\u487f\0\u48c2"+
    "\0\u0605\0\u4905\0\u4948\0\u498b\0\u0605\0\u49ce\0\u4a11\0\u4a54"+
    "\0\u4a97\0\u4ada\0\u4b1d\0\u4b60\0\u4ba3\0\u4be6\0\u4c29\0\u4c6c"+
    "\0\u4caf\0\u4cf2\0\u4d35\0\u4d78\0\u4dbb\0\u4dfe\0\u4e41\0\u4e84"+
    "\0\u4ec7\0\u4f0a\0\u4f4d\0\0\0\u4f90\0\u4fd3\0\u0605\0\u5016"+
    "\0\u5059\0\u509c\0\u50df\0\u0605\0\u0605\0\u1c87\0\0\0\u5122"+
    "\0\u5165\0\u51a8\0\u51eb\0\u0605\0\u522e\0\u5271\0\u52b4\0\u52f7"+
    "\0\u533a\0\u0605\0\u537d\0\u0605\0\u53c0\0\u0605\0\u0605\0\u5403"+
    "\0\u0605\0\u5446\0\u0605\0\u0605\0\u0605\0\u0605\0\u5489\0\u54cc"+
    "\0\u0605\0\u550f\0\u0605\0\u5552\0\u5595\0\u55d8\0\u561b\0\u565e"+
    "\0\u56a1\0\u56e4\0\u5727\0\u576a\0\u57ad\0\0\0\u57f0\0\u5833"+
    "\0\u5876\0\u58b9\0\u58fc\0\u593f\0\u5982\0\u59c5\0\u5a08\0\u5a4b"+
    "\0\u5a8e\0\u5ad1\0\u5b14\0\u5b57\0\u0605\0\u0605\0\u5b9a\0\u5bdd"+
    "\0\u5c20\0\u5c63\0\u5ca6\0\u5ce9\0\u5d2c\0\u5d6f\0\u5db2\0\u5df5"+
    "\0\u5e38\0\u0605\0\u0605\0\u5e7b\0\u5ebe\0\u0605\0\u0605\0\u5f01"+
    "\0\u5f44\0\u5f87\0\u5fca\0\u0605\0\u600d\0\u6050\0\u6093\0\u60d6"+
    "\0\u6119\0\u615c\0\u0605\0\u619f\0\u61e2\0\u6225\0\u6268\0\u62ab"+
    "\0\u62ee\0\u0605\0\u0605\0\u6331\0\u6374\0\u63b7\0\u63fa\0\u0605"+
    "\0\u643d\0\u6480\0\u64c3\0\u0605\0\u6506\0\u6549\0\u658c\0\u65cf"+
    "\0\u6612\0\u6655\0\u6698\0\u66db\0\u671e\0\u6761\0\u67a4\0\u0605"+
    "\0\u67e7\0\u0605\0\u682a\0\u686d\0\u68b0\0\u68f3\0\u0605\0\u0605"+
    "\0\u6936\0\u0605\0\u6979\0\u69bc\0\u69ff\0\u0605\0\u6a42\0\u6a85"+
    "\0\u6ac8\0\u0605\0\u6b0b\0\u0605\0\u6b4e\0\u6b91\0\u6bd4\0\u0605"+
    "\0\u6c17\0\u0605\0\u6c5a\0\u6c9d\0\u0605\0\u0605\0\u6ce0\0\u6d23"+
    "\0\u0605\0\u0605\0\u6d66\0\u6da9\0\u0605\0\u6dec\0\u6e2f\0\u6e72"+
    "\0\u6eb5\0\u0605\0\u0605\0\u0605\0\u6ef8\0\u6f3b\0\u6f7e\0\u0605";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[552];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\103\0\1\21\1\22\1\23\1\24\1\25\1\26\1\27"+
    "\1\30\1\31\2\32\1\33\1\34\1\32\1\35\1\36"+
    "\1\21\1\37\1\40\1\41\1\42\1\43\1\44\1\45"+
    "\1\46\1\47\1\50\1\51\1\52\1\46\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\2\31\1\66\1\67\1\31\1\70\1\31\1\71"+
    "\1\72\1\73\1\74\1\33\1\31\1\75\1\31\1\76"+
    "\2\33\1\77\1\100\1\101\1\33\1\31\1\60\1\65"+
    "\1\31\16\102\1\103\1\104\1\105\1\102\1\106\60\102"+
    "\20\107\1\110\52\107\1\104\7\107\16\111\1\112\1\111"+
    "\1\113\1\104\1\114\60\111\4\115\1\116\15\115\1\117"+
    "\60\115\11\120\1\121\3\120\1\121\1\122\1\120\1\123"+
    "\1\120\1\124\60\120\3\125\1\126\2\125\3\126\25\125"+
    "\22\126\1\125\1\126\1\125\1\126\1\125\3\126\7\125"+
    "\4\126\3\127\1\130\2\127\3\130\1\131\3\127\1\132"+
    "\20\127\22\130\1\127\1\130\1\127\1\130\1\127\3\130"+
    "\7\127\4\130\3\133\1\134\1\135\1\133\3\134\25\133"+
    "\22\134\1\133\1\134\1\133\1\134\1\133\3\134\7\133"+
    "\4\134\1\21\1\136\1\137\1\31\1\137\1\140\3\31"+
    "\2\141\2\137\1\141\1\142\1\137\1\141\15\137\3\31"+
    "\1\143\16\31\1\137\1\31\1\137\1\31\1\137\3\31"+
    "\1\137\1\33\1\144\2\141\2\137\4\31\30\145\1\146"+
    "\52\145\22\147\1\150\5\147\1\151\45\147\1\152\4\147"+
    "\11\153\1\154\3\153\1\155\6\153\1\156\5\153\1\157"+
    "\42\153\1\160\5\153\11\161\2\162\2\161\1\162\65\161"+
    "\3\21\1\163\2\21\3\163\1\0\10\21\1\164\13\21"+
    "\22\163\1\21\1\163\1\21\1\163\1\21\3\163\7\21"+
    "\4\163\1\0\1\22\1\165\1\166\1\0\1\22\76\0"+
    "\1\165\3\0\1\165\15\0\1\167\60\0\1\31\1\0"+
    "\1\31\1\0\1\31\1\170\2\31\25\0\3\31\1\171"+
    "\5\31\1\172\4\31\1\173\2\31\1\174\1\0\1\175"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\4\0\1\167"+
    "\16\0\1\167\1\176\57\0\1\22\1\165\1\166\1\0"+
    "\1\22\1\177\75\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\1\53\21\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\6\0\1\36\7\0\1\200\6\0\1\31\1\201"+
    "\20\31\1\0\1\31\1\0\1\31\1\0\3\31\3\0"+
    "\1\77\3\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\22\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\11\0\2\32\2\0\1\32\70\0"+
    "\1\202\2\0\3\202\25\0\6\202\1\203\13\202\1\0"+
    "\1\202\1\0\1\202\1\0\3\202\7\0\4\202\16\204"+
    "\1\205\1\206\1\207\1\204\1\210\60\204\11\0\2\40"+
    "\2\0\1\40\110\0\1\211\1\167\101\0\1\167\1\211"+
    "\101\0\1\167\1\0\1\167\100\0\1\211\102\0\2\167"+
    "\2\0\1\212\76\0\1\167\102\0\1\167\4\0\1\213"+
    "\1\100\74\0\1\167\1\214\101\0\1\167\7\0\1\167"+
    "\72\0\1\167\10\0\1\167\47\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\1\31\1\215\20\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\216\1\0\4\31\25\0\22\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\2\31\1\217\1\31\25\0\1\31"+
    "\1\220\1\31\1\221\6\31\1\222\7\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\2\31\1\222\1\31"+
    "\1\0\1\31\1\0\1\223\1\0\4\31\25\0\10\31"+
    "\1\224\11\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\225\1\0\4\31"+
    "\25\0\1\226\4\31\1\227\14\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\1\31\1\227\2\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\3\31\1\230"+
    "\3\31\1\231\2\31\1\232\6\31\1\233\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\2\31\1\232\1\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\1\31"+
    "\1\234\12\31\1\235\5\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\1\236\1\237\1\240\2\31\1\241"+
    "\2\31\1\242\11\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\1\31\1\241\2\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\3\31\1\243\6\31\1\244"+
    "\7\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\2\31\1\244\1\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\1\245\1\31\1\246\13\31\1\247\3\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\250\1\0\4\31\25\0\6\31"+
    "\1\251\6\31\1\252\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\14\31\1\253\5\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\5\31\1\254\14\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\1\31"+
    "\1\254\2\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\1\31\1\255\1\256\5\31\1\257\11\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\60\0"+
    "\1\260\23\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\2\31\1\261\17\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\7\0\1\262\2\0\1\263\23\0"+
    "\1\264\1\265\1\266\1\0\1\267\1\270\1\0\1\271"+
    "\1\272\1\0\1\273\27\0\1\270\1\273\2\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\16\31\1\274\3\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\22\31"+
    "\1\0\1\31\1\0\1\31\1\0\1\31\1\275\1\31"+
    "\7\0\4\31\11\0\2\76\2\0\1\76\65\0\20\276"+
    "\1\277\52\276\1\206\7\276\24\0\1\300\56\0\16\102"+
    "\1\301\1\0\1\302\1\102\1\303\63\102\1\304\2\102"+
    "\3\304\5\102\1\305\1\306\1\302\1\102\1\307\13\102"+
    "\22\304\1\102\1\304\1\102\1\304\1\102\3\304\7\102"+
    "\4\304\121\102\1\310\1\306\1\302\1\102\1\311\60\102"+
    "\20\107\1\312\52\107\1\0\27\107\1\206\52\107\1\206"+
    "\7\107\16\111\1\313\1\111\1\314\1\0\1\315\63\111"+
    "\1\304\2\111\3\304\5\111\1\316\1\111\1\314\1\306"+
    "\1\307\13\111\22\304\1\111\1\304\1\111\1\304\1\111"+
    "\3\304\7\111\4\304\121\111\1\310\1\111\1\314\1\306"+
    "\1\317\60\111\24\0\1\320\74\0\1\310\64\0\11\120"+
    "\1\121\3\120\1\121\1\321\1\120\1\322\1\120\1\323"+
    "\63\120\1\324\2\120\3\324\1\121\3\120\1\121\1\321"+
    "\1\120\1\322\1\120\1\323\13\120\22\324\1\120\1\324"+
    "\1\120\1\324\1\120\3\324\7\120\4\324\3\120\1\304"+
    "\2\120\3\304\1\121\3\120\1\121\1\325\1\120\1\322"+
    "\1\120\1\307\13\120\22\304\1\120\1\304\1\120\1\304"+
    "\1\120\3\304\7\120\4\304\11\120\1\121\3\120\1\121"+
    "\76\120\1\121\3\120\1\121\1\310\1\120\1\322\1\120"+
    "\1\326\60\120\1\0\1\327\1\0\1\327\1\0\4\327"+
    "\1\330\2\0\1\331\1\330\20\0\22\327\1\0\1\327"+
    "\1\0\1\327\1\0\3\327\7\0\4\327\11\332\1\0"+
    "\2\332\2\0\66\332\1\333\1\332\1\333\1\332\4\333"+
    "\1\334\2\332\1\335\1\334\20\332\22\333\1\332\1\333"+
    "\1\332\1\333\1\332\3\333\7\332\4\333\3\336\1\337"+
    "\2\336\3\337\1\131\2\336\1\340\1\131\20\336\22\337"+
    "\1\336\1\337\1\336\1\337\1\336\3\337\7\336\4\337"+
    "\1\0\1\134\1\0\1\134\1\0\4\134\25\0\22\134"+
    "\1\0\1\134\1\0\1\134\1\0\3\134\7\0\4\134"+
    "\24\0\1\341\57\0\1\136\3\0\1\136\76\0\1\136"+
    "\3\0\1\136\1\177\77\0\1\342\2\0\3\342\25\0"+
    "\22\342\1\0\1\342\1\0\1\342\1\0\3\342\7\0"+
    "\4\342\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\10\31\1\224\11\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\30\145\1\0\52\145\31\0\1\343"+
    "\147\0\1\344\35\0\1\345\54\0\2\346\1\0\2\346"+
    "\26\0\5\346\1\0\4\346\1\0\4\346\1\0\2\346"+
    "\1\0\1\346\1\0\1\346\1\0\1\346\1\0\1\346"+
    "\7\0\4\346\11\153\1\154\3\153\1\154\6\153\1\154"+
    "\5\153\1\154\42\153\1\154\5\153\11\0\1\347\115\0"+
    "\1\350\67\0\2\162\2\0\1\162\66\0\1\163\1\0"+
    "\1\163\1\0\4\163\25\0\22\163\1\0\1\163\1\0"+
    "\1\163\1\0\3\163\7\0\4\163\3\0\1\351\2\0"+
    "\3\351\2\352\2\0\1\352\20\0\22\351\1\0\1\351"+
    "\1\0\1\351\1\0\3\351\7\0\4\351\1\0\1\165"+
    "\1\0\1\166\1\0\1\165\76\0\1\136\2\0\2\136"+
    "\17\0\1\136\56\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\5\31\1\353\1\354\13\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\1\31\1\353\2\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\4\31\1\355"+
    "\15\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\14\31\1\356\5\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\12\31\1\357\7\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\2\31\1\357\1\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\20\31\1\360"+
    "\1\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\2\31\1\361\17\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\362\1\0\1\362\1\0"+
    "\1\362\1\0\1\362\30\0\1\362\1\0\1\362\2\0"+
    "\1\362\1\0\1\362\62\0\1\363\54\0\1\31\1\0"+
    "\1\364\1\0\4\31\25\0\22\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\202\1\0"+
    "\1\202\1\0\4\202\25\0\22\202\1\0\1\202\1\0"+
    "\1\202\1\0\3\202\7\0\4\202\1\0\1\202\1\0"+
    "\1\202\1\0\4\202\25\0\14\202\1\365\5\202\1\0"+
    "\1\202\1\0\1\202\1\0\3\202\7\0\4\202\3\204"+
    "\1\0\2\204\3\0\5\204\1\205\1\206\1\207\1\204"+
    "\1\0\13\204\22\0\1\204\1\0\1\204\1\0\1\204"+
    "\3\0\7\204\4\0\121\204\1\0\1\206\1\207\1\204"+
    "\1\210\60\204\23\0\1\167\3\0\1\366\103\0\1\367"+
    "\53\0\1\31\1\0\1\31\1\0\4\31\25\0\6\31"+
    "\1\370\13\31\1\0\1\31\1\0\1\31\1\0\2\31"+
    "\1\371\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\12\31\1\372\7\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\2\31\1\372\1\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\1\31\1\373"+
    "\20\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\4\31\1\215\15\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\15\31\1\374\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\16\31\1\375\3\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\7\31\1\376"+
    "\1\31\1\377\10\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\u0100\1\0"+
    "\4\31\25\0\22\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\6\31\1\u0101\2\31\1\u0102\1\u0103\7\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\2\31"+
    "\1\u0103\1\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\12\31\1\u0104\7\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\2\31\1\u0104\1\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\20\31\1\u0105\1\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\10\31"+
    "\1\u0106\2\31\1\u0107\6\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\1\31\1\u0108\20\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\1\31\1\u0109\20\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\1\u010a"+
    "\21\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\16\31\1\u010b\3\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\3\31\1\u010c\16\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\3\31\1\u010d\16\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\12\31\1\u010e"+
    "\7\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\2\31\1\u010e\1\31\1\0\1\31\1\0\1\u010f\1\0"+
    "\4\31\25\0\22\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\3\31\1\u0110\16\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\6\31\1\u0111\3\31\1\u0112"+
    "\7\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\2\31\1\u0112\1\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\1\u0113\1\31\1\u0114\17\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\16\31\1\u0115\3\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\2\31"+
    "\1\u0116\17\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\5\31\1\u0117\14\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\1\31\1\u0117\2\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\5\31\1\u0118\14\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\1\31"+
    "\1\u0118\2\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\12\31\1\u0119\7\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\2\31\1\u0119\1\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\1\u011a\4\31\1\u011b"+
    "\14\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\1\31\1\u011b\2\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\1\31\1\u011c\20\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\2\31\1\u011d\1\31\25\0\22\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\1\31\1\u011e"+
    "\20\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\36\0\1\u011f\4\0\1\u0120\34\0\1\u0120\11\0"+
    "\1\u0121\76\0\1\u0122\136\0\1\u0123\101\0\1\u0124\105\0"+
    "\1\u0125\115\0\1\u0126\67\0\1\u0127\105\0\1\u0128\37\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\1\u0129\21\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\7\31"+
    "\1\u012a\1\31\1\u012b\2\31\1\u012c\1\31\1\u012d\2\31"+
    "\1\u012e\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\103\276\3\102\1\0\2\102\3\0\5\102\1\305"+
    "\1\306\1\302\1\102\1\0\13\102\22\0\1\102\1\0"+
    "\1\102\1\0\1\102\3\0\7\102\4\0\16\102\1\0"+
    "\1\306\1\302\1\102\1\311\60\102\1\0\1\304\1\0"+
    "\1\304\1\0\4\304\25\0\22\304\1\0\1\304\1\0"+
    "\1\304\1\0\3\304\1\0\1\u012f\5\0\4\304\20\107"+
    "\1\0\52\107\1\0\7\107\3\111\1\0\2\111\3\0"+
    "\5\111\1\316\1\111\1\314\1\306\1\0\13\111\22\0"+
    "\1\111\1\0\1\111\1\0\1\111\3\0\7\111\4\0"+
    "\16\111\1\0\1\111\1\314\1\306\1\317\60\111\3\120"+
    "\1\0\2\120\3\0\1\121\3\120\1\121\1\325\1\120"+
    "\1\322\1\120\1\0\13\120\22\0\1\120\1\0\1\120"+
    "\1\0\1\120\3\0\7\120\4\0\11\120\1\121\3\120"+
    "\1\121\1\0\1\120\1\322\1\120\1\326\61\120\1\324"+
    "\1\120\1\324\1\120\4\324\1\u0130\2\120\1\u0131\1\u0130"+
    "\1\321\1\120\1\322\1\120\1\323\13\120\22\324\1\120"+
    "\1\324\1\120\1\324\1\120\3\324\7\120\4\324\11\0"+
    "\1\330\3\0\1\330\65\0\3\340\1\u0132\2\340\3\u0132"+
    "\25\340\22\u0132\1\340\1\u0132\1\340\1\u0132\1\340\3\u0132"+
    "\7\340\4\u0132\1\340\1\u0132\1\340\1\u0132\1\340\4\u0132"+
    "\1\u0133\2\340\1\u0134\1\u0133\20\340\22\u0132\1\340\1\u0132"+
    "\1\340\1\u0132\1\340\3\u0132\7\340\4\u0132\11\0\1\334"+
    "\3\0\1\334\65\0\3\336\1\337\2\336\3\337\1\340"+
    "\2\336\2\340\20\336\22\337\1\336\1\337\1\336\1\337"+
    "\1\336\3\337\7\336\4\337\1\336\1\337\1\336\1\337"+
    "\1\336\4\337\1\u0133\2\336\1\u0134\1\u0133\20\336\22\337"+
    "\1\336\1\337\1\336\1\337\1\336\3\337\7\336\4\337"+
    "\1\0\1\342\1\0\1\342\1\0\4\342\25\0\22\342"+
    "\1\0\1\342\1\0\1\342\1\0\3\342\7\0\4\342"+
    "\3\0\2\u0135\1\0\2\u0135\26\0\5\u0135\1\0\4\u0135"+
    "\1\0\4\u0135\1\0\2\u0135\1\0\1\u0135\1\0\1\u0135"+
    "\1\0\1\u0135\1\0\1\u0135\7\0\4\u0135\11\0\1\u0136"+
    "\3\0\1\u0137\66\0\1\351\1\0\1\351\1\0\4\351"+
    "\25\0\22\351\1\0\1\351\1\0\1\351\1\0\3\351"+
    "\7\0\4\351\11\0\2\352\2\0\1\352\66\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\6\31\1\u0138\13\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\u0139\1\0\4\31\25\0\22\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\4\31"+
    "\1\u013a\1\u013b\1\31\1\u013c\2\31\1\u013d\2\31\1\u013e"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\1\31\1\u013b\1\u013d\1\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\1\u013f\21\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\u0140\1\0\4\31\25\0\22\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\6\31\1\u0141\13\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\16\31\1\u0142"+
    "\3\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\27\0\1\366\54\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\2\31\1\u0143\17\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\202\1\0"+
    "\1\202\1\0\4\202\25\0\5\202\1\u0144\14\202\1\0"+
    "\1\202\1\0\1\202\1\0\3\202\7\0\1\202\1\u0144"+
    "\2\202\3\0\1\u0145\2\0\3\u0145\1\0\1\366\23\0"+
    "\22\u0145\1\0\1\u0145\1\0\1\u0145\1\0\3\u0145\7\0"+
    "\4\u0145\31\0\1\u0146\52\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\10\31\1\u0147\11\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\10\31\1\u0148\11\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\6\31\1\u0149"+
    "\13\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\2\31\1\u014a\17\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\16\31\1\u014b\3\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\2\31\1\u014c\17\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\16\31\1\u014d"+
    "\3\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\u014e\1\0\4\31\25\0"+
    "\22\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\16\31\1\u014f\3\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\6\31\1\u0150\13\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\u0151\1\0\4\31\25\0\22\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\16\31\1\u0152\3\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\u0153\1\0\4\31\25\0\22\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\1\u0154\21\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\u0155\1\0\4\31\25\0\22\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\21\31"+
    "\1\u0156\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\12\31\1\u0157\7\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\2\31\1\u0157\1\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\2\31\1\u0158\17\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\11\31\1\u0159"+
    "\10\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\u015a\1\0\4\31\25\0"+
    "\22\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\6\31\1\u015b\3\31\1\u015c\7\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\2\31\1\u015c\1\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\11\31\1\u015d"+
    "\10\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\u015e\1\0\4\31\25\0"+
    "\22\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\3\31\1\u015f\16\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\12\31\1\u0160\7\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\2\31\1\u0160\1\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\7\31\1\u0161"+
    "\12\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\6\31\1\u0162\13\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\6\31\1\u0163\13\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\16\31\1\u0164\3\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\6\31\1\u0165"+
    "\13\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\6\31\1\u0166\13\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\3\31\1\u0167\16\31\1\0\1\u0168\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\u0169\1\0\4\31\25\0\22\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\16\31\1\u016a\3\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\36\0"+
    "\1\u016b\105\0\1\u016c\126\0\1\u016d\55\0\1\u016e\101\0"+
    "\1\u016f\111\0\1\u0170\100\0\1\u0171\74\0\1\u0172\114\0"+
    "\1\u0173\30\0\1\u0173\40\0\1\u0174\44\0\1\31\1\0"+
    "\1\31\1\0\2\31\1\u0175\1\31\25\0\22\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\5\31\1\u0176"+
    "\2\31\1\u0177\11\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\1\31\1\u0176\2\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\16\31\1\u0178\3\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\2\31\1\u0179"+
    "\17\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\5\31\1\u017a\14\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\1\31\1\u017a\2\31\1\0\1\31\1\0"+
    "\1\u017b\1\0\4\31\25\0\22\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\11\120\1\u0130\3\120"+
    "\1\u0130\1\321\1\120\1\322\1\120\1\323\60\120\11\332"+
    "\1\334\2\332\1\0\1\334\65\332\3\0\2\u0135\1\0"+
    "\2\u0135\26\0\5\u0135\1\0\4\u0135\1\0\4\u0135\1\0"+
    "\2\u0135\1\0\1\u0135\1\0\1\u0135\1\0\1\u0135\1\0"+
    "\1\u0135\1\u017c\6\0\4\u0135\11\0\1\u0136\72\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\3\31\1\u017d\16\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\u017e\1\0\4\31\25\0\22\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\7\31"+
    "\1\u017f\12\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\1\u0180\21\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\15\31\1\u0181\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\14\31\1\u0182\5\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\5\31\1\u0183"+
    "\14\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\1\31\1\u0183\2\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\13\31\1\u0184\6\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\17\31\1\u0185\2\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\3\31\1\u0185"+
    "\1\0\1\202\1\0\1\202\1\0\4\202\25\0\12\202"+
    "\1\u0186\7\202\1\0\1\202\1\0\1\202\1\0\3\202"+
    "\7\0\2\202\1\u0186\1\202\1\0\1\u0145\1\0\1\u0145"+
    "\1\0\4\u0145\1\u0187\3\0\1\u0188\20\0\22\u0145\1\0"+
    "\1\u0145\1\0\1\u0145\1\0\3\u0145\7\0\4\u0145\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\1\31\1\u0189"+
    "\20\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\5\31\1\u018a\14\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\1\31\1\u018a\2\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\1\31\1\u018b\20\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\13\31\1\u018c"+
    "\6\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\10\31\1\u018d\11\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\2\31\1\u018e\17\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\1\31\1\u018f\20\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\10\31\1\u0190"+
    "\11\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\2\31\1\u0191\17\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\6\31\1\u0192\13\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\u0193\1\0\4\31\25\0\22\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\15\31\1\u0194\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\2\31\1\u0195"+
    "\17\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\u0196\1\0\4\31\25\0"+
    "\22\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\16\31\1\u0197\3\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\6\31\1\u0198\13\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\6\31\1\u0199\13\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\5\31\1\u019a"+
    "\14\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\1\31\1\u019a\2\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\6\31\1\u019b\13\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\14\31\1\u019c\5\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\u019d\1\0\4\31\25\0\22\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\12\31\1\u019e"+
    "\7\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\2\31\1\u019e\1\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\5\31\1\u019f\14\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\1\31\1\u019f\2\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\11\31\1\u01a0"+
    "\10\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\u01a1\1\0\4\31\25\0"+
    "\22\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\u01a2\1\0\4\31\25\0"+
    "\22\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\6\31\1\u01a3\13\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\2\31\1\u01a4\17\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\3\31\1\u01a5\16\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\5\31\1\u01a6"+
    "\14\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\1\31\1\u01a6\2\31\54\0\1\u01a7\66\0\1\u01a8\45\0"+
    "\1\u01a9\153\0\1\u01aa\66\0\1\u01ab\51\0\1\u01ac\76\0"+
    "\1\u01ad\6\0\1\u01aa\51\0\1\u01ae\56\0\1\u01af\45\0"+
    "\1\u01af\142\0\1\u01b0\34\0\1\u01b0\3\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\2\31\1\u01b1\17\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\16\31\1\u01b2"+
    "\3\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\3\31\1\u01b3\16\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\2\31\1\u01b4\17\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\16\31\1\u01b5\3\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\3\31\1\u01b6"+
    "\16\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\6\31\1\u01b7\13\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\4\31\1\u01b8\15\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\11\31\1\u01b9\10\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\1\31\1\u01ba"+
    "\20\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\5\31\1\u01bb\14\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\1\31\1\u01bb\2\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\5\31\1\u01bc\14\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\1\31\1\u01bc"+
    "\2\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\7\31\1\u01bd\12\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\11\0\1\u0187\72\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\3\31\1\u01be\16\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\1\31\1\u01bf"+
    "\20\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\2\31\1\u01c0\17\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\16\31\1\u01c1\3\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\1\31\1\u01c2\20\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\7\31\1\u01c3"+
    "\12\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\4\31\1\u01c4\15\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\3\31\1\u01c5\16\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\21\31\1\u01c6\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\11\31\1\u01c7\10\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\5\31"+
    "\1\u01c8\14\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\1\31\1\u01c8\2\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\3\31\1\u01c9\16\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\11\31\1\u01ca\10\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\14\31"+
    "\1\u01cb\5\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\11\31\1\u01cc\10\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\6\31\1\u01cd\13\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\6\31\1\u01ce\13\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\11\31"+
    "\1\u01cf\10\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\3\0\1\u01d0\6\0\1\u01aa\51\0\1\u01ae"+
    "\55\0\1\u01ab\112\0\1\u01af\45\0\1\u01aa\51\0\1\u01ae"+
    "\67\0\1\u01aa\105\0\1\u01d1\111\0\1\u01d2\63\0\1\u01aa"+
    "\77\0\1\u01d3\42\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\16\31\1\u01d4\3\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\u01d5"+
    "\1\0\4\31\25\0\22\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\11\31\1\u01d6\10\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\12\31\1\u01d7\7\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\2\31"+
    "\1\u01d7\1\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\6\31\1\u01d8\13\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\u01d9"+
    "\1\0\4\31\25\0\22\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\14\31\1\u01da\5\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\12\31\1\u01db\7\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\2\31"+
    "\1\u01db\1\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\16\31\1\u01dc\3\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\u01dd"+
    "\1\0\4\31\25\0\22\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\6\31\1\u01de\13\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\16\31\1\u01df\3\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\u01e0\1\0\4\31\25\0\22\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\11\31"+
    "\1\u01e1\10\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\6\31\1\u01e2\13\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\u01e3"+
    "\1\0\4\31\25\0\22\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\2\31\1\u01e4\17\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\u01e5\1\0\4\31\25\0\22\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\11\31\1\u01e6\10\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\u01e7\1\0\4\31\25\0\22\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\14\31"+
    "\1\u01e8\5\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\1\u01e9\21\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\10\31\1\u01ea\11\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\6\31\1\u01eb\13\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\u01ec\1\0\4\31\25\0\22\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\40\0"+
    "\1\u01ed\45\0\1\u01aa\102\0\1\u01ee\162\0\1\u01aa\20\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\22\31\1\0"+
    "\1\31\1\0\1\31\1\0\1\31\1\u01ef\1\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\6\31\1\u01f0\13\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\12\31\1\u01f1\7\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\2\31\1\u01f1\1\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\22\31\1\0"+
    "\1\31\1\0\1\31\1\0\1\31\1\u01f2\1\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\22\31\1\0\1\31\1\0\1\31\1\0\1\31\1\u01f3"+
    "\1\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\1\u01f4\21\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\2\31\1\u01f5\17\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\2\31\1\u01f6\17\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\11\31"+
    "\1\u01f7\10\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\u01f8\1\0\4\31"+
    "\25\0\22\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\22\31\1\0\1\31\1\0\1\31\1\0\1\31"+
    "\1\u01f9\1\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\6\31\1\u01fa\13\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\11\31\1\u01fb\10\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\22\31"+
    "\1\0\1\31\1\0\1\31\1\0\1\31\1\u01fc\1\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\u01fd\1\0\4\31"+
    "\25\0\22\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\3\31\1\u01fe\16\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\3\31\1\u01ff\16\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\u0200\1\0\4\31\25\0\22\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\u0201\1\0\4\31\25\0\22\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\41\0\1\u01aa"+
    "\100\0\1\u01aa\44\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\22\31\1\0\1\31\1\0\1\31\1\0\1\31"+
    "\1\u0202\1\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\5\31\1\u0203\14\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\1\31\1\u0203\2\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\22\31"+
    "\1\0\1\31\1\0\1\31\1\0\1\31\1\u0204\1\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\11\31\1\u0205\10\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\22\31\1\0\1\31\1\0\1\31"+
    "\1\0\1\31\1\u0206\1\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\4\31\1\u0207\15\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\1\31"+
    "\1\u0208\20\31\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\11\31\1\u0209\10\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\14\31\1\u020a\5\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\1\u020b\21\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\u020c\1\0\4\31\25\0\22\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\1\u020d\21\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\1\u020e"+
    "\21\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\6\31\1\u020f\13\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\4\31\1\u0210\15\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\1\u0211\21\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\22\31\1\0\1\31"+
    "\1\0\1\31\1\0\1\31\1\u0212\1\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\1\u0213"+
    "\21\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\22\31\1\0\1\31\1\0\1\31\1\0\1\31\1\u0214"+
    "\1\31\7\0\4\31\1\0\1\31\1\0\1\u0215\1\0"+
    "\4\31\25\0\22\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\14\31\1\u0216\5\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\4\31\1\0\1\31\1\0"+
    "\1\31\1\0\4\31\25\0\3\31\1\u0217\16\31\1\0"+
    "\1\31\1\0\1\31\1\0\3\31\7\0\4\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\3\31\1\u0218"+
    "\16\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\7\31\1\u0219\12\31\1\0\1\31\1\0\1\31\1\0"+
    "\3\31\7\0\4\31\1\0\1\31\1\0\1\31\1\0"+
    "\4\31\25\0\12\31\1\u021a\7\31\1\0\1\31\1\0"+
    "\1\31\1\0\3\31\7\0\2\31\1\u021a\1\31\1\0"+
    "\1\31\1\0\1\31\1\0\4\31\25\0\3\31\1\u021b"+
    "\16\31\1\0\1\31\1\0\1\31\1\0\3\31\7\0"+
    "\4\31\1\0\1\31\1\0\1\31\1\0\4\31\25\0"+
    "\21\31\1\u021c\1\0\1\31\1\0\1\31\1\0\3\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\22\31\1\0\1\31\1\0\1\31\1\0\1\31"+
    "\1\u021d\1\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\11\31\1\u021e\10\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\11\31\1\u021f\10\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\4\31"+
    "\1\0\1\31\1\0\1\31\1\0\4\31\25\0\22\31"+
    "\1\0\1\31\1\0\1\31\1\0\1\31\1\u0220\1\31"+
    "\7\0\4\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\20\31\1\u0221\1\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\u0222"+
    "\1\0\4\31\25\0\22\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\u0223"+
    "\1\0\4\31\25\0\22\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\22\31\1\0\1\31\1\0\1\31"+
    "\1\0\1\31\1\u0224\1\31\7\0\4\31\1\0\1\31"+
    "\1\0\1\31\1\0\4\31\25\0\5\31\1\u0225\14\31"+
    "\1\0\1\31\1\0\1\31\1\0\3\31\7\0\1\31"+
    "\1\u0225\2\31\1\0\1\31\1\0\1\31\1\0\4\31"+
    "\25\0\16\31\1\u0226\3\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\u0227"+
    "\1\0\4\31\25\0\22\31\1\0\1\31\1\0\1\31"+
    "\1\0\3\31\7\0\4\31\1\0\1\31\1\0\1\31"+
    "\1\0\4\31\25\0\1\31\1\u0228\20\31\1\0\1\31"+
    "\1\0\1\31\1\0\3\31\7\0\4\31";

  private static int [] zzUnpackTrans() {
    int [] result = new int[28609];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


	/* error codes */
	private static final int ZZ_UNKNOWN_ERROR = 0;
	private static final int ZZ_NO_MATCH = 1;
	private static final int ZZ_PUSHBACK_2BIG = 2;

	/* error messages for the codes above */
	private static final String ZZ_ERROR_MSG[] = {
		"Unknown internal scanner error",		//$NON-NLS-1$
		"Error: could not match input",			//$NON-NLS-1$
		"Error: pushback value was too large"	//$NON-NLS-1$
	};

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\10\5\0\1\1\11\0\1\11\11\1\2\11\2\1"+
    "\1\11\40\1\1\11\3\1\1\11\10\1\1\11\7\1"+
    "\1\11\3\1\1\0\1\1\1\11\3\1\1\11\1\1"+
    "\1\11\2\1\1\11\2\1\1\11\4\1\1\11\1\1"+
    "\1\11\2\1\1\11\5\1\1\11\6\1\1\11\2\0"+
    "\3\1\2\0\1\11\2\0\3\1\1\11\43\1\1\11"+
    "\1\1\12\0\2\1\2\0\1\11\3\0\2\1\3\11"+
    "\1\1\4\0\2\1\1\11\3\0\3\1\1\0\1\11"+
    "\3\0\1\11\4\0\1\11\1\1\1\11\1\0\1\11"+
    "\1\1\1\11\13\1\1\0\2\1\1\0\50\1\12\0"+
    "\6\1\2\11\1\1\1\0\1\1\2\0\1\11\16\1"+
    "\1\0\1\11\44\1\12\0\7\1\1\11\12\1\1\11"+
    "\37\1\7\0\1\11\2\0\37\1\4\0\31\1\2\0"+
    "\72\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[552];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

	/** the input device */
	private java.io.Reader zzReader;

	/** the current state of the DFA */
	private int zzState;

	/** the current lexical state */
	private int zzLexicalState = YYINITIAL;

	/** this buffer contains the current text to be matched and is
		the source of the yytext() string */
	private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

	/** the textposition at the last accepting state */
	private int zzMarkedPos;

	/** the current text position in the buffer */
	private int zzCurrentPos;

	/** startRead marks the beginning of the yytext() string in the buffer */
	private int zzStartRead;

	/** endRead marks the last character in the buffer, that has been read
		from input */
	private int zzEndRead;

	/** number of newlines encountered up to the start of the matched text */
	private int yyline;

	/** the number of characters up to the start of the matched text */
	private int yychar;

	/**
	 * the number of characters from the last newline up to the start of the
	 * matched text
	 */
	private int yycolumn;

	/**
	 * zzAtBOL == true <=> the scanner is currently at the beginning of a line
	 */
	private boolean zzAtBOL = true;

	/** zzAtEOF == true <=> the scanner is at the EOF */
	private boolean zzAtEOF;

	/** denotes if the user-EOF-code has already been executed */
	private boolean zzEOFDone;

	/**
	 * The number of occupied positions in zzBuffer beyond zzEndRead.
	 * When a lead/high surrogate has been read from the input stream
	 * into the final zzBuffer position, this will have a value of 1;
	 * otherwise, it will have a value of 0.
	 */
	private int zzFinalHighSurrogate = 0;

  /* user code: */
	public PHPLexer(int state) {
		initialize(state);
	}

	// NB: this method resets the lexer only partially
	@Override
	protected void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzFinalHighSurrogate = 0;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		initialize(parameters[6]);
	}

	@Override
	public int getInScriptingState() {
		return ST_PHP_IN_SCRIPTING;
	}

	private static final int[] heredocStates = new int[] { ST_PHP_HEREDOC, ST_PHP_START_HEREDOC, ST_PHP_END_HEREDOC };

	@Override
	public int[] getHeredocStates() {
		return heredocStates;
	}

	private static final int[] phpQuotesStates = new int[] { ST_PHP_DOUBLE_QUOTES, ST_PHP_SINGLE_QUOTE, ST_PHP_BACKQUOTE, ST_PHP_HEREDOC, ST_PHP_START_HEREDOC, ST_PHP_END_HEREDOC };

	@Override
	public int[] getPHPQuotesStates() {
		return phpQuotesStates;
	}

	@Override
	public int[] getParameters() {
		return new int[]{zzMarkedPos, _zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline, zzLexicalState};
	}

	@Override
	protected int getZZLexicalState() {
		return zzLexicalState;
	}

	@Override
	protected int getZZMarkedPos() {
		return zzMarkedPos;
	}

	@Override
	protected int getZZEndRead() {
		return zzEndRead;
	}

	@Override
	public char[] getZZBuffer() {
		return zzBuffer;
	}

	@Override
	protected int getZZStartRead() {
		return this.zzStartRead;
	}

	@Override
	protected int getZZPushBackPosition() {
		return this._zzPushbackPos;
	}

	@Override
	protected void pushBack(int i) {
		yypushback(i);
	}

	@Override
	public int getScriptingState() {
		return ST_PHP_IN_SCRIPTING;
	}

	// A pool of states. To avoid creation of a new state on each createMemento.
	private static final Map<LexerState, LexerState> lexerStates = new HashMap<>();

	@Override
	protected Map<LexerState, LexerState> getLexerStates() {
		return lexerStates;
	}

	// End user code


	/** the textposition at the last state to be included in yytext */
	private int _zzPushbackPos;

	/* The following fields are added in order to support the change in zzRefill */
	private String oldString = null;
	private boolean useOldString = false;
	private int startPos = 0;

	/**
	 * Creates a new scanner
	 *
	 * @param   in  the java.io.Reader to read input from.
	 */
  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PHPLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 234) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>false</code>, iff there was new input.
	 *
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
	private boolean zzRefill() throws java.io.IOException {

		if (useOldString) {
			String saveOldString = oldString;
			oldString = new String(zzBuffer, startPos, zzMarkedPos - startPos);
			if (saveOldString != null) {
				oldString = saveOldString + oldString;
			}
		}

		/* first: make room (if you can) */
		if (zzStartRead > 0) {
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
			System.arraycopy(zzBuffer, zzStartRead,
							zzBuffer, 0,
							zzEndRead-zzStartRead);

			/* translate stored positions */
			zzEndRead-= zzStartRead;
			zzCurrentPos-= zzStartRead;
			zzMarkedPos-= zzStartRead;
			_zzPushbackPos-= zzStartRead;
			startPos = 0;
			zzStartRead = 0;
		}

		/* is the buffer big enough? */
		if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
			/* if not: blow it up */
			char newBuffer[] = new char[zzBuffer.length*2];
			System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
			zzBuffer = newBuffer;
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
		}

		/* fill the buffer with new input */
		int requested = zzBuffer.length - zzEndRead;
		int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

		/* not supposed to occur according to specification of java.io.Reader */
		if (numRead == 0) {
			throw new java.io.IOException("Reader returned 0 characters.");
		}
		if (numRead > 0) {
			zzEndRead += numRead;
			/* If numRead == requested, we might have requested to few chars to
			   encode a full Unicode character. We assume that a Reader would
			   otherwise never return half characters. */
			if (numRead == requested) {
				if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
					--zzEndRead;
					zzFinalHighSurrogate = 1;
				}
			}
			/* potentially more input available */
			return false;
		}

		/* numRead < 0 ==> end of stream */
		return true;
	}


	/**
	 * Gets the next input character.
	 *
	 * @return      the next character of the input stream, EOF if the
	 *              end of the stream is reached.
	 * @exception   IOException  if any I/O-Error occurs
	 */
	private int yy_advance() throws java.io.IOException {

		/* standard case */
		if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

		/* if the eof is reached, we don't need to work hard */
		if (zzAtEOF) return YYEOF;

		/* otherwise: need to refill the buffer */

		String saveOldString = oldString;
		oldString = null;

		/* first: make room (if you can) */
		if (zzRefill()) {
			oldString = saveOldString;
			return YYEOF;
		}

		oldString = saveOldString;

		return zzBuffer[zzCurrentPos++];
	}


	/**
	 * Closes the input stream.
	 */
	public final void yyclose() throws java.io.IOException {
		zzAtEOF = true;            /* indicate end of file */
		zzEndRead = zzStartRead;  /* invalidate buffer    */

		if (zzReader != null)
			zzReader.close();
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>ZZ_INITIAL</tt>.
	 *
	 * Internal scan buffer is resized down to its initial length, if it has grown.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) {
		zzReader = reader;
		zzAtBOL  = true;
		zzAtEOF  = false;
		zzEOFDone = false;
		zzEndRead = zzStartRead = 0;
		zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
		zzFinalHighSurrogate = 0;
		oldString = null;
		yyline = yychar = yycolumn = 0;
		zzLexicalState = YYINITIAL;
		if (zzBuffer.length > ZZ_BUFFERSIZE)
			zzBuffer = new char[ZZ_BUFFERSIZE];
	}


	/**
	 * Returns the current lexical state.
	 */
	public final int yystate() {
		return zzLexicalState;
	}


	/**
	 * Enters a new lexical state
	 *
	 * @param newState the new lexical state
	 */
	public final void yybegin(int newState) {
		zzLexicalState = newState;
	}


	/**
	 * Returns the text matched by the current regular expression.
	 */
	public final String yytext() {
		return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
	}


	/**
	 * Returns the character at position <tt>pos</tt> from the
	 * matched text.
	 *
	 * It is equivalent to yytext().charAt(pos), but faster
	 *
	 * @param pos the position of the character to fetch.
	 *            A value from 0 to yylength()-1.
	 *
	 * @return the character at position pos
	 */
	public final char yycharat(int pos) {
		return zzBuffer[zzStartRead+pos];
	}


	/**
	 * Returns the length of the matched text region.
	 */
	public final int yylength() {
		return zzMarkedPos-zzStartRead;
	}


	/**
	 * Reports an error that occured while scanning.
	 *
	 * In a wellformed scanner (no or only correct usage of
	 * yypushback(int) and a match-all fallback rule) this method
	 * will only be called with things that "Can't Possibly Happen".
	 * If this method is called, something is seriously wrong
	 * (e.g. a JFlex bug producing a faulty scanner etc.).
	 *
	 * Usual syntax/scanner level error handling should be done
	 * in error fallback rules.
	 *
	 * @param   errorCode  the code of the errormessage to display
	 */
  private void zzScanError(int errorCode) {
		String message;
		try {
			message = ZZ_ERROR_MSG[errorCode];
		}
		catch (ArrayIndexOutOfBoundsException e) {
			message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
		}

    throw new Error(message);
	}


	/**
	 * Pushes the specified amount of characters back into the input stream.
	 *
	 * They will be read again by then next call of the scanning method
	 *
	 * @param number  the number of characters to be read again.
	 *                This number must not be greater than yylength()!
	 */
  public void yypushback(int number)  {
		if ( number > yylength() )
			zzScanError(ZZ_PUSHBACK_2BIG);

		zzMarkedPos -= number;
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		updateStartPos(zzMarkedPos);
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos(int position) {
		startPos = position;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


	/**
	 * Resumes scanning until the next regular expression is matched,
	 * the end of input is encountered or an I/O-Error occurs.
	 *
	 * @return      the next token
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
  public String yylex() throws java.io.IOException {
	int zzInput;
	int zzAction;

	// cached fields:
	int zzCurrentPosL;
	int zzMarkedPosL;
	int zzEndReadL = zzEndRead;
	char [] zzBufferL = zzBuffer;
	char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

	while (true) {
		zzMarkedPosL = zzMarkedPos;

		zzAction = -1;

		zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


		zzForAction: {
			while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
				zzAction = zzState;
				zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
				}

			}
		}

			// store back cached position
			zzMarkedPos = zzMarkedPosL;

			if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
				zzAtEOF = true;
        return null;
			}
			else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 129: break;
          case 2: 
            { yypushback(1);
	pushState(ST_PHP_HIGHLIGHTING_ERROR);
            }
          case 130: break;
          case 3: 
            { return PHP_NUMBER;
            }
          case 131: break;
          case 4: 
            { return PHP_TOKEN;
            }
          case 132: break;
          case 5: 
            { return PHP_LABEL;
            }
          case 133: break;
          case 6: 
            { return WHITESPACE;
            }
          case 134: break;
          case 7: 
            { return PHP_SEMICOLON;
            }
          case 135: break;
          case 8: 
            { pushState(ST_PHP_DOUBLE_QUOTES);
	return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 136: break;
          case 9: 
            { pushState(ST_PHP_BACKQUOTE);
	return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 137: break;
          case 10: 
            { // Whitespaces are directly appended to the curly before pushState()
	// is effective or whitespaces would be stored in a separate ContextRegion.
	// Method PhpTokenContainer#addLast() will correct the curlies length...
	if (!phpStack.isEmpty()) {
		// Only push the state when stack is not empty, it's useless otherwise
		// (and it pollutes the stack).
		pushState(ST_PHP_IN_SCRIPTING);
	}
	return PHP_CURLY_OPEN;
            }
          case 138: break;
          case 11: 
            { // Whitespaces are directly appended to the curly before pushState()
	// is effective or whitespaces would be stored in a separate ContextRegion.
	// Method PhpTokenContainer#addLast() will correct the curlies length...
	if (!phpStack.isEmpty()) {
		popState();
		// If new state is not ST_PHP_IN_SCRIPTING then some blanks are signifiant (like newlines
		// after the closing curly and before an ending heredoc tag), so don't append them...
		// See rule <ST_PHP_HEREDOC>{HEREDOC_CHARS}*({HEREDOC_NEWLINE}+({LABEL}";"?)?)?
		if (getZZLexicalState() != ST_PHP_IN_SCRIPTING) {
			yypushback(yylength() - 1);
		}
	}
	return PHP_CURLY_CLOSE;
            }
          case 139: break;
          case 12: 
            { pushState(ST_PHP_SINGLE_QUOTE);
	return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 140: break;
          case 13: 
            { pushState(ST_PHP_LINE_COMMENT);
	return PHP_LINE_COMMENT;
            }
          case 141: break;
          case 14: 
            { return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 142: break;
          case 15: 
            { popState();
	return PHP_CONSTANT_ENCAPSED_STRING;
            }
          case 143: break;
          case 16: 
            { yypushback(1);
		popState();
            }
          case 144: break;
          case 17: 
            { yypushback(1);
	yybegin(ST_PHP_HEREDOC);
            }
          case 145: break;
          case 18: 
            { yypushback(1);
	popState();
            }
          case 146: break;
          case 19: 
            { popState();
	return PHP_LABEL;
            }
          case 147: break;
          case 20: 
            { //the difference from the original rules comes from the fact that we took ';' out of tokens
	return UNKNOWN_TOKEN;
            }
          case 148: break;
          case 21: 
            { yypushback(1);
	popState();
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 149: break;
          case 22: 
            { popState();
	return PHP_TOKEN;
            }
          case 150: break;
          case 23: 
            { return PHP_COMMENT;
            }
          case 151: break;
          case 24: 
            { return PHPDOC_COMMENT;
            }
          case 152: break;
          case 25: 
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			if (yylength() > 0) {
				return PHP_LINE_COMMENT;
			}
			break;
		default:
			popState();
			return PHP_LINE_COMMENT;
	}
            }
          case 153: break;
          case 26: 
            { return PHP_LINE_COMMENT;
            }
          case 154: break;
          case 27: 
            { return UNKNOWN_TOKEN;
            }
          case 155: break;
          case 28: 
            { popState();return WHITESPACE;
            }
          case 156: break;
          case 29: 
            { yybegin(ST_PHP_IN_SCRIPTING);
	return PHP_ENCAPSED_VARIABLE;
            }
          case 157: break;
          case 30: 
            { yybegin(ST_PHP_IN_SCRIPTING);
	return PHP_CURLY_OPEN;
            }
          case 158: break;
          case 31: 
            { return PHP_OPERATOR;
            }
          case 159: break;
          case 32: 
            { pushState(ST_PHP_LOOKING_FOR_PROPERTY);
	return PHP_OBJECT_OPERATOR;
            }
          case 160: break;
          case 33: 
            { return PHP_VARIABLE;
            }
          case 161: break;
          case 34: 
            { pushState(ST_PHP_COMMENT);
	return PHP_COMMENT_START;
            }
          case 162: break;
          case 35: 
            { if (asp_tags) {
		return PHP_CLOSETAG;
	}
	return UNKNOWN_TOKEN;
            }
          case 163: break;
          case 36: 
            { return PHP_AS;
            }
          case 164: break;
          case 37: 
            { return PHP_DO;
            }
          case 165: break;
          case 38: 
            { return PHP_IF;
            }
          case 166: break;
          case 39: 
            { return PHP_PAAMAYIM_NEKUDOTAYIM;
            }
          case 167: break;
          case 40: 
            { return PHP_CLOSETAG;
            }
          case 168: break;
          case 41: 
            { pushState(ST_PHP_QUOTES_AFTER_VARIABLE);
	return PHP_VARIABLE;
            }
          case 169: break;
          case 42: 
            { yypushback(1);
	return PHP_ENCAPSED_AND_WHITESPACE;
            }
          case 170: break;
          case 43: 
            { // We can have nested curlies after applying this rule,
	// so we have to count all curlies...
	yypushback(1);
	pushState(ST_PHP_DOLLAR_CURLY_OPEN);
	return PHP_TOKEN;
            }
          case 171: break;
          case 44: 
            { // We can have nested curlies after applying rule below for "${",
	// so we have to count all curlies...
	yypushback(1);
	pushState(ST_PHP_IN_SCRIPTING);
	return PHP_CURLY_OPEN;
            }
          case 172: break;
          case 45: 
            { popState();
	pushState(ST_PHP_LOOKING_FOR_PROPERTY);
	return PHP_OBJECT_OPERATOR;
            }
          case 173: break;
          case 46: 
            { String yytext = yytext();
	int label_len = yylength() - 1;

	if (yytext.charAt(label_len - 1) == ';') {
		label_len--;
	}

	String heredoc = getHeredocId();
	int heredoc_len = heredoc.length();
	if (label_len == heredoc_len && yytext.substring(0, label_len).equals(heredoc)) {
		// we must (at least) push the newline character back
		yypushback(1);
		popHeredocId();
		popState();
		return PHP_HEREDOC_CLOSE_TAG;
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
		return PHP_ENCAPSED_AND_WHITESPACE;
	}
            }
          case 174: break;
          case 47: 
            { String yytext = yytext();
	int label_len = yylength() - 1;
	int startIndex = 0;
	if (yytext.charAt(label_len - 1) == ';') {
		label_len--;
	}
	while (yytext.charAt(startIndex) == '\r'
			|| yytext.charAt(startIndex) == '\n') {
		startIndex++;
	}

	String heredoc = getHeredocId();
	int heredoc_len = heredoc.length();
	if (label_len > heredoc_len
			&& yytext.substring(startIndex, label_len).equals(
					heredoc)) {
		// we must (at least) push the newline character back
		yypushback(1);
		popHeredocId();
		popState();
		return PHP_HEREDOC_CLOSE_TAG;
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
		yybegin(ST_PHP_HEREDOC);
		return PHP_ENCAPSED_AND_WHITESPACE;
	}
            }
          case 175: break;
          case 48: 
            { return PHP_OBJECT_OPERATOR;
            }
          case 176: break;
          case 49: 
            { popState();
	return PHP_COMMENT_END;
            }
          case 177: break;
          case 50: 
            { popState();
	return PHPDOC_COMMENT_END;
            }
          case 178: break;
          case 51: 
            { TagKind tagkind = TagKind.getTagKindFromValue(yytext());
		if (tagkind != null /* ignore @todo tag */
			&& !"@todo".equalsIgnoreCase(tagkind.getValue())) {
				return PHPDOC_GENERIC_TAG;
		}
		return PHPDOC_COMMENT;
            }
          case 179: break;
          case 52: 
            { popState();
	return PHP_LINE_COMMENT;
            }
          case 180: break;
          case 53: 
            { if (asp_tags) {
		return PHP_CLOSETAG;
	}
	return PHP_LINE_COMMENT;
            }
          case 181: break;
          case 54: 
            { yypushback(yylength() - 1);
	return PHP_CURLY_OPEN;
            }
          case 182: break;
          case 55: 
            { pushState(ST_PHP_DOC_COMMENT);
	return PHPDOC_COMMENT_START;
            }
          case 183: break;
          case 56: 
            { return PHP_NEW;
            }
          case 184: break;
          case 57: 
            { return PHP_DIE;
            }
          case 185: break;
          case 58: 
            { return PHP_TRY;
            }
          case 186: break;
          case 59: 
            { return PHP_FOR;
            }
          case 187: break;
          case 60: 
            { return PHP_USE;
            }
          case 188: break;
          case 61: 
            { return PHP_VAR;
            }
          case 189: break;
          case 62: 
            { yypushback(1);
	pushState(ST_PHP_VAR_OFFSET);
	return PHP_VARIABLE;
            }
          case 190: break;
          case 63: 
            { String yytext = yytext();
	int label_len = yylength() - 1;

	if (yytext.charAt(label_len - 1) == ';') {
		label_len--;
	}
	String heredoc = getHeredocId();
	int heredoc_len = heredoc.length();
	int startIndex = label_len - heredoc_len;
	if (startIndex > 0 && yytext.substring(startIndex, label_len).equals(heredoc)) {

		if (startIndex - 2 >= 0
			&& yytext.charAt(startIndex - 2) == '\r'
			&& yytext.charAt(startIndex - 1) == '\n') {
			startIndex-= 2;
		} else {
			startIndex--;
		}
		yypushback(yylength() - startIndex);

		yybegin(ST_PHP_END_HEREDOC);
	} else {
		// we must (at least) push the newline character back
		yypushback(1);
	}
	// In some cases, all text is pushed back (using yypushback()),
	// especially when the parsed document has Windows newlines.
	// In those cases, ignore this rule and try next one...
	if (yylength() > 0) {
		return PHP_ENCAPSED_AND_WHITESPACE;
	}
            }
          case 191: break;
          case 64: 
            { yypushback(yylength() - 2);
	if (asp_tags) {
		return PHP_CLOSETAG;
	}
	popState();
	return PHP_LINE_COMMENT;
            }
          case 192: break;
          case 65: 
            { return PHP_EXIT;
            }
          case 193: break;
          case 66: 
            { return PHP_ECHO;
            }
          case 194: break;
          case 67: 
            { return PHP_ELSE;
            }
          case 195: break;
          case 68: 
            { return PHP_EVAL;
            }
          case 196: break;
          case 69: 
            { yypushback(2);
	pushState(ST_PHP_COMMENT);
	return PHP_COMMENT_START;
            }
          case 197: break;
          case 70: 
            { return PHP_KEYWORD;
            }
          case 198: break;
          case 71: 
            { return PHP_TRUE;
            }
          case 199: break;
          case 72: 
            { return PHP_FROM;
            }
          case 200: break;
          case 73: 
            { return PHP_CASE;
            }
          case 201: break;
          case 74: 
            { return PHP_SELF;
            }
          case 202: break;
          case 75: 
            { return PHP_LIST;
            }
          case 203: break;
          case 76: 
            { if (TagKind.getTagKindFromValue(yytext()) != null) {
			return PHPDOC_GENERIC_TAG;
		}
		return PHPDOC_COMMENT;
            }
          case 204: break;
          case 77: 
            { return PHP_ENDIF;
            }
          case 205: break;
          case 78: 
            { return PHP_EMPTY;
            }
          case 206: break;
          case 79: 
            { return PHP_BREAK;
            }
          case 207: break;
          case 80: 
            { return PHP_THIS;
            }
          case 208: break;
          case 81: 
            { String yytext = yytext();
	int bprefix = (yytext.charAt(0) != '<') ? 1 : 0;
	int startString = 3 + bprefix;
	int heredoc_len = yylength() - bprefix - 3 - 1 - (yytext.charAt(yylength() - 2) == '\r' ? 1 : 0);
	while ((yytext.charAt(startString) == ' ') || (yytext.charAt(startString) == '\t')) {
		startString++;
		heredoc_len--;
	}
	pushHeredocId(yytext.substring(startString, heredoc_len + startString));
	pushState(ST_PHP_START_HEREDOC);
	return PHP_HEREDOC_START_TAG;
            }
          case 209: break;
          case 82: 
            { return PHP_ARRAY;
            }
          case 210: break;
          case 83: 
            { return PHP_ISSET;
            }
          case 211: break;
          case 84: 
            { return PHP_THROW;
            }
          case 212: break;
          case 85: 
            { return PHP_FALSE;
            }
          case 213: break;
          case 86: 
            { return PHP_FINAL;
            }
          case 214: break;
          case 87: 
            { return PHP_UNSET;
            }
          case 215: break;
          case 88: 
            { return PHP_CONST;
            }
          case 216: break;
          case 89: 
            { return PHP_CATCH;
            }
          case 217: break;
          case 90: 
            { return PHP_CLONE;
            }
          case 218: break;
          case 91: 
            { return PHP_CLASS;
            }
          case 219: break;
          case 92: 
            { return PHP_WHILE;
            }
          case 220: break;
          case 93: 
            { return PHP_PRINT;
            }
          case 221: break;
          case 94: 
            { return PHP_CASTING;
            }
          case 222: break;
          case 95: 
            { return PHP_ENDFOR;
            }
          case 223: break;
          case 96: 
            { return PHP_ELSEIF;
            }
          case 224: break;
          case 97: 
            { return PHP_RETURN;
            }
          case 225: break;
          case 98: 
            { return PHP_STATIC;
            }
          case 226: break;
          case 99: 
            { return PHP_SWITCH;
            }
          case 227: break;
          case 100: 
            { return PHP_PARENT;
            }
          case 228: break;
          case 101: 
            { return PHP_PUBLIC;
            }
          case 229: break;
          case 102: 
            { return PHP_GLOBAL;
            }
          case 230: break;
          case 103: 
            { return PHP_EXTENDS;
            }
          case 231: break;
          case 104: 
            { return PHP_REQUIRE;
            }
          case 232: break;
          case 105: 
            { return PHP_DEFAULT;
            }
          case 233: break;
          case 106: 
            { return PHP_DECLARE;
            }
          case 234: break;
          case 107: 
            { return PHP_INCLUDE;
            }
          case 235: break;
          case 108: 
            { return PHP_FOREACH;
            }
          case 236: break;
          case 109: 
            { return PHP_PRIVATE;
            }
          case 237: break;
          case 110: 
            { return PHP_ENDWHILE;
            }
          case 238: break;
          case 111: 
            { return PHP_ABSTRACT;
            }
          case 239: break;
          case 112: 
            { return PHP_FUNCTION;
            }
          case 240: break;
          case 113: 
            { return PHP_CONTINUE;
            }
          case 241: break;
          case 114: 
            { return PHP__FILE__;
            }
          case 242: break;
          case 115: 
            { return PHP__LINE__;
            }
          case 243: break;
          case 116: 
            { return PHP_ENDSWITCH;
            }
          case 244: break;
          case 117: 
            { return PHP_INTERFACE;
            }
          case 245: break;
          case 118: 
            { return PHP_PROTECTED;
            }
          case 246: break;
          case 119: 
            { return PHP__CLASS__;
            }
          case 247: break;
          case 120: 
            { return PHP_ENDDECLARE;
            }
          case 248: break;
          case 121: 
            { return PHP_ENDFOREACH;
            }
          case 249: break;
          case 122: 
            { return PHP_INSTANCEOF;
            }
          case 250: break;
          case 123: 
            { return PHP_IMPLEMENTS;
            }
          case 251: break;
          case 124: 
            { return PHP__METHOD__;
            }
          case 252: break;
          case 125: 
            { return PHP_REQUIRE_ONCE;
            }
          case 253: break;
          case 126: 
            { return PHP_INCLUDE_ONCE;
            }
          case 254: break;
          case 127: 
            { return PHP__FUNCTION__;
            }
          case 255: break;
          case 128: 
            { return PHP_HALT_COMPILER;
            }
          case 256: break;
		default:
            zzScanError(ZZ_NO_MATCH);
				}
			}
		}
	}


}
