/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dnd;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.php.internal.ui.actions.IPHPMoveActionDelegator;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.NavigatorDropAdapter;

public class PHPNavigatorDropAdapter
extends NavigatorDropAdapter {
    private boolean alwaysOverwrite = false;
    private int lastValidOperation = 0;
    private IPHPMoveActionDelegator fReorgMoveAction;
    private static final String MOVE_ACTION_ID = "org.eclipse.php.ui.actions.Move";

    public PHPNavigatorDropAdapter(StructuredViewer viewer) {
        super(viewer);
    }

    private IStatus error(String message) {
        return this.error(message, null);
    }

    private IStatus error(String message, Throwable exception) {
        return new Status(4, "org.eclipse.ui", 0, message, exception);
    }

    private IContainer getActualTarget(IResource mouseTarget) {
        if (this.getFeedbackEnabled() && (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2)) {
            return mouseTarget.getParent();
        }
        if (mouseTarget.getType() == 1) {
            return mouseTarget.getParent();
        }
        return (IContainer)mouseTarget;
    }

    private IResource[] getSelectedResources() {
        ArrayList selectedResources = new ArrayList();
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            for (Object o : ssel) {
                IAdaptable a;
                IResource r;
                if (o instanceof IResource) {
                    selectedResources.add(o);
                    continue;
                }
                if (!(o instanceof IAdaptable) || (r = (IResource)(a = (IAdaptable)o).getAdapter(IResource.class)) == null) continue;
                selectedResources.add(r);
            }
        }
        return selectedResources.toArray(new IResource[selectedResources.size()]);
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    private IStatus info(String message) {
        return new Status(1, "org.eclipse.ui", 0, message, null);
    }

    private void mergeStatus(MultiStatus status, IStatus toMerge) {
        if (!toMerge.isOK()) {
            status.merge(toMerge);
        }
    }

    private IStatus ok() {
        return new Status(0, "org.eclipse.ui", 0, ResourceNavigatorMessages.DropAdapter_ok, null);
    }

    private void openError(IStatus status) {
        if (status == null) {
            return;
        }
        String genericTitle = ResourceNavigatorMessages.DropAdapter_title;
        int codes = 6;
        if (!status.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)status.getMessage(), null, (IStatus)children[0], (int)codes);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
    }

    public boolean performDrop(Object data) {
        this.alwaysOverwrite = false;
        if (this.getCurrentTarget() == null || data == null) {
            return false;
        }
        boolean result = false;
        IStatus status = null;
        IResource[] resources = null;
        TransferData currentTransfer = this.getCurrentTransfer();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(currentTransfer)) {
            resources = this.getSelectedResources();
        } else if (ResourceTransfer.getInstance().isSupportedType(currentTransfer)) {
            resources = (IResource[])data;
        } else if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
            status = this.performFileDrop(data);
            result = status.isOK();
        } else {
            result = PHPNavigatorDropAdapter.super.performDrop(data);
        }
        if (resources != null && resources.length > 0) {
            status = this.getCurrentOperation() == 1 ? this.performResourceCopy(this.getShell(), resources) : this.performResourceMove(resources);
        }
        this.openError(status);
        return result;
    }

    private IStatus performFileDrop(Object data) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 0, ResourceNavigatorMessages.DropAdapter_problemImporting, null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        final IContainer target = this.getActualTarget((IResource)this.getCurrentTarget());
        final String[] names = (String[])data;
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                PHPNavigatorDropAdapter.this.getShell().forceActive();
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(PHPNavigatorDropAdapter.this.getShell());
                operation.copyFiles(names, target);
            }
        });
        return problems;
    }

    private IStatus performResourceCopy(Shell shell, IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, ResourceNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        IContainer target = this.getActualTarget((IResource)this.getCurrentTarget());
        CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(shell);
        operation.copyResources(sources, target);
        return problems;
    }

    private IStatus performResourceMove(IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, ResourceNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        IContainer target = this.getActualTarget((IResource)this.getCurrentTarget());
        ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), ResourceNavigatorMessages.MoveResourceAction_title, ResourceNavigatorMessages.MoveResourceAction_checkMoveMessage);
        sources = checker.checkReadOnlyResources(sources);
        this.fReorgMoveAction.setSources(sources);
        this.fReorgMoveAction.setTarget(target);
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.fReorgMoveAction.runDrop((IStructuredSelection)selection);
        }
        return problems;
    }

    private IStatus validateTarget(Object target, TransferData transferType) {
        if (!(target instanceof IResource)) {
            return this.info(ResourceNavigatorMessages.DropAdapter_targetMustBeResource);
        }
        IResource resource = (IResource)target;
        if (!resource.isAccessible()) {
            return this.error(ResourceNavigatorMessages.DropAdapter_canNotDropIntoClosedProject);
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return this.error(ResourceNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings);
        }
        String message = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IResource[] selectedResources = this.getSelectedResources();
            if (selectedResources.length == 0) {
                message = ResourceNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else {
                Object operation = this.lastValidOperation == 1 ? new CopyFilesAndFoldersOperation(this.getShell()) : new MoveFilesAndFoldersOperation(this.getShell());
                message = operation.validateDestination(destination, selectedResources);
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            CopyFilesAndFoldersOperation copyOperation = new CopyFilesAndFoldersOperation(this.getShell());
            message = copyOperation.validateImportDestination(destination, sourceNames);
        }
        if (message != null) {
            return this.error(message);
        }
        return this.ok();
    }
}

