/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006, 2015, 2018 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.compiler.ast.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import org.eclipse.php.internal.core.Logger;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.php.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag.TagKind;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;

@SuppressWarnings({"unused", "nls"})


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>documentor_compiler_ast_scanner.flex</tt>
 */
public class DocumentorLexer implements IDocumentorLexer {

	/** This character denotes the end of file */
	public static final int YYEOF = -1;

	/** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

	/** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_IN_FIRST_LINE = 2;
  public static final int ST_IN_SHORT_DESC = 4;
  public static final int ST_IN_LONG_DESC = 6;
  public static final int ST_IN_TAGS = 8;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  1,  2,  3,  4,  5,  6,  7,  8, 9
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\2\1\0\1\0\1\3\22\0\1\1\11\0\1\4"+
    "\2\0\1\10\1\12\1\5\20\0\1\6\32\10\6\0\32\10\1\7"+
    "\1\0\1\11\7\0\1\0\u1fa2\0\1\0\1\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\udfe6\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\1\0\1\1\1\0\1\1\2\2\2\3"+
    "\1\2\2\4\3\2\2\5\4\2\2\6\1\2\2\1"+
    "\2\2\2\1\2\2\4\0\1\7\3\10\1\0\2\1"+
    "\2\0\1\1\1\11\1\12\3\0\1\13\1\1\2\0"+
    "\1\14\2\0\1\1\1\15\1\0\1\16\1\17\2\0"+
    "\2\20\2\0\1\21\1\22\1\23\2\0\1\24";

  private static int [] zzUnpackAction() {
    int [] result = new int[80];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\13\0\26\0\41\0\54\0\67\0\102\0\115"+
    "\0\130\0\143\0\156\0\171\0\156\0\204\0\217\0\156"+
    "\0\232\0\245\0\260\0\273\0\156\0\306\0\321\0\334"+
    "\0\347\0\362\0\156\0\375\0\u0108\0\u0113\0\u011e\0\u0129"+
    "\0\u0134\0\u013f\0\u014a\0\u0155\0\u0160\0\u016b\0\u0176\0\217"+
    "\0\245\0\156\0\u0181\0\156\0\u018c\0\260\0\273\0\321"+
    "\0\334\0\347\0\u0197\0\156\0\334\0\u01a2\0\362\0\u0108"+
    "\0\156\0\u01ad\0\u0129\0\u0134\0\156\0\u0155\0\u0160\0\u01b8"+
    "\0\u0155\0\u01c3\0\u01ce\0\u01d9\0\u01e4\0\u01ef\0\156\0\u01fa"+
    "\0\u0205\0\u0210\0\156\0\156\0\u0205\0\u021b\0\u0226\0\156";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[80];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\20\13\1\14\5\13\20\15\1\16\5\15\1\13\1\17"+
    "\1\20\1\21\1\22\5\13\1\23\1\13\1\24\1\25"+
    "\1\26\1\27\1\13\1\30\1\31\2\13\1\23\1\13"+
    "\1\32\1\33\1\34\1\35\7\13\1\36\1\33\1\34"+
    "\1\37\1\13\1\30\1\31\4\13\1\40\1\33\1\34"+
    "\1\41\7\13\1\42\1\33\1\34\1\43\1\13\1\44"+
    "\1\45\3\13\17\0\1\46\12\0\1\47\7\0\1\50"+
    "\2\0\1\51\10\0\1\20\15\0\1\52\6\0\1\53"+
    "\1\54\1\55\6\0\1\56\1\0\1\57\1\25\1\26"+
    "\1\60\1\0\1\61\1\62\5\0\1\25\11\0\1\63"+
    "\1\25\1\26\1\0\1\64\1\61\1\62\3\0\1\65"+
    "\4\0\6\65\6\0\1\66\5\0\1\67\2\0\1\70"+
    "\10\0\1\33\15\0\1\71\6\0\1\36\2\0\1\37"+
    "\1\0\1\61\1\62\4\0\1\72\3\0\1\71\1\61"+
    "\1\62\4\0\1\73\2\0\1\74\13\0\1\75\6\0"+
    "\1\42\2\0\1\43\1\0\1\76\1\77\4\0\1\100"+
    "\3\0\1\75\1\76\1\77\3\0\1\101\4\0\6\101"+
    "\6\0\1\102\10\0\1\103\12\0\1\104\7\0\1\53"+
    "\1\54\1\55\11\0\1\54\11\0\1\63\1\25\1\26"+
    "\2\0\1\61\1\62\13\0\1\105\3\0\1\72\4\0"+
    "\1\61\1\62\4\0\1\100\4\0\1\76\1\77\13\0"+
    "\1\106\3\0\1\103\1\107\1\110\10\0\1\104\4\0"+
    "\1\111\1\112\13\0\1\105\1\113\11\0\1\106\1\114"+
    "\3\0\1\107\10\0\1\115\4\0\6\115\6\0\1\116"+
    "\14\0\1\117\12\0\1\117\1\120\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[561];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


	/* error codes */
	private static final int ZZ_UNKNOWN_ERROR = 0;
	private static final int ZZ_NO_MATCH = 1;
	private static final int ZZ_PUSHBACK_2BIG = 2;

	/* error messages for the codes above */
	private static final String ZZ_ERROR_MSG[] = {
		"Unknown internal scanner error",		//$NON-NLS-1$
		"Error: could not match input",			//$NON-NLS-1$
		"Error: pushback value was too large"	//$NON-NLS-1$
	};

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\1\1\1\0\1\1\1\0\1\1\1\11\1\1"+
    "\1\11\2\1\1\11\4\1\1\11\5\1\1\11\12\1"+
    "\4\0\1\11\1\1\1\11\1\1\1\0\2\1\2\0"+
    "\1\1\1\11\1\1\3\0\1\11\1\1\2\0\1\11"+
    "\2\0\2\1\1\0\2\1\2\0\1\11\1\1\2\0"+
    "\2\11\1\1\2\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[80];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

	/** the input device */
	private java.io.Reader zzReader;

	/** the current state of the DFA */
	private int zzState;

	/** the current lexical state */
	private int zzLexicalState = YYINITIAL;

	/** this buffer contains the current text to be matched and is
		the source of the yytext() string */
	private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

	/** the textposition at the last accepting state */
	private int zzMarkedPos;

	/** the current text position in the buffer */
	private int zzCurrentPos;

	/** startRead marks the beginning of the yytext() string in the buffer */
	private int zzStartRead;

	/** endRead marks the last character in the buffer, that has been read
		from input */
	private int zzEndRead;

	/** number of newlines encountered up to the start of the matched text */
	private int yyline;

	/** the number of characters up to the start of the matched text */
	private int yychar;

	/**
	 * the number of characters from the last newline up to the start of the
	 * matched text
	 */
	private int yycolumn;

	/**
	 * zzAtBOL == true <=> the scanner is currently at the beginning of a line
	 */
	private boolean zzAtBOL = true;

	/** zzAtEOF == true <=> the scanner is at the EOF */
	private boolean zzAtEOF;

	/** denotes if the user-EOF-code has already been executed */
	private boolean zzEOFDone;

	/**
	 * The number of occupied positions in zzBuffer beyond zzEndRead.
	 * When a lead/high surrogate has been read from the input stream
	 * into the final zzBuffer position, this will have a value of 1;
	 * otherwise, it will have a value of 0.
	 */
	private int zzFinalHighSurrogate = 0;

  /* user code: */
	private String shortDesc;
	private String longDesc;
	private ArrayList<PHPDocTag> tagList;
	private TagKind currTagKind;
	private int tagPosition;
	private String matchedTagName;
	private Scalar indentedTagName;
	private StringBuilder sBuffer;
	private int numOfLines;
	private List<Scalar> textList;

	@Override
	public PHPDocBlock parse() {
		oldString = null;
		shortDesc = "";
		longDesc = "";
		tagList = new ArrayList<>();
		currTagKind = null;
		tagPosition = 0;
		matchedTagName = "";
		indentedTagName = null;
		sBuffer = new StringBuilder();
		numOfLines = 1;
		textList = new ArrayList<>();

		useOldString = true;
		int start = zzStartRead - _zzPushbackPos;

		// start parsing
		try {
			next_token();
		} catch (IOException e) {
			Logger.logException(e);
		}
		if (!tagList.isEmpty() && !textList.isEmpty()) {
			Scalar lastText = textList.get(textList.size() - 1);
			PHPDocTag lastTag = tagList.get(tagList.size() - 1);
			if (lastText.sourceEnd() >= lastTag.sourceEnd()) {
				textList.remove(textList.size() - 1);
				lastTag.getTexts().add(lastText);
				// replace last tag by a new one with updated source range and internal references
				tagList.set(tagList.size() - 1, new PHPDocTag(lastTag.sourceStart(), lastText.sourceEnd(),
						lastTag.getTagKind(), lastTag.getMatchedTag(), lastTag.getValue(), lastTag.getTagText(), lastTag.getTexts()));
			}
		}

		PHPDocTag[] tags = new PHPDocTag[tagList.size()];
		tagList.toArray(tags);

		PHPDocBlock rv = new PHPDocBlock(start, zzMarkedPos - _zzPushbackPos,
				shortDesc, longDesc, tags, textList);

		return rv;
	}

	private void startTagsState(TagKind firstState, int position, String tagName, Scalar indentedTag) {
		updateStartPos();
		handleDesc();
		currTagKind = firstState;
		tagPosition = position - _zzPushbackPos;
		matchedTagName = tagName;
		indentedTagName = indentedTag;
		sBuffer = new StringBuilder();
		yybegin(ST_IN_TAGS);
	}

	private int findTagPosition() {
		for (int i = zzStartRead; i < zzMarkedPos; i++) {
			if (zzBuffer[i] == '@' || zzBuffer[i] == '{') {
				return i;
			}
		}
		return -1;
	}

	// should only be used with ^{LINESTART}... rules:
	private int findIndentedLineStartTagPosition() {
		// we want to keep all blanks after
		// '*', see also token LINESTART
		for (int i = zzStartRead; i < zzMarkedPos; i++) {
			if (zzBuffer[i] == '*') {
				return i + 1;
			}
			if (zzBuffer[i] == '@' || zzBuffer[i] == '{') {
				break;
			}
		}
		return zzStartRead;
	}

	private void setNewTag(TagKind newTag, int position, String tagName, Scalar indentedTag) {
		updateStartPos();
		setTagValue();

		sBuffer = new StringBuilder();
		currTagKind = newTag;
		tagPosition = position - _zzPushbackPos;
		matchedTagName = tagName;
		indentedTagName = indentedTag;
	}

	private void setTagValue() {
		String value = sBuffer.toString();
		// special case for backward compatibility
		if (currTagKind == TagKind.DESC) {
			shortDesc = shortDesc + value;
			shortDesc = shortDesc.trim();
			return;
		}

		PHPDocTag basicPHPDocTag = new PHPDocTag(tagPosition, zzStartRead - _zzPushbackPos, currTagKind, matchedTagName,
				value, indentedTagName, getTexts(tagPosition, zzStartRead - _zzPushbackPos, true));
		tagList.add(basicPHPDocTag);
	}

	@NonNull
	private List<Scalar> getTexts(int start, int end, boolean remove) {
		List<Scalar> result = new ArrayList<>();
		for (Iterator<Scalar> iterator = textList.iterator(); iterator.hasNext();) {
			Scalar scalar = iterator.next();
			if (scalar.sourceStart() >= start && scalar.sourceEnd() <= end) {
				result.add(scalar);
				if (remove) {
					iterator.remove();
				}
			}
		}
		// Scalar[] texts = new Scalar[result.size()];
		// result.toArray(texts);
		return result;
	}

	private void appendText() {
		if (oldString != null) {
			sBuffer.append(oldString);
		}
		String sb = new String(zzBuffer, startPos, zzMarkedPos - startPos);
		if (oldString != null) {
			addText(oldString, sb);
		} else {
			addText(sb);
		}
		sBuffer.append(sb);
		updateStartPos();
	}

	private void addText(String oldString, String string) {
		textList.add(new Scalar(startPos - _zzPushbackPos - oldString.length(), startPos - _zzPushbackPos + string.length(), oldString + string,
				Scalar.TYPE_STRING));
	}

	private void addText(String string) {
		textList.add(new Scalar(startPos - _zzPushbackPos, startPos - _zzPushbackPos + string.length(), string,
				Scalar.TYPE_STRING));
	}

	private void handleDesc() {
		if (zzLexicalState == ST_IN_SHORT_DESC || zzLexicalState == ST_IN_FIRST_LINE) {
			shortDesc = sBuffer.toString().trim();
		} else {
			longDesc = sBuffer.toString().trim();
		}

		sBuffer = new StringBuilder();
	}

	private void startLongDescState(boolean withNewLine) {
		handleDesc();
		updateStartPos();
		if (!withNewLine) {
			addText("");
		}
		yybegin(ST_IN_LONG_DESC);
	}

	private void handleNewLine() {
		appendText();
		if (numOfLines == 4) {
			int firstLineEnd = sBuffer.indexOf("\n", 1);
			if (firstLineEnd == -1) {
				firstLineEnd = sBuffer.indexOf("\r", 1);
			}
			shortDesc = sBuffer.substring(0, firstLineEnd);
			shortDesc = shortDesc.trim();
			sBuffer.delete(0, firstLineEnd);
			yybegin(ST_IN_LONG_DESC);
		} else {
			numOfLines++;
		}
	}
	private void appendLastText() {
		String sb = new String(zzBuffer, startPos, zzMarkedPos - startPos - 2);
		// ignore last text if it only contains white spaces
		if (StringUtils.isNotBlank(sb)) {
			addText(sb);
			sBuffer.append(sb);
		}
		updateStartPos();
	}

	int maxNumberofLines = 4;

	private void handleDocEnd_shortDesc() {
		appendLastText();
		if (numOfLines == maxNumberofLines) {
			int firstLineEnd = sBuffer.indexOf("\n", 1);
			if (firstLineEnd == -1) {
				firstLineEnd = sBuffer.indexOf("\r", 1);
			}
			shortDesc = sBuffer.substring(0, firstLineEnd);
			shortDesc = shortDesc.trim();
			sBuffer.delete(0, firstLineEnd);
			longDesc = sBuffer.toString().trim();
		} else {
			shortDesc = sBuffer.toString().trim();
		}
	}

	private void handleDocEnd_longDesc() {
		appendLastText();
		longDesc = sBuffer.toString().trim();
	}

	private void handleDocEnd_inTags() {
		appendLastText();
		setTagValue();
	}

	/**
	 * Resets the {@code PhpAstLexer} properties to given parameters. Be
	 * careful, method {@link #next_token()} also caches those properties using
	 * internal variables (zzCurrentPosL, zzMarkedPosL, zzBufferL, zzEndReadL)
	 * that should be accordingly resetted by the lexical rules calling
	 * {@link #reset(java.io.Reader, char[], int[])}. Also be careful that those
	 * internal variables could change from one version of JFlex to another.
	 *
	 * @param reader
	 * @param buffer
	 * @param parameters
	 */
	@Override
	public void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		// (re)set all properties like in yyreset(java.io.Reader reader)

		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		// XXX: never used
		this.yychar = 0;
		// XXX: never used
		this.yycolumn = 0;
		this.zzAtEOF = parameters[7] != 0;
		this.zzEOFDone = parameters[8] != 0;
		this.zzFinalHighSurrogate = parameters[9];
		oldString = null;

		// NB: zzAtBOL and zzLexicalState won't be set using (directly) the
		// array "parameters", we always restart this scanner with the YYINITIAL
		// state
		this.zzAtBOL = this.zzAtEOF ? false : true;
		this.zzLexicalState = YYINITIAL;
	}

	@Override
	public int[] getParameters() {
		return new int[] { zzMarkedPos, _zzPushbackPos, zzCurrentPos,
			zzStartRead, zzEndRead, yyline, zzAtBOL ? 1 : 0,
			zzAtEOF ? 1 : 0, zzEOFDone ? 1 : 0, zzFinalHighSurrogate };
	}

	@Override
	public char[] getBuffer() {
		return zzBuffer;
	}



	/** the textposition at the last state to be included in yytext */
	private int _zzPushbackPos;

	/* The following fields are added in order to support the change in zzRefill */
	private String oldString = null;
	private boolean useOldString = false;
	private int startPos = 0;

	/**
	 * Creates a new scanner
	 *
	 * @param   in  the java.io.Reader to read input from.
	 */
  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public DocumentorLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 88) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>false</code>, iff there was new input.
	 *
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
	private boolean zzRefill() throws java.io.IOException {

		if (useOldString) {
			String saveOldString = oldString;
			oldString = new String(zzBuffer, startPos, zzMarkedPos - startPos);
			if (saveOldString != null) {
				oldString = saveOldString + oldString;
			}
		}

		/* first: make room (if you can) */
		if (zzStartRead > 0) {
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
			System.arraycopy(zzBuffer, zzStartRead,
							zzBuffer, 0,
							zzEndRead-zzStartRead);

			/* translate stored positions */
			zzEndRead-= zzStartRead;
			zzCurrentPos-= zzStartRead;
			zzMarkedPos-= zzStartRead;
			_zzPushbackPos-= zzStartRead;
			startPos = 0;
			zzStartRead = 0;
		}

		/* is the buffer big enough? */
		if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
			/* if not: blow it up */
			char newBuffer[] = new char[zzBuffer.length*2];
			System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
			zzBuffer = newBuffer;
			zzEndRead += zzFinalHighSurrogate;
			zzFinalHighSurrogate = 0;
		}

		/* fill the buffer with new input */
		int requested = zzBuffer.length - zzEndRead;
		int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

		/* not supposed to occur according to specification of java.io.Reader */
		if (numRead == 0) {
			throw new java.io.IOException("Reader returned 0 characters.");
		}
		if (numRead > 0) {
			zzEndRead += numRead;
			/* If numRead == requested, we might have requested to few chars to
			   encode a full Unicode character. We assume that a Reader would
			   otherwise never return half characters. */
			if (numRead == requested) {
				if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
					--zzEndRead;
					zzFinalHighSurrogate = 1;
				}
			}
			/* potentially more input available */
			return false;
		}

		/* numRead < 0 ==> end of stream */
		return true;
	}


	/**
	 * Gets the next input character.
	 *
	 * @return      the next character of the input stream, EOF if the
	 *              end of the stream is reached.
	 * @exception   IOException  if any I/O-Error occurs
	 */
	private int yy_advance() throws java.io.IOException {

		/* standard case */
		if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

		/* if the eof is reached, we don't need to work hard */
		if (zzAtEOF) return YYEOF;

		/* otherwise: need to refill the buffer */

		String saveOldString = oldString;
		oldString = null;

		/* first: make room (if you can) */
		if (zzRefill()) {
			oldString = saveOldString;
			return YYEOF;
		}

		oldString = saveOldString;

		return zzBuffer[zzCurrentPos++];
	}


	/**
	 * Closes the input stream.
	 */
	public final void yyclose() throws java.io.IOException {
		zzAtEOF = true;            /* indicate end of file */
		zzEndRead = zzStartRead;  /* invalidate buffer    */

		if (zzReader != null)
			zzReader.close();
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>ZZ_INITIAL</tt>.
	 *
	 * Internal scan buffer is resized down to its initial length, if it has grown.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) {
		zzReader = reader;
		zzAtBOL  = true;
		zzAtEOF  = false;
		zzEOFDone = false;
		zzEndRead = zzStartRead = 0;
		zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
		zzFinalHighSurrogate = 0;
		oldString = null;
		yyline = yychar = yycolumn = 0;
		zzLexicalState = YYINITIAL;
		if (zzBuffer.length > ZZ_BUFFERSIZE)
			zzBuffer = new char[ZZ_BUFFERSIZE];
	}


	/**
	 * Returns the current lexical state.
	 */
	public final int yystate() {
		return zzLexicalState;
	}


	/**
	 * Enters a new lexical state
	 *
	 * @param newState the new lexical state
	 */
	public final void yybegin(int newState) {
		zzLexicalState = newState;
	}


	/**
	 * Returns the text matched by the current regular expression.
	 */
	public final String yytext() {
		return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
	}


	/**
	 * Returns the character at position <tt>pos</tt> from the
	 * matched text.
	 *
	 * It is equivalent to yytext().charAt(pos), but faster
	 *
	 * @param pos the position of the character to fetch.
	 *            A value from 0 to yylength()-1.
	 *
	 * @return the character at position pos
	 */
	public final char yycharat(int pos) {
		return zzBuffer[zzStartRead+pos];
	}


	/**
	 * Returns the length of the matched text region.
	 */
	public final int yylength() {
		return zzMarkedPos-zzStartRead;
	}


	/**
	 * Reports an error that occured while scanning.
	 *
	 * In a wellformed scanner (no or only correct usage of
	 * yypushback(int) and a match-all fallback rule) this method
	 * will only be called with things that "Can't Possibly Happen".
	 * If this method is called, something is seriously wrong
	 * (e.g. a JFlex bug producing a faulty scanner etc.).
	 *
	 * Usual syntax/scanner level error handling should be done
	 * in error fallback rules.
	 *
	 * @param   errorCode  the code of the errormessage to display
	 */
  private void zzScanError(int errorCode) {
		String message;
		try {
			message = ZZ_ERROR_MSG[errorCode];
		}
		catch (ArrayIndexOutOfBoundsException e) {
			message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
		}

    throw new Error(message);
	}


	/**
	 * Pushes the specified amount of characters back into the input stream.
	 *
	 * They will be read again by then next call of the scanning method
	 *
	 * @param number  the number of characters to be read again.
	 *                This number must not be greater than yylength()!
	 */
  public void yypushback(int number)  {
		if ( number > yylength() )
			zzScanError(ZZ_PUSHBACK_2BIG);

		zzMarkedPos -= number;
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		updateStartPos(zzMarkedPos);
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos(int position) {
		startPos = position;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


	/**
	 * Resumes scanning until the next regular expression is matched,
	 * the end of input is encountered or an I/O-Error occurs.
	 *
	 * @return      the next token
	 * @exception   java.io.IOException  if any I/O-Error occurs
	 */
  public int next_token() throws java.io.IOException {
	int zzInput;
	int zzAction;

	// cached fields:
	int zzCurrentPosL;
	int zzMarkedPosL;
	int zzEndReadL = zzEndRead;
	char [] zzBufferL = zzBuffer;
	char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

	while (true) {
		zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
		zzAction = -1;

		zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


		zzForAction: {
			while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
				zzAction = zzState;
				zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
				}

			}
		}

			// store back cached position
			zzMarkedPos = zzMarkedPosL;

			if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
				zzAtEOF = true;
            zzDoEOF();
        return YYEOF;
			}
			else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { updateStartPos(findIndentedLineStartTagPosition());
            }
          case 21: break;
          case 2: 
            { 
            }
          case 22: break;
          case 3: 
            { System.out.print(yytext());
            }
          case 23: break;
          case 4: 
            { handleNewLine();
            }
          case 24: break;
          case 5: 
            { startLongDescState(false);
            }
          case 25: break;
          case 6: 
            { appendText();
            }
          case 26: break;
          case 7: 
            { maxNumberofLines = 4;
	handleDocEnd_shortDesc();
	return -1;
            }
          case 27: break;
          case 8: 
            { appendText();
	startLongDescState(true);
            }
          case 28: break;
          case 9: 
            { maxNumberofLines = 5;
	handleDocEnd_shortDesc();
	return -1;
            }
          case 29: break;
          case 10: 
            { int position = findTagPosition();
	// NB: no need to check if "value" contains the closing "*/" PHPDoc string
	// since character '*' is not allowed in {TAG_NAME_CHARS}
	String value = new String(zzBuffer, position, zzMarkedPos - position);

	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = findIndentedLineStartTagPosition();
	String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
	Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
			indentedText, Scalar.TYPE_STRING);
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		startTagsState(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		startTagsState(TagKind.UNKNOWN, position, value, indentedTag);
	}
            }
          case 30: break;
          case 11: 
            { handleDocEnd_longDesc();return -1;
            }
          case 31: break;
          case 12: 
            { handleDocEnd_inTags();return -1;
            }
          case 32: break;
          case 13: 
            { int position = findTagPosition();
	// NB: no need to check if "value" contains the closing "*/" PHPDoc string
	// since character '*' is not allowed in {TAG_NAME_CHARS}
	String value = new String(zzBuffer, position, zzMarkedPos - position);

	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = findIndentedLineStartTagPosition();
	String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
	Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
			indentedText, Scalar.TYPE_STRING);
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		setNewTag(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		setNewTag(TagKind.UNKNOWN, position, value, indentedTag);
	}
            }
          case 33: break;
          case 14: 
            { yypushback(yylength());
		updateStartPos();
		// https://bugs.eclipse.org/bugs/show_bug.cgi?id=474332
		// look for @tags on the first line of this PHPDoc block
		yybegin(ST_IN_FIRST_LINE);
            }
          case 34: break;
          case 15: 
            { // https://bugs.eclipse.org/bugs/show_bug.cgi?id=474332
	// no @tags were found on first line, continue normal
	// processing...
	updateStartPos(zzStartRead + 3); // skip "/**"
	yybegin(ST_IN_SHORT_DESC);
            }
          case 35: break;
          case 16: 
            { updateStartPos();
		yybegin(ST_IN_SHORT_DESC);
            }
          case 36: break;
          case 17: 
            { int position = findTagPosition();
	String value = new String(zzBuffer, position, zzMarkedPos - position);
	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = findIndentedLineStartTagPosition();
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
		Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
				indentedText, Scalar.TYPE_STRING);
		startTagsState(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		updateStartPos(indentedTagPosition);
		// no need to call yypushback(zzMarkedPos - indentedTagPosition) here...
	}
            }
          case 37: break;
          case 18: 
            { int position = findTagPosition();
	String value = new String(zzBuffer, position, zzMarkedPos - position);
	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = findIndentedLineStartTagPosition();
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
		Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
				indentedText, Scalar.TYPE_STRING);
		setNewTag(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		updateStartPos(indentedTagPosition);
		// no need to call yypushback(zzMarkedPos - indentedTagPosition) here...
	}
            }
          case 38: break;
          case 19: 
            { int position = findTagPosition();
	// NB: no need to check if "value" contains the closing "*/" PHPDoc string
	// since character '*' is not allowed in {TAG_NAME_CHARS}
	String value = new String(zzBuffer, position, zzMarkedPos - position);

	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = zzStartRead + 3; // skip "/**"
	String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
	Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
			indentedText, Scalar.TYPE_STRING);
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		startTagsState(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		startTagsState(TagKind.UNKNOWN, position, value, indentedTag);
	}
            }
          case 39: break;
          case 20: 
            { int position = findTagPosition();
	String value = new String(zzBuffer, position, zzMarkedPos - position);
	TagKind tagkind = TagKind.getTagKindFromValue(value);
	int indentedTagPosition = zzStartRead + 3; // skip "/**"
	if (tagkind != null && tagkind != TagKind.UNKNOWN) {
		String indentedText = new String(zzBuffer, indentedTagPosition, zzMarkedPos - indentedTagPosition);
		Scalar indentedTag = new Scalar(indentedTagPosition - _zzPushbackPos, indentedTagPosition - _zzPushbackPos + indentedText.length(),
				indentedText, Scalar.TYPE_STRING);
		startTagsState(tagkind, position, tagkind.getValue(), indentedTag);
	} else {
		// https://bugs.eclipse.org/bugs/show_bug.cgi?id=474332
		// no @tags were found on first line, continue normal
		// processing...
		updateStartPos(indentedTagPosition);
		// no need to call yypushback(zzMarkedPos - indentedTagPosition) here...
		yybegin(ST_IN_SHORT_DESC);
	}
            }
          case 40: break;
		default:
            zzScanError(ZZ_NO_MATCH);
				}
			}
		}
	}

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java DocumentorLexer [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          java.nio.charset.Charset.forName(encodingName); // Side-effect: is encodingName valid? 
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        DocumentorLexer scanner = null;
        try {
          java.io.FileInputStream stream = new java.io.FileInputStream(argv[i]);
          java.io.Reader reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new DocumentorLexer(reader);
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
