/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Zend Technologies
 *******************************************************************************/
package org.eclipse.php.internal.ui.folding;

import org.eclipse.jface.text.source.projection.ProjectionViewer;

/**
 * Implementors of this interface which will create and maintain
 * {@link org.eclipse.jface.text.source.projection.ProjectionAnnotation} objects
 * that define folded regions in the the
 * {@link org.eclipse.jface.text.source.projection.ProjectionViewer}for a
 * structured model.
 */
public interface IStructuredTextFoldingProvider {

	// copied interface from
	// org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProvider
	/**
	 * Installs this structure provider on the given viewer. Implementations
	 * should listen to the projection events generated by <code>viewer</code>
	 * and enable / disable generation of projection structure accordingly.
	 * 
	 * @param viewer
	 *            the projection viewer that displays the annotations created by
	 *            this structure provider
	 */
	public void install(ProjectionViewer viewer);

	/**
	 * Uninstalls this structure provider. Any references to viewers should be
	 * cleared.
	 */
	public void uninstall();

	/**
	 * Initialize this provider with the correct document. Assumes projection is
	 * enabled. (otherwise, only install would have been called)
	 */
	public void initialize();
}
