// DO NOT EDIT
// Generated by JFlex 1.9.1 http://jflex.de/
// source: ast_scanner.flex

/*******************************************************************************
 * Copyright (c) 2019 Zend Corporation and IBM Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.ast.scanner.php82;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Stack;

import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.util.collections.StateStack;

import java_cup.sym;
import java_cup.runtime.Symbol;

//@SuppressWarnings({"unused", "nls"})


@SuppressWarnings("fallthrough")
public class PHPAstLexer implements org.eclipse.php.internal.core.ast.scanner.AstLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;
  public static final int ST_IN_SCRIPTING = 2;
  public static final int ST_DOUBLE_QUOTES = 4;
  public static final int ST_SINGLE_QUOTE = 6;
  public static final int ST_BACKQUOTE = 8;
  public static final int ST_HEREDOC = 10;
  public static final int ST_NOWDOC = 12;
  public static final int ST_START_HEREDOC = 14;
  public static final int ST_START_NOWDOC = 16;
  public static final int ST_END_HEREDOC = 18;
  public static final int ST_LOOKING_FOR_PROPERTY = 20;
  public static final int ST_LOOKING_FOR_VARNAME = 22;
  public static final int ST_VAR_OFFSET = 24;
  public static final int ST_COMMENT = 26;
  public static final int ST_DOCBLOCK = 28;
  public static final int ST_ONE_LINE_COMMENT = 30;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\37\u0200\1\u0300\266\u0200\10\u0400\40\u0200\u1000\u0500";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\2\0\1\3\22\0\1\1\1\4"+
    "\1\5\1\6\1\7\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\6\25\2\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\67\1\70\1\71\1\72\1\73\1\74"+
    "\1\75\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\67\1\76\1\77\1\100\1\101\1\0"+
    "\260\67\2\46\115\67\1\60\u01aa\67\1\50\325\67\u0100\102"+
    "\u0100\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[1536];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\2\1\11\0\2\2\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\2\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\26\34\1\35\1\36"+
    "\1\37\1\40\1\34\1\41\1\42\1\43\1\44\1\45"+
    "\1\1\1\46\3\3\1\47\1\50\1\3\1\1\2\3"+
    "\1\51\1\3\2\1\3\3\1\1\2\52\1\53\2\54"+
    "\1\55\1\56\3\57\1\60\1\61\1\62\1\63\1\5"+
    "\1\64\1\11\1\12\1\14\1\16\1\17\1\21\1\22"+
    "\1\23\2\65\1\25\1\27\1\30\1\31\1\32\1\34"+
    "\1\66\1\40\1\67\1\70\1\43\1\71\1\4\1\72"+
    "\3\4\3\73\2\72\1\74\1\0\1\75\1\76\1\77"+
    "\1\0\1\100\3\0\1\101\1\102\1\103\1\104\1\0"+
    "\1\105\1\106\1\0\1\107\14\0\1\110\1\111\1\112"+
    "\1\113\1\114\1\115\1\116\1\0\1\117\1\120\1\121"+
    "\1\7\1\122\1\117\5\0\1\123\1\0\1\124\1\125"+
    "\1\77\1\126\1\127\1\130\1\131\1\0\1\132\1\133"+
    "\3\34\1\134\2\0\6\34\1\135\7\34\1\136\4\34"+
    "\1\137\7\34\1\140\15\34\1\141\1\142\1\34\1\143"+
    "\1\144\3\0\2\145\1\102\1\146\1\147\1\145\1\0"+
    "\1\150\3\0\2\145\3\0\1\151\2\145\1\152\2\0"+
    "\1\153\1\0\1\110\4\0\1\154\1\155\1\0\1\156"+
    "\1\157\1\0\1\160\13\0\1\161\1\162\2\0\1\163"+
    "\1\0\1\164\1\0\1\117\1\165\1\117\2\0\1\166"+
    "\1\167\1\170\1\171\1\172\1\173\1\34\1\174\1\34"+
    "\1\175\1\0\11\34\1\176\11\34\1\177\13\34\1\200"+
    "\12\34\1\201\1\34\1\202\1\203\1\34\1\204\1\34"+
    "\1\0\7\34\1\0\1\205\1\206\3\65\13\0\1\207"+
    "\5\0\4\34\1\210\10\34\1\211\1\212\7\34\1\213"+
    "\5\34\1\214\5\34\1\215\30\34\10\0\1\216\11\0"+
    "\2\217\1\34\1\220\1\221\1\34\1\222\1\223\1\224"+
    "\1\225\5\34\1\226\2\34\1\227\2\34\1\0\1\34"+
    "\1\230\10\34\1\231\1\232\1\34\1\233\10\34\1\234"+
    "\1\235\1\236\1\237\1\240\10\34\1\241\2\242\3\0"+
    "\1\243\4\0\1\244\5\0\5\34\1\245\1\246\1\34"+
    "\1\247\2\34\1\250\4\34\1\251\10\34\1\252\2\34"+
    "\1\253\1\254\1\255\1\0\10\34\1\256\4\0\1\257"+
    "\2\0\3\34\1\260\1\261\4\34\1\262\1\263\1\264"+
    "\2\34\1\265\4\34\1\266\2\34\1\267\1\0\1\34"+
    "\1\270\6\34\1\271\1\272\4\0\1\273\1\274\1\275"+
    "\3\34\1\276\1\277\7\34\1\300\1\34\1\0\1\34"+
    "\1\301\2\34\1\302\2\34\2\0\2\34\1\303\3\34"+
    "\1\304\1\305\1\306\1\307\1\34\1\0\1\310\4\34"+
    "\2\0\1\311\1\312\1\313\1\34\1\314\1\0\1\34"+
    "\1\315\2\34\1\316\1\34\3\0\1\34\1\317\4\34"+
    "\2\0\1\320\1\321\1\322\2\34\1\323\1\34\1\324"+
    "\1\34\1\325";

  private static int [] zzUnpackAction() {
    int [] result = new int[727];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\103\0\206\0\311\0\u010c\0\u014f\0\u0192\0\u01d5"+
    "\0\u0218\0\u025b\0\u029e\0\u02e1\0\u0324\0\u0367\0\u03aa\0\u03ed"+
    "\0\u0430\0\u0473\0\u04b6\0\u04f9\0\u053c\0\u057f\0\u05c2\0\u0605"+
    "\0\u0648\0\u068b\0\u06ce\0\u0711\0\u04b6\0\u0754\0\u0797\0\u04b6"+
    "\0\u07da\0\u081d\0\u0860\0\u08a3\0\u08e6\0\u0929\0\u04b6\0\u096c"+
    "\0\u09af\0\u09f2\0\u0a35\0\u04b6\0\u0a78\0\u0abb\0\u0afe\0\u0b41"+
    "\0\u0b84\0\u0bc7\0\u0c0a\0\u0c4d\0\u0c90\0\u0cd3\0\u0d16\0\u0d59"+
    "\0\u0d9c\0\u0ddf\0\u0e22\0\u0e65\0\u0ea8\0\u0eeb\0\u0f2e\0\u0f71"+
    "\0\u0fb4\0\u0ff7\0\u04b6\0\u103a\0\u04b6\0\u107d\0\u10c0\0\u04b6"+
    "\0\u04b6\0\u1103\0\u04b6\0\u04b6\0\u1146\0\u04b6\0\u1189\0\u11cc"+
    "\0\u120f\0\u1252\0\u04b6\0\u1295\0\u12d8\0\u131b\0\u135e\0\u04b6"+
    "\0\u13a1\0\u13e4\0\u1427\0\u146a\0\u14ad\0\u14f0\0\u1533\0\u04b6"+
    "\0\u1576\0\u15b9\0\u04b6\0\u15fc\0\u163f\0\u1682\0\u04b6\0\u16c5"+
    "\0\u1708\0\u174b\0\u04b6\0\u178e\0\u04b6\0\u04b6\0\u04b6\0\u04b6"+
    "\0\u04b6\0\u04b6\0\u17d1\0\u04b6\0\u04b6\0\u04b6\0\u04b6\0\u1814"+
    "\0\u1857\0\u04b6\0\u04b6\0\u04b6\0\u04b6\0\u04b6\0\u189a\0\u04b6"+
    "\0\u04b6\0\u04b6\0\u04b6\0\u04b6\0\u04b6\0\u18dd\0\u1920\0\u04b6"+
    "\0\u1963\0\u19a6\0\u19e9\0\u04b6\0\u1a2c\0\u1a6f\0\u04b6\0\u19e9"+
    "\0\u1ab2\0\u1af5\0\u1b38\0\u1b7b\0\u057f\0\u04b6\0\u1bbe\0\u1c01"+
    "\0\u1c44\0\u04b6\0\u1c87\0\u04b6\0\u04b6\0\u1cca\0\u04b6\0\u04b6"+
    "\0\u1d0d\0\u04b6\0\u06ce\0\u1d50\0\u0711\0\u1d93\0\u1dd6\0\u1e19"+
    "\0\u1e5c\0\u1e9f\0\u1ee2\0\u1f25\0\u1f68\0\u1fab\0\u1fee\0\u04b6"+
    "\0\u04b6\0\u04b6\0\u04b6\0\u04b6\0\u04b6\0\u2031\0\u2074\0\u04b6"+
    "\0\u20b7\0\u04b6\0\u04b6\0\u20fa\0\u213d\0\u2180\0\u21c3\0\u2206"+
    "\0\u2249\0\u04b6\0\u228c\0\u22cf\0\u2312\0\u04b6\0\u2355\0\u04b6"+
    "\0\u04b6\0\u2398\0\u23db\0\u04b6\0\u241e\0\u2461\0\u24a4\0\u24e7"+
    "\0\u0c4d\0\u252a\0\u256d\0\u25b0\0\u25f3\0\u2636\0\u2679\0\u26bc"+
    "\0\u26ff\0\u0c4d\0\u2742\0\u2785\0\u27c8\0\u280b\0\u284e\0\u2891"+
    "\0\u28d4\0\u0c4d\0\u2917\0\u295a\0\u299d\0\u29e0\0\u0c4d\0\u2a23"+
    "\0\u2a66\0\u2aa9\0\u2aec\0\u2b2f\0\u2b72\0\u2bb5\0\u0c4d\0\u2bf8"+
    "\0\u2c3b\0\u2c7e\0\u2cc1\0\u2d04\0\u2d47\0\u2d8a\0\u2dcd\0\u2e10"+
    "\0\u2e53\0\u2e96\0\u2ed9\0\u2f1c\0\u2f5f\0\u04b6\0\u2fa2\0\u04b6"+
    "\0\u04b6\0\u2fe5\0\u11cc\0\u3028\0\u04b6\0\u2fe5\0\u306b\0\u04b6"+
    "\0\u04b6\0\u3028\0\u30ae\0\u04b6\0\u30f1\0\u135e\0\u3134\0\u30f1"+
    "\0\u3134\0\u3177\0\u14ad\0\u31ba\0\u31fd\0\u3177\0\u31ba\0\u3240"+
    "\0\u1576\0\u15fc\0\u04b6\0\u3283\0\u04b6\0\u32c6\0\u3309\0\u334c"+
    "\0\u338f\0\u04b6\0\u04b6\0\u19e9\0\u04b6\0\u04b6\0\u33d2\0\u04b6"+
    "\0\u3415\0\u3458\0\u349b\0\u34de\0\u3521\0\u3564\0\u35a7\0\u35ea"+
    "\0\u362d\0\u3670\0\u36b3\0\u04b6\0\u04b6\0\u36f6\0\u3739\0\u377c"+
    "\0\u37bf\0\u3802\0\u3845\0\u3888\0\u38cb\0\u390e\0\u3951\0\u3994"+
    "\0\u04b6\0\u04b6\0\u04b6\0\u04b6\0\u04b6\0\u04b6\0\u39d7\0\u0c4d"+
    "\0\u3a1a\0\u3a5d\0\u3aa0\0\u3ae3\0\u3b26\0\u3b69\0\u3bac\0\u3bef"+
    "\0\u3c32\0\u3c75\0\u3cb8\0\u3cfb\0\u0c4d\0\u3d3e\0\u3d81\0\u3dc4"+
    "\0\u3e07\0\u3e4a\0\u3e8d\0\u3ed0\0\u3f13\0\u3f56\0\u3f99\0\u3fdc"+
    "\0\u401f\0\u4062\0\u40a5\0\u40e8\0\u412b\0\u416e\0\u41b1\0\u41f4"+
    "\0\u4237\0\u427a\0\u0c4d\0\u42bd\0\u4300\0\u4343\0\u4386\0\u43c9"+
    "\0\u440c\0\u444f\0\u4492\0\u44d5\0\u4518\0\u0c4d\0\u455b\0\u0c4d"+
    "\0\u0c4d\0\u459e\0\u0c4d\0\u45e1\0\u103a\0\u4624\0\u4667\0\u46aa"+
    "\0\u46ed\0\u4730\0\u4773\0\u47b6\0\u47f9\0\u04b6\0\u04b6\0\u483c"+
    "\0\u487f\0\u48c2\0\u4905\0\u4948\0\u498b\0\u49ce\0\u4a11\0\u4a54"+
    "\0\u4a97\0\u4ada\0\u4b1d\0\u4b60\0\u4ba3\0\u04b6\0\u4be6\0\u4c29"+
    "\0\u4c6c\0\u4caf\0\u4cf2\0\u4d35\0\u4d78\0\u4dbb\0\u4dfe\0\u0c4d"+
    "\0\u4e41\0\u4e84\0\u4ec7\0\u4f0a\0\u4f4d\0\u4f90\0\u4fd3\0\u5016"+
    "\0\u0c4d\0\u5059\0\u509c\0\u50df\0\u5122\0\u5165\0\u51a8\0\u51eb"+
    "\0\u522e\0\u0c4d\0\u5271\0\u52b4\0\u52f7\0\u533a\0\u537d\0\u0c4d"+
    "\0\u53c0\0\u5403\0\u5446\0\u5489\0\u54cc\0\u0c4d\0\u550f\0\u5552"+
    "\0\u5595\0\u55d8\0\u561b\0\u565e\0\u56a1\0\u56e4\0\u5727\0\u576a"+
    "\0\u57ad\0\u57f0\0\u5833\0\u5876\0\u58b9\0\u58fc\0\u593f\0\u5982"+
    "\0\u59c5\0\u5a08\0\u5a4b\0\u5a8e\0\u5ad1\0\u5b14\0\u5b57\0\u5b9a"+
    "\0\u5bdd\0\u5c20\0\u5c63\0\u5ca6\0\u5ce9\0\u5d2c\0\u04b6\0\u5d6f"+
    "\0\u5db2\0\u5df5\0\u5e38\0\u5e7b\0\u5ebe\0\u5f01\0\u5f44\0\u5f87"+
    "\0\u04b6\0\u5fca\0\u600d\0\u0c4d\0\u0c4d\0\u6050\0\u0c4d\0\u0c4d"+
    "\0\u0c4d\0\u0c4d\0\u6093\0\u60d6\0\u6119\0\u615c\0\u619f\0\u0c4d"+
    "\0\u61e2\0\u6225\0\u0c4d\0\u6268\0\u62ab\0\u62ee\0\u6331\0\u6374"+
    "\0\u63b7\0\u63fa\0\u643d\0\u6480\0\u64c3\0\u6506\0\u6549\0\u658c"+
    "\0\u0c4d\0\u0c4d\0\u65cf\0\u0c4d\0\u6612\0\u6655\0\u6698\0\u66db"+
    "\0\u671e\0\u6761\0\u67a4\0\u67e7\0\u0c4d\0\u0c4d\0\u0c4d\0\u0c4d"+
    "\0\u682a\0\u686d\0\u68b0\0\u68f3\0\u6936\0\u6979\0\u69bc\0\u69ff"+
    "\0\u6a42\0\u04b6\0\u04b6\0\u6a85\0\u6ac8\0\u6b0b\0\u6b4e\0\u04b6"+
    "\0\u6b91\0\u6bd4\0\u6c17\0\u6c5a\0\u04b6\0\u6c9d\0\u6ce0\0\u6d23"+
    "\0\u6d66\0\u6da9\0\u6dec\0\u6e2f\0\u6e72\0\u6eb5\0\u6ef8\0\u0c4d"+
    "\0\u0c4d\0\u6f3b\0\u6f7e\0\u6fc1\0\u7004\0\u7047\0\u708a\0\u70cd"+
    "\0\u7110\0\u7153\0\u0c4d\0\u7196\0\u71d9\0\u721c\0\u725f\0\u72a2"+
    "\0\u72e5\0\u7328\0\u736b\0\u0c4d\0\u73ae\0\u73f1\0\u0c4d\0\u0c4d"+
    "\0\u0c4d\0\u7434\0\u7477\0\u74ba\0\u74fd\0\u7540\0\u7583\0\u75c6"+
    "\0\u7609\0\u764c\0\u04b6\0\u768f\0\u76d2\0\u7715\0\u7758\0\u04b6"+
    "\0\u779b\0\u77de\0\u7821\0\u7864\0\u78a7\0\u0c4d\0\u0c4d\0\u78ea"+
    "\0\u792d\0\u7970\0\u79b3\0\u0c4d\0\u0c4d\0\u0c4d\0\u79f6\0\u7a39"+
    "\0\u7a7c\0\u7abf\0\u7b02\0\u7b45\0\u7b88\0\u0c4d\0\u7bcb\0\u7c0e"+
    "\0\u7c51\0\u7c94\0\u7cd7\0\u0c4d\0\u7d1a\0\u7d5d\0\u7da0\0\u7de3"+
    "\0\u7e26\0\u7e69\0\u04b6\0\u04b6\0\u7eac\0\u7eef\0\u7f32\0\u7f75"+
    "\0\u0c4d\0\u0c4d\0\u0c4d\0\u7fb8\0\u7ffb\0\u803e\0\u0c4d\0\u0c4d"+
    "\0\u8081\0\u80c4\0\u8107\0\u814a\0\u818d\0\u81d0\0\u8213\0\u0c4d"+
    "\0\u8256\0\u8299\0\u82dc\0\u0c4d\0\u831f\0\u8362\0\u0c4d\0\u83a5"+
    "\0\u83e8\0\u842b\0\u846e\0\u84b1\0\u84f4\0\u0c4d\0\u8537\0\u857a"+
    "\0\u85bd\0\u0c4d\0\u0c4d\0\u8600\0\u0c4d\0\u8643\0\u8686\0\u0c4d"+
    "\0\u86c9\0\u870c\0\u874f\0\u8792\0\u87d5\0\u8818\0\u0c4d\0\u0c4d"+
    "\0\u0c4d\0\u885b\0\u0c4d\0\u889e\0\u88e1\0\u04b6\0\u8924\0\u8967"+
    "\0\u0c4d\0\u89aa\0\u89ed\0\u8a30\0\u8a73\0\u8ab6\0\u8af9\0\u8b3c"+
    "\0\u8b7f\0\u8bc2\0\u8c05\0\u8c48\0\u8c8b\0\u0c4d\0\u0c4d\0\u0c4d"+
    "\0\u8cce\0\u8d11\0\u04b6\0\u8d54\0\u0c4d\0\u8d97\0\u0c4d";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[727];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\31\21\1\22\51\21\1\23\3\24\1\25\1\26\1\27"+
    "\1\30\1\31\1\32\1\33\1\34\1\35\1\36\1\37"+
    "\1\40\1\41\1\42\1\43\1\44\3\45\1\46\1\47"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\1\56\1\57"+
    "\1\60\1\61\1\62\1\63\1\64\1\65\2\64\1\66"+
    "\1\67\1\70\1\71\1\72\1\64\1\73\1\74\1\75"+
    "\1\76\1\77\1\100\1\101\1\102\1\64\1\103\1\104"+
    "\1\105\1\106\1\107\1\110\1\111\1\112\1\113\1\114"+
    "\1\64\5\115\1\116\1\115\1\117\61\115\1\120\4\115"+
    "\1\121\4\115\12\122\1\123\56\122\1\124\11\122\7\125"+
    "\1\126\61\125\1\127\3\125\1\130\1\131\4\125\2\132"+
    "\2\133\3\132\1\134\61\132\1\135\4\132\1\136\4\132"+
    "\2\7\2\137\77\7\1\140\1\141\34\140\32\142\4\140"+
    "\1\142\5\140\1\142\1\143\1\144\34\143\32\145\4\143"+
    "\1\145\5\143\1\145\36\23\32\146\4\23\1\146\5\23"+
    "\1\146\1\147\3\24\14\147\1\150\13\147\1\151\1\147"+
    "\32\152\4\147\1\152\5\147\1\152\36\153\32\154\4\153"+
    "\1\154\5\153\1\154\1\23\3\155\1\156\1\157\1\155"+
    "\1\30\1\160\1\161\1\155\1\162\1\35\1\163\1\164"+
    "\1\40\1\165\1\166\1\167\1\170\3\171\1\172\1\47"+
    "\1\173\1\174\1\175\1\176\1\54\32\177\1\103\1\155"+
    "\1\200\1\201\1\177\1\202\1\203\1\204\1\205\1\114"+
    "\1\177\15\206\1\207\65\206\3\210\1\211\11\210\1\212"+
    "\65\210\2\213\1\214\1\215\4\213\1\216\22\213\1\217"+
    "\1\216\45\213\1\220\31\21\1\221\61\21\1\222\20\21"+
    "\1\0\2\21\1\223\46\21\104\0\3\24\131\0\1\224"+
    "\50\0\5\225\1\226\1\225\1\227\61\225\1\230\4\225"+
    "\1\231\4\225\70\0\1\232\50\0\32\233\4\0\1\233"+
    "\5\0\1\233\32\0\1\234\1\235\50\0\3\236\3\0"+
    "\1\237\1\0\1\240\7\0\1\241\10\0\1\242\50\0"+
    "\12\243\1\226\56\243\1\244\11\243\1\0\1\245\34\0"+
    "\1\246\1\247\1\0\1\250\1\0\1\251\2\0\1\252"+
    "\5\0\1\253\2\0\1\254\1\255\1\0\1\256\35\0"+
    "\1\257\14\0\1\260\66\0\1\261\13\0\1\262\70\0"+
    "\1\263\11\0\1\264\1\265\70\0\1\266\1\0\4\267"+
    "\3\0\1\270\65\0\1\271\4\0\1\272\7\0\1\273"+
    "\71\0\1\274\1\0\4\45\10\0\1\275\2\0\1\276"+
    "\11\0\1\277\10\0\1\300\6\0\1\301\27\0\1\274"+
    "\1\0\4\45\13\0\1\276\31\0\1\301\35\0\1\302"+
    "\75\0\1\303\6\0\1\304\1\305\1\306\101\0\1\307"+
    "\1\310\101\0\1\311\1\312\67\0\1\313\12\0\1\314"+
    "\1\315\71\0\4\64\7\0\1\64\1\316\13\64\1\317"+
    "\3\64\1\320\1\321\7\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\5\0\1\26\4\0\1\243\10\0\4\64"+
    "\2\0\1\323\4\0\21\64\1\324\10\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\1\325"+
    "\12\64\1\326\2\64\1\327\13\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\4\64\1\330"+
    "\3\64\1\331\5\64\1\332\13\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\2\64\1\333"+
    "\10\64\1\334\1\335\1\336\7\64\1\337\1\64\1\340"+
    "\2\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\10\64\1\341\4\64\1\342\1\343\5\64"+
    "\1\344\5\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\13\64\1\345\2\64\1\346\13\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\32\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\5\64\1\347\6\64\1\350\1\351"+
    "\4\64\1\352\7\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\10\64\1\353\21\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\1\354\31\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\1\355\3\64\1\356\25\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\21\64\1\357\10\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\21\64\1\360\2\64\1\361"+
    "\5\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\4\64\1\362\25\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\23\64\1\363"+
    "\2\64\1\364\3\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\7\64\1\365\11\64\1\366"+
    "\10\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\15\64\1\367\4\64\1\370\7\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\1\371\31\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\7\64\1\372\22\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\16\64"+
    "\1\373\13\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\10\64\1\374\21\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\36\0\32\375\4\0\1\375"+
    "\5\0\1\375\32\0\1\376\73\0\4\64\7\0\32\64"+
    "\1\0\1\322\2\0\1\377\5\0\1\64\32\0\1\u0100"+
    "\44\0\1\u0101\3\0\5\115\1\0\1\115\1\u0102\61\115"+
    "\1\u0103\4\115\1\u0104\11\115\1\u0105\1\115\1\u0106\26\115"+
    "\32\u0107\1\115\1\u0103\2\115\1\u0107\1\115\1\u0108\3\115"+
    "\1\u0107\110\115\1\u0105\1\115\1\u0109\61\115\1\u0103\4\115"+
    "\1\u010a\4\115\12\122\1\0\56\122\1\u010b\23\122\1\u010c"+
    "\56\122\1\u010c\11\122\7\125\1\u010d\61\125\1\u010e\3\125"+
    "\1\0\1\u010f\13\125\1\u0110\26\125\32\u0107\1\125\1\u010e"+
    "\2\125\1\u0107\1\u0105\1\u0108\3\125\1\u0107\112\125\1\u0109"+
    "\61\125\1\u010e\3\125\1\u0105\1\u0111\4\125\2\132\2\133"+
    "\3\132\1\u0112\61\132\1\u0113\4\132\1\u0114\5\132\3\133"+
    "\3\132\1\u0112\26\132\32\u0115\1\132\1\u0113\2\132\1\u0115"+
    "\1\132\1\u0114\3\132\1\u0115\2\132\2\133\3\132\1\u0116"+
    "\26\132\32\u0107\1\132\1\u0113\2\132\1\u0107\1\132\1\u0108"+
    "\3\132\1\u0107\2\132\2\133\101\132\2\133\3\132\1\u0109"+
    "\61\132\1\u0113\4\132\1\u0117\4\132\1\7\3\137\32\7"+
    "\32\u0118\4\7\1\u0118\5\7\1\u0118\1\0\1\u0119\34\0"+
    "\32\142\4\0\1\142\5\0\1\142\23\0\4\142\7\0"+
    "\32\142\4\0\1\142\5\0\1\142\1\0\1\u011a\34\0"+
    "\32\145\4\0\1\145\5\0\1\145\23\0\4\145\7\0"+
    "\32\145\4\0\1\145\5\0\1\145\23\0\4\146\7\0"+
    "\32\146\4\0\1\146\5\0\1\146\33\0\1\u011b\67\0"+
    "\1\u011c\105\0\4\152\7\0\32\152\4\0\1\152\5\0"+
    "\1\152\23\0\4\154\7\0\32\154\4\0\1\154\5\0"+
    "\1\154\15\0\1\u011d\110\0\4\171\10\0\1\u011e\14\0"+
    "\1\u011f\10\0\1\u0120\6\0\1\u0121\31\0\4\171\45\0"+
    "\1\u0121\31\0\4\177\7\0\32\177\4\0\1\177\5\0"+
    "\1\177\15\206\1\0\65\206\22\0\1\u0122\62\0\1\210"+
    "\122\0\1\u0123\60\0\2\213\1\214\1\215\4\213\1\214"+
    "\22\213\2\214\45\213\1\u0124\2\0\1\214\133\0\1\u0125"+
    "\47\0\10\21\1\0\20\21\1\0\2\21\1\0\46\21"+
    "\32\0\1\u0126\102\0\1\u0126\22\0\1\u0127\57\0\1\u0128"+
    "\50\0\5\225\1\226\1\225\1\227\26\225\32\0\1\225"+
    "\1\230\2\225\1\0\1\225\1\0\3\225\1\0\110\225"+
    "\1\226\1\225\1\0\61\225\1\230\4\225\1\231\4\225"+
    "\23\0\4\233\7\0\32\233\4\0\1\233\5\0\1\233"+
    "\1\0\3\236\3\0\1\237\11\0\1\241\102\0\1\u0129"+
    "\61\0\103\243\57\0\1\u012a\71\0\1\u012b\5\0\1\u012c"+
    "\102\0\1\u012d\77\0\1\u012e\104\0\1\u012f\66\0\1\u0130"+
    "\105\0\1\u0131\121\0\1\u0132\74\0\1\u0133\61\0\1\u0134"+
    "\71\0\1\u0135\104\0\4\267\13\0\1\276\31\0\1\u0136"+
    "\7\0\3\u0137\11\0\1\u0138\17\0\1\u0139\70\0\4\267"+
    "\13\0\1\276\63\0\2\u013a\74\0\1\u013b\1\0\1\u013b"+
    "\2\0\4\u013c\77\0\3\u013d\100\0\4\u013e\7\0\6\u013e"+
    "\62\0\4\45\134\0\1\u013f\53\0\1\u0140\1\u0141\103\0"+
    "\1\u0142\101\0\1\u0143\102\0\1\u0144\103\0\1\u0145\101\0"+
    "\1\u0146\73\0\4\64\7\0\22\64\1\u0147\7\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\3\64\1\u0148\26\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\21\64\1\u0149\10\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\36\0\32\u014a\4\0"+
    "\1\u014a\5\0\1\u014a\31\0\1\u014b\74\0\4\64\7\0"+
    "\4\64\1\u014c\25\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\13\64\1\u014d\6\64\1\u014e"+
    "\1\u014f\6\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\1\u0150\15\64\1\u0151\13\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\15\64\1\u0152\14\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\2\64\1\u0153\2\64\1\u0154"+
    "\24\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\4\64\1\u0155\25\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\7\64\1\u0156"+
    "\22\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\22\64\1\u0157\7\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\17\64\1\u0158"+
    "\12\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\3\64\1\u0159\20\64\1\u015a\5\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\1\u015b\31\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\10\64\1\u015c\12\64\1\u015d\6\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\15\64\1\u015e\14\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\21\64\1\u015f\10\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\15\64\1\u0160\14\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\16\64\1\u0161\13\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\23\64\1\u0162\6\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\17\64\1\u0163\12\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\2\64\1\u0164\17\64\1\u0165\1\u0166\6\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\22\64\1\u0167\7\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\22\64\1\u0168\7\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\23\64\1\u0169\6\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\14\64\1\u016a\15\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\26\64\1\u016b\3\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\10\64\1\u016c\5\64\1\u016d"+
    "\13\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\1\64\1\u016e\30\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\1\u016f\17\64"+
    "\1\u0170\2\64\1\u0171\6\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\1\u0172\31\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\10\64\1\u0173\21\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\21\64\1\u0174\10\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\1\u0175\27\64\1\u0176\1\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\22\64\1\u0177\7\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\4\64\1\u0178\25\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\21\64\1\u0179\10\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\10\64\1\u017a\21\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\21\64\1\u017b\10\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\4\64\1\u017c\25\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\375\7\0\32\375\1\0\1\u017d"+
    "\2\0\1\375\5\0\1\375\23\0\4\64\7\0\2\64"+
    "\1\u017e\1\u017f\1\64\1\u0180\1\64\1\u0181\3\64\1\u0182"+
    "\1\u0183\1\u0184\14\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\5\115\1\u0105\1\115\1\u0106\26\115\32\0\1\115"+
    "\1\u0103\2\115\1\0\1\115\1\0\3\115\1\0\5\115"+
    "\1\u0105\1\115\1\0\61\115\1\u0103\4\115\1\u010a\4\115"+
    "\20\0\1\u0185\2\0\4\u0107\7\0\32\u0107\1\u0186\3\0"+
    "\1\u0107\5\0\1\u0107\12\122\1\0\56\122\1\0\11\122"+
    "\7\125\1\u0110\26\125\32\0\1\125\1\u010e\2\125\1\0"+
    "\1\u0105\1\0\3\125\1\0\7\125\1\0\61\125\1\u010e"+
    "\3\125\1\u0105\1\u0111\4\125\2\132\2\133\3\132\1\u0116"+
    "\26\132\32\0\1\132\1\u0113\2\132\1\0\1\132\1\0"+
    "\3\132\1\0\2\132\2\133\3\132\1\0\61\132\1\u0113"+
    "\4\132\1\u0117\4\132\23\0\4\u0115\7\0\32\u0115\4\0"+
    "\1\u0115\5\0\1\u0115\23\0\4\u0118\7\0\32\u0118\4\0"+
    "\1\u0118\5\0\1\u0118\33\0\1\u0187\72\0\2\u0188\101\0"+
    "\3\u0189\100\0\4\u018a\7\0\6\u018a\62\0\4\171\121\0"+
    "\1\u018b\56\0\1\237\140\0\1\u018c\76\0\1\u018d\103\0"+
    "\1\u018e\110\0\1\u018f\74\0\1\u0190\107\0\1\u0191\70\0"+
    "\1\u0192\71\0\1\u0193\123\0\1\u0194\103\0\1\u0195\45\0"+
    "\4\267\55\0\3\u0137\31\0\1\u0139\67\0\1\u0196\143\0"+
    "\1\u0197\42\0\2\u013a\47\0\1\275\31\0\4\u013c\77\0"+
    "\4\u013c\45\0\1\u013b\31\0\3\u013d\46\0\1\277\31\0"+
    "\4\u013e\7\0\6\u013e\30\0\1\300\46\0\1\u0198\43\0"+
    "\1\u0140\3\0\1\u0199\4\0\1\u019a\23\0\32\u019b\4\0"+
    "\1\u019b\5\0\1\u019b\23\0\4\64\7\0\23\64\1\u019c"+
    "\6\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\1\u019d\31\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\u014a\7\0\32\u014a\1\0\1\322"+
    "\2\0\1\u014a\5\0\1\u014a\31\0\1\u0140\74\0\4\64"+
    "\7\0\1\u019e\31\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\13\64\1\u019f\16\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\4\64\1\u01a0\25\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\2\64\1\u01a1\27\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\22\64\1\u01a2\7\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\15\64\1\u01a3\14\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\22\64\1\u01a4\1\u01a5\6\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\13\64\1\u01a6\16\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\1\u01a7\7\64\1\u01a8\21\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\16\64\1\u01a9"+
    "\13\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\4\64\1\u01aa\25\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\23\64\1\u01ab"+
    "\6\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\3\64\1\u01ac\1\64\1\u01ad\2\64\1\u01ae"+
    "\11\64\1\u01af\3\64\1\u01b0\3\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\14\64\1\u01b1"+
    "\15\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\13\64\1\u01b2\16\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\23\64\1\u0155"+
    "\6\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\4\64\1\u01b3\25\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\1\u01b4\31\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\4\64\1\u01b5\25\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\2\64\1\u01b6\27\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\1\64\1\u01b7\30\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\16\64\1\u01b8\13\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\13\64\1\u01b9\16\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\13\64\1\u01ba\16\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\23\64\1\u01bb\6\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\4\64\1\u01bc\25\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\4\64\1\u01bd\25\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\23\64\1\u01be\6\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\2\64\1\u01bf\27\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\4\64\1\u01c0\25\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\15\64\1\u01c1\7\64\1\u01c2\4\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\23\64"+
    "\1\u01c3\6\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\13\64\1\u01c4\16\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\3\64"+
    "\1\u01c5\26\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\24\64\1\u01c6\5\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\24\64"+
    "\1\u01c7\5\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\23\64\1\u01c8\6\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\23\64"+
    "\1\u01c9\6\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\16\64\1\u01ca\13\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\10\64"+
    "\1\u01cb\21\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\4\64\1\u01cc\25\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\13\64"+
    "\1\u01cd\16\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\13\64\1\u01ce\16\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\13\64"+
    "\1\u01cf\16\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\10\64\1\u01d0\21\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\10\64"+
    "\1\u01d1\13\64\1\u01d2\5\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\1\u01d3\31\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\10\64\1\u01d4\21\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\4\64\1\u01d5\25\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\1\u01d6\31\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\33\0\1\u01d7\72\0\2\u0188\47\0\1\u011e\31\0\3\u0189"+
    "\46\0\1\u011f\31\0\4\u018a\7\0\6\u018a\30\0\1\u0120"+
    "\63\0\1\u01d8\63\0\1\u01d9\102\0\1\u01da\115\0\1\u01db"+
    "\70\0\1\u01dc\101\0\1\u01dd\45\0\1\u01de\12\0\1\u01df"+
    "\25\0\1\u01e0\102\0\1\u01e1\111\0\1\u01e2\77\0\1\u01e3"+
    "\76\0\1\u01e4\76\0\1\u01e5\123\0\1\u01e6\61\0\32\u01e7"+
    "\4\0\1\u01e7\5\0\1\u01e7\36\0\32\u01e8\4\0\1\u01e8"+
    "\5\0\1\u01e8\2\0\1\u01e9\1\u01ea\17\0\4\u019b\7\0"+
    "\32\u019b\4\0\1\u019b\5\0\1\u019b\23\0\4\64\7\0"+
    "\21\64\1\u01eb\10\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\30\64\1\u01ec\1\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\12\64\1\u01ed\17\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\1\u01ee\31\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\7\64"+
    "\1\u01ef\22\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\22\64\1\u01f0\7\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\4\64"+
    "\1\u01f1\25\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\23\64\1\u01f2\6\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\10\64"+
    "\1\u01f3\21\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\1\u01f4\31\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\24\64\1\u01f5"+
    "\5\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\15\64\1\u01f6\14\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\10\64\1\u01f7"+
    "\21\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\30\64\1\u01f8\1\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\4\64\1\u01f9"+
    "\25\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\16\64\1\u01fa\13\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\5\64\1\u01fb"+
    "\24\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\26\64\1\u01fc\3\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\7\64\1\u01fd"+
    "\22\64\1\0\1\322\2\0\1\64\5\0\1\64\1\0"+
    "\3\u01fe\17\0\4\64\7\0\32\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\15\64\1\u01ff"+
    "\14\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\13\64\1\u0200\16\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\1\u0201\31\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\23\64\1\u0202\6\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\1\u0203\31\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\4\64\1\u0204\25\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\24\64\1\u0205\5\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\1\u0206\3\64\1\u0207\25\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\21\64\1\u0208\10\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\23\64\1\u0209\6\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\7\64\1\u020a\22\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\22\64\1\u020b\7\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\23\64\1\u020c\6\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\1\u020d\31\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\4\64\1\u020e\25\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\10\64\1\u020f\21\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\16\64\1\u0210\13\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\10\64\1\u0211\21\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\21\64\1\u0212\10\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\10\64\1\u0213\21\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\2\64\1\u0214\27\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\26\64\1\u0215\3\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\23\64\1\u0216\6\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\23\64\1\u0217\6\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\4\64\1\u0218\25\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\3\64\1\u0219\26\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\1\u021a\31\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\21\64"+
    "\1\u021b\10\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\13\64\1\u021c\16\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\15\64"+
    "\1\u021d\14\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\13\64\1\u021e\16\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\15\64"+
    "\1\u021f\14\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\23\64\1\u0220\6\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\14\64"+
    "\1\u0221\15\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\36\0\32\u0222\4\0\1\u0222\5\0\1\u0222\1\0\2\u0223"+
    "\1\u0224\165\0\1\u0225\73\0\1\u0226\24\0\1\u0227\12\0"+
    "\1\u0228\25\0\1\u0229\111\0\1\u022a\112\0\1\u01e2\22\0"+
    "\1\u01de\12\0\1\u01df\132\0\1\u022b\76\0\1\u022c\43\0"+
    "\1\u01e2\12\0\1\u022d\141\0\1\u022e\110\0\1\u022f\100\0"+
    "\1\u0230\71\0\1\u0231\41\0\1\u0232\15\0\4\u01e7\7\0"+
    "\32\u01e7\4\0\1\u01e7\5\0\1\u01e7\12\0\1\u0232\10\0"+
    "\4\u01e8\7\0\32\u01e8\4\0\1\u01e8\5\0\1\u01e8\2\0"+
    "\1\u01e9\123\0\4\64\7\0\1\u0233\31\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\1\64"+
    "\1\u0234\30\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\15\64\1\u0235\14\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\21\64"+
    "\1\u0236\10\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\13\64\1\u0237\16\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\4\64"+
    "\1\u0238\25\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\5\64\1\u0239\24\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\2\64"+
    "\1\u023a\27\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\21\64\1\u023b\10\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\10\64"+
    "\1\u023c\21\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\10\64\1\u023d\21\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\1\0\3\u01fe\32\0\32\u023e"+
    "\4\0\1\u023e\5\0\1\u023e\23\0\4\64\7\0\3\64"+
    "\1\u023f\26\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\13\64\1\u0240\16\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\2\64"+
    "\1\u0241\27\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\10\64\1\u0242\21\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\13\64"+
    "\1\u0243\16\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\14\64\1\u0244\15\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\3\64"+
    "\1\u0245\26\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\15\64\1\u0246\14\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\1\u0247"+
    "\31\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\5\64\1\u0248\24\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\17\64\1\u0249"+
    "\12\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\23\64\1\u024a\6\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\2\64\1\u024b"+
    "\27\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\2\64\1\u024c\27\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\15\64\1\u024d"+
    "\14\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\21\64\1\u024e\10\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\15\64\1\u024f"+
    "\14\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\2\64\1\u0250\27\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\7\64\1\u0251"+
    "\22\64\1\0\1\322\2\0\1\64\5\0\1\64\1\0"+
    "\3\u0252\17\0\4\64\7\0\32\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\22\64\1\u0253"+
    "\7\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\32\64\1\0\1\322\2\0\1\u0254\5\0"+
    "\1\64\23\0\4\64\7\0\4\64\1\u0255\25\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\2\64\1\u0256\27\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\23\64\1\u0257\6\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\4\64\1\u0258\25\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\7\64\1\u0259\22\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\4\64\1\u025a\25\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\2\0\1\u0223\101\0\1\u0225\12\0\1\u025b\154\0"+
    "\1\u025c\15\0\1\u0227\12\0\1\u0228\124\0\1\u025d\106\0"+
    "\1\u01e2\102\0\1\u025e\121\0\1\u025f\65\0\1\u025c\37\0"+
    "\1\u022f\12\0\1\u0260\67\0\3\u0261\154\0\1\u0262\27\0"+
    "\1\u01e9\1\u01ea\122\0\4\64\7\0\2\64\1\u0263\27\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\13\64\1\u0264\16\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\24\64\1\u0265\5\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\4\64\1\u0266\25\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\23\64\1\u0267\6\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\13\64\1\u0268\16\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\4\64\1\u0269\25\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\23\64\1\u026a\6\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\13\64\1\u026b\16\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\u023e"+
    "\7\0\32\u023e\4\0\1\u023e\5\0\1\u023e\23\0\4\64"+
    "\7\0\22\64\1\u026c\7\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\30\64\1\u026d\1\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\7\64\1\u026e\22\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\16\64\1\u026f\13\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\4\64\1\u0270\25\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\4\64\1\u0271\25\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\2\64\1\u0272\27\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\3\64\1\u0273\26\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\1\u0274\31\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\1\u0275\31\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\4\64"+
    "\1\u0276\25\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\23\64\1\u0277\6\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\13\64"+
    "\1\u0278\16\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\23\0\4\64\7\0\4\64\1\u0279\25\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\1\0\3\u0252\37\0\1\u027a"+
    "\62\0\4\64\7\0\22\64\1\u027b\7\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\32\64"+
    "\1\0\1\322\2\0\1\u027c\5\0\1\64\23\0\4\64"+
    "\7\0\32\64\1\0\1\322\2\0\1\u027d\5\0\1\64"+
    "\23\0\4\64\7\0\23\64\1\u027e\6\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\32\64"+
    "\1\0\1\322\2\0\1\u027f\5\0\1\64\23\0\4\64"+
    "\7\0\32\64\1\0\1\322\2\0\1\u0280\5\0\1\64"+
    "\23\0\4\64\7\0\16\64\1\u0281\13\64\1\0\1\322"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\22\64"+
    "\1\u0282\7\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\1\0\1\u025c\12\0\1\u0283\141\0\1\u0227\106\0\1\u01de"+
    "\24\0\1\u025f\12\0\1\u0284\67\0\3\u0261\3\0\1\u0285"+
    "\26\0\32\u0286\3\u0287\1\0\1\u0286\2\0\1\u0287\2\0"+
    "\1\u0286\61\0\1\u0288\44\0\4\64\7\0\23\64\1\u0289"+
    "\6\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\4\64\1\u028a\25\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\4\64\1\u028b"+
    "\25\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\1\u028c\31\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\1\u028d\31\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\2\64\1\u028e\27\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\4\64\1\u028f\25\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\15\64\1\u0290\14\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\15\64\1\u0291\14\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\32\64\1\0\1\322\2\0\1\u0292\5\0\1\64\23\0"+
    "\4\64\7\0\4\64\1\u0293\25\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\16\64\1\u0294"+
    "\13\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\2\64\1\u0295\27\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\2\64\1\u0296"+
    "\27\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\4\64\1\u0297\25\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\30\64\1\u0298"+
    "\1\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\32\64\1\0\1\322\2\0\1\u0299\5\0"+
    "\1\64\57\0\1\u029a\46\0\4\64\7\0\32\64\1\0"+
    "\1\322\2\0\1\u029b\5\0\1\64\23\0\4\64\7\0"+
    "\32\64\1\0\1\322\2\0\1\u029c\5\0\1\64\23\0"+
    "\4\64\7\0\10\64\1\u029d\21\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\2\64\1\u029e"+
    "\27\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\32\64\1\0\1\322\2\0\1\u029f\5\0"+
    "\1\64\23\0\4\64\7\0\3\64\1\u02a0\26\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\17\64\1\u02a1\12\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\36\0\32\u02a2\4\0\1\u02a2\5\0\1\u02a2\1\0"+
    "\3\u02a3\17\0\4\u0286\7\0\32\u0286\3\u0287\1\0\1\u0286"+
    "\2\0\1\u0287\2\0\1\u0286\1\0\3\u02a3\32\0\32\u0286"+
    "\3\u0287\1\0\1\u0286\2\0\1\u0287\2\0\1\u0286\1\0"+
    "\3\u0288\27\0\1\314\72\0\4\64\7\0\21\64\1\u02a4"+
    "\10\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\2\64\1\u02a5\27\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\7\64\1\u02a6"+
    "\22\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\23\64\1\u02a7\6\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\16\64\1\u02a8"+
    "\13\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\16\64\1\u02a9\13\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\5\64\1\u02aa"+
    "\24\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\4\64\1\u02ab\25\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\4\64\1\u02ac"+
    "\25\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\3\64\1\u02ad\26\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\16\64\1\u02ae"+
    "\13\64\1\0\1\322\2\0\1\64\5\0\1\64\54\0"+
    "\1\u02af\51\0\4\64\7\0\32\64\1\0\1\322\2\0"+
    "\1\u02b0\5\0\1\64\23\0\4\64\7\0\16\64\1\u02b1"+
    "\13\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\16\64\1\u02b2\13\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\32\64\1\0"+
    "\1\322\2\0\1\u02b3\5\0\1\64\23\0\4\64\7\0"+
    "\1\u02b4\31\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\1\0\3\u02b5\17\0\4\u02a2\7\0\32\u02a2\4\0\1\u02a2"+
    "\5\0\1\u02a2\1\0\3\u02a3\3\0\1\u02b6\116\0\4\64"+
    "\7\0\4\64\1\u02b7\25\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\7\64\1\u02b8\22\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\22\64\1\u02b9\7\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\15\64\1\u02ba\14\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\5\64\1\u02bb\24\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\32\64\1\0\1\u02bc"+
    "\2\0\1\64\5\0\1\64\23\0\4\64\7\0\15\64"+
    "\1\u02bd\14\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\52\0\1\u02be\53\0\4\64\7\0\15\64\1\u02bf\14\64"+
    "\1\0\1\322\2\0\1\64\5\0\1\64\23\0\4\64"+
    "\7\0\14\64\1\u02c0\15\64\1\0\1\322\2\0\1\64"+
    "\5\0\1\64\23\0\4\64\7\0\32\64\1\0\1\322"+
    "\2\0\1\u02c1\5\0\1\64\23\0\4\64\7\0\2\64"+
    "\1\u02c2\27\64\1\0\1\322\2\0\1\64\5\0\1\64"+
    "\1\0\3\u02b5\32\0\32\u02c3\3\u02c4\1\0\1\u02c3\2\0"+
    "\1\u02c4\2\0\1\u02c3\36\0\32\u02c5\4\0\1\u02c5\5\0"+
    "\1\u02c5\23\0\4\64\7\0\2\64\1\u02c6\27\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\36\0\32\u02c7\4\0"+
    "\1\u02c7\5\0\1\u02c7\23\0\4\64\7\0\2\64\1\u02c8"+
    "\27\64\1\0\1\322\2\0\1\64\5\0\1\64\23\0"+
    "\4\64\7\0\32\64\1\0\1\322\2\0\1\u02c9\5\0"+
    "\1\64\23\0\4\64\7\0\17\64\1\u02ca\12\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\4\64\1\u02cb\25\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\1\0\3\u02cc\11\0\1\u02cd\5\0\4\u02c3\7\0"+
    "\32\u02c3\3\u02c4\1\0\1\u02c3\2\0\1\u02c4\2\0\1\u02c3"+
    "\1\0\3\u02cc\11\0\1\u02cd\20\0\32\u02c3\3\u02c4\1\0"+
    "\1\u02c3\2\0\1\u02c4\2\0\1\u02c3\1\0\3\u02cc\11\0"+
    "\1\u02cd\5\0\4\u02c5\7\0\32\u02c5\4\0\1\u02c5\5\0"+
    "\1\u02c5\23\0\4\64\7\0\4\64\1\u02ce\25\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\u02c7\7\0"+
    "\32\u02c7\1\0\1\u02bc\2\0\1\u02c7\5\0\1\u02c7\23\0"+
    "\4\64\7\0\4\64\1\u02cf\25\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\32\64\1\0"+
    "\1\322\2\0\1\u02d0\5\0\1\64\23\0\4\64\7\0"+
    "\10\64\1\u02d1\21\64\1\0\1\322\2\0\1\64\5\0"+
    "\1\64\23\0\4\64\7\0\32\64\1\0\1\322\2\0"+
    "\1\u02d2\5\0\1\64\1\0\3\u02cc\11\0\1\u02cd\107\0"+
    "\1\u02d3\103\0\4\64\7\0\13\64\1\u02d4\16\64\1\0"+
    "\1\322\2\0\1\64\5\0\1\64\23\0\4\64\7\0"+
    "\32\64\1\0\1\322\2\0\1\u02d5\5\0\1\64\23\0"+
    "\4\64\7\0\4\64\1\u02d6\25\64\1\0\1\322\2\0"+
    "\1\64\5\0\1\64\23\0\4\64\7\0\21\64\1\u02d7"+
    "\10\64\1\0\1\322\2\0\1\64\5\0\1\64";

  private static int [] zzUnpacktrans() {
    int [] result = new int[36314];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\2\1\11\0\2\1\1\11\11\1\1\11\2\1"+
    "\1\11\6\1\1\11\4\1\1\11\26\1\1\11\1\1"+
    "\1\11\2\1\2\11\1\1\2\11\1\1\1\11\4\1"+
    "\1\11\4\1\1\11\7\1\1\11\2\1\1\11\3\1"+
    "\1\11\3\1\1\11\1\1\6\11\1\1\4\11\2\1"+
    "\5\11\1\1\6\11\2\1\1\11\3\1\1\11\2\1"+
    "\1\11\1\1\1\0\3\1\1\0\1\11\3\0\1\11"+
    "\1\1\2\11\1\0\2\11\1\0\1\11\14\0\1\1"+
    "\6\11\1\0\1\1\1\11\1\1\2\11\1\1\5\0"+
    "\1\11\1\0\2\1\1\11\1\1\2\11\1\1\1\0"+
    "\1\11\5\1\2\0\52\1\1\11\1\1\2\11\3\0"+
    "\1\11\2\1\2\11\1\1\1\0\1\11\3\0\2\1"+
    "\3\0\4\1\2\0\1\11\1\0\1\11\4\0\2\11"+
    "\1\0\2\11\1\0\1\11\13\0\2\11\2\0\1\1"+
    "\1\0\1\1\1\0\3\1\2\0\6\11\4\1\1\0"+
    "\61\1\1\0\7\1\1\0\2\11\3\1\13\0\1\11"+
    "\5\0\73\1\10\0\1\11\11\0\1\11\24\1\1\0"+
    "\43\1\2\11\1\1\3\0\1\11\4\0\1\11\5\0"+
    "\37\1\1\0\10\1\1\11\4\0\1\11\2\0\27\1"+
    "\1\0\10\1\2\11\4\0\21\1\1\0\7\1\2\0"+
    "\13\1\1\0\5\1\2\0\5\1\1\0\1\1\1\11"+
    "\4\1\3\0\6\1\2\0\5\1\1\11\4\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[727];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  private boolean zzEOFDone;

  /* user code: */
	private final LinkedList<Object> commentList = new LinkedList<>();
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=514632
	// stores nested HEREDOC and NOWDOC ids
	private final Stack<String> heredocIds = new Stack<>();
	private boolean asp_tags = false;
	private boolean short_tags_allowed = true;
	// XXX: "heredocIds" and "stack" are never reset
	private final StateStack stack = new StateStack();
	protected int commentStartPosition;
	protected String lastHeredocIndentation;

	private AST ast;

	public void setAST(AST ast) {
		this.ast = ast;
	}

	@Override
	public PHPVersion getPHPVersion() {
		return PHPVersion.PHP8_2;
	}

	@Override
	public void setInScriptingState() {
		yybegin(ST_IN_SCRIPTING);
	}

	@Override
	public void resetCommentList() {
		commentList.clear();
	}

	/**
	 * Will only be filled when ast != null
	 */
	@Override
	public LinkedList<Object> getCommentList() {
		return commentList;
	}

	/**
	 * Will only be added when ast != null
	 */
	protected void addComment(int type) {
		if (ast != null) {
			int leftPosition = getTokenStartPosition();
			Comment comment = new Comment(commentStartPosition, leftPosition + getTokenLength(), ast, type);
			commentList.add(comment);
		}
	}

	@Override
	public void setUseAspTagsAsPHP(boolean useAspTagsAsPhp) {
		asp_tags = useAspTagsAsPhp;
	}

	@Override
	public void setUseShortTags(boolean useShortTags) {
		short_tags_allowed = useShortTags;
	}

	private void pushState(int state) {
		stack.pushStack(zzLexicalState);
		yybegin(state);
	}

	private void popState() {
		yybegin(stack.popStack());
	}

	@Override
	public int getCurrentLine() {
		return yyline;
	}

	protected int getTokenStartPosition() {
		return zzStartRead - _zzPushbackPos;
	}

	protected int getTokenLength() {
		return zzMarkedPos - zzStartRead;
	}

	@Override
	public int getLength() {
		return zzEndRead - _zzPushbackPos;
	}

	private void handleCommentStart() {
		commentStartPosition = getTokenStartPosition();
	}

	private void handleLineCommentEnd() {
		addComment(Comment.TYPE_SINGLE_LINE);
	}

	private void handleMultilineCommentEnd() {
		addComment(Comment.TYPE_MULTILINE);
	}

	private void handlePHPDocEnd() {
		addComment(Comment.TYPE_PHPDOC);
	}

	protected void handleVarComment() {
		addComment(Comment.TYPE_MULTILINE);
	}

	protected Symbol createFullSymbol(int symbolNumber) {
		Symbol symbol = createSymbol(symbolNumber);
		symbol.value = yytext();
		return symbol;
	}

	protected Symbol createSymbol(int symbolNumber) {
		int leftPosition = getTokenStartPosition();
		return new Symbol(symbolNumber, leftPosition, leftPosition + getTokenLength());
	}

	public int[] getParameters() {
		return new int[] { zzMarkedPos, _zzPushbackPos, zzCurrentPos,
				zzStartRead, zzEndRead, yyline, zzAtBOL ? 1 : 0,
				zzAtEOF ? 1 : 0, zzEOFDone ? 1 : 0, zzFinalHighSurrogate };
	}

	/**
	 * Parses a PHPDoc block comment. Underlying reader (zzReader) can be closed
	 * in the process (when EOF is reached).
	 *
	 * @return true when PHPDoc was parsed, false otherwise (false also implies
	 *         that underlying lexer was unavailable)
	 */
	protected boolean parsePHPDoc() {
		final IDocumentorLexer documentorLexer = getDocumentorLexer(zzReader);
		if (documentorLexer == null) {
			return false;
		}
		yypushback(zzMarkedPos - zzStartRead);
		int[] parameters = getParameters();
		documentorLexer.reset(zzReader, zzBuffer, parameters);
		Object phpDocBlock = documentorLexer.parse();
		commentList.add(phpDocBlock);
		reset(zzReader, documentorLexer.getBuffer(), documentorLexer.getParameters());
		return true;
	}

	protected IDocumentorLexer getDocumentorLexer(java.io.Reader reader) {
		return null;
	}

	/**
	 * Resets the {@code PhpAstLexer} properties to previous values, but leaves
	 * the lexical state unchanged. Be careful, method {@link #next_token()}
	 * also caches those properties using internal variables (zzCurrentPosL,
	 * zzMarkedPosL, zzBufferL, zzEndReadL) that should be accordingly resetted
	 * by the lexical rules calling
	 * {@link #reset(java.io.Reader, char[], int[])}. Also be careful that those
	 * internal variables could change from one version of JFlex to another.
	 *
	 * @param reader
	 * @param buffer
	 * @param parameters
	 */
	public void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		this.yychar = this.zzStartRead - this._zzPushbackPos;
		// XXX: never used
		this.yycolumn = 0;
		this.zzAtEOF = parameters[7] != 0;
		this.zzEOFDone = parameters[8] != 0;
		this.zzFinalHighSurrogate = parameters[9];
		// XXX: check if there's no side-effect to reset zzAtBOL
		// when zzAtEOF is false and zzMarkedPos is equal to zzStartRead.
		// One possible case would be that IDocumentorLexer#parse() matches
		// no text at all without being at EOF (i.e. the document lexer returns
		// a zero-length token), which of course would be totally broken...
		this.zzAtBOL = this.zzAtEOF ? false : (parameters[6] != 0);
	}


  /** the textposition at the last state to be included in yytext */
  private int _zzPushbackPos;

  /* The following fields are added in order to support the change in zzRefill */
  private String oldString = null;
  private boolean useOldString = false;
  private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PHPAstLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    if (useOldString) {
      String saveOldString = oldString;
      oldString = new String(zzBuffer, startPos, zzMarkedPos - startPos);
      if (saveOldString != null) {
        oldString = saveOldString + oldString;
      }
    }

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      _zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

    /* if the eof is reached, we don't need to work hard */
    if (zzAtEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    String saveOldString = oldString;
    oldString = null;

    /* first: make room (if you can) */
    if (zzRefill()) {
      oldString = saveOldString;
      return YYEOF;
    }

    oldString = saveOldString;

    return zzBuffer[zzCurrentPos++];
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      _zzPushbackPos = 0;
      startPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      oldString = null;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		updateStartPos(zzMarkedPos);
	}


	/**
	 * user method - common.sse
	 */
	private void updateStartPos(int position) {
		startPos = position;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
    
  yyclose();    }
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
          { 	return createSymbol(sym.EOF);
 }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 214: break;
          case 2:
            { return createSymbol(ParserConstants.T_INLINE_HTML);
            }
          // fall through
          case 215: break;
          case 3:
            { // do nothing
            }
          // fall through
          case 216: break;
          case 4:
            { 
            }
          // fall through
          case 217: break;
          case 5:
            { return createSymbol(ParserConstants.T_NOT);
            }
          // fall through
          case 218: break;
          case 6:
            { yybegin(ST_DOUBLE_QUOTES);
	return createSymbol(ParserConstants.T_QUATE);
            }
          // fall through
          case 219: break;
          case 7:
            { handleCommentStart();
	yybegin(ST_ONE_LINE_COMMENT);
	// yymore();
            }
          // fall through
          case 220: break;
          case 8:
            { return createSymbol(ParserConstants.T_DOLLAR);
            }
          // fall through
          case 221: break;
          case 9:
            { return createSymbol(ParserConstants.T_PRECENT);
            }
          // fall through
          case 222: break;
          case 10:
            { return createSymbol(ParserConstants.T_REFERENCE);
            }
          // fall through
          case 223: break;
          case 11:
            { yybegin(ST_SINGLE_QUOTE);
	return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          // fall through
          case 224: break;
          case 12:
            { return createSymbol(ParserConstants.T_OPEN_PARENTHESE);
            }
          // fall through
          case 225: break;
          case 13:
            { return createSymbol(ParserConstants.T_CLOSE_PARENTHESE);
            }
          // fall through
          case 226: break;
          case 14:
            { return createSymbol(ParserConstants.T_TIMES);
            }
          // fall through
          case 227: break;
          case 15:
            { return createSymbol(ParserConstants.T_PLUS);
            }
          // fall through
          case 228: break;
          case 16:
            { return createSymbol(ParserConstants.T_COMMA);
            }
          // fall through
          case 229: break;
          case 17:
            { return createSymbol(ParserConstants.T_MINUS);
            }
          // fall through
          case 230: break;
          case 18:
            { return createSymbol(ParserConstants.T_NEKUDA);
            }
          // fall through
          case 231: break;
          case 19:
            { return createSymbol(ParserConstants.T_DIV);
            }
          // fall through
          case 232: break;
          case 20:
            { return createFullSymbol(ParserConstants.T_LNUMBER);
            }
          // fall through
          case 233: break;
          case 21:
            { return createSymbol(ParserConstants.T_NEKUDOTAIM);
            }
          // fall through
          case 234: break;
          case 22:
            { return createSymbol(ParserConstants.T_SEMICOLON);
            }
          // fall through
          case 235: break;
          case 23:
            { return createSymbol(ParserConstants.T_RGREATER);
            }
          // fall through
          case 236: break;
          case 24:
            { return createSymbol(ParserConstants.T_EQUAL);
            }
          // fall through
          case 237: break;
          case 25:
            { return createSymbol(ParserConstants.T_LGREATER);
            }
          // fall through
          case 238: break;
          case 26:
            { return createSymbol(ParserConstants.T_QUESTION_MARK);
            }
          // fall through
          case 239: break;
          case 27:
            { return createSymbol(ParserConstants.T_AT);
            }
          // fall through
          case 240: break;
          case 28:
            { return createFullSymbol(ParserConstants.T_STRING);
            }
          // fall through
          case 241: break;
          case 29:
            { return createSymbol(ParserConstants.T_OPEN_RECT);
            }
          // fall through
          case 242: break;
          case 30:
            { return createSymbol(ParserConstants.T_NS_SEPARATOR);
            }
          // fall through
          case 243: break;
          case 31:
            { return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          // fall through
          case 244: break;
          case 32:
            { return createSymbol(ParserConstants.T_KOVA);
            }
          // fall through
          case 245: break;
          case 33:
            { yybegin(ST_BACKQUOTE);
	return createSymbol(ParserConstants.T_BACKQUATE);
            }
          // fall through
          case 246: break;
          case 34:
            { pushState(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          // fall through
          case 247: break;
          case 35:
            { return createSymbol(ParserConstants.T_OR);
            }
          // fall through
          case 248: break;
          case 36:
            { if (!stack.isEmpty()) {
		popState();
	}
	return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          // fall through
          case 249: break;
          case 37:
            { return createSymbol(ParserConstants.T_TILDA);
            }
          // fall through
          case 250: break;
          case 38:
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_QUATE);
            }
          // fall through
          case 251: break;
          case 39:
            { return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 252: break;
          case 40:
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          // fall through
          case 253: break;
          case 41:
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_BACKQUATE);
            }
          // fall through
          case 254: break;
          case 42:
            { yypushback(1);
	yybegin(ST_HEREDOC);
            }
          // fall through
          case 255: break;
          case 43:
            { String yytext = yytext();
	int textLength = yytext.length();
	String heredoc = heredocIds.peek();
	int heredocLength = heredoc.length();
	if (textLength > heredocLength && yytext.substring(textLength - heredocLength, textLength).equals(heredoc)) {
		char c = yytext.charAt(textLength - heredocLength - 1);
		if (c == ' ' || c == '\t') {
			lastHeredocIndentation = yytext.substring(0, textLength - heredocLength);
			// we need to remove the closing label from the symbol value
			yypushback(heredocLength);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		}
	}
	if (textLength == heredocLength && yytext.equals(heredoc)) {
		lastHeredocIndentation = ""; //$NON-NLS-1$
		heredocIds.pop();
		yybegin(ST_IN_SCRIPTING);
		return createFullSymbol(ParserConstants.T_END_HEREDOC);
	}
	yybegin(ST_HEREDOC);
            }
          // fall through
          case 256: break;
          case 44:
            { yypushback(1);
	yybegin(ST_NOWDOC);
            }
          // fall through
          case 257: break;
          case 45:
            { String yytext = yytext();
	int textLength = yytext.length();
	String nowdoc = heredocIds.peek();
	int nowdocLength = nowdoc.length();
	if (textLength > nowdocLength && yytext.substring(textLength - nowdocLength, textLength).equals(nowdoc)) {
		char c = yytext.charAt(textLength - nowdocLength - 1);
		if (c == ' ' || c == '\t') {
			lastHeredocIndentation = yytext.substring(0, textLength - nowdocLength);
			// we need to remove the closing label from the symbol value
			yypushback(nowdocLength);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		}
	}
	if (textLength == nowdocLength && yytext.equals(nowdoc)) {
		lastHeredocIndentation = ""; //$NON-NLS-1$
		heredocIds.pop();
		yybegin(ST_IN_SCRIPTING);
		return createFullSymbol(ParserConstants.T_END_HEREDOC);
	}
	yybegin(ST_NOWDOC);
            }
          // fall through
          case 258: break;
          case 46:
            { heredocIds.pop();
	yybegin(ST_IN_SCRIPTING);
	return createFullSymbol(ParserConstants.T_END_HEREDOC);
            }
          // fall through
          case 259: break;
          case 47:
            { yypushback(1);
	popState();
            }
          // fall through
          case 260: break;
          case 48:
            { popState();
	return createFullSymbol(ParserConstants.T_STRING);
            }
          // fall through
          case 261: break;
          case 49:
            { yypushback(1);
	yybegin(ST_IN_SCRIPTING);
            }
          // fall through
          case 262: break;
          case 50:
            { yybegin(ST_IN_SCRIPTING);
	return createFullSymbol(ParserConstants.T_STRING_VARNAME);
            }
          // fall through
          case 263: break;
          case 51:
            { yypushback(1);
	popState();
	return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 264: break;
          case 52:
            { return createSymbol(ParserConstants.T_QUATE);
            }
          // fall through
          case 265: break;
          case 53:
            { /* treat numbers (almost) as strings inside encapsulated strings */
	return createFullSymbol(ParserConstants.T_NUM_STRING);
            }
          // fall through
          case 266: break;
          case 54:
            { popState();
	return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          // fall through
          case 267: break;
          case 55:
            { return createSymbol(ParserConstants.T_BACKQUATE);
            }
          // fall through
          case 268: break;
          case 56:
            { return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          // fall through
          case 269: break;
          case 57:
            { return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          // fall through
          case 270: break;
          case 58:
            { // yymore();
            }
          // fall through
          case 271: break;
          case 59:
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			break;
		default:
			handleLineCommentEnd();
			yybegin(ST_IN_SCRIPTING);
	}
	// yymore();
            }
          // fall through
          case 272: break;
          case 60:
            { System.out.print(yytext());
            }
          // fall through
          case 273: break;
          case 61:
            { if (asp_tags) {
		yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 274: break;
          case 62:
            { if (short_tags_allowed) {
		yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 275: break;
          case 63:
            { return createSymbol(ParserConstants.T_IS_NOT_EQUAL);
            }
          // fall through
          case 276: break;
          case 64:
            { return createFullSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
            }
          // fall through
          case 277: break;
          case 65:
            { return createFullSymbol(ParserConstants.T_ATTRIBUTE);
            }
          // fall through
          case 278: break;
          case 66:
            { return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          // fall through
          case 279: break;
          case 67:
            { return createSymbol(ParserConstants.T_MOD_EQUAL);
            }
          // fall through
          case 280: break;
          case 68:
            { if (asp_tags) {
		yybegin(YYINITIAL);
		return createSymbol(ParserConstants.T_SEMICOLON); /* implicit ';' at php-end tag */
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 281: break;
          case 69:
            { yypushback(yylength() - 1);
	return createSymbol(ParserConstants.T_REFERENCE_FOLLOWED_BY_VAR_OR_VARARG);
            }
          // fall through
          case 282: break;
          case 70:
            { return createSymbol(ParserConstants.T_BOOLEAN_AND);
            }
          // fall through
          case 283: break;
          case 71:
            { return createSymbol(ParserConstants.T_AND_EQUAL);
            }
          // fall through
          case 284: break;
          case 72:
            { return createSymbol(ParserConstants.T_POW);
            }
          // fall through
          case 285: break;
          case 73:
            { return createSymbol(ParserConstants.T_MUL_EQUAL);
            }
          // fall through
          case 286: break;
          case 74:
            { return createSymbol(ParserConstants.T_INC);
            }
          // fall through
          case 287: break;
          case 75:
            { return createSymbol(ParserConstants.T_PLUS_EQUAL);
            }
          // fall through
          case 288: break;
          case 76:
            { return createSymbol(ParserConstants.T_DEC);
            }
          // fall through
          case 289: break;
          case 77:
            { return createSymbol(ParserConstants.T_MINUS_EQUAL);
            }
          // fall through
          case 290: break;
          case 78:
            { pushState(ST_LOOKING_FOR_PROPERTY);
	return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          // fall through
          case 291: break;
          case 79:
            { return createFullSymbol(ParserConstants.T_DNUMBER);
            }
          // fall through
          case 292: break;
          case 80:
            { return createSymbol(ParserConstants.T_CONCAT_EQUAL);
            }
          // fall through
          case 293: break;
          case 81:
            { handleCommentStart();
	yybegin(ST_COMMENT);
            }
          // fall through
          case 294: break;
          case 82:
            { return createSymbol(ParserConstants.T_DIV_EQUAL);
            }
          // fall through
          case 295: break;
          case 83:
            { return createSymbol(ParserConstants.T_PAAMAYIM_NEKUDOTAYIM);
            }
          // fall through
          case 296: break;
          case 84:
            { return createSymbol(ParserConstants.T_SL);
            }
          // fall through
          case 297: break;
          case 85:
            { return createSymbol(ParserConstants.T_IS_SMALLER_OR_EQUAL);
            }
          // fall through
          case 298: break;
          case 86:
            { return createSymbol(ParserConstants.T_IS_EQUAL);
            }
          // fall through
          case 299: break;
          case 87:
            { return createSymbol(ParserConstants.T_DOUBLE_ARROW);
            }
          // fall through
          case 300: break;
          case 88:
            { return createSymbol(ParserConstants.T_IS_GREATER_OR_EQUAL);
            }
          // fall through
          case 301: break;
          case 89:
            { return createSymbol(ParserConstants.T_SR);
            }
          // fall through
          case 302: break;
          case 90:
            { yybegin(YYINITIAL);
	return createSymbol(ParserConstants.T_SEMICOLON); /* implicit ';' at php-end tag */
            }
          // fall through
          case 303: break;
          case 91:
            { return createSymbol(ParserConstants.T_COALESCE);
            }
          // fall through
          case 304: break;
          case 92:
            { return createFullSymbol(ParserConstants.T_AS);
            }
          // fall through
          case 305: break;
          case 93:
            { return createFullSymbol(ParserConstants.T_DO);
            }
          // fall through
          case 306: break;
          case 94:
            { return createFullSymbol(ParserConstants.T_FN);
            }
          // fall through
          case 307: break;
          case 95:
            { return createFullSymbol(ParserConstants.T_IF);
            }
          // fall through
          case 308: break;
          case 96:
            { return createFullSymbol(ParserConstants.T_LOGICAL_OR);
            }
          // fall through
          case 309: break;
          case 97:
            { return createFullSymbol(ParserConstants.T_NAME_FULLY_QUALIFIED);
            }
          // fall through
          case 310: break;
          case 98:
            { return createSymbol(ParserConstants.T_XOR_EQUAL);
            }
          // fall through
          case 311: break;
          case 99:
            { return createSymbol(ParserConstants.T_OR_EQUAL);
            }
          // fall through
          case 312: break;
          case 100:
            { return createSymbol(ParserConstants.T_BOOLEAN_OR);
            }
          // fall through
          case 313: break;
          case 101:
            { yypushback(1);
	return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          // fall through
          case 314: break;
          case 102:
            { pushState(ST_LOOKING_FOR_VARNAME);
	return createSymbol(ParserConstants.T_DOLLAR_OPEN_CURLY_BRACES);
            }
          // fall through
          case 315: break;
          case 103:
            { pushState(ST_IN_SCRIPTING);
	yypushback(yylength() - 1);
	return createSymbol(ParserConstants.T_CURLY_OPEN_WITH_DOLAR);
            }
          // fall through
          case 316: break;
          case 104:
            { return createSymbol(ParserConstants.T_CHARACTER);
            }
          // fall through
          case 317: break;
          case 105:
            { String yytext = yytext();
	int textLength = yytext.length();
	String heredoc = heredocIds.peek();
	int heredocLength = heredoc.length();
	if (textLength > heredocLength && yytext.substring(textLength - heredocLength, textLength).equals(heredoc)) {
		int pos = textLength - heredocLength - 1;
		char c = yytext.charAt(pos);
		if (c == ' ' || c == '\t') {
			while (pos > 0) {
				char c2 = yytext.charAt(pos - 1);
				if (c2 != ' ' && c2 != '\t') {
					break;
				}
				pos--;
			}
			lastHeredocIndentation = yytext.substring(pos, textLength - heredocLength);
			// we need to remove the closing label from the symbol value
			yypushback(heredocLength);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		} else if (c == '\n' || c == '\r') {
			lastHeredocIndentation = ""; //$NON-NLS-1$
			// we need to remove the closing label from the symbol value
			yypushback(heredocLength);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		}
	}
            }
          // fall through
          case 318: break;
          case 106:
            { String yytext = yytext();
	int textLength = yytext.length();
	String nowdoc = heredocIds.peek();
	int nowdocLength = nowdoc.length();
	if (textLength > nowdocLength && yytext.substring(textLength - nowdocLength, textLength).equals(nowdoc)) {
		int pos = textLength - nowdocLength - 1;
		char c = yytext.charAt(pos);
		if (c == ' ' || c == '\t') {
			while (pos > 0) {
				char c2 = yytext.charAt(pos - 1);
				if (c2 != ' ' && c2 != '\t') {
					break;
				}
				pos--;
			}
			lastHeredocIndentation = yytext.substring(pos, textLength - nowdocLength);
			// we need to remove the closing label from the symbol value
			yypushback(nowdocLength);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		} else if (c == '\n' || c == '\r') {
			lastHeredocIndentation = ""; //$NON-NLS-1$
			// we need to remove the closing label from the symbol value
			yypushback(nowdocLength);
			yybegin(ST_END_HEREDOC);
			return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
		}
	}
            }
          // fall through
          case 319: break;
          case 107:
            { return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          // fall through
          case 320: break;
          case 108:
            { handleMultilineCommentEnd();
	yybegin(ST_IN_SCRIPTING);
            }
          // fall through
          case 321: break;
          case 109:
            { handlePHPDocEnd();
	yybegin(ST_IN_SCRIPTING);
            }
          // fall through
          case 322: break;
          case 110:
            { if (asp_tags || yytext().charAt(0) != '%') { /* asp comment? */
		handleLineCommentEnd();
		yypushback(yylength());
		yybegin(ST_IN_SCRIPTING);
	}
            }
          // fall through
          case 323: break;
          case 111:
            { String yytext = yytext();
	if ((yytext.charAt(1) == '%' && asp_tags)
		|| (yytext.charAt(1) == '?')) {
		yybegin(ST_IN_SCRIPTING);
		return createSymbol(ParserConstants.T_OPEN_TAG_WITH_ECHO);
	} else {
		return createSymbol(ParserConstants.T_INLINE_HTML);
	}
            }
          // fall through
          case 324: break;
          case 112:
            { return createSymbol(ParserConstants.T_IS_NOT_IDENTICAL);
            }
          // fall through
          case 325: break;
          case 113:
            { return createSymbol(ParserConstants.T_POW_EQUAL);
            }
          // fall through
          case 326: break;
          case 114:
            { return createSymbol(ParserConstants.T_ELLIPSIS);
            }
          // fall through
          case 327: break;
          case 115:
            { if (parsePHPDoc()) {
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=316077
	// Reset the internal variables caching the values
	// previously resetted by parsePHPDoc().
	// Actually it would be enough to only reset zzEndReadL,
	// but do it cleanly...
	// Also be careful that those internal variables could
	// change from one version of JFlex to another.
	zzCurrentPosL = zzCurrentPos;
	zzMarkedPosL = zzMarkedPos;
	zzBufferL = zzBuffer;
	zzEndReadL = zzEndRead;
} else {
	handleCommentStart();
	yybegin(ST_DOCBLOCK);
}
            }
          // fall through
          case 328: break;
          case 116:
            { return createFullSymbol(ParserConstants.T_BNUMBER);
            }
          // fall through
          case 329: break;
          case 117:
            { return createFullSymbol(ParserConstants.T_ONUMBER);
            }
          // fall through
          case 330: break;
          case 118:
            { return createSymbol(ParserConstants.T_SL_EQUAL);
            }
          // fall through
          case 331: break;
          case 119:
            { return createSymbol(ParserConstants.T_SPACESHIP);
            }
          // fall through
          case 332: break;
          case 120:
            { return createSymbol(ParserConstants.T_IS_IDENTICAL);
            }
          // fall through
          case 333: break;
          case 121:
            { return createSymbol(ParserConstants.T_SR_EQUAL);
            }
          // fall through
          case 334: break;
          case 122:
            { pushState(ST_LOOKING_FOR_PROPERTY);
	return createSymbol(ParserConstants.T_NULLSAFE_OBJECT_OPERATOR);
            }
          // fall through
          case 335: break;
          case 123:
            { return createSymbol(ParserConstants.T_COALESCE_EQUAL);
            }
          // fall through
          case 336: break;
          case 124:
            { return createFullSymbol(ParserConstants.T_LOGICAL_AND);
            }
          // fall through
          case 337: break;
          case 125:
            { return createFullSymbol(ParserConstants.T_NAME_QUALIFIED);
            }
          // fall through
          case 338: break;
          case 126:
            { return createFullSymbol(ParserConstants.T_EXIT);
            }
          // fall through
          case 339: break;
          case 127:
            { return createFullSymbol(ParserConstants.T_FOR);
            }
          // fall through
          case 340: break;
          case 128:
            { return createFullSymbol(ParserConstants.T_NEW);
            }
          // fall through
          case 341: break;
          case 129:
            { return createFullSymbol(ParserConstants.T_TRY);
            }
          // fall through
          case 342: break;
          case 130:
            { return createFullSymbol(ParserConstants.T_USE);
            }
          // fall through
          case 343: break;
          case 131:
            { return createFullSymbol(ParserConstants.T_VAR);
            }
          // fall through
          case 344: break;
          case 132:
            { return createFullSymbol(ParserConstants.T_LOGICAL_XOR);
            }
          // fall through
          case 345: break;
          case 133:
            { yypushback(1);
	pushState(ST_VAR_OFFSET);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          // fall through
          case 346: break;
          case 134:
            { return createSymbol(ParserConstants.T_NULLSAFE_OBJECT_OPERATOR);
            }
          // fall through
          case 347: break;
          case 135:
            { handleCommentStart();
	handleMultilineCommentEnd();
            }
          // fall through
          case 348: break;
          case 136:
            { return createFullSymbol(ParserConstants.T_CASE);
            }
          // fall through
          case 349: break;
          case 137:
            { return createFullSymbol(ParserConstants.T_ECHO);
            }
          // fall through
          case 350: break;
          case 138:
            { return createFullSymbol(ParserConstants.T_ELSE);
            }
          // fall through
          case 351: break;
          case 139:
            { return createFullSymbol(ParserConstants.T_EVAL);
            }
          // fall through
          case 352: break;
          case 140:
            { return createFullSymbol(ParserConstants.T_GOTO);
            }
          // fall through
          case 353: break;
          case 141:
            { return createFullSymbol(ParserConstants.T_LIST);
            }
          // fall through
          case 354: break;
          case 142:
            { return createSymbol(ParserConstants.T_INT_CAST);
            }
          // fall through
          case 355: break;
          case 143:
            { String yytext = yytext();
	int removeChars = (yytext.charAt(0) == 'b') ? 4 : 3;
	String hereOrNowDoc = yytext.substring(removeChars).trim();    // for 'b<<<' or '<<<'
	int heredoc_len = hereOrNowDoc.length();

	Symbol sym = createFullSymbol(ParserConstants.T_START_HEREDOC);
	sym.value = hereOrNowDoc;

	if (hereOrNowDoc.charAt(0) == '\'') {
		heredocIds.push(hereOrNowDoc.substring(1, heredoc_len - 1));
		yybegin(ST_START_NOWDOC);
	} else if (hereOrNowDoc.charAt(0) == '"') {
		heredocIds.push(hereOrNowDoc.substring(1, heredoc_len - 1));
		yybegin(ST_START_HEREDOC);
	} else {
		heredocIds.push(hereOrNowDoc);
		yybegin(ST_START_HEREDOC);
	}
	return sym;
            }
          // fall through
          case 356: break;
          case 144:
            { return createFullSymbol(ParserConstants.T_ARRAY);
            }
          // fall through
          case 357: break;
          case 145:
            { return createFullSymbol(ParserConstants.T_BREAK);
            }
          // fall through
          case 358: break;
          case 146:
            { return createFullSymbol(ParserConstants.T_CATCH);
            }
          // fall through
          case 359: break;
          case 147:
            { return createFullSymbol(ParserConstants.T_CLASS);
            }
          // fall through
          case 360: break;
          case 148:
            { return createFullSymbol(ParserConstants.T_CLONE);
            }
          // fall through
          case 361: break;
          case 149:
            { return createFullSymbol(ParserConstants.T_CONST);
            }
          // fall through
          case 362: break;
          case 150:
            { return createFullSymbol(ParserConstants.T_EMPTY);
            }
          // fall through
          case 363: break;
          case 151:
            { return createFullSymbol(ParserConstants.T_ENDIF);
            }
          // fall through
          case 364: break;
          case 152:
            { return createFullSymbol(ParserConstants.T_FINAL);
            }
          // fall through
          case 365: break;
          case 153:
            { return createFullSymbol(ParserConstants.T_ISSET);
            }
          // fall through
          case 366: break;
          case 154:
            { return createFullSymbol(ParserConstants.T_MATCH);
            }
          // fall through
          case 367: break;
          case 155:
            { return createFullSymbol(ParserConstants.T_PRINT);
            }
          // fall through
          case 368: break;
          case 156:
            { return createFullSymbol(ParserConstants.T_THROW);
            }
          // fall through
          case 369: break;
          case 157:
            { return createFullSymbol(ParserConstants.T_TRAIT);
            }
          // fall through
          case 370: break;
          case 158:
            { return createFullSymbol(ParserConstants.T_UNSET);
            }
          // fall through
          case 371: break;
          case 159:
            { return createFullSymbol(ParserConstants.T_WHILE);
            }
          // fall through
          case 372: break;
          case 160:
            { return createFullSymbol(ParserConstants.T_YIELD);
            }
          // fall through
          case 373: break;
          case 161:
            { yypushback(3);
	pushState(ST_LOOKING_FOR_PROPERTY);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          // fall through
          case 374: break;
          case 162:
            { yybegin(ST_IN_SCRIPTING);
	//return T_OPEN_TAG;
            }
          // fall through
          case 375: break;
          case 163:
            { return createSymbol(ParserConstants.T_BOOL_CAST);
            }
          // fall through
          case 376: break;
          case 164:
            { return createSymbol(ParserConstants.T_DOUBLE_CAST);
            }
          // fall through
          case 377: break;
          case 165:
            { /* not a keyword, used to recognize constants.*/
	return createFullSymbol(ParserConstants.T_DEFINE);
            }
          // fall through
          case 378: break;
          case 166:
            { return createFullSymbol(ParserConstants.T_ELSEIF);
            }
          // fall through
          case 379: break;
          case 167:
            { return createFullSymbol(ParserConstants.T_ENDFOR);
            }
          // fall through
          case 380: break;
          case 168:
            { yypushback(yylength()-4);
	return createFullSymbol(ParserConstants.T_ENUM);
            }
          // fall through
          case 381: break;
          case 169:
            { return createFullSymbol(ParserConstants.T_GLOBAL);
            }
          // fall through
          case 382: break;
          case 170:
            { return createFullSymbol(ParserConstants.T_PUBLIC);
            }
          // fall through
          case 383: break;
          case 171:
            { return createFullSymbol(ParserConstants.T_RETURN);
            }
          // fall through
          case 384: break;
          case 172:
            { return createFullSymbol(ParserConstants.T_STATIC);
            }
          // fall through
          case 385: break;
          case 173:
            { return createFullSymbol(ParserConstants.T_SWITCH);
            }
          // fall through
          case 386: break;
          case 174:
            { return createSymbol(ParserConstants.T_ARRAY_CAST);
            }
          // fall through
          case 387: break;
          case 175:
            { return createSymbol(ParserConstants.T_UNSET_CAST);
            }
          // fall through
          case 388: break;
          case 176:
            { return createFullSymbol(ParserConstants.T_DECLARE);
            }
          // fall through
          case 389: break;
          case 177:
            { return createFullSymbol(ParserConstants.T_DEFAULT);
            }
          // fall through
          case 390: break;
          case 178:
            { return createFullSymbol(ParserConstants.T_EXTENDS);
            }
          // fall through
          case 391: break;
          case 179:
            { return createFullSymbol(ParserConstants.T_FINALLY);
            }
          // fall through
          case 392: break;
          case 180:
            { return createFullSymbol(ParserConstants.T_FOREACH);
            }
          // fall through
          case 393: break;
          case 181:
            { return createFullSymbol(ParserConstants.T_INCLUDE);
            }
          // fall through
          case 394: break;
          case 182:
            { return createFullSymbol(ParserConstants.T_PRIVATE);
            }
          // fall through
          case 395: break;
          case 183:
            { return createFullSymbol(ParserConstants.T_REQUIRE);
            }
          // fall through
          case 396: break;
          case 184:
            { return createSymbol(ParserConstants.T_DIR);
            }
          // fall through
          case 397: break;
          case 185:
            { return createSymbol(ParserConstants.T_STRING_CAST);
            }
          // fall through
          case 398: break;
          case 186:
            { return createSymbol(ParserConstants.T_OBJECT_CAST);
            }
          // fall through
          case 399: break;
          case 187:
            { return createFullSymbol(ParserConstants.T_ABSTRACT);
            }
          // fall through
          case 400: break;
          case 188:
            { return createFullSymbol(ParserConstants.T_CALLABLE);
            }
          // fall through
          case 401: break;
          case 189:
            { return createFullSymbol(ParserConstants.T_CONTINUE);
            }
          // fall through
          case 402: break;
          case 190:
            { return createFullSymbol(ParserConstants.T_ENDWHILE);
            }
          // fall through
          case 403: break;
          case 191:
            { return createFullSymbol(ParserConstants.T_FUNCTION);
            }
          // fall through
          case 404: break;
          case 192:
            { return createFullSymbol(ParserConstants.T_READONLY);
            }
          // fall through
          case 405: break;
          case 193:
            { return createSymbol(ParserConstants.T_FILE);
            }
          // fall through
          case 406: break;
          case 194:
            { return createSymbol(ParserConstants.T_LINE);
            }
          // fall through
          case 407: break;
          case 195:
            { return createFullSymbol(ParserConstants.T_ENDSWITCH);
            }
          // fall through
          case 408: break;
          case 196:
            { return createFullSymbol(ParserConstants.T_INSTEADOF);
            }
          // fall through
          case 409: break;
          case 197:
            { return createFullSymbol(ParserConstants.T_INTERFACE);
            }
          // fall through
          case 410: break;
          case 198:
            { return createFullSymbol(ParserConstants.T_NAMESPACE);
            }
          // fall through
          case 411: break;
          case 199:
            { return createFullSymbol(ParserConstants.T_PROTECTED);
            }
          // fall through
          case 412: break;
          case 200:
            { return createSymbol(ParserConstants.T_CLASS_C);
            }
          // fall through
          case 413: break;
          case 201:
            { return createFullSymbol(ParserConstants.T_ENDDECLARE);
            }
          // fall through
          case 414: break;
          case 202:
            { return createFullSymbol(ParserConstants.T_ENDFOREACH);
            }
          // fall through
          case 415: break;
          case 203:
            { return createFullSymbol(ParserConstants.T_IMPLEMENTS);
            }
          // fall through
          case 416: break;
          case 204:
            { return createFullSymbol(ParserConstants.T_INSTANCEOF);
            }
          // fall through
          case 417: break;
          case 205:
            { return createSymbol(ParserConstants.T_YIELD_FROM);
            }
          // fall through
          case 418: break;
          case 206:
            { return createSymbol(ParserConstants.T_METHOD_C);
            }
          // fall through
          case 419: break;
          case 207:
            { return createFullSymbol(ParserConstants.T_NAME_RELATIVE);
            }
          // fall through
          case 420: break;
          case 208:
            { return createFullSymbol(ParserConstants.T_INCLUDE_ONCE);
            }
          // fall through
          case 421: break;
          case 209:
            { return createFullSymbol(ParserConstants.T_REQUIRE_ONCE);
            }
          // fall through
          case 422: break;
          case 210:
            { return createSymbol(ParserConstants.T_FUNC_C);
            }
          // fall through
          case 423: break;
          case 211:
            { handleCommentStart();
	handleVarComment();
	//return createFullSymbol(ParserConstants.T_VAR_COMMENT);
            }
          // fall through
          case 424: break;
          case 212:
            { return createSymbol(ParserConstants.T_NS_C);
            }
          // fall through
          case 425: break;
          case 213:
            { return createSymbol(ParserConstants.T_HALT_COMPILER);
            }
          // fall through
          case 426: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String[] argv) {
    if (argv.length == 0) {
      System.out.println("Usage : java PHPAstLexer [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          // Side-effect: is encodingName valid?
          java.nio.charset.Charset.forName(encodingName);
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        PHPAstLexer scanner = null;
        java.io.FileInputStream stream = null;
        java.io.Reader reader = null;
        try {
          stream = new java.io.FileInputStream(argv[i]);
          reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new PHPAstLexer(reader);
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
        finally {
          if (reader != null) {
            try {
              reader.close();
            }
            catch (java.io.IOException e) {
              System.out.println("IO error closing file \""+argv[i]+"\"");
              System.out.println(e);
            }
          }
          if (stream != null) {
            try {
              stream.close();
            }
            catch (java.io.IOException e) {
              System.out.println("IO error closing file \""+argv[i]+"\"");
              System.out.println(e);
            }
          }
        }
      }
    }
  }


}
