/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.runner;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.osgi.framework.Bundle;

public abstract class AbstractPDTTRunner
extends Suite {
    protected static final List<Runner> EMPTY_RUNNERS = Collections.emptyList();
    protected final List<Runner> runners = new LinkedList<Runner>();
    protected int counter = 0;

    public AbstractPDTTRunner(Class<?> klass) throws Exception {
        super(klass, EMPTY_RUNNERS);
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    protected String[] buildFileList(String[] dirs) throws Throwable {
        LinkedList<String> list = new LinkedList<String>();
        Bundle context = this.getBundle();
        String[] stringArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            String[] stringArray2 = PDTTUtils.getPDTTFiles(dir, context);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String fileName = stringArray2[n4];
                list.add(fileName);
                ++n4;
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    protected Bundle getBundle() throws Throwable {
        for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(Context.class)) {
            if (!method.isPublic() || !method.isStatic() || !method.getReturnType().isAssignableFrom(Bundle.class)) continue;
            return (Bundle)method.invokeExplosively(null, new Object[0]);
        }
        return PHPCoreTests.getDefault().getBundle();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Context {
    }
}

