/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.util.INamespaceResolver;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NamespaceResolverTests {
    private static final String SIMPLE = "namespace_resolver1";
    private static final String SIMPLE_BUILDPATHS = "namespace_resolver2";
    private static IProject simple;
    private static IProject simpleBuildpaths;

    @BeforeClass
    public static void setup() throws CoreException {
        simple = TestUtils.createProject(SIMPLE);
        TestUtils.createFolder(simple, "src");
        TestUtils.createFolder(simple, "tests");
        simpleBuildpaths = TestUtils.createProject(SIMPLE_BUILDPATHS);
        TestUtils.createFolder(simpleBuildpaths, "src");
        TestUtils.createFolder(simpleBuildpaths, "tests");
        DLTKCore.create((IProject)simpleBuildpaths).setRawBuildpath(new IBuildpathEntry[]{DLTKCore.newSourceEntry((IPath)simpleBuildpaths.getFullPath().append("src")), DLTKCore.newSourceEntry((IPath)simpleBuildpaths.getFullPath().append("tests"))}, (IProgressMonitor)new NullProgressMonitor());
    }

    @AfterClass
    public static void cleanup() {
        TestUtils.deleteProject(simple);
        TestUtils.deleteProject(simpleBuildpaths);
        simple = null;
        simpleBuildpaths = null;
    }

    @Test
    public void testSimpleResolveNamespace() {
        INamespaceResolver resolver = PHPToolkitUtil.getNamespaceResolver((IProject)simple);
        Assert.assertEquals((Object)"src", (Object)resolver.resolveNamespace(simple.getFullPath().append("src")));
        Assert.assertEquals((Object)"src\\Api", (Object)resolver.resolveNamespace(simple.getFullPath().append("src").append("Api")));
        Assert.assertEquals((Object)"NotExisted\\Dir", (Object)resolver.resolveNamespace(simple.getFullPath().append("NotExisted").append("Dir")));
    }

    @Test
    public void testSimpleResolveLocation() {
        INamespaceResolver resolver = PHPToolkitUtil.getNamespaceResolver((IProject)simple);
        Assert.assertEquals((Object)simple.getFullPath().append("src"), (Object)resolver.resolveLocation(simple.getFullPath(), "src"));
        Assert.assertEquals((Object)simple.getFullPath().append("src").append("Api"), (Object)resolver.resolveLocation(simple.getFullPath(), "src\\Api"));
        Assert.assertEquals((Object)simple.getFullPath().append("NotExisted").append("Dir"), (Object)resolver.resolveLocation(simple.getFullPath(), "NotExisted\\\\Dir"));
    }

    @Test
    public void testSimpleBuildpathResolveNamespace() {
        INamespaceResolver resolver = PHPToolkitUtil.getNamespaceResolver((IProject)simpleBuildpaths);
        Assert.assertEquals((Object)"", (Object)resolver.resolveNamespace(simpleBuildpaths.getFullPath().append("src")));
        Assert.assertEquals((Object)"Api", (Object)resolver.resolveNamespace(simpleBuildpaths.getFullPath().append("src").append("Api")));
        Assert.assertEquals((Object)"NotExisted\\Dir", (Object)resolver.resolveNamespace(simpleBuildpaths.getFullPath().append("NotExisted").append("Dir")));
        Assert.assertEquals((Object)"Command\\Something", (Object)resolver.resolveNamespace(simpleBuildpaths.getFullPath().append("tests").append("Command").append("Something")));
    }

    @Test
    public void testSimpleBuildpathResolveLocation() {
        INamespaceResolver resolver = PHPToolkitUtil.getNamespaceResolver((IProject)simpleBuildpaths);
        Assert.assertEquals((Object)simpleBuildpaths.getFullPath().append("src").append("Api"), (Object)resolver.resolveLocation(simpleBuildpaths.getFullPath().append("src").append("inner"), "Api"));
        Assert.assertEquals((Object)simpleBuildpaths.getFullPath().append("tests").append("Api").append("Something"), (Object)resolver.resolveLocation(simpleBuildpaths.getFullPath().append("tests"), "Api\\Something"));
        Assert.assertEquals((Object)simpleBuildpaths.getFullPath(), (Object)resolver.resolveLocation(simpleBuildpaths.getFullPath(), ""));
    }
}

