/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;

public class MultipleTypeBinding
implements ITypeBinding {
    private static final IVariableBinding[] NO_VARIABLES = new IVariableBinding[0];
    private static final IMethodBinding[] NO_METHODS = new IMethodBinding[0];
    private ITypeBinding[] subTypes;
    private IVariableBinding[] fields;
    private IMethodBinding[] methods;
    private IEvaluatedType type;
    private int modifiers = -1;
    private ITypeBinding[] interfaces;

    public MultipleTypeBinding(IEvaluatedType type, ITypeBinding[] subTypes) {
        this.type = type;
        this.subTypes = subTypes;
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    public boolean isDeprecated() {
        ITypeBinding[] iTypeBindingArray = this.subTypes;
        int n = this.subTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding binding = iTypeBindingArray[n2];
            if (binding.isDeprecated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IModelElement getPHPElement() {
        ITypeBinding[] iTypeBindingArray = this.subTypes;
        int n = this.subTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding binding = iTypeBindingArray[n2];
            IModelElement element = binding.getPHPElement();
            if (element != null) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getKey() {
        StringBuilder sb = new StringBuilder("mutli_");
        ITypeBinding[] iTypeBindingArray = this.subTypes;
        int n = this.subTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding binding = iTypeBindingArray[n2];
            sb.append(binding.getKey());
            ++n2;
        }
        return null;
    }

    @Override
    public ITypeBinding createArrayType(int dimension) {
        return null;
    }

    @Override
    public String getBinaryName() {
        if (this.isUnknown() || this.isAmbiguous()) {
            return null;
        }
        return this.getKey();
    }

    @Override
    public ITypeBinding getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return null;
    }

    @Override
    public IVariableBinding[] getDeclaredFields() {
        if (this.fields == null) {
            if (this.isUnknown()) {
                this.fields = NO_VARIABLES;
            } else {
                HashSet<IVariableBinding> tmp = new HashSet<IVariableBinding>();
                ITypeBinding[] iTypeBindingArray = this.subTypes;
                int n = this.subTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding binging = iTypeBindingArray[n2];
                    tmp.addAll(Arrays.asList(binging.getDeclaredFields()));
                    ++n2;
                }
                this.fields = tmp.toArray(NO_VARIABLES);
            }
        }
        return this.fields;
    }

    @Override
    public IMethodBinding[] getDeclaredMethods() {
        if (this.methods == null) {
            if (this.isUnknown()) {
                this.methods = NO_METHODS;
            } else {
                HashSet<IMethodBinding> tmp = new HashSet<IMethodBinding>();
                ITypeBinding[] iTypeBindingArray = this.subTypes;
                int n = this.subTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding binging = iTypeBindingArray[n2];
                    tmp.addAll(Arrays.asList(binging.getDeclaredMethods()));
                    ++n2;
                }
                this.methods = tmp.toArray(NO_METHODS);
            }
        }
        return this.methods;
    }

    @Override
    public int getModifiers() {
        int mods = 0;
        ITypeBinding[] iTypeBindingArray = this.subTypes;
        int n = this.subTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding type = iTypeBindingArray[n2];
            mods |= type.getModifiers();
            ++n2;
        }
        return 0;
    }

    @Override
    public int getDimensions() {
        return 0;
    }

    @Override
    public ITypeBinding getElementType() {
        return null;
    }

    @Override
    public ITypeBinding[] getInterfaces() {
        return null;
    }

    @Override
    public String getName() {
        return this.subTypes[0].getName();
    }

    @Override
    public IEvaluatedType getEvaluatedType() {
        return null;
    }

    @Override
    public ITypeBinding getSuperclass() {
        return null;
    }

    @Override
    public ITypeBinding getTypeDeclaration() {
        return null;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isTrait() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isNullType() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isSubTypeCompatible(ITypeBinding type) {
        return false;
    }

    @Override
    public boolean isAmbiguous() {
        return true;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public List<IType> getTraitList(boolean isMethod, String classMemberName, boolean includeSuper) {
        return null;
    }

    @Override
    public IModelElement[] getPHPElements() {
        return null;
    }

    @Override
    public boolean isEnum() {
        return false;
    }
}

