/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.formatter.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.formatter.core.profiles.ICodeFormatterPreferencesInitializer;
import org.eclipse.php.internal.formatter.core.FormattingProfile;
import org.eclipse.php.internal.formatter.core.Logger;

public class FormattingProfileRegistry {
    private static final String PROFILES_EXTENSION_POINT_ID = "profiles";
    private static final String PROFILE_PROPERTY = "profile";
    private static final String ID_PROPERTY = "id";
    private static final String NAME_PROPERTY = "name";
    private static final String CLASS_PROPERTY = "class";
    private Map<String, FormattingProfile> map = new LinkedHashMap<String, FormattingProfile>();

    public FormattingProfileRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.formatter.core", PROFILES_EXTENSION_POINT_ID);
        int i = 0;
        while (i < elements.length) {
            this.addProfile(elements[i]);
            ++i;
        }
    }

    private void addProfile(IConfigurationElement element) {
        if (!PROFILE_PROPERTY.equals(element.getName())) {
            return;
        }
        String id = element.getAttribute(ID_PROPERTY);
        String name = element.getAttribute(NAME_PROPERTY);
        if (element.getAttribute(CLASS_PROPERTY) != null) {
            try {
                ICodeFormatterPreferencesInitializer initializer = (ICodeFormatterPreferencesInitializer)element.createExecutableExtension(CLASS_PROPERTY);
                this.map.put(id, new FormattingProfile(id, name, initializer));
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    public FormattingProfile getProfile(String id) {
        return this.map.get(id);
    }

    public Collection<FormattingProfile> getProfiles() {
        return this.map.values();
    }
}

