/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.refactoring.core.move.PHPMoveProcessor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class PHPMoveProcessorBreakPointTestCase {
    private IProject project1;

    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testMove() {
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                PHPMoveProcessorBreakPointTestCase.this.project1 = TestUtils.createProject((String)"TestProject1");
                IFolder folder = TestUtils.createFolder((IProject)PHPMoveProcessorBreakPointTestCase.this.project1, (String)"src");
                IFile file = TestUtils.createFile((IFolder)folder, (String)"RunBreakPoint.php", (String)"<?php class TestRenameClass{}?>");
                folder.getFile("RunBreakPoint.php");
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("location", file.getFullPath().toString());
                attributes.put("org.eclipse.wst.sse.ui.extensions.breakpoint.path", file.getFullPath().toString());
                new PHPConditionalBreakpoint((IResource)file, 1, -1, -1, attributes);
                folder = PHPMoveProcessorBreakPointTestCase.this.project1.getFolder("src1");
                if (!folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                PHPMoveProcessorBreakPointTestCase.this.project1.build(10, monitor);
                PHPMoveProcessor processor = new PHPMoveProcessor((IResource)PHPMoveProcessorBreakPointTestCase.this.project1.getProject().getFolder("src"));
                RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                Assert.assertEquals((long)0L, (long)status.getSeverity());
                processor.setDestination((IContainer)PHPMoveProcessorBreakPointTestCase.this.project1.getFolder("src1"));
                processor.setUpdateReferences(true);
                try {
                    Change change = processor.createChange((IProgressMonitor)new NullProgressMonitor());
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                }
                catch (OperationCanceledException e) {
                    Assert.fail((String)e.getMessage());
                }
                catch (CoreException e) {
                    Assert.fail((String)e.getMessage());
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                PHPMoveProcessorBreakPointTestCase.this.project1.build(10, monitor);
                IFile file2 = PHPMoveProcessorBreakPointTestCase.this.project1.getFile("src1/src/RunBreakPoint.php");
                try {
                    IMarker[] markers = file2.findMarkers("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker", false, 1);
                    Assert.assertNotNull((Object)markers);
                    Assert.assertTrue((markers.length > 0 ? 1 : 0) != 0);
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    IBreakpoint breakpoint = breakpointManager.getBreakpoint(markers[0]);
                    Assert.assertTrue((boolean)(breakpoint instanceof PHPConditionalBreakpoint));
                    Assert.assertEquals((long)1L, (long)((PHPConditionalBreakpoint)breakpoint).getLineNumber());
                }
                catch (CoreException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, null);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
    }
}

