/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.rewrite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.ArrayAccess;
import org.eclipse.php.core.ast.nodes.ArrayCreation;
import org.eclipse.php.core.ast.nodes.ArrayElement;
import org.eclipse.php.core.ast.nodes.Assignment;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.BreakStatement;
import org.eclipse.php.core.ast.nodes.CastExpression;
import org.eclipse.php.core.ast.nodes.CatchClause;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.ast.nodes.CloneExpression;
import org.eclipse.php.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.core.ast.nodes.ContinueStatement;
import org.eclipse.php.core.ast.nodes.DoStatement;
import org.eclipse.php.core.ast.nodes.EchoStatement;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldAccess;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.ForEachStatement;
import org.eclipse.php.core.ast.nodes.ForStatement;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.FunctionName;
import org.eclipse.php.core.ast.nodes.GlobalStatement;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.IfStatement;
import org.eclipse.php.core.ast.nodes.IgnoreError;
import org.eclipse.php.core.ast.nodes.InLineHtml;
import org.eclipse.php.core.ast.nodes.Include;
import org.eclipse.php.core.ast.nodes.InfixExpression;
import org.eclipse.php.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.ast.nodes.ListVariable;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.MethodInvocation;
import org.eclipse.php.core.ast.nodes.PostfixExpression;
import org.eclipse.php.core.ast.nodes.PrefixExpression;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Quote;
import org.eclipse.php.core.ast.nodes.Reference;
import org.eclipse.php.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.core.ast.nodes.ReturnStatement;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.ast.nodes.StaticStatement;
import org.eclipse.php.core.ast.nodes.SwitchCase;
import org.eclipse.php.core.ast.nodes.SwitchStatement;
import org.eclipse.php.core.ast.nodes.ThrowStatement;
import org.eclipse.php.core.ast.nodes.TryStatement;
import org.eclipse.php.core.ast.nodes.UnaryOperation;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.ast.nodes.WhileStatement;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP54;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP55;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP56;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP7;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP71;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ListRewrite;
import org.eclipse.text.edits.TextEdit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

public class ASTRewriteTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    protected AST ast;
    protected IDocument document;
    protected Program program;

    @Test
    public void variable1() throws Exception {
        String str = "<?php $a; $A;?>";
        this.initialize(str);
        List<Variable> variables = this.getAllOfType(this.program, Variable.class);
        Assert.assertTrue((String)"Unexpected list size.", (variables.size() == 2 ? 1 : 0) != 0);
        variables.get(1).setName((Expression)this.ast.newIdentifier("B1"));
        this.rewrite();
        this.checkResult("<?php $a; $B1;?>");
    }

    @Test
    public void variable2() throws Exception {
        String str = "<?php $AAA;?>";
        this.initialize(str);
        List<Variable> variables = this.getAllOfType(this.program, Variable.class);
        Assert.assertTrue((String)"Unexpected list size.", (variables.size() == 1 ? 1 : 0) != 0);
        ((Identifier)variables.get(0).getName()).setName("B");
        this.rewrite();
        this.checkResult("<?php $B;?>");
    }

    @Test
    public void functionName() throws Exception {
        String str = "<?php foo(); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionName functionName = invocations.get(0).getFunctionName();
        functionName.setName((Expression)this.ast.newIdentifier("boobo"));
        this.rewrite();
        this.checkResult("<?php boobo(); ?>");
    }

    @Test
    public void functionInvocationName() throws Exception {
        String str = "<?php foo(); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.setFunctionName(this.ast.newFunctionName((Expression)this.ast.newIdentifier("boobo")));
        this.rewrite();
        this.checkResult("<?php boobo(); ?>");
    }

    @Test
    public void functionInvocationAddParam() throws Exception {
        String str = "<?php foo( ); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.parameters().add(this.ast.newVariable("aaa"));
        this.rewrite();
        this.checkResult("<?php foo($aaa ); ?>");
    }

    @Test
    public void functionInvocationAddParams() throws Exception {
        String str = "<?php foo(); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.parameters().add(this.ast.newVariable("aaa"));
        functionInvocation.parameters().add(this.ast.newVariable("bbb"));
        functionInvocation.parameters().add(this.ast.newVariable("ccc"));
        this.rewrite();
        this.checkResult("<?php foo($aaa, $bbb, $ccc); ?>");
    }

    @Test
    public void functionInvocationRemoveParam1() throws Exception {
        String str = "<?php foo($aaa, $bbb); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.parameters().remove(1);
        this.rewrite();
        this.checkResult("<?php foo($aaa); ?>");
    }

    @Test
    public void functionInvocationRemoveParam2() throws Exception {
        String str = "<?php foo($aaa, $bbb); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.parameters().remove(0);
        this.rewrite();
        this.checkResult("<?php foo($bbb); ?>");
    }

    @Test
    public void functionInvocationRemoveParams() throws Exception {
        String str = "<?php foo($aaa, $bbb); ?>";
        this.initialize(str);
        List<FunctionInvocation> invocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (invocations.size() == 1 ? 1 : 0) != 0);
        FunctionInvocation functionInvocation = invocations.get(0);
        functionInvocation.parameters().clear();
        this.rewrite();
        this.checkResult("<?php foo(); ?>");
    }

    @Test
    public void variable3() throws Exception {
        String str = "<?php $myClass->bar();?>";
        this.initialize(str);
        List<Variable> variables = this.getAllOfType(this.program, Variable.class);
        Assert.assertTrue((String)"Unexpected list size.", (variables.size() == 2 ? 1 : 0) != 0);
        variables.get(1).setName((Expression)this.ast.newIdentifier("foo"));
        variables.get(1).setIsDollared(true);
        variables.get(0).setIsDollared(false);
        this.rewrite();
        this.checkResult("<?php myClass->$foo();?>");
    }

    @Test
    public void staticFunctionInvocation() throws Exception {
        String str = "<?php A::foo($a); ?>";
        this.initialize(str);
        List<StaticMethodInvocation> staticInvocations = this.getAllOfType(this.program, StaticMethodInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (staticInvocations.size() == 1 ? 1 : 0) != 0);
        staticInvocations.get(0).setClassName((Expression)this.ast.newIdentifier("B"));
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(this.ast.newScalar("b", 2));
        parameters.add(this.ast.newVariable("c"));
        staticInvocations.get(0).setMethod(this.ast.newFunctionInvocation(this.ast.newFunctionName((Expression)this.ast.newIdentifier("bar")), parameters));
        this.rewrite();
        this.checkResult("<?php B::bar(b,$c); ?>");
    }

    @Test
    public void arrayAccessWithoutIndex() throws Exception {
        String str = "<?php $a[]; ?>";
        this.initialize(str);
        List<ArrayAccess> arrayAccess = this.getAllOfType(this.program, ArrayAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).setName((VariableBase)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php $b[]; ?>");
    }

    @Test
    public void arrayAccess() throws Exception {
        String str = "<?php $a[$b]; ?>";
        this.initialize(str);
        List<ArrayAccess> arrayAccess = this.getAllOfType(this.program, ArrayAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).setIndex((Expression)this.ast.newScalar("1"));
        this.rewrite();
        this.checkResult("<?php $a[1]; ?>");
    }

    @Test
    public void arrayVariableMultiIndex() throws Exception {
        String str = "<?php $a[$b][5][3]; ?>";
        this.initialize(str);
        List<ArrayAccess> arrayAccess = this.getAllOfType(this.program, ArrayAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 3 ? 1 : 0) != 0);
        arrayAccess.get(0).setIndex((Expression)this.ast.newVariable("foo"));
        arrayAccess.get(2).setName((VariableBase)this.ast.newVariable("boo"));
        this.rewrite();
        this.checkResult("<?php $boo[$b][5][$foo]; ?>");
    }

    @Test
    public void arrayAccessType1() throws Exception {
        String str = "<?php $a[$b]; ?>";
        this.initialize(str);
        List<ArrayAccess> arrayAccess = this.getAllOfType(this.program, ArrayAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).setArrayType(2);
        this.rewrite();
        this.checkResult("<?php $a{$b}; ?>");
    }

    @Test
    public void arrayAccessType2() throws Exception {
        String str = "<?php $a{'name'}; ?>";
        this.initialize(str);
        List<ArrayAccess> arrayAccess = this.getAllOfType(this.program, ArrayAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        arrayAccess.get(0).setArrayType(1);
        arrayAccess.get(0).setIndex((Expression)this.ast.newScalar("333"));
        this.rewrite();
        this.checkResult("<?php $a[333]; ?>");
    }

    @Test
    public void listVariable1() throws Exception {
        String str = "<?php list($a,$b)=1; ?>";
        this.initialize(str);
        List<ListVariable> listVariables = this.getAllOfType(this.program, ListVariable.class);
        Assert.assertTrue((String)"Unexpected list size.", (listVariables.size() == 1 ? 1 : 0) != 0);
        listVariables.get(0).variables().add(this.ast.newVariable("c"));
        listVariables.get(0).variables().remove(0);
        this.rewrite();
        this.checkResult("<?php list($b,$c)=1; ?>");
    }

    @Test
    public void listVariable2() throws Exception {
        String str = "<?php list($a,$b)=1; ?>";
        this.initialize(str);
        List<ListVariable> listVariables = this.getAllOfType(this.program, ListVariable.class);
        Assert.assertTrue((String)"Unexpected list size.", (listVariables.size() == 1 ? 1 : 0) != 0);
        listVariables.get(0).variables().remove(1);
        this.rewrite();
        this.checkResult("<?php list($a)=1; ?>");
    }

    @Test
    public void nestedListVariable() throws Exception {
        String str = "<?php list($a, list($b,$c))=1;?>";
        this.initialize(str);
        List<ListVariable> listVariables = this.getAllOfType(this.program, ListVariable.class);
        Assert.assertTrue((String)"Unexpected list size.", (listVariables.size() == 2 ? 1 : 0) != 0);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        variables.add(this.ast.newVariable("foo"));
        variables.add(this.ast.newVariable("bar"));
        listVariables.get(1).variables().add(this.ast.newListVariable(variables));
        this.rewrite();
        this.checkResult("<?php list($a, list($b,$c,list($foo, $bar)))=1;?>");
    }

    @Test
    public void assignmentLeft() throws Exception {
        String str = "<?php $a = 1;?>";
        this.initialize(str);
        List<Assignment> assignments = this.getAllOfType(this.program, Assignment.class);
        Assert.assertTrue((String)"Unexpected list size.", (assignments.size() == 1 ? 1 : 0) != 0);
        assignments.get(0).setLeftHandSide((VariableBase)this.ast.newVariable("foo"));
        this.rewrite();
        this.checkResult("<?php $foo = 1;?>");
    }

    @Test
    public void assignmentRight() throws Exception {
        String str = "<?php $a = 1;?>";
        this.initialize(str);
        List<Assignment> assignments = this.getAllOfType(this.program, Assignment.class);
        Assert.assertTrue((String)"Unexpected list size.", (assignments.size() == 1 ? 1 : 0) != 0);
        assignments.get(0).setRightHandSide((Expression)this.ast.newScalar("12345"));
        this.rewrite();
        this.checkResult("<?php $a = 12345;?>");
    }

    @Test
    public void assignmentOperator() throws Exception {
        String str = "<?php $a = 1;?>";
        this.initialize(str);
        List<Assignment> assignments = this.getAllOfType(this.program, Assignment.class);
        Assert.assertTrue((String)"Unexpected list size.", (assignments.size() == 1 ? 1 : 0) != 0);
        assignments.get(0).setOperator(3);
        this.rewrite();
        this.checkResult("<?php $a *= 1;?>");
    }

    @Test
    public void reflectionSimple() throws Exception {
        String str = "<?php $$a;?>";
        this.initialize(str);
        List<ReflectionVariable> reflectionVariables = this.getAllOfType(this.program, ReflectionVariable.class);
        Assert.assertTrue((String)"Unexpected list size.", (reflectionVariables.size() == 1 ? 1 : 0) != 0);
        reflectionVariables.get(0).setName((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php $$b;?>");
    }

    @Test
    public void reflectionFunction() throws Exception {
        String str = "<?php $$$bar(); ?>";
        this.initialize(str);
        List<FunctionInvocation> functionInvocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (functionInvocations.size() == 1 ? 1 : 0) != 0);
        functionInvocations.get(0).setFunctionName(this.ast.newFunctionName((Expression)this.ast.newReflectionVariable((Expression)this.ast.newReflectionVariable((Expression)this.ast.newVariable("foo")))));
        this.rewrite();
        this.checkResult("<?php $$$foo(); ?>");
    }

    @Test
    public void reflectionComplex() throws Exception {
        String str = "<?php ${\"var\"};?>";
        this.initialize(str);
        List<ReflectionVariable> reflectionVariables = this.getAllOfType(this.program, ReflectionVariable.class);
        Assert.assertTrue((String)"Unexpected list size.", (reflectionVariables.size() == 1 ? 1 : 0) != 0);
        reflectionVariables.get(0).setName((Expression)this.ast.newScalar("\"boobo\"", 2));
        this.rewrite();
        this.checkResult("<?php ${\"boobo\"};?>");
    }

    @Test
    public void staticMemberSimple() throws Exception {
        String str = "<?php MyClass::$a;?>";
        this.initialize(str);
        List<StaticFieldAccess> fieldsAccess = this.getAllOfType(this.program, StaticFieldAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (fieldsAccess.size() == 1 ? 1 : 0) != 0);
        fieldsAccess.get(0).setField(this.ast.newVariable("boobo"));
        fieldsAccess.get(0).setClassName((Expression)this.ast.newIdentifier("Foo"));
        this.rewrite();
        this.checkResult("<?php Foo::$boobo;?>");
    }

    @Test
    public void staticMemberWithArray() throws Exception {
        String str = "<?php MyClass::$$a[5];?>";
        this.initialize(str);
        List<StaticFieldAccess> fieldsAccess = this.getAllOfType(this.program, StaticFieldAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (fieldsAccess.size() == 1 ? 1 : 0) != 0);
        fieldsAccess.get(0).setField((Variable)this.ast.newReflectionVariable((Expression)this.ast.newArrayAccess((VariableBase)this.ast.newVariable("bar"), (Expression)this.ast.newScalar("333"))));
        this.rewrite();
        this.checkResult("<?php MyClass::$$bar[333];?>");
    }

    @Test
    public void dispatchSimple() throws Exception {
        String str = "<?php $a->$b;?>";
        this.initialize(str);
        List<FieldAccess> fieldsAccess = this.getAllOfType(this.program, FieldAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (fieldsAccess.size() == 1 ? 1 : 0) != 0);
        fieldsAccess.get(0).setDispatcher((VariableBase)this.ast.newVariable("boo"));
        fieldsAccess.get(0).setField(this.ast.newVariable("foo"));
        this.rewrite();
        this.checkResult("<?php $boo->$foo;?>");
    }

    @Test
    public void dispatchNested() throws Exception {
        String str = "<?php $myClass->foo()->bar(); ?>";
        this.initialize(str);
        List<MethodInvocation> methodInvocations = this.getAllOfType(this.program, MethodInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (methodInvocations.size() == 2 ? 1 : 0) != 0);
        methodInvocations.get(1).getMethod().setFunctionName(this.ast.newFunctionName((Expression)this.ast.newScalar("boobo")));
        this.rewrite();
        this.checkResult("<?php $myClass->boobo()->bar(); ?>");
    }

    @Test
    public void dispatchWithStaticCall() throws Exception {
        String str = "<?php MyClass::$a->foo(); ?>";
        this.initialize(str);
        List<FunctionInvocation> functionInvocations = this.getAllOfType(this.program, FunctionInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (functionInvocations.size() == 1 ? 1 : 0) != 0);
        functionInvocations.get(0).getFunctionName().setName((Expression)this.ast.newScalar("bar"));
        List<MethodInvocation> methodInvocations = this.getAllOfType(this.program, MethodInvocation.class);
        Assert.assertTrue((String)"Unexpected list size.", (methodInvocations.size() == 1 ? 1 : 0) != 0);
        ((StaticFieldAccess)methodInvocations.get(0).getDispatcher()).getField().setName((Expression)this.ast.newScalar("boobo"));
        this.rewrite();
        this.checkResult("<?php MyClass::$boobo->bar(); ?>");
    }

    @Test
    public void testClone() throws Exception {
        String str = "<?php clone $a; ?>";
        this.initialize(str);
        List<CloneExpression> cloneExpressions = this.getAllOfType(this.program, CloneExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (cloneExpressions.size() == 1 ? 1 : 0) != 0);
        cloneExpressions.get(0).setExpression((Expression)this.ast.newVariable("bbb"));
        this.rewrite();
        this.checkResult("<?php clone $bbb; ?>");
    }

    @Test
    public void castOfVariable() throws Exception {
        String str = "<?php (int) $a; ?>";
        this.initialize(str);
        List<CastExpression> castExpressions = this.getAllOfType(this.program, CastExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (castExpressions.size() == 1 ? 1 : 0) != 0);
        castExpressions.get(0).setExpression((Expression)this.ast.newVariable("b"));
        castExpressions.get(0).setCastingType(2);
        this.rewrite();
        this.checkResult("<?php (string) $b; ?>");
    }

    @Test
    public void castOfDispatch() throws Exception {
        String str = "<?php (string) $b->foo(); ?>";
        this.initialize(str);
        List<CastExpression> castExpressions = this.getAllOfType(this.program, CastExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (castExpressions.size() == 1 ? 1 : 0) != 0);
        castExpressions.get(0).setCastingType(0);
        this.rewrite();
        this.checkResult("<?php (int) $b->foo(); ?>");
    }

    @Test
    public void classConstant() throws Exception {
        String str = "<?php $a = MyClass::MY_CONST; ?>";
        this.initialize(str);
        List<StaticConstantAccess> staticConstants = this.getAllOfType(this.program, StaticConstantAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (staticConstants.size() == 1 ? 1 : 0) != 0);
        ((Identifier)staticConstants.get(0).getClassName()).setName("Foo");
        staticConstants.get(0).setConstant(this.ast.newIdentifier("BAR_CONST"));
        this.rewrite();
        this.checkResult("<?php $a = Foo::BAR_CONST; ?>");
    }

    @Test
    public void postfixSimple() throws Exception {
        String str = "<?php $a++;?>";
        this.initialize(str);
        List<PostfixExpression> postfixExp = this.getAllOfType(this.program, PostfixExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (postfixExp.size() == 1 ? 1 : 0) != 0);
        postfixExp.get(0).setOperator(1);
        postfixExp.get(0).setVariable((VariableBase)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php $b--;?>");
    }

    @Test
    public void postfixWithFunction() throws Exception {
        String str = "<?php foo()--;?>";
        this.initialize(str);
        List<PostfixExpression> postfixExp = this.getAllOfType(this.program, PostfixExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (postfixExp.size() == 1 ? 1 : 0) != 0);
        postfixExp.get(0).setOperator(0);
        ((FunctionInvocation)postfixExp.get(0).getVariable()).setFunctionName(this.ast.newFunctionName((Expression)this.ast.newScalar("bar")));
        this.rewrite();
        this.checkResult("<?php bar()++;?>");
    }

    @Test
    public void prefixSimple() throws Exception {
        String str = "<?php ++$a;?>";
        this.initialize(str);
        List<PrefixExpression> prefixExp = this.getAllOfType(this.program, PrefixExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (prefixExp.size() == 1 ? 1 : 0) != 0);
        prefixExp.get(0).setOperator(1);
        this.rewrite();
        this.checkResult("<?php --$a;?>");
    }

    @Test
    public void unaryOperationSimple() throws Exception {
        String str = "<?php +$a;?>";
        this.initialize(str);
        List<UnaryOperation> ops = this.getAllOfType(this.program, UnaryOperation.class);
        Assert.assertTrue((String)"Unexpected list size.", (ops.size() == 1 ? 1 : 0) != 0);
        ops.get(0).setOperator(3);
        ops.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php ~$b;?>");
    }

    @Test
    public void unaryOperationWithFunction() throws Exception {
        String str = "<?php -foo(); ?>";
        this.initialize(str);
        List<UnaryOperation> ops = this.getAllOfType(this.program, UnaryOperation.class);
        Assert.assertTrue((String)"Unexpected list size.", (ops.size() == 1 ? 1 : 0) != 0);
        ops.get(0).setOperator(2);
        this.rewrite();
        this.checkResult("<?php !foo(); ?>");
    }

    @Test
    public void unaryOperationComplex() throws Exception {
        String str = "<?php +-+-$b;?>";
        this.initialize(str);
        List<UnaryOperation> ops = this.getAllOfType(this.program, UnaryOperation.class);
        Assert.assertTrue((String)"Unexpected list size.", (ops.size() == 4 ? 1 : 0) != 0);
        ops.get(2).setOperator(3);
        ops.get(0).setOperator(2);
        this.rewrite();
        this.checkResult("<?php !-~-$b;?>");
    }

    @Test
    public void classInstanciationSimple() throws Exception {
        String str = "<?php new MyClass(); ?>";
        this.initialize(str);
        List<ClassInstanceCreation> instanciations = this.getAllOfType(this.program, ClassInstanceCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanciations.size() == 1 ? 1 : 0) != 0);
        instanciations.get(0).getClassName().setClassName((Expression)this.ast.newScalar("Foo"));
        this.rewrite();
        this.checkResult("<?php new Foo(); ?>");
    }

    @Test
    public void classInstanciationAddParam() throws Exception {
        String str = "<?php new MyClass(); ?>";
        this.initialize(str);
        List<ClassInstanceCreation> instanciations = this.getAllOfType(this.program, ClassInstanceCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanciations.size() == 1 ? 1 : 0) != 0);
        instanciations.get(0).ctorParams().add(this.ast.newVariable("foo"));
        instanciations.get(0).ctorParams().add(this.ast.newVariable("bar"));
        this.rewrite();
        this.checkResult("<?php new MyClass($foo, $bar); ?>");
    }

    @Test
    public void classInstanciationVariable() throws Exception {
        String str = "<?php new $a('start'); ?>";
        this.initialize(str);
        List<ClassInstanceCreation> instanciations = this.getAllOfType(this.program, ClassInstanceCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanciations.size() == 1 ? 1 : 0) != 0);
        instanciations.get(0).ctorParams().add(this.ast.newScalar("'hello'"));
        instanciations.get(0).setClassName(this.ast.newClassName((Expression)this.ast.newVariable("b")));
        this.rewrite();
        this.checkResult("<?php new $b('start', 'hello'); ?>");
    }

    @Test
    public void classInstanciationVariableRemove() throws Exception {
        String str = "<?php new $a('start','end'); ?>";
        this.initialize(str);
        List<ClassInstanceCreation> instanciations = this.getAllOfType(this.program, ClassInstanceCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanciations.size() == 1 ? 1 : 0) != 0);
        instanciations.get(0).ctorParams().remove(1);
        this.rewrite();
        this.checkResult("<?php new $a('start'); ?>");
    }

    @Test
    public void classInstanciationFunction() throws Exception {
        String str = "<?php new $a->$b(1, $a); ?>";
        this.initialize(str);
        List<ClassInstanceCreation> instanciations = this.getAllOfType(this.program, ClassInstanceCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanciations.size() == 1 ? 1 : 0) != 0);
        instanciations.get(0).ctorParams().add(0, this.ast.newScalar("'Welcome'"));
        this.rewrite();
        this.checkResult("<?php new $a->$b('Welcome', 1, $a); ?>");
    }

    @Test
    public void refernceSimple() throws Exception {
        String str = "<?php $b = &$a;?>";
        this.initialize(str);
        List<Reference> references = this.getAllOfType(this.program, Reference.class);
        Assert.assertTrue((String)"Unexpected list size.", (references.size() == 1 ? 1 : 0) != 0);
        references.get(0).setExpression((Expression)this.ast.newVariable("foo"));
        this.rewrite();
        this.checkResult("<?php $b = &$foo;?>");
    }

    @Test
    public void refernceWithFunction() throws Exception {
        String str = "<?php $g = &$foo(); ?>";
        this.initialize(str);
        List<Reference> references = this.getAllOfType(this.program, Reference.class);
        Assert.assertTrue((String)"Unexpected list size.", (references.size() == 1 ? 1 : 0) != 0);
        references.get(0).setExpression((Expression)this.ast.newFunctionInvocation(this.ast.newFunctionName((Expression)this.ast.newVariable("bar")), null));
        this.rewrite();
        this.checkResult("<?php $g = &$bar(); ?>");
    }

    @Test
    public void referenceInstanciation() throws Exception {
        String str = "<?php $b = &new MyClass(); ?>";
        this.initialize(str);
        List<Reference> references = this.getAllOfType(this.program, Reference.class);
        Assert.assertTrue((String)"Unexpected list size.", (references.size() == 1 ? 1 : 0) != 0);
        ((ClassInstanceCreation)references.get(0).getExpression()).ctorParams().add(this.ast.newVariable("boobo"));
        this.rewrite();
        this.checkResult("<?php $b = &new MyClass($boobo); ?>");
    }

    @Test
    public void instanceofSimple() throws Exception {
        String str = "<?php $a instanceof MyClass;?>";
        this.initialize(str);
        List<InstanceOfExpression> instanceOf = this.getAllOfType(this.program, InstanceOfExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (instanceOf.size() == 1 ? 1 : 0) != 0);
        instanceOf.get(0).getClassName().setClassName((Expression)this.ast.newScalar("Foo", 2));
        instanceOf.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php $b instanceof Foo;?>");
    }

    @Test
    public void ignoreError() throws Exception {
        String str = "<?php @$a->foo(); ?>";
        this.initialize(str);
        List<IgnoreError> ignoreErrors = this.getAllOfType(this.program, IgnoreError.class);
        Assert.assertTrue((String)"Unexpected list size.", (ignoreErrors.size() == 1 ? 1 : 0) != 0);
        ignoreErrors.get(0).setExpression((Expression)this.ast.newFunctionInvocation(this.ast.newFunctionName((Expression)this.ast.newScalar("bar")), null));
        this.rewrite();
        this.checkResult("<?php @bar(); ?>");
    }

    @Test
    public void include() throws Exception {
        String str = "<?php include('myFile.php'); ?>";
        this.initialize(str);
        List<Include> includes = this.getAllOfType(this.program, Include.class);
        Assert.assertTrue((String)"Unexpected list size.", (includes.size() == 1 ? 1 : 0) != 0);
        includes.get(0).setExpression((Expression)this.ast.newScalar("'newFile.php'"));
        includes.get(0).setIncludetype(3);
        this.rewrite();
        this.checkResult("<?php include_once 'newFile.php'; ?>");
    }

    @Test
    public void includeWithParenthesis1() throws Exception {
        String str = "<?php include('myFile.php'); ?>";
        this.initialize(str);
        List<Include> includes = this.getAllOfType(this.program, Include.class);
        Assert.assertTrue((String)"Unexpected list size.", (includes.size() == 1 ? 1 : 0) != 0);
        includes.get(0).setExpression((Expression)this.ast.newParenthesisExpression((Expression)this.ast.newScalar("'newFile.php'")));
        includes.get(0).setIncludetype(0);
        this.rewrite();
        this.checkResult("<?php require('newFile.php'); ?>");
    }

    @Test
    public void includeWithParenthesis2() throws Exception {
        String str = "<?php include 'myFile.php'; ?>";
        this.initialize(str);
        List<Include> includes = this.getAllOfType(this.program, Include.class);
        Assert.assertTrue((String)"Unexpected list size.", (includes.size() == 1 ? 1 : 0) != 0);
        includes.get(0).setExpression((Expression)this.ast.newParenthesisExpression((Expression)this.ast.newScalar("'file.php'")));
        includes.get(0).setIncludetype(1);
        this.rewrite();
        this.checkResult("<?php require_once ('file.php'); ?>");
    }

    @Test
    public void includeOnce() throws Exception {
        String str = "<?php include_once($myFile); ?>";
        this.initialize(str);
        List<Include> includes = this.getAllOfType(this.program, Include.class);
        Assert.assertTrue((String)"Unexpected list size.", (includes.size() == 1 ? 1 : 0) != 0);
        includes.get(0).setIncludetype(2);
        this.rewrite();
        this.checkResult("<?php include($myFile); ?>");
    }

    @Test
    public void arrayCreation1() throws Exception {
        String str = "<?php array(1,2,3,); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.get(0).elements().size() == 4 ? 1 : 0) != 0);
        arrays.get(0).elements().add(3, this.ast.newArrayElement((Expression)this.ast.newScalar("'foo'"), (Expression)this.ast.newScalar("'boo'")));
        this.rewrite();
        this.checkResult("<?php array(1,2,3, 'foo'=>'boo',); ?>");
    }

    @Test
    public void arrayCreation2() throws Exception {
        String str = "<?php array(1,2,3,); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.get(0).elements().size() == 4 ? 1 : 0) != 0);
        arrays.get(0).elements().add(3, this.ast.newArrayElement(null, (Expression)this.ast.newScalar("4")));
        this.rewrite();
        this.checkResult("<?php array(1,2,3, 4,); ?>");
    }

    @Test
    public void arrayCreation3() throws Exception {
        String str = "<?php array(1,2,3,); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        arrays.get(0).elements().remove(1);
        this.rewrite();
        this.checkResult("<?php array(1,3,); ?>");
    }

    @Test
    public void functionDeclaration() throws Exception {
        String str = "<?php function foo() {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setFunctionName(this.ast.newIdentifier("bar"));
        declarations.get(0).formalParameters().add(this.ast.newFormalParameter(this.ast.newIdentifier("int"), (Expression)this.ast.newVariable("a"), null, false));
        this.rewrite();
        this.checkResult("<?php function bar(int $a) {} ?> ");
    }

    @Test
    public void functionDeclarationWithParam1() throws Exception {
        String str = "<?php function foo( $a) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(0)).setParameterType((Expression)this.ast.newIdentifier("string"));
        this.rewrite();
        this.checkResult("<?php function foo( string $a) {} ?> ");
    }

    @Test
    public void functionDeclarationWithParam2() throws Exception {
        String str = "<?php function foo($a, boolean $b) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(1)).setParameterType((Expression)this.ast.newIdentifier("string"));
        this.rewrite();
        this.checkResult("<?php function foo($a, string $b) {} ?> ");
    }

    @Test
    public void functionDeclarationWithParam3() throws Exception {
        String str = "<?php function foo($a, $b) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(1)).setParameterType((Expression)this.ast.newIdentifier("string"));
        this.rewrite();
        this.checkResult("<?php function foo($a, string $b) {} ?> ");
    }

    @Test
    public void functionDeclarationDeleteType() throws Exception {
        String str = "<?php function foo(boolean $a) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(0)).getParameterType().delete();
        this.rewrite();
        this.checkResult("<?php function foo( $a) {} ?> ");
    }

    @Test
    public void functionDeclarationCreationPHP5() throws Exception {
        String str = "<?php ?> ";
        this.initialize(str);
        Identifier name = this.ast.newIdentifier("foo");
        ArrayList<FormalParameter> formalParameters = new ArrayList<FormalParameter>();
        formalParameters.add(this.ast.newFormalParameter(this.ast.newIdentifier("int"), (Expression)this.ast.newVariable("a"), (Expression)this.ast.newScalar("5"), false));
        formalParameters.add(this.ast.newFormalParameter(null, (Expression)this.ast.newVariable("b"), (Expression)this.ast.newScalar("'boobo'"), false));
        Block body = this.ast.newBlock();
        this.program.statements().add(0, this.ast.newFunctionDeclaration(name, formalParameters, null, body, true));
        this.rewrite();
        this.checkResult("<?php function &foo(int $a = 5,  $b = 'boobo') {\n}\n?> ");
    }

    @Test
    public void functionDeclarationChangeDefault1() throws Exception {
        String str = "<?php function foo(boolean $a = false) {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Scalar)((FormalParameter)declarations.get(0).formalParameters().get(0)).getDefaultValue()).setStringValue("true");
        this.rewrite();
        this.checkResult("<?php function foo(boolean $a = true) {} ?> ");
    }

    @Test
    public void functionDeclarationDeleteDefault1() throws Exception {
        String str = "<?php function foo(string $a = 'foo') {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(0)).setDefaultValue(null);
        this.rewrite();
        this.checkResult("<?php function foo(string $a) {} ?> ");
    }

    @Test
    public void functionDeclarationDeleteDefault2() throws Exception {
        String str = "<?php function foo(string $a = 'foo') {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((FormalParameter)declarations.get(0).formalParameters().get(0)).getDefaultValue().delete();
        this.rewrite();
        this.checkResult("<?php function foo(string $a) {} ?> ");
    }

    @Test
    public void classDeclarationSimple() throws Exception {
        String str = "<?php class MyClass { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setName(this.ast.newIdentifier("Foo"));
        this.rewrite();
        this.checkResult("<?php class Foo { } ?> ");
    }

    @Test
    public void functionDeclarationRemoveReference() throws Exception {
        String str = "<?php function  &foo() {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setIsReference(false);
        this.rewrite();
        this.checkResult("<?php function foo() {} ?> ");
    }

    @Test
    public void functionDeclarationAddReference() throws Exception {
        String str = "<?php function  foo() {} ?> ";
        this.initialize(str);
        List<FunctionDeclaration> declarations = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setIsReference(true);
        this.rewrite();
        this.checkResult("<?php function &foo() {} ?> ");
    }

    @Test
    public void classDeclarationAddSuper() throws Exception {
        String str = "<?php class MyClass { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setModifier(4);
        declarations.get(0).setSuperClass((Expression)this.ast.newIdentifier("Boo"));
        this.rewrite();
        this.checkResult("<?php final class MyClass extends Boo { } ?> ");
    }

    @Test
    public void classDeclarationDeleteSuper() throws Exception {
        String str = "<?php class MyClass extends Foo { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).getSuperClass().delete();
        this.rewrite();
        this.checkResult("<?php class MyClass { } ?> ");
    }

    @Test
    public void classDeclarationDeleteSuperWithImplements() throws Exception {
        String str = "<?php class MyClass extends Foo implements Bar { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).getSuperClass().delete();
        this.rewrite();
        this.checkResult("<?php class MyClass implements Bar { } ?> ");
    }

    @Test
    public void classDeclarationReplaceSuper() throws Exception {
        String str = "<?php class MyClass extends Foo { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)declarations.get(0).getSuperClass()).setName("Bar");
        this.rewrite();
        this.checkResult("<?php class MyClass extends Bar { } ?> ");
    }

    @Test
    public void classDeclarationAddInterfaces() throws Exception {
        String str = "<?php class MyClass { } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().add(this.ast.newIdentifier("Foo"));
        declarations.get(0).interfaces().add(this.ast.newIdentifier("Bar"));
        this.rewrite();
        this.checkResult("<?php class MyClass implements Foo, Bar { } ?> ");
    }

    @Test
    public void classDeclarationRemoveInterface() throws Exception {
        String str = "<?php class MyClass extends AAA implements Foo,Bar{ } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().remove(0);
        this.rewrite();
        this.checkResult("<?php class MyClass extends AAA implements Bar{ } ?> ");
    }

    @Test
    public void classDeclarationRemoveAllInterfaces() throws Exception {
        String str = "<?php class MyClass extends AAA implements Foo,Bar{ } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().clear();
        this.rewrite();
        this.checkResult("<?php class MyClass extends AAA{ } ?> ");
    }

    @Test
    public void classDeclarationRenameInterface() throws Exception {
        String str = "<?php class MyClass extends AAA implements Foo,Bar{ } ?> ";
        this.initialize(str);
        List<ClassDeclaration> declarations = this.getAllOfType(this.program, ClassDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)declarations.get(0).interfaces().get(1)).setName("BooBo");
        this.rewrite();
        this.checkResult("<?php class MyClass extends AAA implements Foo,BooBo{ } ?> ");
    }

    @Test
    public void interfaceDeclarationSimple() throws Exception {
        String str = "<?php interface MyInterface { } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setName(this.ast.newIdentifier("Foo"));
        this.rewrite();
        this.checkResult("<?php interface Foo { } ?> ");
    }

    @Test
    public void interfaceDeclarationAddExtends() throws Exception {
        String str = "<?php interface MyInterface { const MY_CONSTANT = 3; public function myFunction($a); } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().add(this.ast.newIdentifier("Foo"));
        declarations.get(0).interfaces().add(this.ast.newIdentifier("Bar"));
        this.rewrite();
        this.checkResult("<?php interface MyInterface extends Foo, Bar { const MY_CONSTANT = 3; public function myFunction($a); } ?> ");
    }

    @Test
    public void interfaceDeclarationRemoveExtend() throws Exception {
        String str = "<?php interface MyInterface extends Foo, Bar{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().remove(1);
        this.rewrite();
        this.checkResult("<?php interface MyInterface extends Foo{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ");
    }

    @Test
    public void interfaceDeclarationRemoveAllExtends() throws Exception {
        String str = "<?php interface MyInterface extends Foo, Bar { const MY_CONSTANT = 3; public function myFunction($a); } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).interfaces().clear();
        this.rewrite();
        this.checkResult("<?php interface MyInterface { const MY_CONSTANT = 3; public function myFunction($a); } ?> ");
    }

    @Test
    public void interfaceDeclarationRenameExtend() throws Exception {
        String str = "<?php interface MyInterface extends Foo, Bar{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ";
        this.initialize(str);
        List<InterfaceDeclaration> declarations = this.getAllOfType(this.program, InterfaceDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        ((Identifier)declarations.get(0).interfaces().get(0)).setName("Boobo");
        this.rewrite();
        this.checkResult("<?php interface MyInterface extends Boobo, Bar{ const MY_CONSTANT = 3; public function myFunction($a); } ?> ");
    }

    @Test
    public void arrayKeyValueRemoveKey() throws Exception {
        String str = "<?php array('Dodo'=>'Golo','Dafna'=>'Dodidu'); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        ((ArrayElement)arrays.get(0).elements().get(1)).getKey().delete();
        this.rewrite();
        this.checkResult("<?php array('Dodo'=>'Golo','Dodidu'); ?>");
    }

    @Test
    public void arrayKeyValueAddKey() throws Exception {
        String str = "<?php array('Golo','Dafna'=>'Dodidu'); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        ((ArrayElement)arrays.get(0).elements().get(0)).setKey((Expression)this.ast.newScalar("'Dodo'"));
        this.rewrite();
        this.checkResult("<?php array('Dodo'=>'Golo','Dafna'=>'Dodidu'); ?>");
    }

    @Test
    public void arrayKeyValueChangeKey() throws Exception {
        String str = "<?php array('Golo','Dafna'=>'Dodidu'); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        ((Scalar)((ArrayElement)arrays.get(0).elements().get(1)).getKey()).setStringValue("'Boobo'");
        this.rewrite();
        this.checkResult("<?php array('Golo','Boobo'=>'Dodidu'); ?>");
    }

    @Test
    public void arrayKeyDelete() throws Exception {
        String str = "<?php array('Dudu'=>'Golo','Dafna'=>'Dodidu'); ?>";
        this.initialize(str);
        List<ArrayCreation> arrays = this.getAllOfType(this.program, ArrayCreation.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrays.size() == 1 ? 1 : 0) != 0);
        ((ArrayElement)arrays.get(0).elements().get(1)).delete();
        this.rewrite();
        this.checkResult("<?php array('Dudu'=>'Golo'); ?>");
    }

    @Test
    public void conditionalExpression() throws Exception {
        String str = "<?php (bool)$a ? 3 : 4;?>";
        this.initialize(str);
        List<ConditionalExpression> conditional = this.getAllOfType(this.program, ConditionalExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (conditional.size() == 1 ? 1 : 0) != 0);
        ((CastExpression)conditional.get(0).getCondition()).setExpression((Expression)this.ast.newVariable("b"));
        conditional.get(0).setIfFalse((Expression)this.ast.newScalar("100"));
        conditional.get(0).setIfTrue((Expression)this.ast.newScalar("200"));
        this.rewrite();
        this.checkResult("<?php (bool)$b ? 200 : 100;?>");
    }

    @Test
    public void infixExpression() throws Exception {
        String str = "<?php $a + 1;?>";
        this.initialize(str);
        List<InfixExpression> expressions = this.getAllOfType(this.program, InfixExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (expressions.size() == 1 ? 1 : 0) != 0);
        expressions.get(0).setOperator(21);
        expressions.get(0).setRight((Expression)this.ast.newFunctionInvocation(this.ast.newFunctionName((Expression)this.ast.newScalar("foo")), null));
        this.rewrite();
        this.checkResult("<?php $a % foo();?>");
    }

    @Test
    public void concatOperation() throws Exception {
        String str = "<?php 'string'.$c;?>";
        this.initialize(str);
        List<InfixExpression> expressions = this.getAllOfType(this.program, InfixExpression.class);
        Assert.assertTrue((String)"Unexpected list size.", (expressions.size() == 1 ? 1 : 0) != 0);
        expressions.get(0).setOperator(3);
        this.rewrite();
        this.checkResult("<?php 'string'!=$c;?>");
    }

    @Test
    public void quoteHeredoc() throws Exception {
        String str = "<?php \"this\nis $a quote\";?>";
        this.initialize(str);
        List<Quote> quotes = this.getAllOfType(this.program, Quote.class);
        Assert.assertTrue((String)"Unexpected list size.", (quotes.size() == 1 ? 1 : 0) != 0);
        quotes.get(0).setQuoteType(2);
        this.rewrite();
        this.checkResult("<?php <<<Heredoc\nthis\nis $a quote\nHeredoc;\n;?>");
    }

    @Test
    public void quoteSingle() throws Exception {
        String str = "<?php \"this is $a quote\";?>";
        this.initialize(str);
        List<Quote> quotes = this.getAllOfType(this.program, Quote.class);
        Assert.assertTrue((String)"Unexpected list size.", (quotes.size() == 1 ? 1 : 0) != 0);
        quotes.get(0).setQuoteType(1);
        this.rewrite();
        this.checkResult("<?php 'this is $a quote';?>");
    }

    @Test
    public void quoteDouble() throws Exception {
        String str = "<?php <<<Heredoc\r\nthis is $a quote\r\nHeredoc;\r\n?>";
        this.initialize(str);
        List<Quote> quotes = this.getAllOfType(this.program, Quote.class);
        Assert.assertTrue((String)"Unexpected list size.", (quotes.size() == 1 ? 1 : 0) != 0);
        quotes.get(0).setQuoteType(0);
        this.rewrite();
        this.checkResult("<?php \"this is $a quote\";\r\n?>");
    }

    @Test
    public void quoteWithCurly() throws Exception {
        String str = "<?php $text = <<<EOF\ntest{test}test\nEOF;\n?>";
        this.initialize(str);
        List<Quote> quotes = this.getAllOfType(this.program, Quote.class);
        Assert.assertTrue((String)"Unexpected list size.", (quotes.size() == 1 ? 1 : 0) != 0);
        quotes.get(0).setQuoteType(0);
        this.rewrite();
        this.checkResult("<?php $text = \"test{test}test\";\n?>");
    }

    @Test
    public void emptyHeredoc() throws Exception {
        String str = "<?php <<<Heredoc\nHeredoc;\n?>";
        this.initialize(str);
        List<Quote> quotes = this.getAllOfType(this.program, Quote.class);
        Assert.assertTrue((String)"Unexpected list size.", (quotes.size() == 1 ? 1 : 0) != 0);
        quotes.get(0).expressions().add(this.ast.newScalar("Hello World"));
        this.rewrite();
        this.checkResult("<?php <<<Heredoc\nHello World\nHeredoc;\n?>");
    }

    @Test
    public void breakStatementChange() throws Exception {
        String str = "<?php break $a;?>";
        this.initialize(str);
        List<BreakStatement> breaks = this.getAllOfType(this.program, BreakStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (breaks.size() == 1 ? 1 : 0) != 0);
        breaks.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php break $b;?>");
    }

    @Test
    public void breakStatementRemove() throws Exception {
        String str = "<?php break $a;?>";
        this.initialize(str);
        List<BreakStatement> breaks = this.getAllOfType(this.program, BreakStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (breaks.size() == 1 ? 1 : 0) != 0);
        breaks.get(0).getExpression().delete();
        this.rewrite();
        this.checkResult("<?php break;?>");
    }

    @Test
    public void breakStatementAdd() throws Exception {
        String str = "<?php break;?>";
        this.initialize(str);
        List<BreakStatement> breaks = this.getAllOfType(this.program, BreakStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (breaks.size() == 1 ? 1 : 0) != 0);
        breaks.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php break $b;?>");
    }

    @Test
    public void continueStatementAdd() throws Exception {
        String str = "<?php continue;?>";
        this.initialize(str);
        List<ContinueStatement> continueExp = this.getAllOfType(this.program, ContinueStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (continueExp.size() == 1 ? 1 : 0) != 0);
        continueExp.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php continue $b;?>");
    }

    @Test
    public void continueStatementRemove() throws Exception {
        String str = "<?php continue $a;?>";
        this.initialize(str);
        List<ContinueStatement> continueExp = this.getAllOfType(this.program, ContinueStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (continueExp.size() == 1 ? 1 : 0) != 0);
        continueExp.get(0).getExpression().delete();
        this.rewrite();
        this.checkResult("<?php continue;?>");
    }

    @Test
    public void continueStatementChange() throws Exception {
        String str = "<?php continue $a;?>";
        this.initialize(str);
        List<ContinueStatement> continueExp = this.getAllOfType(this.program, ContinueStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (continueExp.size() == 1 ? 1 : 0) != 0);
        continueExp.get(0).setExpression((Expression)this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php continue $b;?>");
    }

    @Test
    public void returnStatementAdd() throws Exception {
        String str = "<?php return; ?>";
        this.initialize(str);
        List<ReturnStatement> returnStatements = this.getAllOfType(this.program, ReturnStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (returnStatements.size() == 1 ? 1 : 0) != 0);
        returnStatements.get(0).setExpression((Expression)this.ast.newVariable("a"));
        this.rewrite();
        this.checkResult("<?php return $a; ?>");
    }

    @Test
    public void returnExprStatementChange() throws Exception {
        String str = "<?php return $a; ?>";
        this.initialize(str);
        List<ReturnStatement> returnStatements = this.getAllOfType(this.program, ReturnStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (returnStatements.size() == 1 ? 1 : 0) != 0);
        ((Variable)returnStatements.get(0).getExpression()).setName((Expression)this.ast.newScalar("b"));
        this.rewrite();
        this.checkResult("<?php return $b; ?>");
    }

    @Test
    public void returnExprStatementRemove() throws Exception {
        String str = "<?php return $c; ?>";
        this.initialize(str);
        List<ReturnStatement> returnStatements = this.getAllOfType(this.program, ReturnStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (returnStatements.size() == 1 ? 1 : 0) != 0);
        returnStatements.get(0).getExpression().delete();
        this.rewrite();
        this.checkResult("<?php return; ?>");
    }

    @Test
    public void echoStatement() throws Exception {
        String str = "<?php echo \"hello \",$b;?>";
        this.initialize(str);
        List<EchoStatement> list = this.getAllOfType(this.program, EchoStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (list.size() == 1 ? 1 : 0) != 0);
        list.get(0).expressions().set(0, this.ast.newScalar("\"replaced hello\""));
        list.get(0).expressions().add(this.ast.newScalar("'1111'"));
        this.rewrite();
        this.checkResult("<?php echo \"replaced hello\",$b, '1111';?>");
    }

    @Test
    public void newEchoStatement() throws Exception {
        String str = "<?php ?>";
        this.initialize(str);
        ArrayList<Object> expressions = new ArrayList<Object>(2);
        expressions.add(this.ast.newScalar("\"hello\""));
        expressions.add(this.ast.newVariable("b"));
        this.program.statements().add(0, this.ast.newEchoStatement(expressions));
        this.rewrite();
        this.checkResult("<?php echo \"hello\", $b;\n?>");
    }

    @Test
    public void switchStatementSetExpression() throws Exception {
        String str = "<?php switch ($i) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>";
        this.initialize(str);
        List<SwitchStatement> statements = this.getAllOfType(this.program, SwitchStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setExpression((Expression)this.ast.newVariable("a"));
        this.rewrite();
        this.checkResult("<?php switch ($a) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>");
    }

    @Test
    public void switchStatementChangeCaseAction() throws Exception {
        String str = "<?php switch ($i) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>";
        this.initialize(str);
        List<SwitchCase> switchCases = this.getAllOfType(this.program, SwitchCase.class);
        Assert.assertTrue((String)"Unexpected list size.", (switchCases.size() == 3 ? 1 : 0) != 0);
        switchCases.get(0).setValue((Expression)this.ast.newScalar("5"));
        switchCases.get(0).actions().set(0, this.ast.newEchoStatement((Expression)this.ast.newScalar("'i equals 5'")));
        this.rewrite();
        this.checkResult("<?php switch ($i) { case 5:    echo 'i equals 5';\n    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>");
    }

    @Test
    public void switchStatementCaseDeletion() throws Exception {
        String str = "<?php switch ($i) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>";
        this.initialize(str);
        List<SwitchCase> switchCases = this.getAllOfType(this.program, SwitchCase.class);
        Assert.assertTrue((String)"Unexpected list size.", (switchCases.size() == 3 ? 1 : 0) != 0);
        switchCases.get(0).delete();
        this.rewrite();
        this.checkResult("<?php switch ($i) { case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>");
    }

    @Test
    public void switchStatementChangeAddCase() throws Exception {
        String newLine = System.getProperty("line.separator");
        String str = "<?php " + newLine + "switch ($i) { " + newLine + "\tcase 0:" + newLine + "\t\techo 'i equals 0';" + newLine + "\t\tbreak;" + newLine + "\tcase 1:" + newLine + "\t\techo 'i equals 1';" + newLine + "\t\tbreak;" + newLine + "\tdefault:" + newLine + "\t\techo 'i not equals 0,1';" + newLine + "}  ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        Assert.assertTrue((String)"Unexpected list size.", (blocks.size() == 1 ? 1 : 0) != 0);
        ArrayList<Object> actions = new ArrayList<Object>(3);
        actions.add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'a new case'")));
        actions.add(this.ast.newExpressionStatement((Expression)this.ast.newFunctionInvocation(this.ast.newFunctionName((Expression)this.ast.newScalar("foo")), null)));
        actions.add(this.ast.newBreakStatement());
        blocks.get(0).statements().add(2, this.ast.newSwitchCase((Expression)this.ast.newScalar("2"), actions, false));
        this.rewrite();
        this.checkResult("<?php \nswitch ($i) { \n\tcase 0:\n\t\techo 'i equals 0';\n\t\tbreak;\n\tcase 1:\n\t\techo 'i equals 1';\n\t\tbreak;\n\tcase 2 :\n\t\techo 'a new case';\n\t\tfoo ();\n\t\tbreak;\n\n\tdefault:\n\t\techo 'i not equals 0,1';\n}  ?>");
    }

    @Test
    public void ifStatementCondition() throws Exception {
        String str = "<?php if ($a > $b) {   echo 'a is bigger than b';} elseif ($a == $b) {   echo 'a is equal to b';} else {   echo 'a is smaller than b';} ?>";
        this.initialize(str);
        List<IfStatement> statements = this.getAllOfType(this.program, IfStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 2 ? 1 : 0) != 0);
        statements.get(0).setCondition((Expression)this.ast.newInfixExpression((Expression)this.ast.newVariable("c"), 8, (Expression)this.ast.newVariable("d")));
        this.rewrite();
        this.checkResult("<?php if ($c || $d) {   echo 'a is bigger than b';} elseif ($a == $b) {   echo 'a is equal to b';} else {   echo 'a is smaller than b';} ?>");
    }

    @Test
    public void ifStatementCurlyToAlternative() throws Exception {
        String str = "<?php if ($a > $b) {\n\techo 'a > b';\n\t} else {\n\techo 'a <= b';\n} ?>";
        this.initialize(str);
        List<IfStatement> statements = this.getAllOfType(this.program, IfStatement.class);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        blocks.get(0).setIsCurly(false);
        blocks.get(1).setIsCurly(false);
        this.rewrite();
        this.checkResult("<?php if ($a > $b) :\n\techo 'a > b';\n\t else :\n\techo 'a <= b';\nendif; ?>");
    }

    @Test
    public void ifStatementAlternativeToCurly() throws Exception {
        String str = "<?php if ($a > $b) :\n\techo 'a > b';\n else :\n\techo 'a <= b';\nendif; ?>";
        this.initialize(str);
        List<IfStatement> statements = this.getAllOfType(this.program, IfStatement.class);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        blocks.get(0).setIsCurly(true);
        blocks.get(1).setIsCurly(true);
        this.rewrite();
        this.checkResult("<?php if ($a > $b) {\n\techo 'a > b';\n}\n else {\n\techo 'a <= b';\n}\n ?>");
    }

    @Test
    public void nestedIfStatementCurlyToAlternative1() throws Exception {
        String str = "<?php if ($a > $b) {\n\tif ($a == $b) {\n\techo 'a > b';\n\t}\n} else {\n\techo 'a <= b';\n} ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        for (Block block : blocks) {
            block.setIsCurly(false);
        }
        this.rewrite();
        this.checkResult("<?php if ($a > $b) :\n\tif ($a == $b) :\n\techo 'a > b';\n\tendif;\n else :\n\techo 'a <= b';\nendif; ?>");
    }

    @Test
    public void nestedIfStatementCurlyToAlternative2() throws Exception {
        String str = "<?php if ($a > $b) {\n\tif ($a == $b) {\n\techo 'a > b'; \n} elseif ($b == 1) {\n\techo 'boobo';\n} else {\n\techo 5;\n\t}\n} else {\n\techo 'a <= b';\n}\n?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        for (Block block : blocks) {
            block.setIsCurly(false);
        }
        this.rewrite();
        this.checkResult("<?php if ($a > $b) :\n\tif ($a == $b) :\n\techo 'a > b'; \n elseif ($b == 1) :\n\techo 'boobo';\n else :\n\techo 5;\n\tendif;\n else :\n\techo 'a <= b';\nendif;\n?>");
    }

    @Test
    public void whileStatementCurlyToAlternative() throws Exception {
        String str = "<?php while ($i <= 10){\n echo $i++;\n}\n?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(false);
        this.rewrite();
        this.checkResult("<?php while ($i <= 10):\n echo $i++;\nendwhile;\n?>");
    }

    @Test
    public void whileStatementAlternativeToCurly() throws Exception {
        String str = "<?php while ($i <= 10):  echo $i;   $i++; endwhile; ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(true);
        this.rewrite();
        this.checkResult("<?php while ($i <= 10){  echo $i;   $i++;\n}  ?>");
    }

    @Test
    public void forStatementCurlyToAlternative() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) {  echo $i; } ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(false);
        this.rewrite();
        this.checkResult("<?php for ($i = 1; $i <= 10; $i++) :  echo $i; endfor; ?>");
    }

    @Test
    public void forStatementAlternativeToCurly() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) :  echo $i; endfor; ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(true);
        this.rewrite();
        this.checkResult("<?php for ($i = 1; $i <= 10; $i++) {  echo $i;\n}  ?>");
    }

    @Test
    public void forEachStatementCurlyToAlternative() throws Exception {
        String str = "<?php foreach ($arr as &$value) { $value = $value * 2; } ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(false);
        this.rewrite();
        this.checkResult("<?php foreach ($arr as &$value) : $value = $value * 2; endforeach; ?>");
    }

    @Test
    public void forEachStatementAlternativeToCurly() throws Exception {
        String str = "<?php foreach ($arr as &$value) : $value = $value * 2; endforeach; ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(true);
        this.rewrite();
        this.checkResult("<?php foreach ($arr as &$value) { $value = $value * 2;\n}  ?>");
    }

    @Test
    public void switchStatementCurlyToAlternative() throws Exception {
        String str = "<?php switch ($i) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  }  ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(false);
        this.rewrite();
        this.checkResult("<?php switch ($i) : case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  endswitch;  ?>");
    }

    @Test
    public void switchStatementAlternativeToCurly() throws Exception {
        String str = "<?php switch ($i) : case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  endswitch;  ?>";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        blocks.get(0).setIsCurly(true);
        this.rewrite();
        this.checkResult("<?php switch ($i) { case 0:    echo 'i equals 0';    break; case 1:     echo 'i equals 1';     break; default:    echo 'i not equals 0,1';  \n}  ?>");
    }

    @Test
    public void whileStatement() throws Exception {
        String str = "<?php while ($i <= 10) echo $i++; ?>";
        this.initialize(str);
        List<WhileStatement> statements = this.getAllOfType(this.program, WhileStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setCondition((Expression)this.ast.newInfixExpression((Expression)this.ast.newVariable("a"), 8, (Expression)this.ast.newVariable("b")));
        statements.get(0).setBody((Statement)this.ast.newEchoStatement((Expression)this.ast.newScalar("'Hello!!'")));
        this.rewrite();
        this.checkResult("<?php while ($a || $b)echo 'Hello!!';\n ?>");
    }

    @Test
    public void doWhileStatement() throws Exception {
        String str = "<?php do { echo $i;} while ($i > 0); ?>";
        this.initialize(str);
        List<DoStatement> statements = this.getAllOfType(this.program, DoStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setCondition((Expression)this.ast.newInfixExpression((Expression)this.ast.newVariable("a"), 3, (Expression)this.ast.newVariable("b")));
        ArrayList<EchoStatement> newStatements = new ArrayList<EchoStatement>(2);
        newStatements.add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'Hello!!'")));
        newStatements.add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'Goodbye!!'")));
        statements.get(0).setBody((Statement)this.ast.newBlock(newStatements));
        this.rewrite();
        this.checkResult("<?php do {\n\techo 'Hello!!';\n\techo 'Goodbye!!';\n}\nwhile ($a != $b); ?>");
    }

    @Test
    public void curlyBlockCreation() throws Exception {
        String str = "<?php ?>";
        this.initialize(str);
        ArrayList<EchoStatement> trueStatement = new ArrayList<EchoStatement>(1);
        trueStatement.add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'Boobo'")));
        Block block = this.ast.newBlock(trueStatement);
        block.setIsCurly(true);
        this.program.statements().add(0, this.ast.newIfStatement((Expression)this.ast.newVariable("a"), (Statement)block, null));
        this.rewrite();
        this.checkResult("<?php if ($a) {\n\techo 'Boobo';\n}\n?>");
    }

    @Test
    public void alternativeBlockCreation() throws Exception {
        String str = "<?php ?>";
        this.initialize(str);
        ArrayList<EchoStatement> trueStatement = new ArrayList<EchoStatement>(1);
        trueStatement.add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'Boobo'")));
        Block block = this.ast.newBlock(trueStatement);
        block.setIsCurly(false);
        this.program.statements().add(0, this.ast.newIfStatement((Expression)this.ast.newVariable("a"), (Statement)block, null));
        this.rewrite();
        this.checkResult("<?php if ($a) :\n\techo 'Boobo';\n\nendif;\n?>");
    }

    @Test
    public void forStatement() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) {  echo $i; } ?>";
        this.initialize(str);
        List<ForStatement> statements = this.getAllOfType(this.program, ForStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).initializers().add(this.ast.newAssignment((VariableBase)this.ast.newVariable("j"), 0, (Expression)this.ast.newScalar("5")));
        statements.get(0).conditions().add(this.ast.newInfixExpression((Expression)this.ast.newVariable("j"), 6, (Expression)this.ast.newScalar("20")));
        statements.get(0).updaters().add(this.ast.newPrefixExpression((VariableBase)this.ast.newVariable("j"), 0));
        this.rewrite();
        this.checkResult("<?php for ($i = 1, $j=5; $i <= 10, $j > 20; $i++, $j++) {  echo $i; } ?>");
    }

    @Test
    public void forStatementRemoveInitialization() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) {  echo $i; } ?>";
        this.initialize(str);
        List<ForStatement> statements = this.getAllOfType(this.program, ForStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        ((Expression)statements.get(0).initializers().get(0)).delete();
        this.rewrite();
        this.checkResult("<?php for (; $i <= 10; $i++) {  echo $i; } ?>");
    }

    @Test
    public void forStatementRemoveCondition() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) {  echo $i; } ?>";
        this.initialize(str);
        List<ForStatement> statements = this.getAllOfType(this.program, ForStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).conditions().clear();
        this.rewrite();
        this.checkResult("<?php for ($i = 1;; $i++) {  echo $i; } ?>");
    }

    @Test
    public void forStatementRemoveUpdaters() throws Exception {
        String str = "<?php for ($i = 1; $i <= 10; $i++) {  echo $i; } ?>";
        this.initialize(str);
        List<ForStatement> statements = this.getAllOfType(this.program, ForStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        ((Expression)statements.get(0).updaters().get(0)).delete();
        this.rewrite();
        this.checkResult("<?php for ($i = 1; $i <= 10;) {  echo $i; } ?>");
    }

    @Test
    public void forEachStatementAddKey() throws Exception {
        String str = "<?php foreach ($arr as &$value) { $value = $value * 2; } ?>";
        this.initialize(str);
        List<ForEachStatement> statements = this.getAllOfType(this.program, ForEachStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setExpression((Expression)this.ast.newVariable("foo"));
        statements.get(0).setKey((Expression)this.ast.newVariable("bar"));
        this.rewrite();
        this.checkResult("<?php foreach ($foo as $bar=>&$value) { $value = $value * 2; } ?>");
    }

    @Test
    public void forEachStatementChangeKeyAndValue() throws Exception {
        String str = "<?php foreach ($arr as $foo=>&$value) { $value = $value * 2; } ?>";
        this.initialize(str);
        List<ForEachStatement> statements = this.getAllOfType(this.program, ForEachStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setKey((Expression)this.ast.newVariable("bar"));
        Reference ref = this.ast.newReference((Expression)this.ast.newVariable("val"));
        statements.get(0).setValue((Expression)ref);
        this.rewrite();
        this.checkResult("<?php foreach ($arr as $bar=>&$val) { $value = $value * 2; } ?>");
    }

    @Test
    public void forEachStatementRemoveKey() throws Exception {
        String str = "<?php foreach ($foo as $bar=>&$value) { $value = $value * 2; } ?>";
        this.initialize(str);
        List<ForEachStatement> statements = this.getAllOfType(this.program, ForEachStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).getKey().delete();
        this.rewrite();
        this.checkResult("<?php foreach ($foo as &$value) { $value = $value * 2; } ?>");
    }

    @Test
    public void tryCatchStatement() throws Exception {
        String str = "<?php try { $error = 'Always throw this error'; } catch (Exception $e) { echo ''; }  ?>";
        this.initialize(str);
        List<TryStatement> statements = this.getAllOfType(this.program, TryStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        Block newBlock = this.ast.newBlock();
        newBlock.statements().add(this.ast.newEchoStatement((Expression)this.ast.newScalar("'Hello'")));
        statements.get(0).catchClauses().add(this.ast.newCatchClause(this.ast.newIdentifier("Boobo"), this.ast.newVariable("b"), newBlock));
        this.rewrite();
        this.checkResult("<?php try { $error = 'Always throw this error'; } catch (Exception $e) { echo ''; }catch (Boobo $b) {\necho 'Hello';\n}\n  ?>");
    }

    @Test
    public void tryMultiCatchStatement() throws Exception {
        String str = "<?php try { $error = 'Always throw this error'; } catch (Exception $e) { echo ''; } catch (AnotherException $ea) { echo ''; }  ?>";
        this.initialize(str);
        List<TryStatement> statements = this.getAllOfType(this.program, TryStatement.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        ((CatchClause)statements.get(0).catchClauses().get(1)).delete();
        this.rewrite();
        this.checkResult("<?php try { $error = 'Always throw this error'; } catch (Exception $e) { echo ''; }  ?>");
    }

    @Test
    public void globalStatementSimple() throws Exception {
        String str = "<?php global $a; ?>";
        this.initialize(str);
        List<GlobalStatement> statements = this.getAllOfType(this.program, GlobalStatement.class);
        statements.get(0).variables().add(this.ast.newVariable("b"));
        this.rewrite();
        this.checkResult("<?php global $a, $b; ?>");
    }

    @Test
    public void globalStatementReflection() throws Exception {
        String str = "<?php global $$a; ?>";
        this.initialize(str);
        List<GlobalStatement> statements = this.getAllOfType(this.program, GlobalStatement.class);
        statements.get(0).variables().add(this.ast.newReflectionVariable((Expression)this.ast.newVariable("b")));
        this.rewrite();
        this.checkResult("<?php global $$a, $$b; ?>");
    }

    @Test
    public void staticSimple() throws Exception {
        String str = "<?php static $a;?>";
        this.initialize(str);
        List<StaticStatement> statements = this.getAllOfType(this.program, StaticStatement.class);
        statements.get(0).expressions().add(this.ast.newAssignment((VariableBase)this.ast.newVariable("b"), 0, (Expression)this.ast.newScalar("8")));
        this.rewrite();
        this.checkResult("<?php static $a, $b=8;?>");
    }

    @Test
    public void inLineHtml() throws Exception {
        String str = "<html> </html>";
        this.initialize(str);
        List<InLineHtml> inline = this.getAllOfType(this.program, InLineHtml.class);
        Assert.assertTrue((String)"Unexpected list size.", (inline.size() == 1 ? 1 : 0) != 0);
        this.rewrite();
        this.checkResult("<html> </html>");
    }

    @Test
    public void fieldDeclaration() throws Exception {
        String str = "<?php class A { public $a = 3; final private static $var; }?>";
        this.initialize(str);
        List<FieldsDeclaration> declarations = this.getAllOfType(this.program, FieldsDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 2 ? 1 : 0) != 0);
        declarations.get(0).fields().add(this.ast.newSingleFieldDeclaration(this.ast.newVariable("b"), (Expression)this.ast.newScalar("4")));
        ((SingleFieldDeclaration)declarations.get(0).fields().get(0)).getValue().delete();
        declarations.get(1).setModifier(36);
        this.rewrite();
        this.checkResult("<?php class A { public $a, $b = 4; protected final $var; }?>");
    }

    @Test
    public void methodDeclaration() throws Exception {
        String str = "<?php class A { public function foo(int $a){} }?> ";
        this.initialize(str);
        List<MethodDeclaration> declarations = this.getAllOfType(this.program, MethodDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (declarations.size() == 1 ? 1 : 0) != 0);
        declarations.get(0).setModifier(33);
        declarations.get(0).getFunction().setFunctionName(this.ast.newIdentifier("bar"));
        this.rewrite();
        this.checkResult("<?php class A { protected abstract function bar(int $a){} }?> ");
    }

    @Test
    public void comment() throws Exception {
        String str = "<?php\n class A { \n\tpublic function foo(int $a){}\n }?> ";
        this.initialize(str);
        List<Block> blocks = this.getAllOfType(this.program, Block.class);
        Assert.assertTrue((String)"Unexpected list size.", (blocks.size() == 2 ? 1 : 0) != 0);
        AST astRoot = this.program.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot);
        Block block = blocks.get(0);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
        ASTNode placeHolder = rewrite.createStringPlaceholder("//mycomment", 16);
        listRewrite.insertFirst(placeHolder, null);
        TextEdit textEdits = rewrite.rewriteAST(this.document, null);
        textEdits.apply(this.document);
        this.checkResult("<?php\n class A { \n\t//mycomment\n\tpublic function foo(int $a){}\n }?> ");
    }

    @Test
    public void exception() throws Exception {
        String str = "<?php\n function A() { throw new Exception(); }";
        this.initialize(str);
        List<ThrowStatement> allthrows = this.getAllOfType(this.program, ThrowStatement.class);
        ASTRewrite rewrite = ASTRewrite.create((AST)this.program.getAST());
        rewrite.replace((ASTNode)allthrows.get(0), rewrite.createGroupNode(new ASTNode[]{(ASTNode)allthrows.get(0), this.program.getAST().newBreakStatement()}), null);
        rewrite.rewriteAST(this.document, null).apply(this.document);
        this.checkResult("<?php\n function A() { throw new Exception(); break; }");
    }

    private void initialize(String content, PHPVersion phpVersion) throws Exception {
        this.document = new Document(content);
        ASTParser parser = ASTParser.newParser((PHPVersion)phpVersion, (boolean)ProjectOptions.isSupportingASPTags(null), (boolean)ProjectOptions.useShortTags(null));
        parser.setSource(this.document.get().toCharArray());
        this.program = parser.createAST((IProgressMonitor)new NullProgressMonitor());
        this.ast = this.program.getAST();
        this.program.recordModifications();
    }

    protected final void initialize(String content) throws Exception {
        this.initialize(content, this.getPHPVersion());
    }

    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP5;
    }

    protected final void rewrite() throws Exception {
        TextEdit edits = this.program.rewrite(this.document, null);
        edits.apply(this.document);
    }

    protected final void checkResult(String expected) {
        String actual = this.document.get();
        String diff = TestUtils.compareContentsIgnoreWhitespace(expected, actual);
        if (diff != null) {
            Assert.fail((String)diff);
        }
    }

    public <T extends ASTNode> List<T> getAllOfType(Program program, final String className) {
        final ArrayList list = new ArrayList();
        program.accept((Visitor)new ApplyAll(){

            protected boolean apply(ASTNode node) {
                if (node.getClass().getName().equals(className)) {
                    list.add(node);
                }
                return true;
            }
        });
        return list;
    }

    public <T extends ASTNode> List<T> getAllOfType(Program program, final Class<T> nodeClass) {
        final ArrayList list = new ArrayList();
        program.accept((Visitor)new ApplyAll(){

            protected boolean apply(ASTNode node) {
                if (node.getClass() == nodeClass) {
                    list.add(node);
                }
                return true;
            }
        });
        return list;
    }

    @RunWith(value=org.junit.runners.Suite.class)
    @Suite.SuiteClasses(value={ASTRewriteTests.class, ASTRewriteTestsPHP54.Suite.class, ASTRewriteTestsPHP55.Suite.class, ASTRewriteTestsPHP56.Suite.class, ASTRewriteTestsPHP7.Suite.class, ASTRewriteTestsPHP71.Suite.class})
    public static class Suite {
    }
}

