/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.cdt.dsf.debug.service.IExpressions3;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.GDBTypeParser;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExpressions;
import org.eclipse.cdt.dsf.mi.service.MIStack;
import org.eclipse.cdt.dsf.mi.service.MIVariableManager;
import org.eclipse.cdt.dsf.mi.service.Messages;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetAttributes;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetChildCount;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetChildren;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetValue;
import org.eclipse.cdt.dsf.mi.service.command.commands.ExprMetaGetVar;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetAttributesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetChildCountInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetChildrenInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetValueInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.ExprMetaGetVarInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class MIExpressions
extends AbstractDsfService
implements IMIExpressions,
ICachingService {
    private static final int PARTITION_LENGTH = 100;
    public static final String DETAILS_FORMAT = "Details";
    private static final String[] FORMATS_SUPPORTED = new String[]{"Details", "NATURAL.Format", "DECIMAL.Format", "HEX.Format", "BINARY.Format", "OCTAL.Format"};
    protected CommandCache fExpressionCache;
    private CommandFactory fCommandFactory;
    private MIVariableManager varManager;
    private boolean fTraceVisualization;

    public MIExpressions(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                MIExpressions.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.getSession().addServiceEventListener((Object)this, null);
        if (this.getServicesTracker().getService(IExpressions.class) == null) {
            this.register(new String[]{IExpressions.class.getName(), IExpressions2.class.getName(), IExpressions3.class.getName(), IMIExpressions.class.getName(), MIExpressions.class.getName()}, new Hashtable());
        }
        this.varManager = this.createMIVariableManager();
        this.fExpressionCache = new CommandCache(this.getSession(), (ICommandControl)this.varManager);
        ICommandControlService commandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.fExpressionCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        requestMonitor.done();
    }

    protected MIVariableManager createMIVariableManager() {
        return new MIVariableManager(this.getSession(), this.getServicesTracker());
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.varManager.dispose();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public IExpressions.IExpressionDMContext createExpression(IDMContext ctx, String expression) {
        return this.createExpression(ctx, expression, expression);
    }

    public IExpressions.IExpressionDMContext createExpression(IDMContext ctx, String expression, String relExpr) {
        return this.createExpression(ctx, new ExpressionInfo(expression, relExpr));
    }

    private IExpressions.IExpressionDMContext createExpression(IDMContext ctx, ExpressionInfo info) {
        String expression = info.getFullExpr();
        IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IStack.IFrameDMContext.class);
        if (frameDmc != null) {
            return new MIExpressionDMC(this.getSession().getId(), info, frameDmc);
        }
        IMIExecutionDMContext execCtx = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMIExecutionDMContext.class);
        if (execCtx != null) {
            MIStack stackService = (MIStack)((Object)this.getServicesTracker().getService(MIStack.class));
            if (stackService != null) {
                frameDmc = stackService.createFrameDMContext(execCtx, 0);
                return new MIExpressionDMC(this.getSession().getId(), info, frameDmc);
            }
            return new InvalidContextExpressionDMC(this.getSession().getId(), expression, (IDMContext)execCtx);
        }
        IMemory.IMemoryDMContext memoryCtx = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMemory.IMemoryDMContext.class);
        if (memoryCtx != null) {
            return new MIExpressionDMC(this.getSession().getId(), info, (IDMContext)memoryCtx);
        }
        return new InvalidContextExpressionDMC(this.getSession().getId(), expression, ctx);
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValueContext(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
        return new IFormattedValues.FormattedValueDMContext((IDsfService)this, (IDMContext)dmc, formatId);
    }

    public void getAvailableFormats(IFormattedValues.IFormattedDataDMContext dmc, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)FORMATS_SUPPORTED);
        rm.done();
    }

    public void getExpressionData(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions.IExpressionDMData> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetVar(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetVarInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    IExpressions.IExpressionDMData.BasicType basicType = null;
                    GDBTypeParser.GDBType gdbType = ((ExprMetaGetVarInfo)this.getData()).getGDBType();
                    if (gdbType != null) {
                        switch (gdbType.getType()) {
                            case 3: {
                                basicType = IExpressions.IExpressionDMData.BasicType.array;
                                break;
                            }
                            case 4: {
                                basicType = IExpressions.IExpressionDMData.BasicType.function;
                                break;
                            }
                            case 1: 
                            case 2: {
                                basicType = IExpressions.IExpressionDMData.BasicType.pointer;
                                break;
                            }
                            default: {
                                basicType = ((ExprMetaGetVarInfo)this.getData()).hasChildren() || ((ExprMetaGetVarInfo)this.getData()).getCollectionHint() ? IExpressions.IExpressionDMData.BasicType.composite : IExpressions.IExpressionDMData.BasicType.basic;
                            }
                        }
                    }
                    rm.setData((Object)new ExpressionDMData(((ExprMetaGetVarInfo)this.getData()).getExpr(), ((ExprMetaGetVarInfo)this.getData()).getType(), ((ExprMetaGetVarInfo)this.getData()).getNumChildren(), ((ExprMetaGetVarInfo)this.getData()).getEditable(), basicType));
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void getExpressionAddressData(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions.IExpressionDMAddress> rm) {
        MIExpressionDMC miDMC;
        if (dmc instanceof MIExpressionDMC && ((miDMC = (MIExpressionDMC)dmc).getExpressionInfo().hasDynamicAncestor() || !miDMC.getExpressionInfo().inMemory())) {
            rm.setData((Object)new InvalidDMAddress());
            rm.done();
            return;
        }
        IExpressions.IExpressionDMContext addressDmc = this.createExpression((IDMContext)dmc, "&(" + dmc.getExpression() + ")");
        final IExpressions.IExpressionDMContext sizeDmc = this.createExpression((IDMContext)dmc, "sizeof(" + dmc.getExpression() + ")");
        if (addressDmc instanceof InvalidContextExpressionDMC || sizeDmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            this.fExpressionCache.execute(this.fCommandFactory.createMIDataEvaluateExpression(addressDmc), (DataRequestMonitor)new DataRequestMonitor<MIDataEvaluateExpressionInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    String tmpAddrStr = ((MIDataEvaluateExpressionInfo)this.getData()).getValue();
                    int split = tmpAddrStr.indexOf(32);
                    if (split != -1) {
                        tmpAddrStr = tmpAddrStr.substring(0, split);
                    }
                    final String addrStr = tmpAddrStr;
                    MIExpressions.this.fExpressionCache.execute(MIExpressions.this.fCommandFactory.createMIDataEvaluateExpression(sizeDmc), (DataRequestMonitor)new DataRequestMonitor<MIDataEvaluateExpressionInfo>((Executor)MIExpressions.this.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            try {
                                int size = Integer.parseInt(((MIDataEvaluateExpressionInfo)this.getData()).getValue());
                                rm.setData((Object)new ExpressionDMAddress(addrStr, size));
                            }
                            catch (NumberFormatException numberFormatException) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Unexpected size format from backend: " + ((MIDataEvaluateExpressionInfo)this.getData()).getValue(), null));
                            }
                            rm.done();
                        }
                    });
                }
            });
        }
    }

    public void getFormattedExpressionValue(IFormattedValues.FormattedValueDMContext dmc, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        MIExpressionDMC exprDmc = (MIExpressionDMC)DMContexts.getAncestorOfType((IDMContext)dmc, MIExpressionDMC.class);
        if (exprDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else if (DETAILS_FORMAT.equals(dmc.getFormatID())) {
            if (exprDmc.getExpressionInfo().hasDynamicAncestor()) {
                rm.setData((Object)new IFormattedValues.FormattedValueDMData(Messages.MIExpressions_NotAvailableBecauseChildOfDynamicVarobj));
                rm.done();
            } else {
                this.fExpressionCache.execute(this.fCommandFactory.createMIDataEvaluateExpression(exprDmc), (DataRequestMonitor)new DataRequestMonitor<MIDataEvaluateExpressionInfo>((Executor)this.getExecutor(), rm){

                    protected void handleSuccess() {
                        rm.setData((Object)new IFormattedValues.FormattedValueDMData(((MIDataEvaluateExpressionInfo)this.getData()).getValue()));
                        rm.done();
                    }

                    protected void handleError() {
                        if (MIExpressions.this.fTraceVisualization) {
                            rm.setData((Object)new IFormattedValues.FormattedValueDMData(""));
                            rm.done();
                        } else {
                            super.handleError();
                        }
                    }
                });
            }
        } else {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetValue(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetValueInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)new IFormattedValues.FormattedValueDMData(((ExprMetaGetValueInfo)this.getData()).getValue()));
                    rm.done();
                }
            });
        }
    }

    public void getBaseExpressions(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void getSubExpressions(IExpressions.IExpressionDMContext dmc, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        this.getSubExpressions(dmc, -1, -1, rm);
    }

    public void getSubExpressions(final IExpressions.IExpressionDMContext exprCtx, final int startIndex, final int length, final DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        if (exprCtx instanceof IndexedPartitionDMC) {
            this.getIndexedPartitionChildren((IndexedPartitionDMC)exprCtx, startIndex, length, rm);
        } else if (exprCtx instanceof MIExpressionDMC) {
            this.getRealSubExpressionCount(exprCtx, -1, new DataRequestMonitor<Integer>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    final int realNumChildren = (Integer)this.getData();
                    if (realNumChildren == 0) {
                        rm.setData((Object)new IExpressions.IExpressionDMContext[0]);
                        rm.done();
                        return;
                    }
                    if (realNumChildren <= MIExpressions.this.getArrayPartitionLength()) {
                        MIExpressions.this.getRealSubExpressions(exprCtx, startIndex, length, (DataRequestMonitor<IExpressions.IExpressionDMContext[]>)rm);
                    } else {
                        MIExpressions.this.getExpressionData(exprCtx, new DataRequestMonitor<IExpressions.IExpressionDMData>(ImmediateExecutor.getInstance(), (RequestMonitor)rm){

                            protected void handleSuccess() {
                                if (IExpressions.IExpressionDMData.BasicType.array.equals((Object)((IExpressions.IExpressionDMData)this.getData()).getBasicType())) {
                                    rm.setData((Object)MIExpressions.this.getTopLevelIndexedPartitions((MIExpressionDMC)exprCtx, realNumChildren, startIndex, length));
                                    rm.done();
                                } else {
                                    MIExpressions.this.getRealSubExpressions(exprCtx, startIndex, length, (DataRequestMonitor<IExpressions.IExpressionDMContext[]>)rm);
                                }
                            }
                        });
                    }
                }
            });
        } else if (exprCtx instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    @Override
    public void safeToAskForAllSubExpressions(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<Boolean> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetVar(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetVarInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    boolean safe = ((ExprMetaGetVarInfo)this.getData()).isSafeToAskForAllChildren();
                    rm.setData((Object)safe);
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    @Override
    public void getSubExpressionCount(final IExpressions.IExpressionDMContext dmc, int numChildLimit, final DataRequestMonitor<Integer> rm) {
        if (dmc instanceof MIExpressionDMC) {
            if (dmc instanceof IndexedPartitionDMC) {
                int length = ((IndexedPartitionDMC)dmc).getLength();
                rm.setData((Object)this.computeNumberOfChildren(length));
                rm.done();
            } else {
                this.getRealSubExpressionCount(dmc, numChildLimit, new DataRequestMonitor<Integer>((Executor)this.getExecutor(), rm){

                    protected void handleSuccess() {
                        final int realNum = (Integer)this.getData();
                        if (realNum <= MIExpressions.this.getArrayPartitionLength()) {
                            rm.setData((Object)realNum);
                            rm.done();
                        } else {
                            MIExpressions.this.getExpressionData(dmc, new DataRequestMonitor<IExpressions.IExpressionDMData>(ImmediateExecutor.getInstance(), (RequestMonitor)rm){

                                protected void handleSuccess() {
                                    if (IExpressions.IExpressionDMData.BasicType.array.equals((Object)((IExpressions.IExpressionDMData)this.getData()).getBasicType())) {
                                        rm.setData((Object)MIExpressions.this.computeNumberOfChildren(realNum));
                                    } else {
                                        rm.setData((Object)realNum);
                                    }
                                    rm.done();
                                }
                            });
                        }
                    }
                });
            }
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void getSubExpressionCount(IExpressions.IExpressionDMContext dmc, DataRequestMonitor<Integer> rm) {
        this.getSubExpressionCount(dmc, -1, rm);
    }

    public void canWriteExpression(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<Boolean> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetAttributes(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetAttributesInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)((ExprMetaGetAttributesInfo)this.getData()).getEditable());
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void writeExpression(final IExpressions.IExpressionDMContext dmc, String expressionValue, String formatId, final RequestMonitor rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.varManager.writeValue(dmc, expressionValue, formatId, new RequestMonitor((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIExpressions.this.fExpressionCache.reset();
                    MIExpressions.this.getSession().dispatchEvent((Object)new ExpressionChangedEvent(dmc), MIExpressions.this.getProperties());
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.fExpressionCache.setContextAvailable(e.getDMContext(), false);
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fExpressionCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fExpressionCache.setContextAvailable(e.getDMContext(), true);
        this.fExpressionCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMemory.IMemoryChangedEvent e) {
        this.fExpressionCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
        this.fTraceVisualization = e.isVisualizationModeEnabled();
    }

    public void flushCache(IDMContext context) {
        this.fExpressionCache.reset(context);
        this.varManager.markAllOutOfDate();
    }

    public IExpressions2.ICastedExpressionDMContext createCastedExpression(IExpressions.IExpressionDMContext exprDMC, IExpressions2.CastInfo castInfo) {
        if (exprDMC instanceof MIExpressionDMC && castInfo != null) {
            StringBuffer buffer;
            String castType = castInfo.getTypeString();
            String castExpression = exprDMC.getExpression();
            int castingLength = castInfo.getArrayCount();
            int castingIndex = castInfo.getArrayStartIndex();
            if (castType != null && castType.length() > 0) {
                buffer = new StringBuffer();
                buffer.append('(').append(castType).append(')');
                buffer.append('(').append(castExpression).append(')');
                castExpression = buffer.toString();
            }
            if (castingLength > 0) {
                buffer = new StringBuffer();
                buffer.append("*(");
                buffer.append('(').append(castExpression).append(')');
                buffer.append('+').append(castingIndex).append(')');
                buffer.append('@').append(castingLength);
                castExpression = buffer.toString();
            }
            castExpression = String.format("(%s)", castExpression);
            return new CastedExpressionDMC((MIExpressionDMC)exprDMC, castExpression, castInfo);
        }
        assert (false);
        return null;
    }

    public void getExpressionDataExtension(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions3.IExpressionDMDataExtension> rm) {
        this.getExpressionData(dmc, new DataRequestMonitor<IExpressions.IExpressionDMData>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                rm.setData((Object)((IExpressions3.IExpressionDMDataExtension)this.getData()));
                super.handleSuccess();
            }
        });
    }

    private IndexedPartitionDMC[] getTopLevelIndexedPartitions(MIExpressionDMC exprCtx, int realNumChildren, int startIndex, int length) {
        int numChildren = this.computeNumberOfChildren(realNumChildren);
        if (startIndex >= numChildren) {
            return new IndexedPartitionDMC[0];
        }
        int startIndex1 = startIndex < 0 ? 0 : startIndex;
        int length1 = length < 0 ? numChildren - startIndex1 : Math.min(length, numChildren - startIndex1);
        IndexedPartitionDMC[] children = new IndexedPartitionDMC[numChildren];
        int index = 0;
        int i = 0;
        while (i < children.length) {
            int partLength = this.computePartitionLength(realNumChildren, i);
            children[i] = this.createIndexedPartition(exprCtx, index, partLength);
            index += partLength;
            ++i;
        }
        return Arrays.copyOfRange(children, startIndex1, startIndex1 + length1);
    }

    private void getIndexedPartitionChildren(IndexedPartitionDMC partDmc, int startIndex, int length, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        int startIndex1 = startIndex < 0 ? 0 : startIndex;
        int length1 = length < 0 ? Integer.MAX_VALUE : length;
        int partStartIndex = partDmc.getIndex();
        int partLength = partDmc.getLength();
        if (partLength > this.getArrayPartitionLength()) {
            int numChildren = this.computeNumberOfChildren(partLength);
            if (startIndex1 >= numChildren) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Invalid range for evaluating sub expressions.", null));
                rm.done();
                return;
            }
            int numPart = Math.min(numChildren, length1);
            IndexedPartitionDMC[] children = new IndexedPartitionDMC[numPart];
            int index = partStartIndex;
            int i = 0;
            while (i < startIndex1) {
                index += this.computePartitionLength(partLength, i);
                ++i;
            }
            i = 0;
            while (i < children.length) {
                int childPartLength = this.computePartitionLength(partLength, i + startIndex1);
                children[i] = this.createIndexedPartition(partDmc.getParentExpressionContext(), index, childPartLength);
                index += childPartLength;
                ++i;
            }
            rm.setData((Object)children);
            rm.done();
        } else if (startIndex1 > partLength) {
            rm.setData((Object)new IExpressions.IExpressionDMContext[0]);
            rm.done();
        } else {
            this.getRealSubExpressions(partDmc.getParentExpressionContext(), partStartIndex + startIndex1, Math.min(length1, partLength - startIndex1), rm);
        }
    }

    void getRealSubExpressions(final IExpressions.IExpressionDMContext exprCtx, int startIndex, int length, final DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        ExprMetaGetChildren getChildren = startIndex < 0 || length < 0 ? new ExprMetaGetChildren(exprCtx) : new ExprMetaGetChildren(exprCtx, startIndex + length);
        final int startIndex1 = startIndex < 0 ? 0 : startIndex;
        final int length1 = length < 0 ? Integer.MAX_VALUE : length;
        this.fExpressionCache.execute((ICommand)getChildren, (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetChildrenInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                ExpressionInfo[] childrenExpr = ((ExprMetaGetChildrenInfo)this.getData()).getChildrenExpressions();
                if (startIndex1 >= childrenExpr.length) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Invalid range for evaluating sub expressions.", null));
                    rm.done();
                    return;
                }
                int numChildren = childrenExpr.length - startIndex1;
                numChildren = Math.min(length1, numChildren);
                IExpressions.IExpressionDMContext[] childrenArray = new IExpressions.IExpressionDMContext[numChildren];
                int i = 0;
                while (i < numChildren) {
                    childrenArray[i] = MIExpressions.this.createExpression(exprCtx.getParents()[0], childrenExpr[startIndex1 + i]);
                    ++i;
                }
                rm.setData((Object)childrenArray);
                rm.done();
            }
        });
    }

    private int computeNumberOfChildren(int realNumberOfChildren) {
        int childNum = realNumberOfChildren;
        int partLength = this.getArrayPartitionLength();
        while (childNum > partLength) {
            childNum /= partLength;
        }
        if (childNum * partLength < realNumberOfChildren) {
            ++childNum;
        }
        return childNum;
    }

    private int computePartitionLength(int realNumberOfChildren, int index) {
        int partLength;
        int childNum = realNumberOfChildren;
        int depth = 0;
        int length = partLength = this.getArrayPartitionLength();
        while (childNum > partLength) {
            childNum /= partLength;
            if (depth > 0) {
                length *= partLength;
            }
            ++depth;
        }
        int diff = realNumberOfChildren - length * index;
        return diff > length ? length : diff;
    }

    private IndexedPartitionDMC createIndexedPartition(MIExpressionDMC parentExpr, int index, int length) {
        return new IndexedPartitionDMC(parentExpr, index, length);
    }

    private void getRealSubExpressionCount(IExpressions.IExpressionDMContext dmc, int numChildLimit, final DataRequestMonitor<Integer> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetChildCount(dmc, numChildLimit), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetChildCountInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)((ExprMetaGetChildCountInfo)this.getData()).getChildNum());
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    private int getArrayPartitionLength() {
        return 100;
    }

    protected class CastedExpressionDMC
    extends MIExpressionDMC
    implements IExpressions2.ICastedExpressionDMContext {
        private final IExpressions2.CastInfo fCastInfo;

        public CastedExpressionDMC(MIExpressionDMC exprDMC, String castExpression, IExpressions2.CastInfo castInfo) {
            super(MIExpressions.this.getSession().getId(), castExpression, exprDMC.getRelativeExpression(), (IDMContext)exprDMC);
            this.fCastInfo = castInfo;
        }

        public IExpressions2.CastInfo getCastInfo() {
            return this.fCastInfo;
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && this.fCastInfo.equals((Object)((CastedExpressionDMC)((Object)other)).fCastInfo);
        }
    }

    protected static class ExpressionChangedEvent
    extends AbstractDMEvent<IExpressions.IExpressionDMContext>
    implements IExpressions.IExpressionChangedDMEvent {
        public ExpressionChangedEvent(IExpressions.IExpressionDMContext context) {
            super((IDMContext)context);
        }
    }

    protected static class ExpressionDMAddress
    implements IExpressions.IExpressionDMAddress {
        IAddress fAddr;
        int fSize;

        public ExpressionDMAddress(IAddress addr, int size) {
            this.fAddr = addr;
            this.fSize = size;
        }

        public ExpressionDMAddress(String addrStr, int size) {
            this.fSize = size;
            this.fAddr = addrStr.length() <= 10 ? new Addr32(addrStr) : new Addr64(addrStr);
        }

        public IAddress getAddress() {
            return this.fAddr;
        }

        public int getSize() {
            return this.fSize;
        }

        public boolean equals(Object other) {
            if (other instanceof ExpressionDMAddress) {
                ExpressionDMAddress otherAddr = (ExpressionDMAddress)other;
                return this.fSize == otherAddr.getSize() && (this.fAddr == null ? otherAddr.getAddress() == null : this.fAddr.equals((Object)otherAddr.getAddress()));
            }
            return false;
        }

        public int hashCode() {
            return (this.fAddr == null ? 0 : this.fAddr.hashCode()) + this.fSize;
        }

        public String toString() {
            return String.valueOf(this.fAddr == null ? "null" : "(" + this.fAddr.toHexAddressString()) + ", " + this.fSize + ")";
        }
    }

    protected static class ExpressionDMData
    implements IExpressions3.IExpressionDMDataExtension {
        private final String relativeExpression;
        private final String exprType;
        private final int numChildrenHint;
        private final boolean editable;
        private final IExpressions.IExpressionDMData.BasicType fBasicType;

        public ExpressionDMData(String expr, String type, int num, boolean edit) {
            this(expr, type, num, edit, null);
        }

        public ExpressionDMData(String expr, String type, int num, boolean edit, IExpressions.IExpressionDMData.BasicType basicType) {
            this.relativeExpression = expr;
            this.exprType = type;
            this.numChildrenHint = num;
            this.editable = edit;
            this.fBasicType = basicType;
        }

        public IExpressions.IExpressionDMData.BasicType getBasicType() {
            return this.fBasicType;
        }

        public String getEncoding() {
            return null;
        }

        public Map<String, Integer> getEnumerations() {
            return new HashMap<String, Integer>();
        }

        public String getName() {
            return this.relativeExpression;
        }

        public IRegisters.IRegisterDMContext getRegister() {
            return null;
        }

        public String getStringValue() {
            return null;
        }

        public String getTypeId() {
            return null;
        }

        public String getTypeName() {
            return this.exprType;
        }

        @Deprecated
        public int getNumChildren() {
            return this.numChildrenHint;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public boolean hasChildren() {
            return this.numChildrenHint > 0;
        }

        public boolean equals(Object other) {
            if (other instanceof ExpressionDMData) {
                ExpressionDMData otherData = (ExpressionDMData)other;
                return this.numChildrenHint == otherData.numChildrenHint && (this.getTypeName() == null ? otherData.getTypeName() == null : this.getTypeName().equals(otherData.getTypeName())) && (this.getName() == null ? otherData.getName() == null : this.getName().equals(otherData.getName()));
            }
            return false;
        }

        public int hashCode() {
            return this.relativeExpression == null ? 0 : (String.valueOf(this.relativeExpression.hashCode()) + this.exprType == null ? 0 : this.exprType.hashCode() + this.numChildrenHint);
        }

        public String toString() {
            return "relExpr=" + this.relativeExpression + ", type=" + this.exprType + ", numchildren=" + this.numChildrenHint;
        }
    }

    public static class ExpressionInfo {
        private final String fullExpression;
        private final String relativeExpression;
        private boolean isDynamic = false;
        private ExpressionInfo parent;
        private int indexInParent = -1;
        private int childCountLimit = -1;

        public ExpressionInfo(String full, String relative) {
            this.fullExpression = full;
            this.relativeExpression = relative;
        }

        public ExpressionInfo(String full, String relative, boolean isDynamic, ExpressionInfo parent, int indexInParent) {
            this.fullExpression = full;
            this.relativeExpression = relative;
            this.isDynamic = isDynamic;
            this.parent = parent;
            this.indexInParent = indexInParent;
        }

        public String getFullExpr() {
            return this.fullExpression;
        }

        public String getRelExpr() {
            return this.relativeExpression;
        }

        public boolean equals(Object other) {
            return other instanceof ExpressionInfo && (this.fullExpression == null ? ((ExpressionInfo)other).fullExpression == null : this.fullExpression.equals(((ExpressionInfo)other).fullExpression)) && (this.relativeExpression == null ? ((ExpressionInfo)other).relativeExpression == null : this.relativeExpression.equals(((ExpressionInfo)other).relativeExpression));
        }

        public int hashCode() {
            return (this.fullExpression == null ? 0 : this.fullExpression.hashCode()) ^ (this.relativeExpression == null ? 0 : this.relativeExpression.hashCode());
        }

        public String toString() {
            return "[" + this.fullExpression + ", " + this.relativeExpression + ", isDynamic=" + this.isDynamic + "]";
        }

        public ExpressionInfo getParent() {
            return this.parent;
        }

        public int getIndexInParentExpression() {
            return this.indexInParent;
        }

        public boolean isDynamic() {
            return this.isDynamic;
        }

        public boolean hasDynamicAncestor() {
            ExpressionInfo parent = this.getParent();
            while (parent != null) {
                if (parent.isDynamic()) {
                    return true;
                }
                parent = parent.getParent();
            }
            return false;
        }

        public void setDynamic(boolean isDynamic) {
            this.isDynamic = isDynamic;
        }

        public void setParent(ExpressionInfo parent) {
            this.parent = parent;
        }

        public void setIndexInParent(int index) {
            this.indexInParent = index;
        }

        public int getChildCountLimit() {
            return this.childCountLimit;
        }

        public void setChildCountLimit(int newLimit) {
            this.childCountLimit = newLimit;
        }

        public boolean inMemory() {
            if (this.getParent() == null) {
                return !this.getRelExpr().startsWith("$");
            }
            return this.getParent().inMemory();
        }
    }

    protected static class IndexedPartitionDMC
    extends MIExpressionDMC
    implements IExpressions.IIndexedPartitionDMContext {
        private final MIExpressionDMC fParentExpression;
        private final int fIndex;
        private final int fLength;

        @Deprecated
        public IndexedPartitionDMC(String sessionId, ExpressionInfo parentInfo, IStack.IFrameDMContext frameCtx, int index, int length) {
            this(new MIExpressionDMC(sessionId, parentInfo, frameCtx), (IDMContext)frameCtx, index, length);
        }

        public IndexedPartitionDMC(MIExpressionDMC parentExpr, int index, int length) {
            this(parentExpr, IndexedPartitionDMC.getParentDmc(parentExpr), index, length);
        }

        private IndexedPartitionDMC(MIExpressionDMC parentExpr, IDMContext parentDmc, int index, int length) {
            super(parentExpr.getSessionId(), IndexedPartitionDMC.createExpressionInfo(parentExpr.getExpressionInfo(), index, length), parentDmc);
            this.fIndex = index;
            this.fLength = length;
            this.fParentExpression = parentExpr;
        }

        private static IDMContext getParentDmc(MIExpressionDMC parentExpr) {
            IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)parentExpr, IStack.IFrameDMContext.class);
            if (frameDmc != null) {
                return frameDmc;
            }
            IMIExecutionDMContext execCtx = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)parentExpr, IMIExecutionDMContext.class);
            if (execCtx != null) {
                DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), parentExpr.getSessionId());
                MIStack stackService = (MIStack)((Object)tracker.getService(MIStack.class));
                tracker.dispose();
                if (stackService != null) {
                    return stackService.createFrameDMContext(execCtx, 0);
                }
            }
            return parentExpr;
        }

        public ExpressionInfo getParentInfo() {
            return this.fParentExpression.getExpressionInfo();
        }

        public String getParentExpression() {
            return this.getParentExpressionContext().getExpression();
        }

        public MIExpressionDMC getParentExpressionContext() {
            return this.fParentExpression;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public int getLength() {
            return this.fLength;
        }

        @Override
        public boolean equals(Object other) {
            return super.baseEquals(other) && ((IndexedPartitionDMC)((Object)other)).getParentExpressionContext().equals((Object)this.getParentExpressionContext()) && ((IndexedPartitionDMC)((Object)other)).getIndex() == this.getIndex() && ((IndexedPartitionDMC)((Object)other)).getLength() == this.getLength();
        }

        @Override
        public int hashCode() {
            return super.baseHashCode() + 17 * this.getIndex() + 31 * this.getLength();
        }

        @Override
        public String toString() {
            return String.format("%s.expr[%s][%d-%d]", this.baseToString(), this.getParentExpression(), this.getIndex(), this.getIndex() + this.getLength() - 1);
        }

        private static ExpressionInfo createExpressionInfo(ExpressionInfo parentInfo, int index, int length) {
            String expression = String.format("*((%s)+%d)@%d", parentInfo.getFullExpr(), index, length);
            return new ExpressionInfo(expression, expression);
        }
    }

    protected static class InvalidContextExpressionDMC
    extends AbstractDMContext
    implements IExpressions.IExpressionDMContext {
        private final String expression;

        public InvalidContextExpressionDMC(String sessionId, String expr, IDMContext parent) {
            super(sessionId, new IDMContext[]{parent});
            this.expression = expr;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && (this.expression == null ? ((InvalidContextExpressionDMC)((Object)other)).getExpression() == null : this.expression.equals(((InvalidContextExpressionDMC)((Object)other)).getExpression()));
        }

        public int hashCode() {
            return this.expression == null ? super.baseHashCode() : super.baseHashCode() ^ this.expression.hashCode();
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".invalid_expr[" + this.expression + "]";
        }

        public String getExpression() {
            return this.expression;
        }
    }

    protected class InvalidDMAddress
    implements IExpressions.IExpressionDMLocation {
        protected InvalidDMAddress() {
        }

        public IAddress getAddress() {
            return IExpressions.IExpressionDMLocation.INVALID_ADDRESS;
        }

        public int getSize() {
            return 0;
        }

        public String getLocation() {
            return "";
        }
    }

    public static class MIExpressionDMC
    extends AbstractDMContext
    implements IExpressions.IExpressionDMContext {
        private ExpressionInfo exprInfo;

        public MIExpressionDMC(String sessionId, String expression, String relExpr, IStack.IFrameDMContext frameCtx) {
            this(sessionId, expression, relExpr, (IDMContext)frameCtx);
        }

        public MIExpressionDMC(String sessionId, String expression, String relExpr, IMIExecutionDMContext execCtx) {
            this(sessionId, expression, relExpr, (IDMContext)execCtx);
        }

        public MIExpressionDMC(String sessionId, String expression, String relExpr, IMemory.IMemoryDMContext memoryCtx) {
            this(sessionId, expression, relExpr, (IDMContext)memoryCtx);
        }

        private MIExpressionDMC(String sessionId, String expr, String relExpr, IDMContext parent) {
            this(sessionId, new ExpressionInfo(expr, relExpr), parent);
        }

        public MIExpressionDMC(String sessionId, ExpressionInfo info, IStack.IFrameDMContext frameCtx) {
            this(sessionId, info, (IDMContext)frameCtx);
        }

        public MIExpressionDMC(String sessionId, ExpressionInfo info, IDMContext parent) {
            super(sessionId, new IDMContext[]{parent});
            this.exprInfo = info;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && this.exprInfo.equals(((MIExpressionDMC)((Object)other)).exprInfo);
        }

        public int hashCode() {
            return super.baseHashCode() + this.exprInfo.hashCode();
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".expr" + this.exprInfo.toString();
        }

        public String getExpression() {
            return this.exprInfo.getFullExpr();
        }

        public String getRelativeExpression() {
            return this.exprInfo.getRelExpr();
        }

        public ExpressionInfo getExpressionInfo() {
            return this.exprInfo;
        }

        public void setExpressionInfo(ExpressionInfo info) {
            assert (this.exprInfo.getFullExpr().equals(info.getFullExpr()));
            assert (this.exprInfo.getRelExpr().equals(info.getRelExpr()));
            this.exprInfo = info;
        }
    }
}

