/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model;

import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.IVisualizerModelObject;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerExecutionState;

public class VisualizerThread
implements Comparable<VisualizerThread>,
IVisualizerModelObject {
    protected VisualizerCore m_core;
    protected int m_pid;
    protected int m_tid;
    protected int m_gdbtid;
    protected VisualizerExecutionState m_threadState;

    public VisualizerThread(VisualizerCore core, int pid, int tid, int gdbtid, VisualizerExecutionState state) {
        this.m_core = core;
        this.m_pid = pid;
        this.m_tid = tid;
        this.m_gdbtid = gdbtid;
        this.m_threadState = state;
    }

    public void dispose() {
        this.m_core = null;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof VisualizerThread) {
            VisualizerThread v = (VisualizerThread)obj;
            result = v.m_pid == this.m_pid && v.m_tid == this.m_tid && v.m_gdbtid == this.m_gdbtid;
        }
        return result;
    }

    public int hashCode() {
        return this.m_pid ^ this.m_tid ^ this.m_gdbtid;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append(this.m_core).append(",Proc:").append(this.m_pid).append(",Thread:(").append(this.m_tid).append(",").append(this.m_gdbtid).append(")");
        return output.toString();
    }

    public VisualizerCore getCore() {
        return this.m_core;
    }

    public void setCore(VisualizerCore core) {
        this.m_core = core;
    }

    public boolean isProcessThread() {
        return this.m_pid == this.m_tid;
    }

    public int getPID() {
        return this.m_pid;
    }

    public int getTID() {
        return this.m_tid;
    }

    public void setTID(int tid) {
        this.m_tid = tid;
    }

    @Override
    public int getID() {
        return this.getGDBTID();
    }

    @Override
    public IVisualizerModelObject getParent() {
        return this.getCore();
    }

    public int getGDBTID() {
        return this.m_gdbtid;
    }

    public VisualizerExecutionState getState() {
        return this.m_threadState;
    }

    public void setState(VisualizerExecutionState state) {
        this.m_threadState = state;
    }

    @Override
    public int compareTo(VisualizerThread o) {
        int result = 0;
        if (o != null) {
            if (this.m_pid < o.m_pid) {
                result = -1;
            } else if (this.m_pid > o.m_pid) {
                result = 1;
            } else if (this.getID() < o.getID()) {
                result = -1;
            } else if (this.getID() > o.getID()) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public int compareTo(IVisualizerModelObject o) {
        if (o != null && o.getClass() == this.getClass()) {
            return this.compareTo((VisualizerThread)o);
        }
        return 1;
    }
}

